#!/bin/bash
#
# Aymeric: pour construire IOIPSL [adapte de get_lmdz_ciclad_pgf90.bash]
#

# ADVICE: copy the [GCMdir]/LMDZ.COMMON/ioipsl directory 
# to [GCMdir]/ioipsl to get it out of svn
# then go to [GCMdir]/ioipsl before doing all the following commands.

rm -rf lib
mkdir lib
mkdir modeles

### 1. Get IOIPSL (via modipsl) and compile it
cd util
## get IOIPSL
./model IOIPSL

## 2. Set correct settings
# add a "gnome" configuration to AA_make.gdef
echo "#-Q- gnome  #- Global definitions for Idataplex (gnome) at UPMC, ifort" >> AA_make.gdef
echo "#-Q- gnome  M_K = make" >> AA_make.gdef
echo "#-Q- gnome  P_C = cpp" >> AA_make.gdef
echo '#-Q- gnome  P_O = -P -C $(P_P)' >> AA_make.gdef
echo "#-Q- gnome  F_C = ifort -c" >> AA_make.gdef
echo "#-Q- gnome  #-D- MD    F_D = -g" >> AA_make.gdef
echo "#-Q- gnome  #-D- MN    F_D =" >> AA_make.gdef
echo "#-Q- gnome  #-P- I4R4  F_P = -integer-size 32" >> AA_make.gdef
echo "#-Q- gnome  #-P- I4R8  F_P = -integer-size 32 -real-size 64" >> AA_make.gdef
echo "#-Q- gnome  #-P- I8R8  F_P = -integer-size 64 -real-size 64" >> AA_make.gdef
echo '#-Q- gnome  F_O = -O $(F_D) $(F_P) -I$(MODDIR) -module $(MODDIR)' >> AA_make.gdef
echo "#-Q- gnome  F_L = ifort" >> AA_make.gdef
echo "#-Q- gnome  M_M = 0" >> AA_make.gdef
echo "#-Q- gnome  L_X = 0" >> AA_make.gdef
echo "#-Q- gnome  L_O =" >> AA_make.gdef
echo "#-Q- gnome  A_C = ar -r" >> AA_make.gdef
echo "#-Q- gnome  A_G = ar -x" >> AA_make.gdef
echo "#-Q- gnome  C_C = icc -c" >> AA_make.gdef
echo "#-Q- gnome  C_O =" >> AA_make.gdef
echo "#-Q- gnome  C_L = icc" >> AA_make.gdef
echo "#-Q- gnome  #-" >> AA_make.gdef
echo "#-Q- gnome  NCDF_INC = /usr/local/include" >> AA_make.gdef
echo "#-Q- gnome  NCDF_LIB = -L/usr/local/lib -lnetcdf" >> AA_make.gdef
echo "#-Q- gnome  #-" >> AA_make.gdef

ins_make -t gnome -p I4R8

## 3. build ioipsl:
cd ../modeles/IOIPSL/src
make

rm -rf modeles

exit
