#!/bin/bash
#
# Aymeric: pour construire IOIPSL [adapte de get_lmdz_ciclad_pgf90.bash]
#

# ADVICE: copy the [GCMdir]/LMDZ.COMMON/ioipsl directory 
# to [GCMdir]/ioipsl to get it out of svn
# then go to [GCMdir]/ioipsl before doing all the following commands.

rm -rf lib
mkdir lib
mkdir modeles

### 1. Get IOIPSL (via modipsl) and compile it
cd util
## get IOIPSL
./model IOIPSL

## 2. Set correct settings
# modify path to netcdf in 'AA_make.gdef'
cp AA_make.gdef AA_make.gdef.old
sed -e s:"linux    NCDF_INC = /distrib/local/netcdf/pgf/include/":"linux    NCDF_INC = /opt/netcdf/pgf/include/":1 \
    -e s:"linux    NCDF_LIB = -L/distrib/local/netcdf/pgf/lib/":"linux    NCDF_LIB = -L/opt/netcdf/pgf/lib/":1 \
    AA_make.gdef.old > AA_make.gdef
ins_make -t linux -p I4R8
## 3. build ioipsl:
cd ../modeles/IOIPSL/src
make

rm -rf modeles

exit
