###Script to launch several successive jobs on Gnome 

# In your directory, you need :
# - this script
# - launch_128_96_64_ref : a reference script, containing the settings of a job (which .def to use, which executable, Load Leveler settings...) 
# - the PROTO_Saturn_Article directory (add the executable inside)

#!/bin/bash

#MODIFY THIS :  
n=11 	#total number of jobs 
name='norings'
cd /san/home/sylvestr/simus/bacasable/long_run/norings #your start directory 

# THE REFERENCE SCRIPT IS READ : launch_128_96_64_ref

#we check that the lines about the copy of the startfi.nc follows the one with
#start.nc 

ligne=$(grep -n 'start.nc' launch_128_96_64_ref | cut -d: -f1)
lignefi=$(grep -n 'startfi.nc' launch_128_96_64_ref | cut -d: -f1)

if [ ${lignefi} -ne $(expr ${ligne} \+ 1) ]
then
	echo 'Error :'
	echo 'In  launch_128_96_64_ref, the line about startfi.nc must follow the line about start.nc'
	exit
fi

#CREATION OF THE 1ST SCRIPT
cp launch_128_96_64_ref launch1_128_96_64

#CREATION OF THE LAST SCRIPT

#same as the reference script except that its start*.nc files are the restart*.nc files produced by the second to last simulation
 
head -n $(expr ${ligne} \- 1 ) launch1_128_96_64 > launch${n}_128_96_64
echo 'cp -rf zeLAST/restart.nc $LOADL_STEP_INITDIR/${tmpdir}/start.nc' >> launch${n}_128_96_64 
echo 'cp -rf zeLAST/restartfi.nc $LOADL_STEP_INITDIR/${tmpdir}/startfi.nc' >> launch${n}_128_96_64
tail -n +$(expr ${lignefi} \+ 1 ) launch1_128_96_64 >> launch${n}_128_96_64


#1ST SCRIPT IS COMPLETED AND THE OTHERS (from 2 to n-1 ARE CREATED) 

# Scripts 2 to n-1 are created from the last script (to start from the restart*.nc).
# Commands are added to Scripts 1 to n-1 to launch the next script.

touch outputs_${name}.txt #file to save the names of the jobs composing this run

for ((i=1 ; i<$n; i+=1))
do 	
	if [ ${i} -ne 1 ]
	then  
		cp launch${n}_128_96_64 launch${i}_128_96_64
	fi 
	
	#Save the name of the jobs
	echo 'echo $LOADL_STEP_INITDIR/${tmpdir} >> $LOADL_STEP_INITDIR/outputs_'${name}'.txt' >> launch${i}_128_96_64 
	echo ' ' >> launch${i}_128_96_64

	#Launch the next job
	echo '#Lancement du job script suivant' >> launch${i}_128_96_64
	echo 'cd $LOADL_STEP_INITDIR' >> launch${i}_128_96_64
	echo 'llsubmit launch'$(expr $i \+ 1)'_128_96_64' >> launch${i}_128_96_64
	
done

 echo 'echo $LOADL_STEP_INITDIR/${tmpdir} >> $LOADL_STEP_INITDIR/outputs_'${name}'.txt' >> launch${n}_128_96_64

#LAUNCH THE 1ST JOB
llsubmit launch1_128_96_64

