!
! $Header: /home/cvsroot/LMDZ4/libf/phylmd/phytrac.F,v 1.16 2006/03/24 15:06:23 lmdzadmin Exp $
!
c
c
      SUBROUTINE  phytrac_chimie (
     I                    debutphy,
     I                    gmtime,
     I                    nqmax,
     I                    n_lon,
     I                    lat,
     I                    lon,
     I                    n_lev, 
     I                    pdtphys,
     I                    temp,
     I                    pplev,
     O                    trac,
     O                    NBRTOT_droplet,
     O                    W_H2SO4,
     O                    rho)

c======================================================================
c Auteur(s) FH
c Objet: Moniteur general des tendances traceurs
c
cAA Remarques en vrac:
cAA--------------------
cAA 1/ le call phytrac se fait avec nqmax 
c======================================================================
      USE chemparam_mod
      IMPLICIT none
      
#include "clesphys.h" 
#include "YOMCST.h"
c======================================================================
c Arguments:
c
c
c   EN ENTREE:
c   ==========
c
c   divers:
c   -------
c

      REAL  sza_local 
      REAL  gmtime
c      INTEGER, SAVE :: cpt_cloudIO  !un compteur pour fichier sortie cloud_parameter en 1D
      INTEGER  iq
      INTEGER  i
      INTEGER  ilon, ilev
      integer  n_lon  ! nombre de points horizontaux
      INTEGER  n_lev  ! nombre de couches verticales
      INTEGER  nqmax ! nombre de traceurs auxquels on applique la physique
c      INTEGER  nbapp_cloud, i_app_cloud
      real  pdtphys  ! pas d'integration pour la physique (seconde)
      real  lat(n_lon), lat_local(n_lon)
      real  lon(n_lon), lon_local(n_lon)
      real  temp(n_lon,n_lev) ! temp
      real  trac(n_lon,n_lev,nqmax) ! traceur 
      real  pplev(n_lon,n_lev)  ! pression pour le mileu de chaque couche (en Pa)
      real  lon_sun
      logical debutphy       ! le flag de l'initialisation de la physique
c      character*7 modname

C
C----------------------------------------------------------------------------
C     Model cloud:
C     Aerosol and PSC variables:
      real  NBRTOT_droplet(n_lon,n_lev)
      real  W_H2SO4(n_lon,n_lev)
      real  W_H2O(n_lon,n_lev)
      real  rho(n_lon,n_lev)
C----------------------------------------------------------------------------
C----------------------------------------------------------------------------
C     Time variables:
      REAL, save :: dT_cloud
C----------------------------------------------------------------------------   
C----------------------------------------------------------------------------
C     Auxilary variables:
 
      REAL mrtwv,mrtsa,mrwv,mrsa,
     +     ppwv, psatwv,
     +     ps_sa,satps_sa
C    ps_sa: satur pressure pure SA 
C    satps_sa: satur pres over mixture in dyne/cm2=Pa/10
C----------------------------------------------------------------------------
        
C Variables liees a l'ecriture de la bande histoire : phytrac.nc
 
      logical ok_sync
      parameter (ok_sync = .true.)

c      modname = 'phytrac'

c      PRINT*,'DEBUT subroutine PHYTRAC'

c----------------------------------
c debutphy: Initiation des traceurs
c----------------------------------

      if (debutphy) then
         
      PRINT*,'PRECISION REAL'
      PRINT*,precision(NBRTOT_droplet(1,1)), range(NBRTOT_droplet(1,1))
      
         if (n_lon .EQ. 1) then           
         PRINT*,'n_lon 1D: ',n_lon
         end if
                  
c         if ((n_lon .GT. 1) .AND. ok_chem) then
c !!! DONC 3D !!!	
c           CALL chemparam_ini() 
c         endif
         
c         if ((n_lon .GT. 1) .AND. ok_cloud) then
c !!! DONC 3D !!!
c         CALL cloud_ini(n_lon,n_lev)
c         endif
           
         IF (reinit_trac) THEN
         PRINT*,'REINIT MIXING RATIO TRACEURS'

c	=============================================================
c					Passage de Rm à Rv
c	=============================================================
c     Necessaire si on reprend les start.nc qui sont en MMR
      DO iq=1,nqmax
      trac(:,:,iq)=trac(:,:,iq)*RMD/M_tr(iq)
      END DO
c	=============================================================
          
      
c=============================================================
c		Initialisation des profils traceurs en Rv
c=============================================================
         trac(:,:,:)=1.0d-30
      
         trac(:,:,i_co2)=0.965d0 * RMD / M_tr(i_co2)

         trac(:,:,i_co)=25.0d-6

 
      trac(:,:,i_h2so4)=1.0d-21 
      trac(:,:,i_h2o)=1.0d-21 

c     !!! SANS NUAGE !!!	
c	 trac(:,1:29,i_ocs)=1.0d-6
c	 trac(:,29:40,i_ocs)=1.0e-9
c       trac(:,:,i_so2)=1.d-6
c       trac(:,:,i_h2o)=1.0d-6

c     !!! AVEC NUAGE !!!
         trac(:,1:20,i_ocs)=3.d-6

            DO i=21,26
            trac(:,i,i_ocs)=trac(:,i-1,i_ocs)-0.3d-6
            END DO
	
c	DO i=21,30
c	trac(:,i,i_ocs)=trac(:,i-1,i_ocs)-0.3d-6
c	END DO
	
         trac(:,1:26,i_hcl)=0.2d-6

c      trac(:,:,i_hcl)=0.2d-6

c	Initialisation SO2 Bertaux et De Bergh 2007 JGR
c         trac(:,1:26,i_so2)=20.d-6
c            DO i=2,20
c            trac(:,i,i_so2)=trac(:,i-1,i_so2)+(100./19.)*0.25d-6
c            END DO
c            DO i=21,22
c            trac(:,i,i_so2)=trac(:,i-1,i_so2)-(100./9.)*0.25d-6
c            END DO

c	DO i=21,29
c	trac(:,i,i_so2)=trac(:,i-1,i_so2)-(100./9.)*1d-6
c	END DO

c      trac(:,1:30,i_so2)= 100.0d-6
c	trac(:,30,i_so2)=20.0d-6
c      trac(:,31,i_so2)=10.0d-6
c      trac(:,32,i_so2)=1.0d-6
c      trac(:,33,i_so2)=0.1d-6
c      trac(:,34:42,i_so2)=0.02d-6
c      trac(:,43:46,i_so2)=0.07d-6
c      trac(:,47:50,i_so2)=0.05d-6

c      trac(:,1:28,i_h2o)=30.0d-6
c      trac(:,29:50,i_h2o)=5.0d-6
      trac(:,15:50,i_h2o)=10.0d-6
c      trac(:,15:35,i_h2so4)=17.0d-6
c	DO i=23,35
c	trac(:,i,i_h2o)=(3.d-6-30.0d-6)/12.0*(-23.0+i)+trac(:,22,i_h2o)
c	END DO
c	trac(:,36:50,i_h2o)=3.0d-6
	
      trac(:,15:50,i_h2so4)=20.0d-6
c      trac(:,29:50,i_h2so4)=1.0d-9
c      trac(:,1:10,i_h2)=1.0d-10
c      trac(:,11:20,i_h2)=1.0d-9
c      trac(:,21:35,i_h2)=1.0d-8
c      trac(:,36:50,i_h2)=1.0d-7     
   
c=============================================================
      
c	=============================================================
c					Passage de Rv à Rm
c	=============================================================
         DO iq=1,nqmax
         trac(:,:,iq)=trac(:,:,iq)*M_tr(iq)/RMD
         END DO
c	=============================================================

c	Ecriture fichier initialisation
c	PRINT*,'Ecriture Initial_State.csv'
c 	OPEN(88,file='Initial_State.csv',
c     & form='formatted')
     
c      DO ilon=1,n_lon
c        DO ilev=1,n_lev
c        WRITE(88,"(36(e15.8,','))") R_MEDIAN(ilon,ilev),
c     &  STDDEV(ilon,ilev),trac(ilon,ilev,1:nqmax)
c        ENDDO
c      ENDDO
c      PRINT*,'FIN Ecriture Initial_State.csv'
     
         ENDIF  !FIN REINIT TRAC
	
c-------------
c fin debutphy
c-------------
      ENDIF  ! fin debutphy 

c	=============================================================
c					Passage de Rm à Rv
c	=============================================================
      DO iq=1,nqmax
      trac(:,:,iq)=trac(:,:,iq)*RMD/M_tr(iq)
      END DO
c	=============================================================


c=============================================================
c			Boucle sur les lon, lat (n_lon)
c=============================================================
c      PRINT*, 'gmtime', gmtime*RDAY
c      PRINT*, 'RDAY', RDAY
      
      lon_sun = (0.5 - gmtime) * 2.0 * RPI
      lon_local = lon * RPI/180.0d0
      lat_local = lat * RPI/180.0d0
       
      DO ilon=1, n_lon

c     calcul sza_local pour obtenir des sza_local > 90, utile pour la chimie
      sza_local = acos(cos(lat_local(ilon))*cos(lon_local(ilon))*
     & cos(lon_sun) + cos(lat_local(ilon))*sin(lon_local(ilon))
     & *sin(lon_sun))* 180.0d0/RPI 
      
c      PRINT*,'sza_local :', sza_local

         IF (ok_cloud) THEN
c      PRINT*,'DEBUT CLOUD'
                
      dT_cloud=pdtphys
      
      
c      nbapp_cloud=NINT(pdtphys/dT_cloud)
c      PRINT*,'pdtphys',pdtphys
c      PRINT*,'nbapp_cloud',nbapp_cloud
c	=============================================================
c			 Appel Microphysique (sans nucleation)
c                  Volume Mixing Ratio
c	=============================================================

c      FIXE un profil de temperature def dans fichier temp
      if (n_lon .EQ. 1) then
      OPEN(13,file='temp',status='old',form='formatted')
      DO ilev=1,n_lev
        READ (13,*) temp(n_lon,ilev)
      ENDDO
      CLOSE(13)
      endif
                  
      DO ilev=1, n_lev
c      PRINT*,'DEBUT INIT CALL CLOUD'
c     ppwv et pplev en Pa
       
c      PRINT*,'@@@@ IN CLOUD @@@@'      
      
c     On remet tout le RM liq dans la partie gaz
c     !!! On reforme un nuage à chaque fois !!!
         
      mrtwv=trac(ilon,ilev,i_h2o) + trac(ilon,ilev,i_h2oliq)
      mrtsa=trac(ilon,ilev,i_h2so4) + trac(ilon,ilev,i_h2so4liq)
      mrwv=mrtwv
      mrsa=mrtsa
      

c     !!! Remise a zero !!!
	W_H2SO4(ilon,ilev)=0.0d0
	W_H2O(ilon,ilev)=0.d0
	rho(ilon,ilev)=0.0d0
	NBRTOT_droplet(ilon,ilev)=0.d0
	satps_sa=0.d0
	ps_sa=0.d0
	
c	pression partielle H2O       
      ppwv=pplev(ilon,ilev) * mrwv

c     Pression saturante de vapeur d'eau, tirée du code d'Anni
      psatwv=EXP(77.344913 - 7235.4247/temp(ilon,ilev)
     & - 8.2*DLOG(temp(ilon,ilev)) + 0.0057113*temp(ilon,ilev))
     
c      PRINT*,'DEBUT CALL CLOUD'

c	Ne pas passer par la routine des nuages si on a des valeurs proches de 0 ?
c	Empeche de foirer en parallèle ?

            
      CALL new_cloud_venus(dT_cloud,
     e NBRTOT_droplet(ilon,ilev),
     e R_MEDIAN(ilon,ilev),STDDEV(ilon,ilev),
     e temp(ilon,ilev),pplev(ilon,ilev),
     e ppwv,
     e mrwv,mrsa,
     e ilev,
     e mrtwv,mrtsa,
     e W_H2SO4(ilon,ilev),
     e ps_sa,satps_sa,
     e rho(ilon,ilev))
           
c      END DO
    
c	=========================================                
c	Actualisation des mixing ratio liq et gaz
c	=========================================
c	Si la routine new_cloud_venus n'a pas actualisé mrwv et mrsa
c	on a alors bien mr=mrt pour sa et wv, donc les parties liq sont=0 hors du nuage
c	ou si on ne condense pas

c      PRINT*,'DEBUT ACTUALISATION OUTPUT CLOUD'
c    si tout se passe bien, mrtwv et mrtsa ne changent pas
      
      trac(ilon,ilev,i_h2o) = mrwv
      trac(ilon,ilev,i_h2oliq) = mrtwv - trac(ilon,ilev,i_h2o)
     
      trac(ilon,ilev,i_h2so4) = mrsa
      trac(ilon,ilev,i_h2so4liq) = mrtsa - trac(ilon,ilev,i_h2so4)
       
c      ENDIF
      
      
      IF (n_lon .EQ. 1) THEN	
      WRITE(66,"(i4,','11(e15.8,','))") ilev,temp(ilon,ilev),
     & pplev(ilon,ilev),ps_sa,satps_sa,NBRTOT_droplet(ilon,ilev),
     & W_H2SO4(ilon,ilev),trac(ilon,ilev,i_h2oliq),
     & trac(ilon,ilev,i_h2so4liq),mrwv,mrsa,trac(ilon,ilev,i_so2)
      ENDIF 

      END DO

c	=============================================================
c      PRINT*,'FIN CLOUD'
      ENDIF
      
      IF (ok_chem) THEN
c      PRINT*,"vmr SO2 ht atmo: ",trac(1,50,i_so2)
c      PRINT*,'DEBUT CHEMISTRY'
c	=============================================================
c					Appel Photochimie
c	=============================================================
c     Pression en hPa => pplev/100.
	
      CALL new_photochemistry_venus(n_lev, n_lon, pdtphys,
     e                         pplev(ilon,:)/100.,
     e                         temp(ilon,:),
     e                         trac(ilon,:,:),
     e                         sza_local, nqmax)
c	=============================================================
c      PRINT*,'FIN CHEMISTRY'
c      PRINT*,"vmr SO2 ht atmo: ",trac(1,50,i_so2)
      
	END IF

      END DO
c	=============================================================
c					Passage de Rv à Rm
c	=============================================================
	DO iq=1,nqmax
		trac(:,:,iq)=trac(:,:,iq)*M_tr(iq)/RMD
	END DO
c	=============================================================	

c      PRINT*,'FIN PHYTRAC'
      RETURN
      END
