pro level

;!p.multi=[0,2,2]
set_plot, 'ps'
device, file='plot.ps'

power=15.
nlev=61
ptop=5.e-2
psurf=610.
quickrise=15.

nlev=101
ptop=1.e-3
psurf=610.


levels=alog(quickrise*findgen(nlev)+1)^(1/power)
levels=levels/max(levels)
levels=1-levels


levels=1/(quickrise*findgen(nlev)+1)
levels=levels-min(levels)
levels=levels/max(levels)


levels=1/((-findgen(nlev)+1))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
quickrise=3
levels=1-(findgen(nlev)/float(nlev-1))^quickrise
levels=1-levels

print, float(nlev)/10.

levels = levels + exp(findgen(nlev)/10.)*1.e-5
levels(nlev-7:nlev-1)=[0.94,0.97,0.985,0.995,0.998,0.9995,1]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

absc=100.-findgen(101)

print, levels

plot, absc, levels, ytitle='Eta Level' 
!psym=7 & oplot, absc, levels
!psym=0


print, 'pressure'
pi=levels*(psurf-ptop)+ptop
print, pi

print, 'pseudo-altitude'
pseudo=10.*alog(610./pi)
print, 10.*alog(610./pi)

openw, 1, 'levels'
for i=0, nlev-1 do begin
	printf, 1, levels(nlev-1-i), ','
endfor
close, 1


plot, absc, pseudo, ytitle='Altitude (km)'
!psym=7 & oplot, absc, pseudo 
!psym=0


plot, absc, pi, ytitle='Pressure (Pa)', ylog=1
!psym=7 & oplot, absc, pi 
!psym=0



diff=pseudo - shift(pseudo,-1)
diff=diff(0:nlev-2)
plot, absc, diff, ytitle='Altitude (km)'
!psym=7 & oplot, absc, diff
!psym=0



end
