      SUBROUTINE phys_state_var_init(ngrid,nlayer,nq
     .               ,pdaysec,ptimestep,prad,pg,pr,pcpp)

!=======================================================================
!
!   purpose:
!   -------
!
!   Allocate arrays in modules
!   Fill geometrical arrays
!   Fill a first set of physical constants
!   -- was done previously in inifis
!
!=======================================================================
!   
!   authors: Ehouarn Millour and Aymeric Spiga
!            14/04/2014
!
!   arguments:
!   ----------
!
!   input:
!   ------
!
!    ngrid                 Size of the horizontal grid.
!    nlayer                Number of vertical layers.
!    nq                    Number of tracers.
!
!=======================================================================

      use slope_mod, only: ini_slope_mod
      use comsaison_h, only: ini_comsaison_h
      use surfdat_h, only: ini_surfdat_h
      use comgeomfi_h, only: ini_comgeomfi_h
      use comsoil_h, only: ini_comsoil_h
      use dimradmars_mod, only: ini_dimradmars_mod
      use yomaer_h,only: ini_yomaer_h
      use yomlw_h, only: ini_yomlw_h
      use conc_mod, only: ini_conc_mod
      use turb_mod, only: ini_turb_mod
      use comcstfi_h, only: pi,rad,cpp,g,r,rcp,daysec,dtphys
      use tracer_mod, only: nqmx

      IMPLICIT NONE
      
      INTEGER,INTENT(IN) :: ngrid,nlayer,nq
      REAL,INTENT(IN) :: pdaysec,ptimestep,prad,pg,pr,pcpp
      EXTERNAL SSUM
      REAL SSUM

      ! set dimension in tracer_mod
      nqmx=nq

      ! set parameters in comcstfi_h
      pi=2.*asin(1.) 
      rad=prad
      cpp=pcpp
      g=pg
      r=pr
      rcp=r/cpp
      daysec=pdaysec
      dtphys=ptimestep

      ! allocate "slope_mod" arrays
      call ini_slope_mod(ngrid)

      ! allocate "comsaison_h" arrays
      call ini_comsaison_h(ngrid)

      ! allocate "surfdat_h" arrays
      call ini_surfdat_h(ngrid,nq)

      ! allocate "comgeomfi_h" arrays
      call ini_comgeomfi_h(ngrid)

      ! allocate "comsoil_h" arrays
      call ini_comsoil_h(ngrid)

      ! set some variables in "dimradmars_mod"
      call ini_dimradmars_mod(ngrid,nlayer)

      ! allocate arrays in "yomaer_h"
      call ini_yomaer_h

      ! allocate arrays in "yomlw_h"
      call ini_yomlw_h(ngrid)

      ! allocate arrays in "conc_mod" (aeronomars)
      call ini_conc_mod(ngrid,nlayer)

      ! allocate arrays in "turb_mod"
      call ini_turb_mod(ngrid,nlayer)

      END SUBROUTINE phys_state_var_init
