#! /usr/bin/env python
from ppclass import pp
import numpy as np

# settings
fi = ["nest1_rad.nc","nest2_rad.nc","nest3_rad.nc"]
limvmr=5.0

# get radius
rad=pp()
rad.file=fi
rad.var=["RICE","VMR_ICE"]
rad.vargoal=["main","contour"]
rad.x=-120.
rad.t=4
rad.changetime = "mars_meso_lt"
rad.verbose = True
rad.filename = "radius"
rad.out = "png"
rad.includedate = False
rad.get()

# radius in microns
rad = rad*1.e6
rad.units = "$\mu$m"
rad.fmt = "%.0f"

# define plot
rad.defineplot()

# loop on all plots
for plotobj in rad.p:
    # mask plotted field with contoured field
    plotobj.f[np.where(plotobj.c<limvmr)]=np.nan
    # a few plot settings 
    # (some of them could have been actually set globally in rad object)
    plotobj.vmin = 0.
    plotobj.vmax = 10.
    plotobj.div = 20
    plotobj.xmin = 12.
    plotobj.xmax = 16.
    plotobj.colorbar = "spectral"
    plotobj.ycoeff = 1.e-3
    plotobj.ylabel = "Altitude above MOLA zero areoid (km)"
    plotobj.xlabel = 'Latitude ($^{\circ}$N)'
    plotobj.nxticks = 4

# set different titles
rad.p[0].title = "Ice radius. Nest 1."
rad.p[1].title = "Ice radius. Nest 2."
rad.p[2].title = "Ice radius. Nest 3."


# make final plot
rad.makeplot()
