module dimradmars_mod
!   Declaration and settings for radiative transfer calculations
!   Initializations and allocations are done in inifis
implicit none
  ! nflev: number of vertical layer
  ! ndlon,ndlo2: number of horizontal points
  ! Splitting of horizontal grid
  ! NDLO2 and ndomainsz for the splitting in the physics call
  ! WARNING:  One must have  1 < ndomainsz =< ngrid
  integer,save :: NFLEV !=nlayermx   ! with splitting
  integer,save :: ndomainsz !=(ngrid-1)/20 + 1
  integer,save :: NDLON !=ndomainsz  ! with splitting
  integer,save :: NDLO2 !=NDLON


! Number of kind of tracer radiative properties
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! naerkind is set in scatterers.h (built when compiling with makegcm -s #)

#include"scatterers.h"
! NB: May have to change value of nsizemax below when changing scatterers

! Reference wavelengths used to compute reference optical depth (m)
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

  real,save :: longrefir(naerkind),longrefvis(naerkind)
  
! Definition of spectral intervals at thermal infrared wavelengths (LW)
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  integer,parameter :: nir=4 ! Total number of thermal IR bands
  integer,parameter :: nuco2=2 ! number of bands in CO2 bands
  real,parameter :: long1ir=5.E-6 , long2ir=200.E-6
  real,parameter :: long1co2=1.E+0 / 865.E+2 , long2co2=1.E+0 / 500.E+2

!  Warning : the "nir" thermal IR bands are not ordered by wavelength:
!      iir=1 : central 15um CO2 bands     
!      iir=2 : CO2 band wings    [long1co2-long2co2] MINUS central band
!      iir=3 : 9 um band [long1ir - long1co2]
!      iir=4 : Far IR    [long2co2 - long2ir]
    
!  Definition of spectral interval at solar wavelengths (SW)
!  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  integer,parameter :: NSUN=2   ! do not change that !
!  Boundaries of spectral intervals (m) : 
  real,parameter :: long1vis=0.1E-6 , long2vis=0.5E-6 , long3vis=5.E-6
!  Fraction of solar energy in solar band #1 [long1vis-long2vis] : 0.274490
!  Fraction of solar energy in solar band #2 [long2vis-long3vis] : 0.725509
  real,save :: sunfr(2) = (/ 0.274490 , 0.725509 /)

! Maximum number of grain size classes
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! This parameter has to be set to the maximum number of particle
!   sizes contained in the optical parameter database; For example,
!   if only one grain size is used to describe dust, and 30 are used
!   to describe water-ice crystals in the visible and 15 in the IR,
!   nsizemax has to be set to 30.
! If only one grain size is considered for all the aerosols, set
!   this parameter to 1 and convolution will be turned off during
!   the radiative calculations.

  integer, parameter :: nsizemax = 60
! integer, parameter :: nsizemax = 1

! Various initialisation for LW radiative code
! ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
! npademx : number of Pade coefficients
! nabsmx : ?
! nt_pademx : number of temperature intervals for Pade

  integer,parameter :: npademx=4
  integer,parameter :: nabsmx=2
  integer,parameter :: nt_pademx=19

contains
  
  subroutine ini_dimradmars_mod(ngrid,nlayer)
  
  implicit none
  
  integer,intent(in) :: ngrid ! number of atmospheric columns
  integer,intent(in) :: nlayer ! number of atmospheric layers
  
   nflev=nlayer
!  ndomainsz=ngrid
   ndomainsz=(ngrid-1)/20 + 1
!  ndomainsz=(ngrid-1)/5 + 1
   ndlon=ndomainsz
   ndlo2=ndlon

  end subroutine ini_dimradmars_mod
  
end module dimradmars_mod
