!==================================================================
module aerosol_mod
implicit none
save
!==================================================================

!  aerosol indexes: these are initialized to be 0 if the
!                 corresponding aerosol was not activated in callphys.def
!                 -- otherwise a value is given in iniaerosol
      integer :: iaero_co2 = 0 
      integer :: iaero_h2o = 0
      integer :: iaero_dust = 0
      integer :: iaero_h2so4 = 0
      logical :: noaero = .false.

! two-layer simple aerosol model
      integer :: iaero_back2lay = 0
      REAL :: obs_tau_col_tropo  !! observed total optical depth in the tropospheric layer (visible)
      REAL :: obs_tau_col_strato !! observed total optical depth in the stratospheric layer (visible)
      REAL :: pres_bottom_tropo  !! In Pa !   
      REAL :: pres_top_tropo     !! In Pa
      REAL :: pres_bottom_strato  !! In Pa
      REAL :: pres_top_strato     !! In Pa
      REAL :: size_tropo  !! particle size in the tropospheric layer
      REAL :: size_strato !! particle size in the stratospheric layer
      
!==================================================================
end module aerosol_mod
!==================================================================
