pro smoothoxf

;------------------------------------
file='input_totoptdep.nc'
smoothampl=4
;------------------------------------

cdfid = ncdf_open(file)
;
; coordinates
;
varid=ncdf_varid(cdfid,'lat')       & ncdf_varget, cdfid, varid, lati  & lat=n_elements(lati)
varid=ncdf_varid(cdfid,'lon')       & ncdf_varget, cdfid, varid, longi & lon=n_elements(longi)
varid=ncdf_varid(cdfid,'time')      & ncdf_varget, cdfid, varid, time  & ntime=n_elements(time)
;
; field
;
varid=ncdf_varid(cdfid,'totoptdep') & ncdf_varget, cdfid, varid, totoptdep
help, totoptdep
totoptdep=smooth(totoptdep,[smoothampl,smoothampl,0],/EDGE_TRUNCATE) ;; SMOOTH wrt SPACE
fieldname='totoptdep'
outfieldstring='Total dust  optical depth (tauref/700Pa)'
unit='Opacity/Pa'

goto, nointerp
;;;*********************************************************************
;
; INTERPOLATE wrt TIME
;
which_utc_is_TES=3
;; for Hellas 8AM is 02PM LT, i.e. TES measurements
;; IDL convention, starts 0 !!!!
nday=floor(float(ntime-1)/12.)-1 & ref=fltarr(nday) & subsarr=fltarr(nday)
for i=0, n_elements(totoptdep(*,0,0))-1 do begin
	for j=0, n_elements(totoptdep(0,*,0))-1 do begin
		for each=0,nday-1 do begin
  		        subs=each*12 + which_utc_is_TES
			ref(each)=totoptdep(i,j,subs)
			subsarr(each)=subs
		endfor
		;;yeah=interpol(ref,subsarr,findgen(ntime), /spline)
		yeah=interpol(ref,subsarr,findgen(ntime) )
		totoptdep(i,j,*)=yeah
	endfor
endfor
;;;*********************************************************************
nointerp:


;--------------------------------
print,'writing netcdf file'

filencdf='input_totoptdep_tot.nc' & cdfid=ncdf_create(filencdf,/clobber)
;;
londimid=ncdf_dimdef(cdfid,'lon',lon) & latdimid=ncdf_dimdef(cdfid,'lat',lat) & tdimid=ncdf_dimdef(cdfid,'time',ntime)
;;
lonid=ncdf_vardef(cdfid,'lon',[londimid],/float) & ncdf_attput,cdfid,lonid,'long_name','longitude'   & ncdf_attput,cdfid,lonid,'units','degrees_east'
;;
latid=ncdf_vardef(cdfid,'lat',[latdimid],/float) & ncdf_attput,cdfid,latid,'long_name','latitude'    & ncdf_attput,cdfid,latid,'units','degrees_north'
;;
timeid=ncdf_vardef(cdfid,'time',[tdimid],/float) & ncdf_attput,cdfid,timeid,'long_name','model time' & ncdf_attput,cdfid,timeid,'units','hours since 00:00:00'
;;
varid=ncdf_vardef(cdfid,fieldname,[londimid,latdimid,tdimid],/float) 
ncdf_attput,cdfid,varid,'Physics_diagnostic',outfieldstring 
ncdf_attput,cdfid,varid,'units',unit
;;
ncdf_control,cdfid,/endef
;;
ncdf_varput,cdfid,lonid,longi & ncdf_varput,cdfid,latid,lati & ncdf_varput,cdfid,timeid,time & ncdf_varput,cdfid,varid,totoptdep
;;
ncdf_close,cdfid

end
