PRO PREPARE_SIMU

;p0=610.
;r_cp =1/3.89419
;R=191.182

g = 8.87
p1000mb      = 9000000.
r_d          = 191.
cp           = 800.
cv           = cp-r_d
rcp          = r_d/cp

file1='/donnees/sllmd/VENUS/Hiv10/MetY/histmth.200_P.nc'
coord='./input_coord'
sounding='./input_sounding'
therm='./input_therm'
more='./input_more'

getcdf, file=file1, charvar='temp',    invar=temp         & temp[     where(temp    gt 9.99e31) ] = !Values.F_NAN
getcdf, file=file1, charvar='pres',    invar=pres         & pres[     where(pres    gt 9.99e31) ] = !Values.F_NAN
getcdf, file=file1, charvar='zareoid', invar=zareoid      & zareoid[  where(zareoid gt 9.99e31) ] = !Values.F_NAN
getcdf, file=file1, charvar='vitu',    invar=vitu         & vitu[     where(vitu    gt 9.99e31) ] = !Values.F_NAN
getcdf, file=file1, charvar='vitv',    invar=vitv         & vitv[     where(vitv    gt 9.99e31) ] = !Values.F_NAN
getcdf, file=file1, charvar='phis',    invar=phis         
getcdf, file=file1, charvar='ps',      invar=ps
getcdf, file=file1, charvar='latitude',invar=latitude
getcdf, file=file1, charvar='longitude',invar=longitude

getcdf, file=file1, charvar='dtswr',    invar=dtswr        & dtswr[     where(dtswr    gt 9.99e31) ] = !Values.F_NAN
getcdf, file=file1, charvar='dtlwr',    invar=dtlwr        & dtlwr[     where(dtlwr    gt 9.99e31) ] = !Values.F_NAN

s=size(temp)
xxx = floor(s[1]/2) & yyy = floor(s[2]/2) & ttt = 4
;xxx = floor(s[1]/3) & yyy = floor(s[2]/3) & ttt = 4

uprof = reform( vitu    ( xxx,yyy,*,ttt ) )  
vprof = reform( vitv    ( xxx,yyy,*,ttt ) )
tprof = reform( temp    ( xxx,yyy,*,ttt ) )
zprof = reform( zareoid ( xxx,yyy,*,ttt ) )
pprof = reform( pres    ( xxx,yyy,*,ttt ) )
	thprof  = tprof * (p1000mb / pprof) ^ rcp
	thsurf  = thprof(0)
	tsurf   = tprof(0)
	rhoprof = - DERIV( zprof, pprof ) / g
sgeop = reform( phis    ( xxx,yyy       ) ) 
	sheight = sgeop / g
	print, 'sheight (km) ', sheight/1000.
spres = reform( ps      ( xxx,yyy  ,ttt ) ) 
	spres   = spres / 100.  ;; en mbar
	print, 'spres (bar) ', spres / 1.e3	
dtswrprof = reform( dtswr   ( xxx,yyy,*,ttt ) )
dtlwrprof = reform( dtlwr   ( xxx,yyy,*,ttt ) )

w = where(zprof/1000. ge 40.) & s(3) = n_elements(w)
uprof = uprof[w] & vprof = vprof[w] & tprof = tprof[w] & zprof = zprof[w] & pprof = pprof[w] & thprof = thprof[w] & rhoprof = rhoprof[w]
dtswrprof = dtswrprof[w] & dtlwrprof = dtlwrprof[w]
thsurf  = thprof(0) & tsurf   = tprof(0) & sheight = zprof(0) & spres = pprof(0)/100.  
print, 'sheight (km) ', sheight/1000.
print, 'spres (bar) ', spres / 1.e3

zero=0.

;!p.multi=[0,2,1] & plot, thprof, zprof/1000. & plot, uprof, zprof/1000. & oplot, vprof, zprof/1000.
plot, dtswrprof, zprof/1000.
stop

;dtswrprof = reform( dtswr   ( 0,0,*,ttt ) )
;dtlwrprof = reform( dtlwr   ( 0,0,*,ttt ) )
;plot, (dtswrprof+dtlwrprof)/mean(dtswrprof+dtlwrprof), zprof/1000., yrange=[40.,75.]
;for xxx=1,s(1)-1,3 do begin
;for yyy=1,s(2)-1,3 do begin
;dtswrprof = reform( dtswr   ( xxx,yyy,*,ttt ) )
;dtlwrprof = reform( dtlwr   ( xxx,yyy,*,ttt ) )
;oplot, (dtswrprof+dtlwrprof)/mean(dtswrprof+dtlwrprof), zprof/1000.
;endfor
;endfor
;stop



openw, lun, 'heating_rate', /get_lun
for k=0, s(3)-1 do printf, lun, dtswrprof(k), dtlwrprof(k), format='((5x,e13.6)(5x,e13.6))'
FREE_LUN, lun & close, lun

openw, lun, sounding, /get_lun & printf, lun, spres, thsurf, zero, format='((2x,F8.2)(4x,F8.2)(4x,F8.2))'
for k=0, s(3)-1 do printf, lun, zprof(k), thprof(k), zero, uprof(k), vprof(k), format='((2x,F8.2)(4x,F8.2)(4x,F8.2)(4x,F8.2)(4x,F8.2))'
FREE_LUN, lun & close, lun 

openw, lun, more, /get_lun & printf, lun, sheight, tsurf, format='((2x,F8.2)(4x,F6.2))'
FREE_LUN, lun & close, lun

openw, lun, therm, /get_lun 
for k=0, s(3)-1 do printf, lun, r_d, cp, pprof(k), rhoprof(k), tprof(k), format='((4x,F8.2)(4x,F8.2)(5x,e13.6)(5x,e13.6)(4x,F8.2))'
FREE_LUN, lun & close, lun

openw, lun, coord, /get_lun 
printf, lun, longitude(xxx), '    lon'
printf, lun, latitude(yyy),  '    lat'
printf, lun, zero,           '    ls '
printf, lun, zero,           '    lct'
printf, lun, zero,           '    ztop'
printf, lun, zero,           '    nz' 
FREE_LUN, lun & close, lun

end
