!
! $Header: /home/cvsroot/LMDZ4/libf/phylmd/iniphysiq.F,v 1.1.1.1 2004/05/19 12:53:08 lmdzadmin Exp $
!
c
c
      SUBROUTINE iniphysiq(ngrid,nlayer,
     $           punjours,
     $           pdayref,ptimestep,
     $           plat,plon,parea,pcu,pcv,
     $           prad,pg,pr,pcpp,iflag_phys)

c
c=======================================================================
c
c   subject:
c   --------
c
c   Initialisation for the physical parametrisations of the LMD 
c   martian atmospheric general circulation modele.
c
c   author: Frederic Hourdin 15 / 10 /93
c   -------
c
c   arguments:
c   ----------
c
c   input:
c   ------
c
c    ngrid                 Size of the horizontal grid.
c                          All internal loops are performed on that grid.
c    nlayer                Number of vertical layers.
c    pdayref               Day of reference for the simulation
c    firstcall             True at the first call
c    lastcall              True at the last call
c    pday                  Number of days counted from the North. Spring
c                          equinoxe.
c
c=======================================================================
c
c-----------------------------------------------------------------------
c   declarations:
c   -------------
 
      USE dimphy, only : klev
      USE mod_grid_phy_lmdz, only : klon_glo
      USE mod_phys_lmdz_para, only : klon_omp,klon_omp_begin,
     &                               klon_omp_end,klon_mpi_begin
      USE comgeomphy, only : airephy,cuphy,cvphy,rlond,rlatd
      IMPLICIT NONE
#include "iniprint.h"

      REAL,INTENT(IN) :: prad ! radius of the planet (m)
      REAL,INTENT(IN) :: pg ! gravitational acceleration (m/s2)
      REAL,INTENT(IN) :: pr ! ! reduced gas constant R/mu
      REAL,INTENT(IN) :: pcpp ! specific heat Cp
      REAL,INTENT(IN) :: punjours ! length (in s) of a standard day
      INTEGER,INTENT(IN) :: ngrid ! number of horizontal grid points in the physics
      INTEGER,INTENT(IN) :: nlayer ! number of atmospheric layers
      REAL,INTENT(IN) :: plat(ngrid) ! latitudes of the physics grid
      REAL,INTENT(IN) :: plon(ngrid) ! longitudes of the physics grid
      REAL,INTENT(IN) :: parea(klon_glo) ! area (m2)
      REAL,INTENT(IN) :: pcu(klon_glo) ! cu coeff. (u_covariant = cu * u)
      REAL,INTENT(IN) :: pcv(klon_glo) ! cv coeff. (v_covariant = cv * v)
      INTEGER,INTENT(IN) :: pdayref ! reference day of for the simulation
      REAL,INTENT(IN) :: ptimestep !physics time step (s)
      INTEGER,INTENT(IN) :: iflag_phys ! type of physics to be called

      INTEGER :: ibegin,iend,offset
      CHARACTER (LEN=20) :: modname='iniphysiq'
      CHARACTER (LEN=80) :: abort_message
 
      IF (nlayer.NE.klev) THEN
         write(lunout,*) 'STOP in ',trim(modname)
         write(lunout,*) 'Problem with dimensions :'
         write(lunout,*) 'nlayer     = ',nlayer
         write(lunout,*) 'klev   = ',klev
         abort_message = ''
         CALL abort_gcm (modname,abort_message,1)
      ENDIF

      IF (ngrid.NE.klon_glo) THEN
         write(lunout,*) 'STOP in ',trim(modname)
         write(lunout,*) 'Problem with dimensions :'
         write(lunout,*) 'ngrid     = ',ngrid
         write(lunout,*) 'klon   = ',klon_glo
         abort_message = ''
         CALL abort_gcm (modname,abort_message,1)
      ENDIF

c$OMP PARALLEL PRIVATE(ibegin,iend) 
c$OMP+         SHARED(parea,pcu,pcv,plon,plat)
      
      offset=klon_mpi_begin-1
      airephy(1:klon_omp)=parea(offset+klon_omp_begin:
     &                          offset+klon_omp_end)
      cuphy(1:klon_omp)=pcu(offset+klon_omp_begin:offset+klon_omp_end)
      cvphy(1:klon_omp)=pcv(offset+klon_omp_begin:offset+klon_omp_end)
      rlond(1:klon_omp)=plon(offset+klon_omp_begin:offset+klon_omp_end)
      rlatd(1:klon_omp)=plat(offset+klon_omp_begin:offset+klon_omp_end)

      call suphec

c$OMP END PARALLEL

c     print*,'ATTENTION !!! TRAVAILLER SUR INIPHYSIQ'
c     print*,'CONTROLE DES LATITUDES, LONGITUDES, PARAMETRES ...'

c      print*,'agagagagagagagagaga'
c      print*,'klon_mpi_begin =', klon_mpi_begin
c      print*,'klon_mpi_end =', klon_mpi_end
c      print*,'klon_mpi =', klon_mpi
c      print*,'klon_mpi_para_nb =', klon_mpi_para_nb
c      print*,'klon_mpi_para_begin =', klon_mpi_para_begin
c      print*,'klon_mpi_para_end  =', klon_mpi_para_end
c      print*,'mpi_rank =', mpi_rank
c      print*,'mpi_size =', mpi_size
c      print*,'mpi_root =', mpi_root
c      print*,'klon_glo =', klon_glo
c      print*,'is_mpi_root =',is_mpi_root
c      print*,'is_omp_root =',is_omp_root

! pas d'inifis ici... 
! est-ce que cursor est utile ? Voir avec Aymeric
!      cursor = klon_mpi_begin
!      print*, "CURSOR !!!!", mpi_rank, cursor

      RETURN
      END
