      SUBROUTINE REGIS (FNU,ND1,NNU,T,ND2,NT,XN2N2,XCH4CH4,XN2CH4,XN2H2)
C THIS SUBROUTINE RETURNS THE PRESSURE INDUCED ABSORBTION COEFFICIENTS
C FOR N2-N2, CH4-CH4, N2-CH4 + CH4-N2, H2-N2 + N2-H2.
C FNU IS THE WAVENUMBER ARRAY
C T IS THE TEMPERATURE ARRAY
C NNU IS THE NUMBER OF WAVENUMBERS
C NT IS THE NUMBER OF TEMPERATURES
C ND1 IS THE DIMENSION OF THE WAVENUMERS
C ND2 IS THE DIMENSION OF THE TEMPERATURES
C XN2N2(ND1,ND2) IS THE N2-N2 COEFFICIENT
C XCH4CH4(ND1,ND2) IS THE CH4-CH4 COEFFICIENT
C XN2CH4(ND1,ND2) IS THE N2-CH4 + CH4-N2 COEFFICIENT
C XN2H2(ND1,ND2) IS THE N2-H2 + H2-N2 COEFFICIENT
C FROM REGIS COURTIN ADAPTED BY CPM.
      IMPLICIT REAL (A-H,O-Z)
      DIMENSION FNU(NNU),T(NT),
     & XN2N2(ND1,ND2),XCH4CH4(ND1,ND2),XN2H2(ND1,ND2),XN2CH4(ND1,ND2)
      DIMENSION F8MN(100),F8NH(100),F8HN(100),F10(100),
     2 XN2R(100),XN2T(100),XCH4R(100),XCH4T(100),XH2R(100),XH2T(100)
      DATA EPS1/71.4/,EPS2/148.6/,EPS3/36.8/
      DO 1 IT=1,NT
      EPS4=SQRT(EPS1*EPS2)
      EPS5=SQRT(EPS1*EPS3)
      Y=4.*EPS4/T(IT)
      F8MN(IT)=FI8(Y)
      F10(IT)=FI10(Y)
      Y=4.*EPS5/T(IT)
      Z=FI8(Y)
      F8NH(IT)=Z
      F8HN(IT)=Z
      Y=4.*EPS1/T(IT)
      Z=FI8(Y)
      F8MN(IT)=F8MN(IT)/Z
      F8HN(IT)=F8HN(IT)/Z
      Y=4.*EPS2/T(IT)
      F10(IT)=F10(IT)/FI10(Y)
      Y=4.*EPS3/T(IT)
      F8NH(IT)=F8NH(IT)/FI8(Y)
1     CONTINUE
      CALL PIAN2(0.,NT,XN2R,XN2T,T)
      CALL PIACH4(0.,NT,XCH4R,XCH4T,T)
      CALL PIAH2(0.,NT,XH2R,XH2T,T)
      DO 2 INU=1,NNU
      CALL OPAN2(FNU(INU),NT,XN2R,XN2T,T)
      CALL OPACH4(FNU(INU),NT,XCH4R,XCH4T,T)
      CALL OPAH2(FNU(INU),NT,XH2R,XH2T,T)
c!!!! CALL OPAN2(FNU(INU),NT,XN2R,XN2T)
c!!!! CALL OPACH4(FNU(INU),NT,XCH4R,XCH4T)
c!!!! CALL OPAH2(FNU(INU),NT,XH2R,XH2T)
      DO 11 IT=1,NT
      XN2N2(INU,IT)=XN2R(IT)+XN2T(IT)
      XCH4CH4(INU,IT)=XCH4R(IT)+XCH4T(IT)
C
C  LINES 1 AND 3 ARE CORRECTION FACTORS INTRODUCED IN ORDER TO FIT
C  THE MEASUREMENTS OF DAGG ET AL (1986) BETWEEN 126 AND 212 K.
C
      XN2CH4(INU,IT)=F8MN(IT)*(2.067*XN2R(IT)+2.865*XN2T(IT))
     1  * 2.48/(T(IT)**0.184)  +
     2               F10(IT)*(0.480*XCH4R(IT)+0.374*XCH4T(IT))
     3  * 1.54
C
C  LINE 3 IS A CORRECTION FACTOR INTRODUCED IN ORDER TO FIT
C  THE MEASUREMENTS OF DORE ET AL (1986) BETWEEN 91 AND 298 K.
C  OTHER CORRECTION FACTORS ARE IMBEDDED IN THE ROUTINE PIAH2.
C
      XN2H2(INU,IT)= F8NH(IT)*(2.543*XH2R(IT)+1.445E1*XH2T(IT)) +
     2               F8HN(IT)*(0.360*XN2R(IT)+0.246*XN2T(IT))
     3  * 0.30
11    CONTINUE
2     CONTINUE
      RETURN
      END
