!
! $Header: /home/cvsroot/LMDZ4/libf/phylmd/conf_phys.F90,v 1.3 2005/02/07 15:15:31 fairhead Exp $
!
!
!

  subroutine conf_phys(ok_journe, ok_mensuel, ok_instan, &
 &                     if_ebil)

   use IOIPSL
   implicit none

#include "YOMCST.inc"
#include "clesphys.inc"
#include "compbl.h"
!
! Configuration de la "physique" de LMDZ a l'aide de la fonction
! GETIN de IOIPSL
!
! LF 05/2001
!
!--- Ca lit le physiq.def ---

!
! ok_journe:  sorties journalieres
! ok_mensuel: sorties mensuelles
! ok_instan:  sorties instantanees


! Sortie:
  logical              :: ok_journe, ok_mensuel, ok_instan        
  integer              :: if_ebil

! Local
  integer              :: numout = 6
  real*4               :: zzz
! real                 :: zzz

!Config Key  = OK_journe
!Config Desc = Pour des sorties journalieres 
!Config Def  = .false.
!Config Help = Pour creer le fichier histday contenant les sorties
!              journalieres 
!
  ok_journe = .false.
  call getin('OK_journe', ok_journe)
!
!Config Key  = OK_mensuel
!Config Desc = Pour des sorties mensuelles 
!Config Def  = .true.
!Config Help = Pour creer le fichier histmth contenant les sorties
!              mensuelles 
!
  ok_mensuel = .true.
  call getin('OK_mensuel', ok_mensuel)
!
!Config Key  = OK_instan
!Config Desc = Pour des sorties instantanees 
!Config Def  = .false.
!Config Help = Pour creer le fichier histins contenant les sorties
!              instantanees 
!
  ok_instan = .false.
  call getin('OK_instan', ok_instan)
!
!
!Config Key  = if_ebil
!Config Desc = Niveau de sortie pour les diags bilan d'energie 
!Config Def  = 0
!Config Help = 
!               
!
  if_ebil = 0
  call getin('if_ebil', if_ebil)
!!
!! Constante solaire & Parametres orbitaux & taux gaz effet de serre BEG
!!
!Config Key  = R_ecc
!Config Desc = Excentricite
!Config Def  = 0.006787
!Config Help = 
!               
! VENUS
! R_ecc = 0.006787
  zzz   = 0.0
  call getin('R_ecc', zzz)
  R_ecc = zzz
!!
!Config Key  = R_peri
!Config Desc = Equinoxe
!Config Def  = 
!Config Help = 
!               
! VENUS
  zzz = 0.
  call getin('R_peri', zzz)
  R_peri = zzz
!!
!Config Key  = R_incl
!Config Desc = Inclinaison
!Config Def  = 
!Config Help = 
!               
! VENUS
  zzz = 0.0
  call getin('R_incl', zzz)
  R_incl = zzz
!
!Config Key  = solaire
!Config Desc = Constante solaire en W/m2
! VENUS
!Config Def  = 2620.
!Config Help = 
!
  zzz = 2620.
    call getin('solaire', zzz)
  solaire = zzz
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! PARAMETER FOR THE PLANETARY BOUNDARY LAYER AND SOIL
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!Config Key  = iflag_pbl
!Config Desc =
!Config Def  = 1
!Config Help =
!
! 2   = calculs Cd et K simples pour VENUS :
!       parametres = z0, lmixmin, ksta (en dur: umin2,ric,cepdu2,karman)
! 1   = calculs Cd et K issus LMDZ Terre
!       parametres = ksta, ok_kzmin (et plein d'autres en dur...)
! 6-9 = schema des thermiques Fred
  iflag_pbl = 1
  call getin('iflag_pbl',iflag_pbl)

!
!Config Key  = ksta
!Config Desc =
!Config Def  = 1.0e-7
!Config Help =
!
  zzz = 1.0e-7
  call getin('ksta',zzz)
  ksta = zzz

!
!Config Key  = z0
!Config Desc =
!Config Def  = 1.0e-2
!Config Help =
!
  zzz = 1.0e-2
  call getin('z0',zzz)
  z0 = zzz

!
!Config Key  = lmixmin
!Config Desc =
!Config Def  = 35.
!Config Help =
!
  zzz = 35.
  call getin('lmixmin',zzz)
  lmixmin = zzz

!
!
!Config Key  = ok_kzmin
!Config Desc =
!Config Def  = .false.
!Config Help =
!
  ok_kzmin = .false.
  call getin('ok_kzmin',ok_kzmin)


!Config Key  = iflag_ajs
!Config Desc =
!Config Def  = 0
!Config Help =
!
  iflag_ajs = 1
  call getin('iflag_ajs',iflag_ajs)

!
!Config Key  = inertie
!Config Desc =
!Config Def  = 30000.
!Config Help =
!
  zzz = 30000.
  call getin('inertie',zzz)
  inertie = zzz
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! PARAMETER FOR THE OUTPUT LEVELS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!Config Key  = lev_histhf
!Config Desc =
!Config Def  = 0
!Config Help =
!
  lev_histhf = 0
  call getin('lev_histhf',lev_histhf)

!
!Config Key  = lev_histday
!Config Desc =
!Config Def  = 1
!Config Help =
!
  lev_histday = 1
  call getin('lev_histday',lev_histday)

!
!Config Key  = lev_histmth
!Config Desc =
!Config Def  = 2
!Config Help =
!
  lev_histmth = 2
  call getin('lev_histmth',lev_histmth)

!
!
!Config Key  = 
!Config Desc =  
!Config Def  =
!Config Help = 
!
!   =
!  call getin('',)
!
!
!
!

  write(numout,*)' ##############################################'
  write(numout,*)' Configuration des parametres de la physique: '
  write(numout,*)' Sortie journaliere = ', ok_journe
  write(numout,*)' Sortie mensuelle = ', ok_mensuel
  write(numout,*)' Sortie instantanee = ', ok_instan
  write(numout,*)' Sortie bilan d''energie, if_ebil =', if_ebil
  write(numout,*)' Excentricite = ',R_ecc
  write(numout,*)' Equinoxe = ',R_peri
  write(numout,*)' Inclinaison =',R_incl
  write(numout,*)' iflag_pbl = ', iflag_pbl
  write(numout,*)' z0 = ',z0 
  write(numout,*)' lmixmin = ',lmixmin 
  write(numout,*)' ksta = ',ksta 
  write(numout,*)' ok_kzmin = ',ok_kzmin 
  write(numout,*)' inertie = ', inertie 
  write(numout,*)' iflag_ajs = ', iflag_ajs
  write(numout,*)' lev_histhf = ',lev_histhf 
  write(numout,*)' lev_histday = ',lev_histday 
  write(numout,*)' lev_histmth = ',lev_histmth 

  return

  end subroutine conf_phys

