!
! $Header: /home/cvsroot/LMDZ4/libf/phylmd/FCTTRE.h,v 1.1.1.1 2004/05/19 12:53:08 lmdzadmin Exp $
!
C     ------------------------------------------------------------------
C     This COMDECK includes the Thermodynamical functions for the cy39
C       ECMWF Physics package.
C       Consistent with YOMCST Basic physics constants, assuming the
C       partial pressure of water vapour is given by a first order
C       Taylor expansion of Qs(T) w.r.t. to Temperature, using constants
C       in YOETHF
C     ------------------------------------------------------------------
      REAL PTARG, PDELARG, P5ARG, PQSARG, PCOARG
      REAL FOEEW, FOEDE, qsats, qsatl, dqsats, dqsatl
      LOGICAL thermcep
      PARAMETER (thermcep=.TRUE.)
C
      FOEEW ( PTARG,PDELARG ) = EXP (
     S          (R3LES*(1.-PDELARG)+R3IES*PDELARG) * (PTARG-RTT)
     S / (PTARG-(R4LES*(1.-PDELARG)+R4IES*PDELARG)) )
C
      FOEDE ( PTARG,PDELARG,P5ARG,PQSARG,PCOARG ) = PQSARG*PCOARG*P5ARG
     S / (PTARG-(R4LES*(1.-PDELARG)+R4IES*PDELARG))**2
c
      qsats(ptarg) = 100.0 * 0.622 * 10.0
     .           ** (2.07023 - 0.00320991 * ptarg
     .           - 2484.896 / ptarg + 3.56654 * LOG10(ptarg))
      qsatl(ptarg) = 100.0 * 0.622 * 10.0
     .           ** (23.8319 - 2948.964 / ptarg
     .           - 5.028 * LOG10(ptarg)
     .           - 29810.16 * EXP( - 0.0699382 * ptarg)
     .           + 25.21935 * EXP( - 2999.924 / ptarg))
c
      dqsats(ptarg,pqsarg) = RLVTT/RCPD*pqsarg * (3.56654/ptarg
     .                     +2484.896*LOG(10.)/ptarg**2
     .                     -0.00320991*LOG(10.))
      dqsatl(ptarg,pqsarg) = RLVTT/RCPD*pqsarg*LOG(10.)*
     .                (2948.964/ptarg**2-5.028/LOG(10.)/ptarg
     .                +25.21935*2999.924/ptarg**2*EXP(-2999.924/ptarg)
     .                +29810.16*0.0699382*EXP(-0.0699382*ptarg))
