!
! $Header: /home/cvsroot/LMDZ4/libf/phylmd/phyredem.F,v 1.2 2004/06/22 11:45:34 lmdzadmin Exp $
!
c
      SUBROUTINE phyredem (fichnom,dtime,radpas,chimpas,
     .           rlat,rlon, tsol,tsoil,
     .           albedo, 
     .           solsw, sollw,fder,
     .           radsol,
     .           t_ancien)
      IMPLICIT none
c======================================================================
c Auteur(s) Z.X. Li (LMD/CNRS) date: 19930818
c Objet: Ecriture de l'etat de redemarrage pour la physique
c======================================================================
#include "dimensions.h"
#include "dimphy.h"
#include "netcdf.inc"
#include "dimsoil.h"
#include "clesphys.h"
#include "control.h"
#include "temps.h"
c======================================================================
      CHARACTER*13 fichnom
      REAL dtime
      INTEGER radpas,chimpas
      REAL rlat(klon), rlon(klon)
      REAL tsol(klon)
      REAL tsoil(klon,nsoilmx)
      REAL albedo(klon)
      real solsw(klon)
      real sollw(klon)
      real fder(klon)
      REAL radsol(klon)
      REAL t_ancien(klon,klev)
c
      INTEGER nid, nvarid, idim1, idim2, idim3
      INTEGER ierr
      INTEGER length
      PARAMETER (length=100)
      REAL tab_cntrl(length)
c
      INTEGER isoil
      CHARACTER*2 str2
c
c     print*,'fichnom',fichnom
      ierr = NF_CREATE(fichnom, NF_CLOBBER, nid)
      IF (ierr.NE.NF_NOERR) THEN
        write(6,*)' Pb d''ouverture du fichier '//fichnom
        write(6,*)' ierr = ', ierr
        CALL ABORT
      ENDIF
c
      ierr = NF_PUT_ATT_TEXT (nid, NF_GLOBAL, "title", 28,
     .                       "Fichier redemarrage physique")
c
      ierr = NF_DEF_DIM (nid, "index", length, idim1)
      ierr = NF_DEF_DIM (nid, "points_physiques", klon, idim2)
      ierr = NF_DEF_DIM (nid, "horizon_vertical", klon*klev, idim3)
c
      ierr = NF_ENDDEF(nid)
c
      DO ierr = 1, length
         tab_cntrl(ierr) = 0.0
      ENDDO
      tab_cntrl(1) = dtime
      tab_cntrl(2) = radpas
      tab_cntrl(3) = chimpas
      tab_cntrl(4) = solaire
      tab_cntrl(5) = 0
      tab_cntrl(6) = nbapp_rad
      tab_cntrl(16)= nbapp_chim

      IF( cycle_diurne ) tab_cntrl( 7 ) = 1.
      IF(   soil_model ) tab_cntrl( 8 ) = 1.
      IF(     new_oliq ) tab_cntrl( 9 ) = 1.
      IF(     ok_orodr ) tab_cntrl(10 ) = 1.
      IF(     ok_orolf ) tab_cntrl(11 ) = 1.

      tab_cntrl(13) = day_end
      tab_cntrl(14) = annee_ref
      tab_cntrl(15) = itau_phy
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "controle", NF_DOUBLE, 1, idim1,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "controle", NF_FLOAT, 1, idim1,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 22,
     .                        "Parametres de controle")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tab_cntrl)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,tab_cntrl)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "longitude", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "longitude", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 32,
     .                        "Longitudes de la grille physique")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rlon)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rlon)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "latitude", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "latitude", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 31,
     .                        "Latitudes de la grille physique")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rlat)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rlat)
#endif
c
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid, "TS", NF_DOUBLE, 1, idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid, "TS", NF_FLOAT, 1, idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 22,
     .                        "Temperature de surface")
        ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tsol(1))
#else
        ierr = NF_PUT_VAR_REAL (nid,nvarid,tsol(1))
#endif
c
      DO isoil=1, nsoilmx
        IF (isoil.LE.99) THEN
        WRITE(str2,'(i2.2)') isoil
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid, "Tsoil"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid, "Tsoil"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 24,
     .                        "Temperature du sol No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de couches"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tsoil(1,isoil))
#else
        ierr = NF_PUT_VAR_REAL (nid,nvarid,tsoil(1,isoil))
#endif
      ENDDO
c
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"ALBE",NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"ALBE",NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 18,
     .                        "albedo de surface")
        ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,albedo(1))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,albedo(1))
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "solsw", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "solsw", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 32,
     .                        "Rayonnement solaire a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,solsw)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,solsw)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "sollw", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "sollw", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 27,
     .                        "Rayonnement IF a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,sollw)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,sollw)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "fder", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "fder", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 14,
     .                        "Derive de flux")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,fder)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,fder)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RADS", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RADS", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Rayonnement net a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,radsol)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,radsol)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "TANCIEN", NF_DOUBLE, 1, idim3,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "TANCIEN", NF_FLOAT, 1, idim3,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,t_ancien)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,t_ancien)
#endif
c
      ierr = NF_CLOSE(nid)
c
      RETURN
      END
