      SUBROUTINE optcv_1pt(zqaer_1pt,ioptv,
     .            COSBV_1pt,DTAUV_1pt,TAUHV_1pt,TAUHVD_1pt,TAUCV_1pt,
     .       TAURV_1pt,TAUGV_1pt,TAUGVD_1pt,WBARV_1pt,TAUV_1pt,IPRINT)


#include "dimensions.h"
#include "dimphy.h"
#include "microtab.h"
#include "clesphys.h"

      PARAMETER(NLAYER=llm,NLEVEL=NLAYER+1)
      PARAMETER (NSPECI=46,NSPC1I=47,NSPECV=24,NSPC1V=25)

c   Arguments:
c   ---------
      integer IPRINT,ioptv
C ioptv: premier appel, on ne calcule qu'une fois les QM et QF
* nrad dans microtab.h
      real   zqaer_1pt(NLAYER,nrad)
      real   TAUHVD_1pt(NLAYER,NSPECV)
      real   TAUGVD_1pt(NLAYER,NSPECV)
      real   TAUHV_1pt(NSPECV),TAUCV_1pt(NSPECV)
      real   TAURV_1pt(NSPECV),TAUGV_1pt(NSPECV)
      real   DTAUV_1pt(NLAYER,NSPECV,4),TAUV_1pt(NLEVEL,NSPECV,4)
      real   WBARV_1pt(NLAYER,NSPECV,4)
      real   COSBV_1pt(NLAYER,NSPECV,4)
c   ---------

      COMMON /ATM/ Z(NLEVEL),PRESS(NLEVEL),DEN(NLEVEL),TEMP(NLEVEL)

      COMMON /GASS/ CH4(NLEVEL),XN2(NLEVEL),H2(NLEVEL),AR(NLEVEL)
     & ,XMU(NLEVEL),GAS1(NLAYER),COLDEN(NLAYER)

      COMMON /VISGAS/SOLARF(NSPECV),NTERM(NSPECV),PEXPON(NSPECV),
     &         ATERM(4,NSPECV),BTERM(4,NSPECV)

      COMMON /AERSOL/ RADIUS(NLAYER), XNUMB(NLAYER)
     & , REALI(NSPECI), XIMGI(NSPECI), REALV(NSPECV), XIMGV(NSPECV)

      COMMON /CLOUD/ RADCLD(NLAYER), XNCLD(NLAYER)
     &             , RCLDI(NSPECI), XICLDI(NSPECI)
     &             , RCLDV(NSPECV), XICLDV(NSPECV)

      COMMON /SPECTV/ BWNV(NSPC1V),WNOV(NSPECV) 
     &               ,DWNV(NSPECV),WLNV(NSPECV)

      COMMON /PLANT/ CSUBP,RSFI,RSFV,F0PI
      COMMON /ADJUST/ RHCH4,FH2,FHAZE,FHVIS,FHIR,TAUFAC,RCLOUD,FARGON
      COMMON /CONST/ RGAS,RHOP,PI,SIGMA
* nrad dans microtab.h
      COMMON /part/ v(nrad),rayon(nrad),vrat,dr(nrad),dv(nrad)

      REAL QF1(nrad,NSPECV),QF2(nrad,NSPECV)
      REAL QF3(nrad,NSPECV),QF4(nrad,NSPECV)
      REAL QM1(nrad,NSPECV),QM2(nrad,NSPECV)
      REAL QM3(nrad,NSPECV),QM4(nrad,NSPECV)

      save qf1,qf2,qf3,qf4,qm1,qm2,qm3,qm4
 
C*
C THIS SUBROUTINE SETS THE OPTICAL CONSTANTS IN THE VISIBLE
C IT CALCUALTES FOR EACH LAYER, FOR EACH SPECRAL INTERVAL IN THE VIS
C LAYER: WBAR, DTAU, COSBAR
C LEVEL: TAU
C
C ZERO THE COLUMN OPTICAL DEPTHS OF EACH TYPE
C ??FLAG? THE OPTICAL DEPTH OF THE TOP OF THE MODEL
C MAY NOT BE ZERO.

c******* DEBUT DES BOUCLES ************************
      DO 100 K=1,NSPECV         !b! BOUCLE SUR LAMBDA

      TAURV_1pt(K)=0.
      TAUHV_1pt(K)=0.            ! INTEGRATED TAU.......INITIALIZATION.
      TAUCV_1pt(K)=0.            ! Rayleigh, Haze, Cloud, Gas
      TAUGV_1pt(K)=0.            !   sca,    abs,  abs  , abs

      DO 100 J=1,NLAYER         !a! BOUCLE SUR L"ALTITUDE

C #1:                   HAZE
c---------------------------

c     CALL THE MIE CODE TO GIVE THE AEROSOL PROPERTIES
c     USE XFRAC FOR FRACTAL AEROSOLS PROPERTIES AT LAMBDA < 2. um 




c                    /\
c                   /  \
c                  /    \
c                 / _O   \
c                / |/     \
c               /  / \     \
c              /   |\ \/\   \
c             /    || /  \   \
c             ----------------
c            |     WARNING    |
c            |    SLOW DOWN   |
c             ---------------- 




c*********** EN TRAVAUX ***************************
 
         TAEROS=0.
         TAEROSCAT=0.
         CBAR=0.

c       print*,"rayon=",rayon
c       print*,"RF=",RF

      DO inq=1,nrad         !BOUCLE SUR LES TAILLE D"AEROSOLS


            IF (rayon(inq).lt.RF(inq)) THEN    ! aerosols spheriques

              
            if(ioptv.eq.0.and.J.eq.1) then
c                  CALL XMIE(rayon(inq)*1.e6,REALV(K),XIMGV(K),
c    &             QEXT,QSCT,QABS,QBAR,WNOV(K))

                CALL CMIE(1.E-2/WNOV(K),REALV(K),XIMGV(K),rayon(inq),
     &          QEXT,QSCT,QABS,QBAR)

c       print*,'inq=',inq,' QM1=',QM1(inq,K),' QEXT=',QEXT

              QM1(inq,K)=QEXT
              QM2(inq,K)=QSCT
              QM3(inq,K)=QABS
              QM4(inq,K)=QBAR
            endif

       TAEROS=QM1(inq,K)*zqaer_1pt(NLAYER+1-J,inq)*1.e-4+TAEROS
       TAEROSCAT=QM2(inq,K)*zqaer_1pt(NLAYER+1-J,inq)*1.e-4+TAEROSCAT
       CBAR=CBAR+QM4(inq,K)*QM2(inq,K)*zqaer_1pt(NLAYER+1-J,inq)*1.e-4

            ELSE                        ! aerosols fractals

               XMONO=(rayon(inq)/RF(inq))**3.
               XRULE=1. 

            if(XMONO.gt.16384./1.5) then 
             XRULE=(XMONO/16384.) 
             XMONO=16384.
            endif 

            if(ioptv.eq.0.and.J.eq.1) then

        CALL OPTFRAC(XMONO,10000./WNOV(K)
     &                        ,QEXT,QSCT,QABS,QBAR)

c       CALL CFFFV11(1.e-2/WNOV(K),REALV(K),XIMGV(K),RF(inq),2.
c    &   ,XMONO,QSCT,QEXT,QABS,QBAR)


              QF1(inq,K)=QEXT*XRULE
              QF2(inq,K)=QSCT*XRULE
              QF3(inq,K)=QABS*XRULE
              QF4(inq,K)=QBAR

c       print*,'inq=',inq,' QF1=',QF1(inq,K),' QEXT=',QEXT,' XRULE=',XRULE
                   
            endif

        TAEROS=QF1(inq,K)*zqaer_1pt(NLAYER+1-J,inq)+TAEROS
        TAEROSCAT=QF2(inq,K)*zqaer_1pt(NLAYER+1-J,inq)+TAEROSCAT
        CBAR=CBAR+QF4(inq,K)*QF2(inq,K)*zqaer_1pt(NLAYER+1-J,inq)

           ENDIF 


       ENDDO    ! nrad


       CBAR=CBAR/TAEROSCAT

        DELTAZ=Z(J)-Z(J+1)

c --------------------------------------------------------------------
c profil brume Pascal: fit T (sauf tropopause) et albedo
c -------------------
        if( cutoff.eq.1) then
         IF(PRESS(J).gt.9.e-3) THEN
          TAEROS=TAEROSM1*DELTAZ/DELTAZM1*0.85
          TAEROSCAT=TAEROSCATM1*DELTAZ/DELTAZM1*0.85
c         TAEROS=0.
c         TAEROSCAT=0.
         ENDIF

         IF(PRESS(J).gt.1.e-1) THEN
          TAEROS=TAEROSM1*DELTAZ/DELTAZM1*1.15
          TAEROSCAT=TAEROSCATM1*DELTAZ/DELTAZM1*1.15
c         TAEROS=0.
c         TAEROSCAT=0.
         ENDIF
        endif !cutoff=1

c profil brume pour fit T (y compris tropopause), mais ne fit plus albedo...
c -----------------------
        if( cutoff.eq.2) then
         IF(PRESS(J).gt.1.e-1) THEN
          TAEROS=0.
          TAEROSCAT=0.
         ENDIF
        endif !cutoff=2
c --------------------------------------------------------------------

         TAEROSM1=TAEROS
         TAEROSCATM1=TAEROSCAT
         DELTAZM1=DELTAZ


       IF (TAEROSCAT.le.0.) CBAR=0. 

      if (IPRINT.eq.1) then
      if (k.eq.NSPECV/2) then   
       print*,'@VI',K,J,TAEROS,TAEROSCAT,CBAR
       print*,'@  ',K,J,QF1(1,K),QF2(1,K),zqaer_1pt(NLAYER+1-J,1)
       print*,'@  ',K,J,QF1(3,K),QF2(3,K),zqaer_1pt(NLAYER+1-J,3)
       print*,'@  ',K,J,QF1(5,K),QF2(5,K),zqaer_1pt(NLAYER+1-J,5)
       print*,'@  ',K,J,QF1(7,K),QF2(7,K),zqaer_1pt(NLAYER+1-J,7)
       print*,'@  ',K,J,QF1(9,K),QF2(9,K),zqaer_1pt(NLAYER+1-J,9)
       print*
      endif
      endif



c*********** EN TRAVAUX ***************************

C #2:                   RAYLEIGH
c-------------------------------

C RAYLEIGH SCATTERING STRAIGHT FROM HANSEN AND TRAVIS...SEE NOTES
C RATIOED BY THE LAYER COLUMN NUMBER TO THE TOTAL
C COLUMN NUMBER ON EARTH. CM-2
C THIS IS THE SCATTERING BY THE ATMOSPHERE

      TAURAY=(COLDEN(J)*28.9/(XMU(J)*1013.25))*
     &(.008569/WLNV(K)**4)*(1.+.0113/WLNV(K)**2+.00013/WLNV(K)**4)

c       PRINT*,WLNV(K)
c      COLX=0.
c      COLP=0.
c      COLT=0.
c     DO IU=1,NLAYER
c      COLP=COLDEN(IU)*1.e+1*1.35+COLP
c     TAURAY=(COLDEN(IU)*28.9/(XMU(IU)*1013.25))*
c    & (.008569/WLNV(K)**4)*(1.+.0113/WLNV(K)**2
c    & +.00013/WLNV(K)**4)
c      COLT=COLT+TAURAY
c      COLX=COLDEN(IU)*1.e+1/(1.E5*28./22.4E3)*1.e-1*0.0933e-1+COLX
c                           |    
c                           |    
c           g/cm2->kg/m2    |  m2/kg   
c      Print*,IU, tauray, 
c    &   COLDEN(IU)*1.e+1/(1.E5*28./22.4E3)*1.e-1*0.543e-1
c     ENDDO
c       PRINT*,COLP,' PRESSURE AT GROUND;'
c       PRINT*,COLX,' TAU_GAS AT GROUND;'
c       print*,colt,colx,' COLT, COLX'
c      STOP
							
c       DZ=Z(J)-Z(J+1)
c     PRINT*, Z(J),WLNV(K),
c    &(28.9/(XMU(J)*1013.25))*(.008569/WLNV(K)**4)*
c    &(1.+.0113/WLNV(K)**2+.00013/WLNV(K)**4)
c    & ,COLDEN(J)/DZ/100000.,
c    &(28.9/(XMU(J)*1013.25))*(.008569/WLNV(K)**4)*
c    &(1.+.0113/WLNV(K)**2+.00013/WLNV(K)**4)
c    & *COLDEN(J)/DZ/100000.
    
 

C #3:                   CLOUD
c----------------------------

C NEXT COMPUTE TAU CLOUD

      TAUCLD=0.0
      CBARC =0.0
      QEXTC =0.0
      QSCTC =0.0
c             XNCLD(J)=0.
      IF ( XNCLD(J) .GT. 0. .and .taufac.gt.0.) THEN
                CALL XMIE(RADCLD(J),RCLDV(K),XICLDV(K),
     &                         QEXTC,QSCTC,QABSC,CBARC,WNOV(K))
                TAUCLD=QEXTC*XNCLD(J)         
      ENDIF
C
      TAURV_1pt(K)=TAURV_1pt(K)+TAURAY
      TAUGVD_1pt(J,K)=TAURV_1pt(K)

      TAUHV_1pt(K)=TAUHV_1pt(K)+TAEROS          ! INTEGRATED Quant.
      TAUHVD_1pt(J,K)=TAUHV_1pt(K)

      TAUCV_1pt(K)=TAUCV_1pt(K)+TAUCLD

C #4:                  TAUGAS
C----------------------------

C LOOP OVER THE NTERMS
C THIS IS THE ABSORPTION BY THE ATMOSPHERE (METHANE)


      DO 909 NT=1,NTERM(K)
      TAUGAS=COLDEN(J)*GAS1(J)*BTERM(NT,K)*
     &  (   (PRESS(J+1) + PRESS(J))*.5  )**PEXPON(K)


C COMPUTE THE AVERAGE COSBAR AND WBAR
C&&

c     CBAR=MIN(1.0,1.05*CBAR)       ! THE HAZE FORWARD SCATTERING 5%(WHY?)
      COSBV_1pt(J,K,NT)=(CBAR*TAEROSCAT + CBARC*TAUCLD)
     &  /(TAEROSCAT+TAUCLD+TAURAY)     !CBAR_RAY=0.
c        print*,'CBV',J,K,NT,CBAR,TAEROSCAT,CBARC,TAUCLD       

      DTAUV_1pt(J,K,NT)=TAUGAS+TAEROS+TAURAY+TAUCLD       !TOTAL TAU_EXT
      TAUGV_1pt(K)=TAUGV_1pt(K)+TAUGAS*ATERM(NT,K)         !TAU_ABS_METH INTEG.

C WE LET W RAYLEIGH BE .999 OR W=1 WHEN ONLY RAYLEIGH=PROBLEM FOR TRID
c WE HAVE ASSUMED ABOVE THAT COSBAR FOR RAYLEIGH IS ZERO.
      if (IPRINT.eq.1) then
      if (k.eq.NSPECV/2) then   
       print*,'@VI',K,J,DTAUV_1pt(J,K,1),TAUGAS,TAEROS,TAUCLD
      endif
      endif


c***************** ECHANGE 
c     WBARV(J,K,NT)=(QSCT*XNUMB(J)+TAURAY*0.9999999 + QSCTC*XNCLD(J) )
c****************
      WBARV_1pt(J,K,NT)=(TAEROSCAT+TAURAY*0.9999999 + QSCTC*XNCLD(J) )
c     WBARV_1pt(J,K,NT)=(TAEROSCAT+TAURAY*0.9999999 )
     &            /(TAUGAS+TAEROS+TAURAY+TAUCLD)
c**************** 
      IF((TAEROS+TAUCLD+TAURAY+TAUCLD).le.0.) WBARV_1pt(J,K,NT)=0.
      IF((TAEROS+TAUCLD+TAURAY).le.0.) COSBV_1pt(J,K,NT)=0.

c     print*,'WBV',J,K,NT,TAEROSCAT,TAURAY,QSCTC*XNCLD(J)
c     print*,'WBV',J,K,NT,TAEROS,TAUGAS,TAURAY,TAUCLD
c     print*,Z(j),J,K,NT,TAUV(1,j,K,NT),WBARV(1,j,K,NT),COSBV(1,j,K,NT)

 909  CONTINUE
      TAUGVD_1pt(J,K)=TAUGVD_1pt(J,K)+TAUGV_1pt(K)
 100  CONTINUE
       ioptv=1

c HERE END OF THE LOOPS *******
c******************************
         
C TOTAL EXTINCTION OPTICAL DEPTHS
          DO 119 K=1,NSPECV
C LOOP OVER NTERMS
           DO 119 NT=1,NTERM(K)
           TAUV_1pt(1,K,NT)=0.0
             DO 119 J=1,NLAYER
             TAUV_1pt(J+1,K,NT)=TAUV_1pt(J,K,NT)+DTAUV_1pt(J,K,NT)
 119     CONTINUE

c       print*,'SETUP'
c      do i=1,NSPECV
c      print*,WLNV(i)
c       do j=1,NLAYER+1
c       print*,Z(j),TAUV(1,j,i,1),WBARV(1,j,i,1),COSBV(1,j,i,1)
c       enddo
c      enddo
c
c     IF (IPRINT .GT. 1) THEN
c           NT=1
c     IF (2 .GT. 1) THEN
c          WRITE (6,120)
c 120      FORMAT(///'  OPTICAL CONSTANTS IN THE VISIBLE (@EQUATOR) ')
c          WRITE(6,*) 'latitude:',ig
c          DO 200 K=1,NSPECV
c          WRITE (6,190)
c          WRITE (6,210)K,WLNV(K),WNOV(K),BWNV(K)
c    &    ,BWNV(K)+DWNV(K),DWNV(K)
c          WRITE (6,230)REALV(K),XIMGV(K)
c          DO 195 J=1,NLAYER,NLAYER
C RECALCULATE FOR PRINT OUT ONLY, ONLY FIRST NTERM AT ig=12 (EQUATOR)
c          WRITE (6,220)XNUMB(J), WBARV_1pt(J,K,NT),COSBV_1pt(J,K,NT)
c    &      ,DTAUV_1pt(J,K,NT),TAUV_1pt(J,K,NT)
c 195      CONTINUE
c          WRITE (6,240) TAUV_1pt(NLEVEL,K,NT)
c 200      CONTINUE
c     END IF

c  210 FORMAT(1X,I3,F10.3,F10.2,F10.2,'-',F8.2,F10.3)
c  190 FORMAT(1X//'  SNUM  MICRONS   WAVENU   INTERVAL    DELTA-WN')
c  230 FORMAT(1X,'NREAL(LAYER)= ',1PE10.3,' NIMG(LAYER)= ',E10.3/
c     &' #AEROSOLS   WBAR  COSBAR       DTAU     TAU'
c     & ,9X,'RAY     GAS    AEROSOL')
c  220 FORMAT(8(1X,F9.3))
c  240 FORMAT(41X,F9.3)

       if (IPRINT.eq.1) stop

      RETURN
      END
