      SUBROUTINE OPTCV(nmicro,IPRINT)


#include "dimensions.h"
#include "dimphy.h"
#include "microtab.h"
#include "clesphys.h"

c   Argument:
c   ---------
      integer nmicro
c   ---------

      PARAMETER(NLAYER=llm,NLEVEL=NLAYER+1)
      PARAMETER (NSPECI=46,NSPC1I=47,NSPECV=24,NSPC1V=25)

      COMMON /ATM/ Z(NLEVEL),PRESS(NLEVEL),DEN(NLEVEL),TEMP(NLEVEL)

      COMMON /GASS/ CH4(NLEVEL),XN2(NLEVEL),H2(NLEVEL),AR(NLEVEL)
     & ,XMU(NLEVEL),GAS1(NLAYER),COLDEN(NLAYER)

      COMMON /VISGAS/SOLARF(NSPECV),NTERM(NSPECV),PEXPON(NSPECV),
     &         ATERM(4,NSPECV),BTERM(4,NSPECV)

      COMMON /AERSOL/ RADIUS(NLAYER), XNUMB(NLAYER)
     & , REALI(NSPECI), XIMGI(NSPECI), REALV(NSPECV), XIMGV(NSPECV)

      COMMON /CLOUD/ RADCLD(NLAYER), XNCLD(NLAYER)
     &             , RCLDI(NSPECI), XICLDI(NSPECI)
     &             , RCLDV(NSPECV), XICLDV(NSPECV)

      COMMON /TAUS/   TAUHI(klon,NSPECI), TAUCI(klon,NSPECI)
     &               ,TAUGI(klon,NSPECI), TAURV(klon,NSPECV)
     &               ,TAUHV(klon,NSPECV) ,TAUCV(klon,NSPECV)
     &               ,TAUGV(klon,NSPECV)

      COMMON /TAUD/   TAUHID(klon,NLAYER,NSPECI)
     &               ,TAUGID(klon,NLAYER,NSPECI)
     &               ,TAUHVD(klon,NLAYER,NSPECV)
     &               ,TAUGVD(klon,NLAYER,NSPECV)

      COMMON /OPTICV/ DTAUV(klon,NLAYER,NSPECV,4)
     &               ,TAUV(klon,NLEVEL,NSPECV,4)
     &               ,WBARV(klon,NLAYER,NSPECV,4)
     &               ,COSBV(klon,NLAYER,NSPECV,4)

      COMMON /SPECTV/ BWNV(NSPC1V),WNOV(NSPECV) 
     &               ,DWNV(NSPECV),WLNV(NSPECV)

      COMMON /PLANT/ CSUBP,RSFI,RSFV,F0PI
      COMMON /ADJUST/ RHCH4,FH2,FHAZE,FHVIS,FHIR,TAUFAC,RCLOUD,FARGON
      COMMON /CONST/ RGAS,RHOP,PI,SIGMA
      COMMON /traceurs/qaer(klon,nlayer,nqmx)
      COMMON /part/ v(nrad),rayon(nrad),vrat,dr(nrad),dv(nrad)

      REAL xv1(klev,NSPECV)
      REAL xv2(klev,NSPECV)
      REAL xv3(klev,NSPECV)

      REAL QF1(nrad,NSPECV),QF2(nrad,NSPECV)
      REAL QF3(nrad,NSPECV),QF4(nrad,NSPECV)
      REAL QM1(nrad,NSPECV),QM2(nrad,NSPECV)
      REAL QM3(nrad,NSPECV),QM4(nrad,NSPECV)

      save qf1,qf2,qf3,qf4,qm1,qm2,qm3,qm4
 
      integer ioptv,iwarning     ! ioptv: premier appel, une seule boucle sur les l.d'o.
      integer ig_,seulmtunpt
      save ioptv,iwarning,seulmtunpt
      data ioptv,iwarning,seulmtunpt/0,0,0/

      real   zqaer_1pt(NLAYER,nrad)
      real   TAUHVD_1pt(NLAYER,NSPECV)
      real   TAUGVD_1pt(NLAYER,NSPECV)
      real   TAUHV_1pt(NSPECV),TAUCV_1pt(NSPECV)
      real   TAURV_1pt(NSPECV),TAUGV_1pt(NSPECV)
      real   DTAUV_1pt(NLAYER,NSPECV,4),TAUV_1pt(NLEVEL,NSPECV,4)
      real   WBARV_1pt(NLAYER,NSPECV,4)
      real   COSBV_1pt(NLAYER,NSPECV,4)
      character*100 dummy
      real   dummy2,dummy3

C*
C THIS SUBROUTINE SETS THE OPTICAL CONSTANTS IN THE VISIBLE
C IT CALCUALTES FOR EACH LAYER, FOR EACH SPECRAL INTERVAL IN THE VIS
C LAYER: WBAR, DTAU, COSBAR
C LEVEL: TAU
C
       sum=0.
       PRINT*,'OPTCV'
       print*,'ATTENTION, TAU UNIFORME DANS OPTCV'

c      do nng=2,klon
c       do i=1,klev           
c        do j=1,nqmx
c          sum=sum+qaer(nng,i,j)*rayon(j)**3.*1.3333*3.1415*1000.
c        enddo
c       enddo
c       enddo
c       print*,sum/(klon-1),'SOMME COLONNE/OPTCV'

             
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
c INITIALISATIONS UNE SEULE FOIS
C++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      if (ioptv.eq.0) then

c verif pour taille zqaer_1pt, sachant que si microfi=0 et nqmx=1, 
c il faut quand meme qu'on lise la look-up table de dim nrad=10
c et si microfi=1, on doit avoir nmicro=nrad (dans microtab.h)
       if ((nmicro.ne.nrad).and.(microfi.eq.1)) then
          print*,"nmicro.ne.nrad",nmicro,nrad
	  print*,"PROBLEME pour zqaer_1pt dans optcv !!"
	  stop
       endif

      
      DO 130 K=1,NSPECV
C LETS USE THE OPTICAL CONSTANTS FOR THOLIN
      CALL THOLIN(WLNV(K),TNR,TNI)
      REALV(K)=TNR
      XIMGV(K)=TNI*FHVIS
C BUT WE NOW USE THE GEOMETRIC ALBEDO FITTED RESULTS
C      XIMGV(K)=FITEDT(WLNV(K))
C      XIMGV(K)=FITEDN(WLNV(K))
C THE CLOUD IS CLEAR IN THE VISIBLE
      RCLDV(K)=1.27
      XICLDV(K)=1.E-7
 130  CONTINUE
C
c      open (unit=1,file='xsetupv')
c       do j=1,nspecv
c        read(1,*) a
c        do i=1,klev
c            read(1,*) xv1(i,j),xv2(i,j),xv3(i,j)
c        enddo
c       enddo
c       close(1)

      endif    ! fin initialisations premier appel

c******* DEBUT DES BOUCLE GRILLE ************************
c     PRINT*, 'AEROSOLS EN VISIBLE'

      DO 101 ig=1,klon       !c! BOUCLE SUR GRILLE HORIZONTALE

        if (microfi.eq.1) then
           do iq=1,nrad
	      do j=1,NLAYER
	         zqaer_1pt(j,iq)=qaer(ig,j,iq)
	      enddo
	   enddo
        else
         if (ig.eq.1)  then
c initialisation zqaer_1pt a partir d'une look-up table (uniforme en ig)
c boucle sur nrad=10
           open(10,file="qaer_eq_1d.dat")
           do iq=1,15
             read(10,'(A100)') dummy
           enddo
           do j=NLAYER,1,-1
             read(10,*) dummy2,dummy3,(zqaer_1pt(j,iq),iq=1,nrad)
           enddo
           close(10)
         endif
        endif
	
c        if ((ig.eq.klon/2).or.(microfi.eq.0))  then
c       print*,"Q01=",zqaer_1pt(:,1)
c       print*,"Q05=",zqaer_1pt(:,5)
c       print*,"Q10=",zqaer_1pt(:,10)
c       stop
c        endif
	
        iout=0
c       if ((microfi.eq.0).or.(ig.eq.klon/2)) iout=1
        if (seulmtunpt.eq.0) then
	   call optcv_1pt(zqaer_1pt,ioptv,
     .            COSBV_1pt,DTAUV_1pt,TAUHV_1pt,TAUHVD_1pt,TAUCV_1pt,
     .       TAURV_1pt,TAUGV_1pt,TAUGVD_1pt,WBARV_1pt,TAUV_1pt,iout)
           ioptv = 1
	endif

c Pas de microphysique, ni de composition variable: un seul passage
c dans optci_1pt.
        if ((microfi.eq.0).and.(ylellouch)) then
	   seulmtunpt = 1
	endif
	
	COSBV(ig,:,:,:)= COSBV_1pt(:,:,:) 
	WBARV(ig,:,:,:)= WBARV_1pt(:,:,:) 
	DTAUV(ig,:,:,:)= DTAUV_1pt(:,:,:) 
	TAUHV(ig,:)    = TAUHV_1pt(:) 
	TAUCV(ig,:)    = TAUCV_1pt(:) 
	TAURV(ig,:)    = TAURV_1pt(:) 
	TAUGV(ig,:)    = TAUGV_1pt(:) 
	TAUV(ig,:,:,:) = TAUV_1pt(:,:,:) 
	TAUHVD(ig,:,:) = TAUHVD_1pt(:,:) 
	TAUGVD(ig,:,:) = TAUGVD_1pt(:,:) 

 101  CONTINUE

c FIN BOUCLE GRILLE     *******
c******************************
         
       PRINT*, 'FIN OPTCV'
      RETURN
      END
