      SUBROUTINE LELL_LIGHT(NLEVEL,Z,FARGON,TEMP,PRESS,DEN,XMU,
     & CH4,H2,XN2,AR,IPRINT)

C MODIF 20/1/00, S.Lebonnois: 
c    utilisation de la composition chimique directement
c    inclue dans le modele

C THIS SUBROUTINE SETS UP THE INTITAL ATMOSPHERIC PROFILE FOR TITAN
C BASED ON THE LELLOUCH AT AL DATA.  THE ROUTINE STARTS WITH INPUTS
C INPUTS:
C NLEVEL:   NUMBER OF ALTITUDE LEVELS, J=1 IS AT THE TOP
C P         PRESS GRID IN BARS
C
C ASSUMES: FARGON = 0
C
C OUTPUTS:  
C AND AT EACH LEVEL (NOT LAYER AVERAGES)
C TEMP (K), PRESS(BARS), DEN(CM-3), XMU = MEAN MOLECULAR WEIGHT
C AR IS THE NUMBER MIXING RATIO OF Argon
C
C DATA: IS THE LELLOUCH ET AL VALUES DENOTED BY __LE(J)
C
C NEW VERSION FOR GCM : Z E [0,1200]
       INTEGER ITIME
      DIMENSION Z(NLEVEL),TEMP(NLEVEL),PRESS(NLEVEL),
     $    DEN(NLEVEL),XMU(NLEVEL)
     
c ch4,xn2,h2 sont definis ici car ils sont definis dans lell
      DIMENSION CH4(NLEVEL),H2(NLEVEL),XN2(NLEVEL),AR(NLEVEL)
C
      DIMENSION ZLE(148), XN2LE(148), CH4LE(148), TLE(148), PLE(148),
     & DLE(148), XMULE(148), DENMLE(148)

      save ZLE,XN2LE,CH4LE,TLE,PLE,DLE,XMULE,DENMLE
      save itime
      data itime/0/
C
C
      DATA ZLE/
     & 1265., 1215., 1165., 1116., 1050., 1000., 950.0, 900.0, 880.0,
     & 820.0, 800.0, 760.0, 700.0, 675.0, 650.0, 625.0, 600.0, 575.0,
     & 550.0, 525.0, 500.0, 475.0, 450.0, 435.0, 420.0, 410.0, 400.0,
     & 390.0, 380.0, 350.0, 340.0, 330.0, 320.0, 310.0, 300.0, 280.0,
     & 260.0, 250.0, 240.0, 230.0, 220.0, 210.0,
     & 200.0, 198.0, 196.0, 194.0, 192.0, 190.0, 188.0, 186.0, 184.0,
     & 182.0, 180.0, 178.0, 176.0, 174.0, 172.0, 170.0, 168.0, 166.0,
     & 164.0, 162.0, 160.0, 158.0, 156.0, 154.0, 152.0, 150.0, 148.0,
     & 146.0, 144.0, 142.0, 140.0, 138.0, 136.0, 134.0, 132.0, 130.0,
     & 128.0, 126.0, 124.0, 122.0, 120.0, 118.0, 116.0, 114.0, 112.0,
     & 110.0, 108.0, 106.0, 104.0, 102.0, 100.0,  98.0,  96.0,  94.0,
     &  92.0,  90.0,  88.0,  86.0,  84.0,  82.0,  80.0,  78.0,  76.0,
     &  74.0,  72.0,  70.0,  68.0,  66.0,  64.0,  62.0,  60.0,  58.0,
     &  56.0,  54.0,  52.0,  50.0,  48.0,  46.0,  44.0,  42.0,  40.0,
     &  38.0,  36.0,  34.0,  32.0,  30.0,  28.0,  26.0,  24.0,  22.0,
     &  20.0,  18.0,  16.0,  14.0,  12.0,  10.0,   8.0,   6.0,   5.0,
     &   4.0,   3.0,   2.0,   1.5,   1.0,   0.5,   0.0/
! N2 MIXING RATIO
      DATA XN2LE/
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985, 0.985,
     & 0.985, 0.985, 0.985, 0.984, 0.983, 0.983, 0.982, 0.980, 0.979,
     & 0.977, 0.974, 0.971, 0.966, 0.960, 0.955, 0.945, 0.935, 0.926,
     & 0.920, 0.920, 0.920, 0.920, 0.920, 0.920, 0.920/
! CH4 MIXING RATIO
      DATA CH4LE/
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015, 0.015,
     & 0.015, 0.015, 0.015, 0.016, 0.017, 0.017, 0.018, 0.020, 0.021,
     & 0.023, 0.026, 0.029, 0.034, 0.040, 0.045, 0.055, 0.065, 0.074,
     & 0.080, 0.080, 0.080, 0.080, 0.080, 0.080, 0.080/
! TEMPERATURE IN k
      DATA TLE/
     & 183.0, 181.0, 178.0, 174.7, 169.0, 164.0, 158.0, 150.0, 147.0,
     & 136.0, 135.0, 137.0, 143.0, 146.5, 150.0, 154.5, 159.0, 163.5,
     & 166.5, 169.0, 171.1, 172.8, 174.3, 175.1, 175.6, 175.9, 176.0,
     & 176.0, 175.9, 175.8, 175.7, 175.6, 175.5, 175.4, 175.3, 175.2,
     & 175.1, 175.0, 174.9, 174.8, 174.6, 174.4,
     & 174.0, 173.9, 173.8, 173.6, 173.4, 173.2, 173.0, 172.9, 172.7,
     & 172.5, 172.4, 172.2, 172.0, 171.8, 171.6, 171.4, 171.2, 171.0,
     & 170.8, 170.4, 169.9, 169.5, 169.0, 168.5, 167.9, 167.4, 166.7,
     & 166.0, 165.3, 164.5, 163.7, 163.0, 162.4, 161.8, 161.2, 160.5,
     & 159.6, 158.6, 157.5, 156.3, 155.3, 154.3, 153.4, 152.6, 151.9,
     & 151.0, 150.1, 149.0, 147.8, 146.5, 145.1, 143.7, 142.1, 140.6,
     & 139.1, 137.6, 135.8, 133.8, 131.5, 128.8, 125.8, 122.7, 119.7,
     & 116.6, 111.9, 106.1, 100.5,  92.6,  85.9,  80.9,  77.6,  75.4,
     &  73.8,  72.8,  72.2,  71.7,  71.5,  71.4,  71.2,  71.1,  71.1,
     &  71.2,  71.4,  71.5,  71.8,  72.3,  73.1,  73.9,  74.7,  75.7,
     &  76.7,  78.0,  79.2,  80.6,  82.1,  83.6,  85.5,  87.3,  88.5,
     &  89.5,  90.5,  91.5,  92.1,  92.7,  93.3,  93.9/
! PRESSURE IN MILLIBARS
      DATA PLE/
     & 8.08e-09, 1.39e-08, 2.45e-08, 4.41e-08, 1.03e-07, 2.04e-07,
     & 4.27e-07, 9.44e-07, 1.32e-06, 3.92e-06, 5.77e-06, 1.26e-05,
     & 4.11e-05, 6.68e-05, 1.08e-04, 1.75e-04, 2.80e-04, 4.46e-04,
     & 7.08e-04, 1.12e-03, 1.78e-03, 2.84e-03, 4.54e-03, 6.03e-03,
     & 8.01e-03, 9.70e-03, 1.18e-02, 1.43e-02, 1.73e-02, 3.13e-02,
     & 3.83e-02, 4.69e-02, 5.74e-02, 7.05e-02, 8.66e-02, 1.32e-01,
     & 2.01e-01, 2.49e-01, 3.09e-01, 3.84e-01, 4.78e-01, 5.96e-01, !
     & 7.59E-01, 7.98E-01, 8.37E-01, 8.77E-01, 9.20E-01, 9.64E-01,
     & 1.01E+00, 1.06E+00, 1.11E+00, 1.16E+00, 1.22E+00, 1.28E+00,
     & 1.35E+00, 1.41E+00, 1.48E+00, 1.55E+00, 1.63E+00, 1.71E+00,
     & 1.79E+00, 1.88E+00, 1.97E+00, 2.07E+00, 2.17E+00, 2.29E+00,
     & 2.40E+00, 2.52E+00, 2.65E+00, 2.78E+00, 2.93E+00, 3.08E+00,
     & 3.24E+00, 3.41E+00, 3.59E+00, 3.78E+00, 3.90E+00, 4.19E+00,
     & 4.42E+00, 4.66E+00, 4.91E+00, 5.19E+00, 5.48E+00, 5.78E+00,
     & 6.10E+00, 6.45E+00, 6.82E+00, 7.22E+00, 7.63E+00, 8.08E+00,
     & 8.56E+00, 9.06E+00, 9.61E+00, 1.02E+01, 1.08E+01, 1.15E+01,
     & 1.22E+01, 1.30E+01, 1.38E+01, 1.47E+01, 1.57E+01, 1.68E+01,
     & 1.80E+01, 1.93E+01, 2.07E+01, 2.23E+01, 2.40E+01, 2.60E+01,
     & 2.83E+01, 3.10E+01, 3.42E+01, 3.79E+01, 4.23E+01, 4.75E+01,
     & 5.34E+01, 6.01E+01, 6.79E+01, 7.67E+01, 8.67E+01, 9.81E+01,
     & 1.11E+02, 1.26E+02, 1.42E+02, 1.61E+02, 1.83E+02, 2.07E+02,
     & 2.35E+02, 2.65E+02, 3.00E+02, 3.40E+02, 3.83E+02, 4.32E+02,
     & 4.87E+02, 5.47E+02, 6.14E+02, 6.88E+02, 7.70E+02, 8.59E+02,
     & 9.57E+02, 1.06E+03, 1.12E+03, 1.18E+03, 1.24E+03, 1.30E+03,
     & 1.34E+03, 1.37E+03, 1.40E+03, 1.44E+03/
! NUMBER DENSITY
      DATA DLE/
     & 3.20e+08, 5.55e+08, 9.96e+08, 1.83e+09, 4.40e+09, 9.03e+09,
     & 1.96e+10, 4.56e+10, 6.51e+10, 2.09e+11, 3.09e+11, 6.68e+11,
     & 2.08e+12, 3.30e+12, 5.23e+12, 8.19e+12, 1.28e+13, 1.98e+13,
     & 3.08e+13, 4.81e+13, 7.55e+13, 1.19e+14, 1.89e+14, 2.49e+14,
     & 3.31e+14, 3.99e+14, 4.84e+14, 5.87e+14, 7.14e+14, 1.29e+15,
     & 1.58e+15, 1.93e+15, 2.37e+15, 2.91e+15, 3.58e+15, 5.44e+15,
     & 8.31e+15, 1.03e+16, 1.28e+16, 1.59e+16, 1.98e+16, 2.47e+16, !
     & 3.11E+16, 3.30E+16, 3.47E+16, 3.70E+16, 3.90E+16, 4.09E+16,
     & 4.25E+16, 4.48E+16, 4.67E+16, 4.93E+16, 5.16E+16, 5.45E+16,
     & 5.68E+16, 5.97E+16, 6.27E+16, 6.56E+16, 6.91E+16, 7.20E+16,
     & 7.55E+16, 7.98E+16, 8.41E+16, 8.86E+16, 9.34E+16, 9.83E+16,
     & 1.04E+17, 1.09E+17, 1.15E+17, 1.22E+17, 1.28E+17, 1.36E+17,
     & 1.44E+17, 1.52E+17, 1.61E+17, 1.69E+17, 1.79E+17, 1.89E+17,
     & 2.00E+17, 2.13E+17, 2.26E+17, 2.41E+17, 2.56E+17, 2.72E+17,
     & 2.88E+17, 3.06E+17, 3.26E+17, 3.46E+17, 3.68E+17, 3.92E+17,
     & 4.19E+17, 4.48E+17, 4.80E+17, 5.14E+17, 5.51E+17, 5.92E+17,
     & 6.38E+17, 6.86E+17, 7.36E+17, 7.95E+17, 8.65E+17, 9.45E+17,
     & 1.04E+18, 1.14E+18, 1.26E+18, 1.39E+18, 1.56E+18, 1.78E+18,
     & 2.04E+18, 2.43E+18, 2.89E+18, 3.40E+18, 3.96E+18, 4.57E+18,
     & 5.25E+18, 6.00E+18, 6.83E+18, 7.77E+18, 8.83E+18, 1.00E+19,
     & 1.14E+19, 1.29E+19, 1.46E+19, 1.66E+19, 1.87E+19, 2.12E+19,
     & 2.39E+19, 2.69E+19, 3.02E+19, 3.38E+19, 3.78E+19, 4.21E+19,
     & 4.68E+19, 5.19E+19, 5.75E+19, 6.34E+19, 6.97E+19, 7.66E+19,
     & 8.36E+19, 9.11E+19, 9.48E+19, 9.88E+19, 1.03E+20, 1.07E+20,
     & 1.09E+20, 1.11E+20, 1.13E+20, 1.15E+20/
! MEAN MOLECULAR WEIGHT
      DATA XMULE/ 
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,
     &  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.8,  27.7,
     &  27.7,  27.7,  27.6,  27.6,  27.5,  27.5,  27.3,  27.2,  27.1,
     &  27.0,  27.0,  27.0,  27.0,  27.0,  27.0,  27.0/
! DENSITY IN GRAMS/CUBIT CENTIMETER
      DATA DENMLE/  
     & 1.40e-14, 2.46e-14, 4.46e-14, 8.25e-14, 2.01e-13, 4.13e-13,
     & 8.99e-13, 2.10e-12, 3.01e-12, 9.63e-12, 1.43e-11, 3.08e-11,
     & 9.60e-11, 1.53e-10, 2.42e-10, 3.78e-10, 5.89e-10, 9.12e-10,
     & 1.42e-09, 2.22e-09, 3.49e-09, 5.50e-09, 8.71e-09, 1.15e-08,
     & 1.53e-08, 1.84e-08, 2.23e-08, 2.71e-08, 3.29e-08, 5.96e-08,
     & 7.29e-08, 8.92e-08, 1.09e-07, 1.34e-07, 1.65e-07, 2.51e-07,
     & 3.84e-07, 4.75e-07, 5.90e-07, 7.34e-07, 9.15e-07, 1.14e-06, !
     & 1.43E-06, 1.52E-06, 1.60E-06, 1.71E-06, 1.80E-06, 1.89E-06,
     & 1.96E-06, 2.07E-06, 2.16E-06, 2.28E-06, 2.38E-06, 2.52E-06,
     & 2.63E-06, 2.76E-06, 2.89E-06, 3.03E-06, 3.19E-06, 3.33E-06,
     & 3.49E-06, 3.69E-06, 3.88E-06, 4.09E-06, 4.32E-06, 4.54E-06,
     & 4.79E-06, 5.04E-06, 5.31E-06, 5.62E-06, 5.91E-06, 6.27E-06,
     & 6.63E-06, 7.01E-06, 7.42E-06, 7.83E-06, 8.26E-06, 8.71E-06,
     & 9.26E-06, 9.84E-06, 1.04E-05, 1.11E-05, 1.18E-05, 1.26E-05,
     & 1.33E-05, 1.41E-05, 1.51E-05, 1.60E-05, 1.70E-05, 1.81E-05,
     & 1.94E-05, 2.07E-05, 2.22E-05, 2.38E-05, 2.55E-05, 2.73E-05,
     & 2.95E-05, 3.17E-05, 3.40E-05, 3.67E-05, 4.00E-05, 4.37E-05,
     & 4.78E-05, 5.26E-05, 5.80E-05, 6.40E-05, 7.20E-05, 8.22E-05,
     & 9.45E-05, 1.12E-04, 1.33E-04, 1.57E-04, 1.83E-04, 2.11E-04,
     & 2.43E-04, 2.77E-04, 3.16E-04, 3.59E-04, 4.08E-04, 4.62E-04,
     & 5.26E-04, 5.96E-04, 6.75E-04, 7.65E-04, 8.65E-04, 9.79E-04,
     & 1.10E-03, 1.24E-03, 1.39E-03, 1.56E-03, 1.74E-03, 1.94E-03,
     & 2.16E-03, 2.39E-03, 2.64E-03, 2.91E-03, 3.19E-03, 3.49E-03,
     & 3.79E-03, 4.12E-03, 4.27E-03, 4.43E-03, 4.62E-03, 4.80E-03,
     & 4.89E-03, 4.98E-03, 5.08E-03, 5.17E-03/
C
      print*,'press ',press
c     write(77,*) press
C RETURNS PRESSURE IN BARS
      IF (ITIME.EQ.0) THEN
       DO 201 I=1,148
       PLE(I)=PLE(I)*0.001
       ITIME=1
201   CONTINUE
      ENDIF
C AND SET ARGON
      FARGON=0.
C
      DO 202 J=1,NLEVEL
      AR(J)=0.0
202   CONTINUE
C
      DO 100 J=1,NLEVEL
C EXTRAPOLATE WITH ISOTHERMAL ATM ABOVE DATA POINTS
      ISTART=1
      IF (PRESS(J) .LT. PLE(1) ) THEN
            TEMP(J)=TLE(1)
            XMU(J)=XMULE(1)
            Z(J)=ZLE(1)+ALOG(PLE(1)/PRESS(J))*40.43
            DEN(J)=DLE(1)*PRESS(J)/PLE(1)
         ELSE
           DO 101 I=ISTART,147
C INTERPOLATE LINEAR IN LOP P
      IF (PRESS(J) .GT. PLE(I+1) ) GO TO 101
      FACTOR= ALOG(PRESS(J)/PLE(I) )/ALOG(PLE(I+1)/PLE(I))
      TEMP(J)=TLE(I) + FACTOR*(TLE(I+1) - TLE(I))
      XMU(J)=XMULE(I) + FACTOR*(XMULE(I+1) - XMULE(I))
      Z(J)=ZLE(I) + FACTOR*(ZLE(I+1) - ZLE(I))
      DEN(J)=EXP(ALOG(DLE(I))+FACTOR*(ALOG(DLE(I+1))-ALOG(DLE(I))))
      ISTART=I
      GO TO 100
 101  CONTINUE
      ENDIF
 100  CONTINUE

C
      IF (IPRINT .LT. 0) RETURN
         WRITE (6,139)FARGON
         DO 135 J=1,NLEVEL-1
         WRITE(6,140)J,Z(J),PRESS(J),DEN(J),TEMP(J),
     &         AR(J)*100.,XMU(J)
     &         ,(TEMP(J+1)-TEMP(J))/(Z(J+1)-Z(J))
  135    CONTINUE
         J=NLEVEL
         WRITE(6,140)J,Z(J),PRESS(J),DEN(J),TEMP(J),
     &         AR(J)*100.,XMU(J)
  139 FORMAT(///'   BACKGROUND ATMOSPHERE AT LEVELS (LELLOUCH ET AL)'/
     & ' (light version: no composition)',
     & ' ARGON SETTING:',F8.4/' LELLOUCH ET AL RESULTS '/
     &' LVL ALTITUDE  P(BARS)  DEN(CM-3) TEMP'
     & , ' %AR   MU   DT/DZ'  )
  140 FORMAT(1X,I3,F8.3,1P2E10.3,0PF7.2,F5.2,4F6.2)
C
      RETURN
      END
