      FUNCTION H2ENER(V,J)
C     H2ENER SUBROUTINE OF THE INV PROGRAM. COMPUTES THE ENERGY
C     (IN CM-1) OF A VIBRATION-ROTATION STATE OF A HYDROGEN MOLECULE.
C     THE VIBRATION QUANTUM NUMBER IS V, AND THE QUANTUM NUMBER FOR
C     THE RIGID BODY ANGULAR MOMENTUM IS J (A REAL*4 QUANTITY).
C     THE FIRST LINE OF THE FORMULA FOR E IS THE CONTRIBUTION FROM
C     PURE VIBRATION, INCLUDING ANHARMONIC TERMS. THE OTHER LINES
C     ACCOUNT FOR COUPLED VIBRATION AND ROTATION, INCLUDING
C     CENTRIFUGAL DISTORTION. (THE (J(J+1))**2 AND (J(J+1))**3
C     PROVIDE FOR CENTRIFUGAL DISTORTION; THE VP AND VP**2 IN THE
C     ROTATION TERMS PROVIDE FOR COUPLING BETWEEN VIBRATION AND
C     ROTATION.)
C     THE FORMULA OF COHEN AND BIRNBAUM(1981),
C       NU = 59.3392*(J(J+1))  - 0.04599*(J(J+1))**2
C            + 0.000052*(J(J+1))**3 CM-1,
C     IS A SPECIAL CASE OF THE FORMULA USED HERE, OBTAINED BY
C     SETTING V=0 (IE., VP = 1/2); THE VP TERMS IN THE VIBRATION-
C     ROTATION CONTRIBUTIONS CORRECT THE INITIAL TERMS TO
C     PRODUCE THE COEFFICIENTS IN THE COHEN AND BIRNBAUM FORMULA.
C     FOR THE COLD ATMOSPHERES OF THE OUTER PLANETS, THE SIGNIF-
C     ICANTLY POPULATED LEVELS HAVE V=0.
C
C***********************************************************************
C
      IMPLICIT REAL (A-H,O-Z)
      REAL J,JP
C
      VP = V + 0.5
      JP = J + 1.0
      E = 4400.39*VP - 120.815*VP**2 + 0.7242*VP**3 +
     A    (60.841 - 3.0177*VP + 0.0286*VP**2)*J*JP -
     B    (0.04684 - 0.00171*VP + 3.1E-05*VP**2)*J**2*JP**2 +
     C    5.2E-05*J**3*JP**3 - 2170.08
      H2ENER = E
      RETURN
      END
