!
! $Header: /home/cvsroot/LMDZ4/libf/phylmd/conf_phys.F90,v 1.3 2005/02/07 15:15:31 fairhead Exp $
!
!
!

  subroutine conf_phys(ok_mensuel,ok_journe,ok_instan,if_ebil)

   use IOIPSL
   implicit none

#include "YOMCST.inc"
#include "clesphys.inc"
#include "compbl.h"
#include "comorbit.inc"
!
! Configuration de la "physique" de LMDZ a l'aide de la fonction
! GETIN de IOIPSL
!
! LF 05/2001
!
!--- Ca lit le physiq.def ---

!
! ok_mensuel: sorties mensuelles
! ok_journe:  sorties journalieres
! ok_instan:  sorties instantanees


! Sortie:
  logical              :: ok_mensuel, ok_journe, ok_instan
  integer              :: if_ebil

! Local
  integer              :: numout = 6
  real*4               :: zzz

!Config Key  = OK_mensuel
!Config Desc = Pour des sorties mensuelles 
!Config Def  = .true.
!Config Help = Pour creer le fichier histmth contenant les sorties
!              mensuelles 
!
  ok_mensuel = .true.
  call getin('OK_mensuel', ok_mensuel)
!
!Config Key  = OK_journe
!Config Desc = Pour des sorties journalieres 
!Config Def  = .false.
!Config Help = Pour creer le fichier histday contenant les sorties
!              journalieres 
!
  ok_journe = .false.
  call getin('OK_journe', ok_journe)
!
!Config Key  = OK_instan
!Config Desc = Pour des sorties instantanees 
!Config Def  = .false.
!Config Help = Pour creer le fichier histins contenant les sorties
!              instantanees 
!
  ok_instan = .false.
  call getin('OK_instan', ok_instan)
!
!
!Config Key  = if_ebil
!Config Desc = Niveau de sortie pour les diags bilan d'energie 
!Config Def  = 0
!Config Help = 
!               
!
  if_ebil = 0
  call getin('if_ebil', if_ebil)
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! Constante solaire & Parametres orbitaux 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!
! TITAN         ! Valeurs par defaut d'apres Fig Tokano.
!
!!
!Config Key  = year_day
!Config Desc = Duree de l'annee en jour
!Config Def  = 
!Config Help = 
!               
  zzz = 673.
  call getin('year_day', zzz)
  year_day = zzz
!
!Config Key  = peri_day
!Config Desc = position du perihelie en jour
!Config Def  = 
!Config Help = 
!               
  zzz = 533.
  call getin('peri_day', zzz)
  peri_day = zzz
!
!Config Key  = periheli
!Config Desc = Distance au soleil au perihelie
!Config Def  = 
!Config Help = 
!               
  zzz = 1354.5
  call getin('periheli', zzz)
  periheli = zzz
!!
!Config Key  = aphelie
!Config Desc = Distance au soleil a l'aphelie
!Config Def  = 
!Config Help = 
!               
  zzz = 1506.0
  call getin('aphelie', zzz)
  aphelie = zzz
!!
!Config Key  = obliquit
!Config Desc = Obliquite
!Config Def  = 
!Config Help = 
!               
  zzz = 26.7
  call getin('obliquit', zzz)
  obliquit = zzz
!
!Config Key  = solaire
!Config Desc = Constante solaire en W/m2
! VENUS
!Config Def  = 2620.
!Config Help = 
!
  zzz = 2620.
    call getin('solaire', zzz)
  solaire = zzz
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! PARAMETER FOR THE PLANETARY BOUNDARY LAYER AND SOIL
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!Config Key  = iflag_pbl
!Config Desc =
!Config Def  = 1
!Config Help =
!
! 2   = calculs Cd et K simples pour VENUS :
!       parametres = z0, lmixmin, ksta (en dur: umin2,ric,cepdu2,karman)
! 1   = calculs Cd et K issus LMDZ Terre
!       parametres = ksta, ok_kzmin (et plein d'autres en dur...)
! 6-9 = schema des thermiques Fred
  iflag_pbl = 1
  call getin('iflag_pbl',iflag_pbl)

!
!Config Key  = ksta
!Config Desc =
!Config Def  = 1.0e-7
!Config Help =
!
  zzz = 1.0e-7
  call getin('ksta',zzz)
  ksta = zzz

!
!Config Key  = z0
!Config Desc =
!Config Def  = 1.0e-2
!Config Help =
!
  zzz = 1.0e-2
  call getin('z0',zzz)
  z0 = zzz

!
!Config Key  = lmixmin
!Config Desc =
!Config Def  = 35.
!Config Help =
!
  zzz = 35.
  call getin('lmixmin',zzz)
  lmixmin = zzz

!
!
!Config Key  = ok_kzmin
!Config Desc =
!Config Def  = .false.
!Config Help =
!
  ok_kzmin = .false.
  call getin('ok_kzmin',ok_kzmin)


!Config Key  = iflag_ajs
!Config Desc =
!Config Def  = 0
!Config Help =
!
  iflag_ajs = 1
  call getin('iflag_ajs',iflag_ajs)

!
!Config Key  = inertie
!Config Desc =
!Config Def  = 2000.
!Config Help =
!
  zzz = 2000.
  call getin('inertie',zzz)
  inertie = zzz
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! parametres CHIMIE
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!Config Key  = chimi
!Config Desc =
!Config Def  = .false.
!Config Help =
!
  chimi = .false.
  call getin('chimi',chimi)

!
!Config Key  = vchim
!Config Desc =
!Config Def  = 1
!Config Help =
!
  vchim = 1
  call getin('vchim',vchim)

!
!Config Key  = aerprod
!Config Desc =
!Config Def  = 0
!Config Help =
!
  aerprod = 0
  call getin('aerprod',aerprod)

!
!Config Key  = htoh2
!Config Desc =
!Config Def  = 1
!Config Help =
!
  htoh2 = 1
  call getin('htoh2',htoh2)

!
!Config Key  = ylellouch
!Config Desc =
!Config Def  = .true.
!Config Help =
!
  ylellouch = .true.
  call getin('ylellouch',ylellouch)

!
!Config Key  = hcnrad
!Config Desc =
!Config Def  = .false.
!Config Help =
!
  hcnrad = .false.
  call getin('hcnrad',hcnrad)

!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! parametres MICROPHYSIQUE
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!Config Key  = microfi
!Config Desc =
!Config Def  = 1
!Config Help =
!
  microfi = 1
  call getin('microfi',microfi)

!
!Config Key  = tx
!Config Desc =
!Config Def  = 3.5
!Config Help =
!
  zzz = 3.5
  call getin('tx',zzz)
  tx = zzz

!
!Config Key  = tcorrect
!Config Desc =
!Config Def  = 1.
!Config Help =
!
  zzz = 1.
  call getin('tcorrect',zzz)
  tcorrect = zzz

!
!Config Key  = cutoff
!Config Desc =
!Config Def  = 2
!Config Help =
!
  cutoff = 2
  call getin('cutoff',cutoff)

!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! PARAMETER FOR THE OUTPUT LEVELS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!
!Config Key  = lev_histmth
!Config Desc =
!Config Def  = 2
!Config Help =
! 
  lev_histmth = 2
  call getin('lev_histmth',lev_histmth)

!
!Config Key  = lev_histday
!Config Desc =
!Config Def  = 1
!Config Help =
!
  lev_histday = 1
  call getin('lev_histday',lev_histday)

!
!
!Config Key  = 
!Config Desc =  
!Config Def  =
!Config Help = 
!
!   =
!  call getin('',)
!
!
!
!

  write(numout,*)' ##############################################'
  write(numout,*)' Configuration des parametres de la physique: '
  write(numout,*)' Sortie mensuelle = ', ok_mensuel
  write(numout,*)' Sortie journaliere = ', ok_journe
  write(numout,*)' Sortie instantanee = ', ok_instan
  write(numout,*)' Sortie bilan d energie, if_ebil =', if_ebil
  write(numout,*)' Duree de l annee = ',year_day
  write(numout,*)' Position du perihelie = ',peri_day
  write(numout,*)' Perihelie = ',periheli
  write(numout,*)' Aphelie = ',aphelie
  write(numout,*)' Obliquite =',obliquit
  write(numout,*)' iflag_pbl = ', iflag_pbl
  write(numout,*)' z0 = ',z0 
  write(numout,*)' lmixmin = ',lmixmin 
  write(numout,*)' ksta = ',ksta 
  write(numout,*)' ok_kzmin = ',ok_kzmin 
  write(numout,*)' inertie = ', inertie 
  write(numout,*)' iflag_ajs = ', iflag_ajs
  write(numout,*)' chimi = ', chimi
  write(numout,*)' vchim = ', vchim
  write(numout,*)' aerprod = ', aerprod
  write(numout,*)' htoh2 = ', htoh2
  write(numout,*)' ylellouch = ', ylellouch
  write(numout,*)' hcnrad = ', hcnrad
  write(numout,*)' microfi = ', microfi
  write(numout,*)' tx = ', tx
  write(numout,*)' tcorrect = ', tcorrect
  write(numout,*)' cutoff = ', cutoff
  write(numout,*)' lev_histmth = ',lev_histmth
  write(numout,*)' lev_histday = ',lev_histday 

  return

  end subroutine conf_phys

