/* trac.h: parameters for traceurs.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "dim_c.h"

#define R0   (float)(2575.0)     /* Titan's radius */

#define THETA (float)(0.501)
#ifndef M_PI
#define M_PI (float)(3.14159265358979323846e0)
#endif
#define RAD (float)(M_PI / 180.0e0)
#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#define min(a,b) ((a)<=(b)?(a):(b))
#endif

float *rm1d( int, int );
float **rm2d( int, int, int, int );
float ***rm3d( int, int, int, int, int, int );
float ****rm4d( int, int, int, int, int, int );
double *dm1d( int, int );
double **dm2d( int, int, int, int );
double ***dm3d( int, int, int, int, int, int );
double ****dm4d( int, int, int, int, int, int );
void  frm1d( float *, int );
void  frm2d( float **, int, int, int );
void  frm3d( float ***, int, int, int, int, int );
void  fdm1d( double *, int );
void  fdm2d( double **, int, int, int );
void  fdm3d( double ***, int, int, int, int, int );
int   *im1d( int, int );
int   **im2d( int, int, int, int );
int   ***im3d( int, int, int, int, int, int );
