#include "cnames.h"

/*
 * GRIB table 202 at DWD
 *     Helmut P. Frank, 30.08.2001
 * updated 24.07.2003: UV_Ind_F_h, BasicUV_IF, UV_Ind_W_h, UV_IndmaxF,
 *                     "gesamt O3", UV_IndmaxW, "h UV_IndMx"
 */

struct ParmTable parm_table_dwd_202[256] = {
    /* 0 */ {"var0", "undefined"},
    /* 1 */ {"Seeg_peak", "jonswap parameter fm [s**(-1)]"},
    /* 2 */ {"Seeg_alpha", "jonswap parameter alpha [1]"},
    /* 3 */ {"Seeg_gamma", "jonswap parameter gamma [1]"},
    /* 4 */ {"Seeg_dir", "Seegang direction [degree true]"},
    /* 5 */ {"Seeg_energ", "Seegang energy densitiy [(m**2)*(s**2)]"},
    /* 6 */ {"Seeg_icemk", "Seegang ice mask [1]"},
    /* 7 */ {"peak p sw", "peak period of swell [s]"},
    /* 8 */ {"peak p ww", "peak period of wind waves [s]"},
    /* 9 */ {"var9", "undefined"},
    /* 10 */ {"var10", "undefined"},
    /* 11 */ {"var11", "undefined"},
    /* 12 */ {"var12", "undefined"},
    /* 13 */ {"var13", "undefined"},
    /* 14 */ {"var14", "undefined"},
    /* 15 */ {"var15", "undefined"},
    /* 16 */ {"var16", "undefined"},
    /* 17 */ {"var17", "undefined"},
    /* 18 */ {"var18", "undefined"},
    /* 19 */ {"var19", "undefined"},
    /* 20 */ {"Var. Geop.", "Varianz Geopotential [(m/s)**4]"},
    /* 21 */ {"Var. T", "Varianz Temperatur [K**2]"},
    /* 22 */ {"Var. u", "Varianz Zonalwind [(m/s)**2]"},
    /* 23 */ {"Var. v", "Varianz Meridionalwind [(m/s)**2]"},
    /* 24 */ {"Var. q", "Varianz spezifische Feuchte [(kg/kg)**2]"},
    /* 25 */ {"Mer. Imptr", "Meridionaler Impulstransport [(m/s)**2]"},
    /* 26 */ {"Mer. TrEpt", "Meridionaler Transport potentieller Energie [(m/s)**3]"},
    /* 27 */ {"Mer. TrsW", "Meridionaler Transport sensibler Waerme [K*(m/s)]"},
    /* 28 */ {"Mer. TrlW", "Meridionaler Transport latenter Waerme [(kg/kg)*(m/s)]"},
    /* 29 */ {"Ver. TrEpt", "Vertikaler Transport potentieller Energie [(m/s)**2*(Pa/s)]"},
    /* 30 */ {"Ver. TrsW", "Vertikaler Transport sensibler Waerme [K*(Pa/s)]"},
    /* 31 */ {"Ver.TrlW", "Vertikaler Transport latenter Waerme [(kg/kg)*(Pa/s)]"},
    /* 32 */ {"var32", "undefined"},
    /* 33 */ {"var33", "undefined"},
    /* 34 */ {"var34", "undefined"},
    /* 35 */ {"var35", "undefined"},
    /* 36 */ {"var36", "undefined"},
    /* 37 */ {"var37", "undefined"},
    /* 38 */ {"var38", "undefined"},
    /* 39 */ {"var39", "undefined"},
    /* 40 */ {"VarAF Geop", "Varianz des Analyse-Fehlers Geopotential [(m/s)**4]"},
    /* 41 */ {"VarAF u", "Varianz des Analyse-Fehlers Zonalwind [(m/s)**2]"},
    /* 42 */ {"VarAF v", "Varianz des Analyse-Fehlers Meridionalwind [(m/s)**2]"},
    /* 43 */ {"var43", "undefined"},
    /* 44 */ {"DU_SSO", "undefined"},
    /* 45 */ {"DV_SSO", "undefined"},
    /* 46 */ {"SSO_STDH", "standard deviation of subgrid scale orogr. height [m]"},
    /* 47 */ {"SSO_GAMMA", "anisotropy of topography [1]"},
    /* 48 */ {"SSO_THETA", "angle betw. principal axis of orogr. and global E [1]"},
    /* 49 */ {"SSO_SIGMA", "mean slope of subgrid scale orography [1]"},
    /* 50 */ {"oro varian", "subgrid-scale variance of orography [m**2]"},
    /* 51 */ {"E-W oro va", "E-W component of subgrid-scale variance of orogr [m**2]"},
    /* 52 */ {"N-S oro va", "N-S component of subgrid-scale variance of orogr [m**2]"},
    /* 53 */ {"NW-SE o va", "NW-SE component of subgrid-scale variance of orogr [m**2]"},
    /* 54 */ {"NE-SW o va", "NE-SW component of subgrid-scale variance of orogr [m**2]"},
    /* 55 */ {"inl w frac", "fraction of inland water [1]"},
    /* 56 */ {"surf emiss", "surface emissivity [1]"},
    /* 57 */ {"SOILTYP", "soil texture [1]"},
    /* 58 */ {"soil color", "soil color [1]"},
    /* 59 */ {"soil drain", "soil drainage [1]"},
    /* 60 */ {"ground wat", "ground water table [m]"},
    /* 61 */ {"LAI", "leaf area index [1]"},
    /* 62 */ {"ROOT", "root depth [m]"},
    /* 63 */ {"root dens", "root density [1]"},
    /* 64 */ {"HMO3", "height of maximum of ozone concentration [Pa]"},
    /* 65 */ {"VIO3", "total vertically integrated ozone content [Pa]"},
    /* 66 */ {"ld-sea msk", "land-sea mask [1]"},
    /* 67 */ {"PLCOV_MX", "ground fraction covered by plants (vegetation p.) [1]"},
    /* 68 */ {"PLCOV_MN", "ground fraction covered by plants (time of rest) [1]"},
    /* 69 */ {"LAI_MX", "leaf area index (vegetation period) [1]"},
    /* 70 */ {"LAI_MN", "leaf area index (time of rest) [1]"},
    /* 71 */ {"Orographie", "Orographie + Land-Meer-Verteilung [m]"},
    /* 72 */ {"r length m", "roughness length momentum [m]"},
    /* 73 */ {"r length h", "roughness length heat [m]"},
    /* 74 */ {"var smc", "variance of soil moisture content [kg**2/m**4]"},
    /* 75 */ {"FOR_E", "fractional coverage with evergreen forest [1]"},
    /* 76 */ {"FOR_D", "fractional coverage with deciduous forest [1]"},
    /* 77 */ {"var77", "undefined"},
    /* 78 */ {"var78", "undefined"},
    /* 79 */ {"var79", "undefined"},
    /* 80 */ {"var80", "undefined"},
    /* 81 */ {"var81", "undefined"},
    /* 82 */ {"var82", "undefined"},
    /* 83 */ {"var83", "undefined"},
    /* 84 */ {"var84", "undefined"},
    /* 85 */ {"var85", "undefined"},
    /* 86 */ {"var86", "undefined"},
    /* 87 */ {"var87", "undefined"},
    /* 88 */ {"var88", "undefined"},
    /* 89 */ {"var89", "undefined"},
    /* 90 */ {"var90", "undefined"},
    /* 91 */ {"var91", "undefined"},
    /* 92 */ {"var92", "undefined"},
    /* 93 */ {"var93", "undefined"},
    /* 94 */ {"var94", "undefined"},
    /* 95 */ {"var95", "undefined"},
    /* 96 */ {"var96", "undefined"},
    /* 97 */ {"var97", "undefined"},
    /* 98 */ {"var98", "undefined"},
    /* 99 */ {"AER_DES", "undefined"},
    /* 100 */ {"var100", "undefined"},
    /* 101 */ {"tidal tend", "tidal tendencies [(m/s)**2]"},
    /* 102 */ {"diab heatg", "sum of diabatic heating terms [K/s]"},
    /* 103 */ {"adiab heat", "total adiabatic heating [K/s]"},
    /* 104 */ {"adv q tend", "advective tendency of specific humidity [s**(-1)]"},
    /* 105 */ {"nadv q ten", "non-advective tendency of specific humidity [s**(-1)]"},
    /* 106 */ {"adv m te X", "advective momentum tendency (X component) [m/s**2]"},
    /* 107 */ {"adv m te Y", "advective momentum tendency (Y component) [m/s**2]"},
    /* 108 */ {"nad m te X", "non-advective momentum tendency (X component) [m/s**2]"},
    /* 109 */ {"nad m te Y", "non-advective momentum tendency (Y component) [m/s**2]"},
    /* 110 */ {"torque", "sum of mountain and frictional torque [kg*(m/s)**2]"},
    /* 111 */ {"budget val", "budget values [1]"},
    /* 112 */ {"scale fact", "scale factor [1]"},
    /* 113 */ {"Coriol par", "Coriolis parameter [s**(-1)]"},
    /* 114 */ {"PHI", "latitude [degr N]"},
    /* 115 */ {"RLA", "longitude [degr E]"},
    /* 116 */ {"relax fact", "relaxation factor (lateral boundary, LAM) [1]"},
    /* 117 */ {"climsstint", "climatic sea surface temp interpolated in time [degr C]"},
    /* 118 */ {"pot vortic", "potential vorticity [K*m**2/(s*kg)]"},
    /* 119 */ {"ln ps", "log surface pressure [1]"},
    /* 120 */ {"EXP_SI", "undefined"},
    /* 121 */ {"RHS_SI", "undefined"},
    /* 122 */ {"DTTDIV", "undefined"},
    /* 123 */ {"var123", "undefined"},
    /* 124 */ {"var124", "undefined"},
    /* 125 */ {"var125", "undefined"},
    /* 126 */ {"var126", "undefined"},
    /* 127 */ {"var127", "undefined"},
    /* 128 */ {"var128", "undefined"},
    /* 129 */ {"var129", "undefined"},
    /* 130 */ {"var130", "undefined"},
    /* 131 */ {"var131", "undefined"},
    /* 132 */ {"var132", "undefined"},
    /* 133 */ {"var133", "undefined"},
    /* 134 */ {"var134", "undefined"},
    /* 135 */ {"var135", "undefined"},
    /* 136 */ {"var136", "undefined"},
    /* 137 */ {"var137", "undefined"},
    /* 138 */ {"var138", "undefined"},
    /* 139 */ {"var139", "undefined"},
    /* 140 */ {"var140", "undefined"},
    /* 141 */ {"var141", "undefined"},
    /* 142 */ {"var142", "undefined"},
    /* 143 */ {"var143", "undefined"},
    /* 144 */ {"var144", "undefined"},
    /* 145 */ {"var145", "undefined"},
    /* 146 */ {"var146", "undefined"},
    /* 147 */ {"var147", "undefined"},
    /* 148 */ {"var148", "undefined"},
    /* 149 */ {"var149", "undefined"},
    /* 150 */ {"SO2-conc", "SO2-concentration [10**(-6)*g/m**3]"},
    /* 151 */ {"SO2-dryd", "SO2-dry deposition [10**(-3)*g/m**2]"},
    /* 152 */ {"SO2-wetd", "SO2-wet deposition [10**(-3)*g/m**2]"},
    /* 153 */ {"SO4-conc", "SO4-concentration [10**(-6)*g/m**3]"},
    /* 154 */ {"SO4-dryd", "SO4-dry deposition [10**(-3)*g/m**2]"},
    /* 155 */ {"SO4-wetd", "SO4-wet deposition [10**(-3)*g/m**2]"},
    /* 156 */ {"NO-conc", "NO-concentration [10**(-6)*g/m**3]"},
    /* 157 */ {"NO-dryd", "NO-dry deposition [10**(-3)*g/m**2]"},
    /* 158 */ {"NO-wetd", "NO-wet deposition [10**(-3)*g/m**2]"},
    /* 159 */ {"NO2-conc", "NO2-concentration [10**(-6)*g/m**3]"},
    /* 160 */ {"NO2-dryd", "NO2-dry deposition [10**(-3)*g/m**2]"},
    /* 161 */ {"NO2-wetd", "NO2-wet deposition [10**(-3)*g/m**2]"},
    /* 162 */ {"NO3-conc", "NO3-concentration [10**(-6)*g/m**3]"},
    /* 163 */ {"NO3-dryd", "NO3-dry deposition [10**(-3)*g/m**2]"},
    /* 164 */ {"NO3-wetd", "NO3-wet deposition [10**(-3)*g/m**2]"},
    /* 165 */ {"HNO3-conc", "HNO3-concentration [10**(-6)*g/m**3]"},
    /* 166 */ {"HNO3-dryd", "HNO3-dry deposition [10**(-3)*g/m**2]"},
    /* 167 */ {"HNO3-wetd", "HNO3-wet deposition [10**(-3)*g/m**2]"},
    /* 168 */ {"NH3-conc", "NH3-concentration [10**(-6)*g/m**3]"},
    /* 169 */ {"NH3-dryd", "NH3-dry deposition [10**(-3)*g/m**2]"},
    /* 170 */ {"NH3-wetd", "NH3-wet deposition [10**(-3)*g/m**2]"},
    /* 171 */ {"NH4-conc", "NH4-concentration [10**(-6)*g/m**3]"},
    /* 172 */ {"NH4-dryd", "NH4-dry deposition [10**(-3)*g/m**2]"},
    /* 173 */ {"NH4-wetd", "NH4-wet deposition [10**(-3)*g/m**2]"},
    /* 174 */ {"O3-conc", "O3-concentration [10**(-6)*g/m**3]"},
    /* 175 */ {"PAN-conc", "PAN-concentration [10**(-6)*g/m**3]"},
    /* 176 */ {"PAN-dryd", "PAN-dry deposition [10**(-3)*g/m**2]"},
    /* 177 */ {"OH-conc", "OH-concentration [10**(-6)*g/m**3]"},
    /* 178 */ {"O3-dryd", "O3-dry deposition [10**(-3)*g/m**2]"},
    /* 179 */ {"O3-wetd", "O3-wet deposition [10**(-3)*g/m**2]"},
    /* 180 */ {"O3", "O3-mixing ratio [kg/kg]"},
    /* 181 */ {"var181", "undefined"},
    /* 182 */ {"var182", "undefined"},
    /* 183 */ {"var183", "undefined"},
    /* 184 */ {"var184", "undefined"},
    /* 185 */ {"var185", "undefined"},
    /* 186 */ {"var186", "undefined"},
    /* 187 */ {"var187", "undefined"},
    /* 188 */ {"var188", "undefined"},
    /* 189 */ {"var189", "undefined"},
    /* 190 */ {"var190", "undefined"},
    /* 191 */ {"var191", "undefined"},
    /* 192 */ {"var192", "undefined"},
    /* 193 */ {"var193", "undefined"},
    /* 194 */ {"var194", "undefined"},
    /* 195 */ {"var195", "undefined"},
    /* 196 */ {"var196", "undefined"},
    /* 197 */ {"var197", "undefined"},
    /* 198 */ {"var198", "undefined"},
    /* 199 */ {"var199", "undefined"},
    /* 200 */ {"I131-conc", "I131-concentration [Bq/m**3]"},
    /* 201 */ {"I131-dryd", "I131-dry deposition [Bq/m**2]"},
    /* 202 */ {"I131-wetd", "I131-wet deposition [Bq/m**2]"},
    /* 203 */ {"Cs137-conc", "Cs137-concentration [Bq/m**3]"},
    /* 204 */ {"Cs137-dryd", "Cs1370dry deposition [Bq/m**2]"},
    /* 205 */ {"Cs137-wetd", "Cs137-wet deposition [Bq/m**2]"},
    /* 206 */ {"Te132-conc", "Te132-concentration [Bq/m**3]"},
    /* 207 */ {"Te132-dryd", "Te132-dry deposition [Bq/m**2]"},
    /* 208 */ {"Te132-wetd", "Te132-wet deposition [Bq/m**2]"},
    /* 209 */ {"Zr95-conc", "Zr95-concentration [Bq/m**3]"},
    /* 210 */ {"Zr95-dryd", "Zr95-dry deposition [Bq/m**2]"},
    /* 211 */ {"Zr95-wetd", "Zr95-wet deposition [Bq/m**2]"},
    /* 212 */ {"var212", "undefined"},
    /* 213 */ {"var213", "undefined"},
    /* 214 */ {"var214", "undefined"},
    /* 215 */ {"var215", "undefined"},
    /* 216 */ {"var216", "undefined"},
    /* 217 */ {"var217", "undefined"},
    /* 218 */ {"var218", "undefined"},
    /* 219 */ {"var219", "undefined"},
    /* 220 */ {"var220", "undefined"},
    /* 221 */ {"var221", "undefined"},
    /* 222 */ {"var222", "undefined"},
    /* 223 */ {"var223", "undefined"},
    /* 224 */ {"var224", "undefined"},
    /* 225 */ {"var225", "undefined"},
    /* 226 */ {"var226", "undefined"},
    /* 227 */ {"var227", "undefined"},
    /* 228 */ {"var228", "undefined"},
    /* 229 */ {"var229", "undefined"},
    /* 230 */ {"var230", "undefined"},
    /* 231 */ {"var231", "undefined"},
    /* 232 */ {"var232", "undefined"},
    /* 233 */ {"var233", "undefined"},
    /* 234 */ {"var234", "undefined"},
    /* 235 */ {"var235", "undefined"},
    /* 236 */ {"var236", "undefined"},
    /* 237 */ {"var237", "undefined"},
    /* 238 */ {"var238", "undefined"},
    /* 239 */ {"var239", "undefined"},
    /* 240 */ {"UV_Ind_F_h", "UV_Index corr. for albedo+altitude,cloudless(F), h [1]"},
    /* 241 */ {"BasicUV_IF", "Basic UV_Index m.s.l.,fixed albedo,cloudless(F), h [1]"},
    /* 242 */ {"UV_Ind_W_h", "UV_Index corrected for albedo+altitude+clouds(W),h [1]"},
    /* 243 */ {"UV_IndmaxF", "UV_Index cloudless (F), daily maximum [1]"},
    /* 244 */ {"SB-Index", "Sonnenbrand-Index [(W*10**(-3))/m**2]"},
    /* 245 */ {"SB-Index W", "Sonnenbrand-Index bei mittl. Bewoelkung (08z-12z) [(W*10**(-3))/m**2]"},
    /* 246 */ {"Kan.UVB-WI", "Kanadischer UVB-Warnindex (bew|lkungsreduziert) [(W*10**(-3))/m**2]"},
    /* 247 */ {"gesamt O3", "total column ozone (Gesamtozon) [Dobson Unit, DU]"},
    /* 248 */ {"UV_IndmaxW", "UV_Index clouded (W), daily maximum [1]"},
    /* 249 */ {"h UV_IndMx", "time of UV_Index maximum [h UTC]"},
    /* 250 */ {"var250", "undefined"},
    /* 251 */ {"var251", "undefined"},
    /* 252 */ {"var252", "undefined"},
    /* 253 */ {"var253", "undefined"},
    /* 254 */ {"var254", "undefined"},
    /* 255 */ {"var255", "undefined"},
};
