#include "cnames.h"

/*
 * GRIB table 2 at DWD
 *     Helmut P. Frank, 30.08.2001
 * updated 24.07.2003: PMSL, DD, FF, W, FR_ICE, H_ICE
 */

struct ParmTable parm_table_dwd_002[256] = {
    /* 0 */ {"var0", "undefined"},
    /* 1 */ {"PS", "pressure [Pa]"},
    /* 2 */ {"PMSL", "pressure reduced to MSL [Pa]"},
    /* 3 */ {"p-tendency", "pressure tendency [Pa/s]"},
    /* 4 */ {"var4", "undefined"},
    /* 5 */ {"var5", "undefined"},
    /* 6 */ {"FI", "geopotential [(m**2)/(s**2)]"},
    /* 7 */ {"geopot h", "geopotential height [gpm]"},
    /* 8 */ {"geomet h", "geometrical height [m]"},
    /* 9 */ {"dev of h", "standard deviation of height [m]"},
    /* 10 */ {"TO3", "total ozone [Dobson Units]"},
    /* 11 */ {"T", "temperature [K]"},
    /* 12 */ {"virt.temp.", "virtual temperature [K]"},
    /* 13 */ {"pot. temp.", "potential temperature [K]"},
    /* 14 */ {"pseudo-pot", "pseudo-adiabatic potential temperature [K]"},
    /* 15 */ {"TMAX", "maximum temperature [K]"},
    /* 16 */ {"TMIN", "minimum temperature [K]"},
    /* 17 */ {"TD", "dew-point temperature [K]"},
    /* 18 */ {"dew-pnt de", "dew-point depression (or deficit) [K]"},
    /* 19 */ {"lapse rate", "laps rate [K/m]"},
    /* 20 */ {"visibility", "visibility [m]"},
    /* 21 */ {"radar sp 1", "radar spectra (1) [non-dim]"},
    /* 22 */ {"radar sp 2", "radar spectra (2) [non-dim]"},
    /* 23 */ {"radar sp 3", "radar spectra (3) [non-dim]"},
    /* 24 */ {"pli to 500", "parcel lifted index (to 500 hPa) [K]"},
    /* 25 */ {"temp anom", "temperature anomaly [K]"},
    /* 26 */ {"pres anom", "pressure anomaly [Pa]"},
    /* 27 */ {"geop anom", "geopotential height anomaly [gpm]"},
    /* 28 */ {"wave sp 1", "wave spaectra(1) [non-dim]"},
    /* 29 */ {"wave sp 2", "wave spaectra(2) [non-dim]"},
    /* 30 */ {"wave sp 3", "wave spaectra(3) [non-dim]"},
    /* 31 */ {"DD", "wind direction [degree true]"},
    /* 32 */ {"FF", "wind speed [m/s]"},
    /* 33 */ {"U", "u-component (zonal) of wind [m/s]"},
    /* 34 */ {"V", "v-component (merdional) of wind [m/s]"},
    /* 35 */ {"stream fun", "stream function [(m**2)/s]"},
    /* 36 */ {"vel potent", "velocity potential [(m**2)/s]"},
    /* 37 */ {"M.stream f", "Montgomery stream function [(m**2)/(s**2)]"},
    /* 38 */ {"sigma vert", "sigma co-ordinate vertical velocity [1/s]"},
    /* 39 */ {"OMEGA", "vertical velocity [Pa/s]"},
    /* 40 */ {"W", "vertical velocity [m/s]"},
    /* 41 */ {"abs vortic", "absolute vorticity [1/s]"},
    /* 42 */ {"abs diverg", "absolute divergence [1/s]"},
    /* 43 */ {"rel vortic", "relative vorticity [1/s]"},
    /* 44 */ {"rel diverg", "relative divergence [1/s]"},
    /* 45 */ {"vert.u-shr", "vertical u-component shear [1/s]"},
    /* 46 */ {"vert.v-shr", "vertical v-component shear [1/s]"},
    /* 47 */ {"dir of cur", "direction of current [degree true]"},
    /* 48 */ {"spd of cur", "speed of current [m/s]"},
    /* 49 */ {"currcomp U", "u-component of current [m/s]"},
    /* 50 */ {"currcomp V", "v-component of current [m/s]"},
    /* 51 */ {"QV", "specific humidity [kg/kg]"},
    /* 52 */ {"RELHUM", "relative humidity [%]"},
    /* 53 */ {"hum mixrat", "humidity mixing ratio [kg/kg]"},
    /* 54 */ {"TQV", "total precipitable water [kg/m**2]"},
    /* 55 */ {"vapor pres", "vapor pressure [Pa]"},
    /* 56 */ {"sat.defic.", "saturation deficit [Pa]"},
    /* 57 */ {"evaporat.", "evaporation [kg/(m**2)]"},
    /* 58 */ {"TQI", "total cloud ice content [kg/m**2]"},
    /* 59 */ {"prec. rate", "precipitation rate [kg/((m**2)*s)]"},
    /* 60 */ {"thunderst.", "thunderstorm probability [%]"},
    /* 61 */ {"TOT_PREC", "total precipitation [kg/(m**2)]"},
    /* 62 */ {"ls precip.", "large scale precipitation [kg/(m**2)]"},
    /* 63 */ {"conv prec.", "convective precipitation [kg/(m**2)]"},
    /* 64 */ {"snowf.rate", "snowfall rate water equivalent [kg/((m**2)*s)]"},
    /* 65 */ {"W_SNOW", "water equivalent of accumulated snow depth [kg/(m**2)]"},
    /* 66 */ {"snow depth", "snow depth [m]"},
    /* 67 */ {"mix lay de", "mixed layer depth [m]"},
    /* 68 */ {"tr therm d", "transient thermocline depth [m]"},
    /* 69 */ {"ma therm d", "main thermocline depth [m]"},
    /* 70 */ {"m therm da", "main thermocline depth anomaly [m]"},
    /* 71 */ {"CLCT", "total cloud cover [%]"},
    /* 72 */ {"CLC_CON", "convective cloud cover [%]"},
    /* 73 */ {"CLCL", "low cloud cover [%]"},
    /* 74 */ {"CLCM", "medium cloud cover [%]"},
    /* 75 */ {"CLCH", "high cloud cover [%]"},
    /* 76 */ {"TQC", "total cloud water content [kg/m**2]"},
    /* 77 */ {"bli to 500", "best lifted index (to 500 hPa) [K]"},
    /* 78 */ {"SNOW_CON", "convective snow [kg/(m**2)]"},
    /* 79 */ {"SNOW_GSP", "large scale snow [kg/(m**2)]"},
    /* 80 */ {"water temp", "water temperature [K]"},
    /* 81 */ {"FR_LAND", "land cover (1=land, 0=sea) [1]"},
    /* 82 */ {"dev sea-le", "deviation of sea-level from mean [m]"},
    /* 83 */ {"Z0", "surface roughness [m]"},
    /* 84 */ {"ALB_RAD", "albedo [%]"},
    /* 85 */ {"T_soil", "soil temperature [K]"},
    /* 86 */ {"W_soil", "soil moisture content [kg/(m**2)]"},
    /* 87 */ {"PLCOV", "vegetation (plant cover) [%]"},
    /* 88 */ {"salinity", "salinity [kg/kg]"},
    /* 89 */ {"density", "density [kg/(m**3)]"},
    /* 90 */ {"RUNOFF", "water run-off [kg/(m**2)]"},
    /* 91 */ {"FR_ICE", "ice cover (1=ice, 0=no ice) [1]"},
    /* 92 */ {"H_ICE", "ice thickness [m]"},
    /* 93 */ {"dir ice dr", "direction of ice drift [degree true]"},
    /* 94 */ {"sp ice dr", "speed of ice drift [m/s]"},
    /* 95 */ {"ice dr u", "u-component of ice drift [m/s]"},
    /* 96 */ {"ice dr v", "v-component of ice drift [m/s]"},
    /* 97 */ {"ice growth", "ice growth rate [m/s]"},
    /* 98 */ {"ice diverg", "ice divergence [1/s]"},
    /* 99 */ {"snow melt", "snow melt [kg/(m**2)]"},
    /* 100 */ {"winwav/swe", "significant height of comb. wind waves and swell [m]"},
    /* 101 */ {"dir of wav", "direction of wind waves [degree true]"},
    /* 102 */ {"hei of wav", "significant height of wind waves [m]"},
    /* 103 */ {"MP of wiwa", "mean period of wind waves [s]"},
    /* 104 */ {"dir of swe", "direction of swell [degree true]"},
    /* 105 */ {"hei of swe", "significant height of swell [m]"},
    /* 106 */ {"MP of swel", "mean period of swell [s]"},
    /* 107 */ {"pr wave di", "primary wave direction [degree true]"},
    /* 108 */ {"pr wave pe", "primary wave period [s]"},
    /* 109 */ {"se wave di", "secondary wave direction [degree true]"},
    /* 110 */ {"se wave pe", "secondary wave period [s]"},
    /* 111 */ {"ASOB_S", "net short-wave radiation (surface) [W/(m**2)]"},
    /* 112 */ {"ATHB_S", "net long-wave radiation (surface) [W/(m**2)]"},
    /* 113 */ {"ASOB_T", "net short-wave radiation (top of atmosphere) [W/(m**2)]"},
    /* 114 */ {"ATHB_T", "net long-wave radiation (top of atmosphere) [W/(m**2)]"},
    /* 115 */ {"l-w rad.", "long-wave radiation [W/(m**2)]"},
    /* 116 */ {"s-w rad.", "short-wave radiation [W/(m**2)]"},
    /* 117 */ {"global rad", "global radiation [W/(m**2)]"},
    /* 118 */ {"var118", "undefined"},
    /* 119 */ {"var119", "undefined"},
    /* 120 */ {"var120", "undefined"},
    /* 121 */ {"ALHFL_S", "latent heat flux [W/(m**2)]"},
    /* 122 */ {"ASHFL_S", "sensible heat flux [W/(m**2)]"},
    /* 123 */ {"bound l di", "boundary layer dissipation [W/(m**2)]"},
    /* 124 */ {"AUMFL_S", "momentum flux, u component [N/(m**2)]"},
    /* 125 */ {"AVMFL_S", "momentum flux, v component [N/(m**2)]"},
    /* 126 */ {"wind mix e", "wind mixing energy [J]"},
    /* 127 */ {"image data", "image data []"},
    /* 128 */ {"var128", "undefined"},
    /* 129 */ {"geopot h", "geopotential height (ECMF) [gpm]"},
    /* 130 */ {"temperatur", "temperature (ECMF) [K]"},
    /* 131 */ {"wind compU", "u-component of wind (ECMF) [m/s]"},
    /* 132 */ {"wind compV", "v-component of wind (ECMF) [m/s]"},
    /* 133 */ {"var133", "undefined"},
    /* 134 */ {"var134", "undefined"},
    /* 135 */ {"var135", "undefined"},
    /* 136 */ {"var136", "undefined"},
    /* 137 */ {"var137", "undefined"},
    /* 138 */ {"var138", "undefined"},
    /* 139 */ {"soil temp.", "soil temperature (ECMF) [K]"},
    /* 140 */ {"var140", "undefined"},
    /* 141 */ {"var141", "undefined"},
    /* 142 */ {"ls precip.", "large scale precipitation (ECMF) [kg/(m**2)]"},
    /* 143 */ {"conv prec.", "convective precipitation (ECMF) [kg/(m**2)]"},
    /* 144 */ {"snowfall", "snowfall (ECMF) [m of water equivalent]"},
    /* 145 */ {"var145", "undefined"},
    /* 146 */ {"var146", "undefined"},
    /* 147 */ {"var147", "undefined"},
    /* 148 */ {"var148", "undefined"},
    /* 149 */ {"var149", "undefined"},
    /* 150 */ {"var150", "undefined"},
    /* 151 */ {"pressure", "pressure reduced to MSL (ECMF) [Pa]"},
    /* 152 */ {"var152", "undefined"},
    /* 153 */ {"var153", "undefined"},
    /* 154 */ {"var154", "undefined"},
    /* 155 */ {"var155", "undefined"},
    /* 156 */ {"geopot h", "geopotential height (ECMF) [gpm]"},
    /* 157 */ {"rel. humid", "relative humidity (ECMF) [%]"},
    /* 158 */ {"var158", "undefined"},
    /* 159 */ {"var159", "undefined"},
    /* 160 */ {"var160", "undefined"},
    /* 161 */ {"var161", "undefined"},
    /* 162 */ {"var162", "undefined"},
    /* 163 */ {"var163", "undefined"},
    /* 164 */ {"cloud cov.", "total cloud cover (ECMF) [%]"},
    /* 165 */ {"10m-wind U", "u-component of 10m-wind (ECMF) [m/s]"},
    /* 166 */ {"10m-wind V", "v-component of 10m-wind (ECMF) [m/s]"},
    /* 167 */ {"2m temper", "2m temperature (ECMF) [K]"},
    /* 168 */ {"2m due-p.", "2m due-point temperature (ECMF) [K]"},
    /* 169 */ {"var169", "undefined"},
    /* 170 */ {"var170", "undefined"},
    /* 171 */ {"var171", "undefined"},
    /* 172 */ {"var172", "undefined"},
    /* 173 */ {"var173", "undefined"},
    /* 174 */ {"var174", "undefined"},
    /* 175 */ {"var175", "undefined"},
    /* 176 */ {"var176", "undefined"},
    /* 177 */ {"var177", "undefined"},
    /* 178 */ {"var178", "undefined"},
    /* 179 */ {"var179", "undefined"},
    /* 180 */ {"var180", "undefined"},
    /* 181 */ {"var181", "undefined"},
    /* 182 */ {"var182", "undefined"},
    /* 183 */ {"var183", "undefined"},
    /* 184 */ {"var184", "undefined"},
    /* 185 */ {"var185", "undefined"},
    /* 186 */ {"var186", "undefined"},
    /* 187 */ {"var187", "undefined"},
    /* 188 */ {"var188", "undefined"},
    /* 189 */ {"var189", "undefined"},
    /* 190 */ {"var190", "undefined"},
    /* 191 */ {"var191", "undefined"},
    /* 192 */ {"var192", "undefined"},
    /* 193 */ {"var193", "undefined"},
    /* 194 */ {"var194", "undefined"},
    /* 195 */ {"var195", "undefined"},
    /* 196 */ {"var196", "undefined"},
    /* 197 */ {"var197", "undefined"},
    /* 198 */ {"var198", "undefined"},
    /* 199 */ {"var199", "undefined"},
    /* 200 */ {"var200", "undefined"},
    /* 201 */ {"var201", "undefined"},
    /* 202 */ {"var202", "undefined"},
    /* 203 */ {"var203", "undefined"},
    /* 204 */ {"var204", "undefined"},
    /* 205 */ {"var205", "undefined"},
    /* 206 */ {"var206", "undefined"},
    /* 207 */ {"var207", "undefined"},
    /* 208 */ {"var208", "undefined"},
    /* 209 */ {"var209", "undefined"},
    /* 210 */ {"var210", "undefined"},
    /* 211 */ {"var211", "undefined"},
    /* 212 */ {"var212", "undefined"},
    /* 213 */ {"var213", "undefined"},
    /* 214 */ {"var214", "undefined"},
    /* 215 */ {"var215", "undefined"},
    /* 216 */ {"var216", "undefined"},
    /* 217 */ {"var217", "undefined"},
    /* 218 */ {"var218", "undefined"},
    /* 219 */ {"var219", "undefined"},
    /* 220 */ {"var220", "undefined"},
    /* 221 */ {"var221", "undefined"},
    /* 222 */ {"var222", "undefined"},
    /* 223 */ {"var223", "undefined"},
    /* 224 */ {"var224", "undefined"},
    /* 225 */ {"var225", "undefined"},
    /* 226 */ {"var226", "undefined"},
    /* 227 */ {"var227", "undefined"},
    /* 228 */ {"total prec", "total precipitation (ECMF) [m]"},
    /* 229 */ {"seaway 01", "seaway 01 (ECMF) []"},
    /* 230 */ {"seaway 02", "seaway 02 (ECMF) []"},
    /* 231 */ {"seaway 03", "seaway 03 (ECMF) []"},
    /* 232 */ {"seaway 04", "seaway 04 (ECMF) []"},
    /* 233 */ {"seaway 05", "seaway 05 (ECMF) []"},
    /* 234 */ {"seaway 06", "seaway 06 (ECMF) []"},
    /* 235 */ {"seaway 07", "seaway 07 (ECMF) []"},
    /* 236 */ {"seaway 08", "seaway 08 (ECMF) []"},
    /* 237 */ {"seaway 09", "seaway 09 (ECMF) []"},
    /* 238 */ {"seaway 10", "seaway 10 (ECMF) []"},
    /* 239 */ {"seaway 11", "seaway 11 (ECMF) []"},
    /* 240 */ {"var240", "undefined"},
    /* 241 */ {"var241", "undefined"},
    /* 242 */ {"var242", "undefined"},
    /* 243 */ {"var243", "undefined"},
    /* 244 */ {"var244", "undefined"},
    /* 245 */ {"var245", "undefined"},
    /* 246 */ {"var246", "undefined"},
    /* 247 */ {"var247", "undefined"},
    /* 248 */ {"var248", "undefined"},
    /* 249 */ {"var249", "undefined"},
    /* 250 */ {"var250", "undefined"},
    /* 251 */ {"var251", "undefined"},
    /* 252 */ {"var252", "undefined"},
    /* 253 */ {"var253", "undefined"},
    /* 254 */ {"var254", "undefined"},
    /* 255 */ {"var255", "undefined"},
};
