# Python script to plot lidar values from 'lidar.nc' from 'LIDAR_ASCII_netCDF.py'
# L. Fita, LMD. Jussieu, November 2013
## g.e. # plot_lidar.py -f lidar.nc -c 'BuPu' -v 'qv,0.0,0.001' -k pdf -r True
## g.e. # plot_lidar.py -f lidar.nc -c 'seismic' -v 'w,-0.5,0.5' -k pdf -r True

#
## export PATH=/u/lflmd/bin/gcc_Python-2.7.5/bin:${PATH}

import numpy as np
from netCDF4 import Dataset as NetCDFFile
import os
import re
import nc_var_tools as ncvar
from optparse import OptionParser
import drawing_tools as drawpy

main = 'plot_lidar'
errormsg = 'ERROR -- error -- ERROR -- error'

####### ###### ##### #### ### ## #


parser = OptionParser()
parser.add_option("-c", "--Color_Bar", dest="colorbar",
                  help="""color bar to use in the plot:
                   Sequential: 'binary', 'Blues', 'BuGn', 'BuPu', 
                             'gist_yarg', 'GnBu', 'Greens', 'Greys', 
                             'Oranges', 'OrRd', 'PuBu', 'PuBuGn', 
                             'PuRd', 'Purples', 'RdPu', 'Reds', 'YlGn',
                             'YlGnBu', 'YlOrBr', 'YlOrRd'
                   Sequential 2: 'afmhot', 'autumn', 'bone', 'cool', 
                             'copper', 'gist_gray', 'gist_heat', 'gray',
                             'hot', 'pink', 'spring', 'summer', 'winter'
                   Diverging: 'BrBG', 'bwr', 'coolwarm', 'PiYG', 'PRGn', 
                             'PuOr', 'RdBu', 'RdGy', 'RdYlBu', 'RdYlGn', 
                             'seismic'
                   Qualitative: 'Accent', 'Dark2', 'hsv', 'Paired', 
                              'Pastel1', 'Pastel2', 'Set1', 'Set2', 
                              'Set3', 'spectral'
                   Miscellaneous: 'gist_earth', 'gist_ncar', 
                             'gist_rainbow', 'gist_stern', 'jet', 'brg',
                             'CMRmap', 'cubehelix', 'gnuplot', 'gnuplot2',
                             'ocean', 'rainbow', 'terrain', 'flag', 
                             'prism'
                   http://matplotlib.org/1.3.1/examples/color/colormaps_reference.html""", metavar="LABEL")
parser.add_option("-f", "--file", dest="ifile",
                  help="netCDF file to use", metavar="FILE")
parser.add_option("-k", "--figure_kind", dest="kfig",
                  help="kind of figure ('null', only show, 'png', 'pdf')", metavar="LABEL")
parser.add_option("-r", "--reverseAxes", dest="reversea",
                  help="indicate if axes have to be reversed (default False. True, x-->y, y-->x)", metavar="FILE")
parser.add_option("-v", "--variable", dest="var",
                  help="varn,minv,maxv (name of the variable, minimum and maximum values ['all', full range]", metavar="LABEL")

(opts, args) = parser.parse_args()

#######    #######
## MAIN
    #######

if not os.path.isfile(opts.ifile):
    print errormsg
    print '  ' + main + ' file: "' + opts.ifile + '" does not exist !!'
    print errormsg
    quit(-1)

objifile = NetCDFFile(opts.ifile, 'r')
varobj = objifile.variables[opts.var.split(',')[0]]
varvalues = varobj[:]

oheights = objifile.variables['z']
otimes = objifile.variables['time']
heights = oheights[:]
times = otimes[:]

drawpy.check_colorBar(opts.colorbar)

varname = opts.var.split(',')[0]
varmin = opts.var.split(',')[1]
if varmin == 'all':
    varn = np.min(varvalues)
else:
    varn = np.float(opts.var.split(',')[1])

varmax = opts.var.split(',')[2]
if varmax == 'all':
    varx = np.max(varvalues)
else:
    varx = np.float(opts.var.split(',')[2])

if not opts.reversea is None:
    reversea = opts.reversea
else:
    reversea = False

drawpy.plot_2Dfield_easy(varvalues, heights, times,                                  \
  ['time (h since simulation start)','z'], opts.colorbar, varn, varx,                \
  drawpy.units_lunits(varobj.getncattr('units')), opts.ifile, varname, opts.kfig,    \
  reversea)

