# Python script to transfomr ASCII LIDAR outputs to netCDF
## g.e. # TS_ASCII_netCDF.py -f //media/ExtDiskD/bkup/ciclad/etudes/WL_HyMeX/iop15/wrf/run/control/stations_20121018000000-20121022000000/h0001.d01.TS

import os
from optparse import OptionParser
import numpy as np
from netCDF4 import Dataset as NetCDFFile
import nc_var_tools as ncvar

main = 'TS_ASCII_netCDF.py'
errormsg='ERROR -- error -- ERROR -- error'
warnmsg='WARNING -- warning -- WARNING -- warning'

fillValue = 1.e20

####### ###### ##### #### ### ## #

parser = OptionParser()
parser.add_option("-f", "--TS_file", dest="lfile",
                  help="Time Series ASCII text file to use", metavar="FILE")

(opts, args) = parser.parse_args()


tsvn = ['t', 'q', 'u', 'v', 'psfc', 'glw', 'gsw', 'hfx', 'lh', 'tsk', 'tslb1', 'rainc', 'rainnc', 'clw']

tsvln = ['2 m Temperature', '2 m vapor mixing ratio', '10 m U wind (earth-relative)', '10 m V wind (earth-relative)', 'surface pressure', 'downward longwave radiation flux at the ground (downward is positive)', 'net shortwave radiation flux at the ground (downward is positive)', 'surface sensible heat flux (upward is positive)', 'surface latent heat flux (upward is positive)', 'skin temperature', 'top soil layer temperature', 'rainfall from a cumulus scheme', 'rainfall from an explicit scheme', 'total column-integrated water vapor and cloud variables']

tsvu = ['K', 'kg/kg', 'm/s', 'm/s', 'Pa', 'W/m2', 'W/m2', 'W/m2', 'W/m2', 'K', 'K', 'mm', 'mm', 1']

#######    #######
## MAIN
    #######

ofile = 'ts.nc'
Ntsvariables = len(tsvn)

if not os.path.isfile(opts.lfile):
    print errormsg
    print '  Time-Series ASCII text file "' + opts.lfile + '" does not exist !!'
    print errormsg
    quit()

objlfile = open(opts.lfile, 'r')

objofile = NetCDFFile(ofile, 'w')

# Creation of dimensions
##
objofile.createDimension('time',None)

ncvar.set_attribute(objofile, 'author', 'Lluis Fita Borrell')
ncvar.set_attribute(objofile, 'institution', 'Laboratoire Meteorologique Dynamique')
ncvar.set_attribute(objofile, 'university', 'University Pierre et Marie Curie')
ncvar.set_attribute(objofile, 'center', 'Centre national de la recherche scientifique')
ncvar.set_attribute(objofile, 'country', 'France')
ncvar.set_attribute(objofile, 'city', 'Paris')
ncvar.set_attribute(objofile, 'script', 'TS_ASCII_netCFD.py')
ncvar.set_attribute(objofile, 'version', '1.0')

time_step = []
psfc = []
rainc = []
rainnc = []
drydens = []

tsvals = {}

iline=0
itz = 0
for line in objlfile:
    values = ncvar.reduce_spaces(line)
#    print iline, values[0], dimz, Searchdimz
# Writting general information
    if iline == 0:
        newvar = objofile.createVariable('station','c')
        ncvar.set_attribute(newvar, 'name',values[0])
        ncvar.set_attribute(newvar, 'acronym',values[3])
        ncvar.set_attribute(newvar, 'real_lon',                                      \
          np.float(values[6].replace(',','').replace('(','').replace(')','')) )
        ncvar.set_attribute(newvar, 'real_lat',                                      \
          np.float(values[5].replace(',','').replace('(','').replace(')','')) )
        ncvar.set_attribute(newvar, 'x_grid_point',                                  \
          int(values[8].replace(',','').replace('(','').replace(')','')) )
        ncvar.set_attribute(newvar, 'y_grid_point',                                  \
          int(values[9].replace(',','').replace('(','').replace(')','')) )
        ncvar.set_attribute(newvar, 'model_lon',                                     \
          np.float(values[12].replace(',','').replace('(','').replace(')','')) )
        ncvar.set_attribute(newvar, 'model_lat',                                     \
          np.float(values[11].replace(',','').replace('(','').replace(')','')) )
        ncvar.set_attribute(newvar, 'model_height',                                  \
          np.float(values[13].replace(',','').replace('(','').replace(')','')) )
        simstarttime = values[18]
    else:
        tsvals[itz] = values
    iline = iline + 1

dimt = len(time_step)

print '  Found:',dimt,'time steps, over:',dimz,'vertical levels'
objlfile.close()

objofile.createDimension('z',dimz)

time_stepv = np.zeros((dimt), dtype=np.float)
psfcv = np.zeros((dimt), dtype=np.float)
raincv = np.zeros((dimt), dtype=np.float)
rainncv = np.zeros((dimt), dtype=np.float)
drydensv = np.zeros((dimt), dtype=np.float)

tsvaluesv = np.zeros( (dimt,dimz,Ntsvariables), dtype= np.float)

itz = 0
for it in range(dimt):
    time_stepv[it] = np.float(time_step[it])
    psfcv[it] = np.float(psfc[it])
    raincv[it] = np.float(rainc[it])
    rainncv[it] = np.float(rainnc[it])
    drydensv[it] = np.float(drydens[it])

    for iz in range(dimz):
        for iv in range(Ntsvariables):
            tsvaluesv[it,iz,iv] = np.float(tsvals[itz][iv+1])

        itz = itz + 1
# Surface variables
newvar = objofile.createVariable('time','f4',('time',))
newvar[:] = time_stepv
newattr = ncvar.basicvardef(newvar, 'time', 'time', 'hours since ' +                 \
  simstarttime.replace('_',' '))

newvar = objofile.createVariable('psfc','f4',('time',))
newvar[:] = psfcv
newattr = ncvar.basicvardef(newvar, 'psfc', 'surface pressure', 'hPa')

newvar = objofile.createVariable('rainc','f4',('time',))
newvar[:] = raincv
newattr = ncvar.basicvardef(newvar, 'rainc',                                         \
  'accumulated precipitation from cumulus scheme', 'mm')

newvar = objofile.createVariable('rainnc','f4',('time',))
newvar[:] = rainncv
newattr = ncvar.basicvardef(newvar, 'rainnc',                                        \
  'accumulated precipitation not from cumulus scheme', 'mm')

newvar = objofile.createVariable('drydens','f4',('time',))
newvar[:] = drydensv
newattr = ncvar.basicvardef(newvar, 'drydens', 'total dry air column pressure', 'hPa')

# Lidar variables
for iv in range(Ntsvariables):
    newvar = objofile.createVariable(tsvn[iv], 'f4', ('time','z'))
    newvar[:] = tsvaluesv[:,:,iv]
    newattr = ncvar.basicvardef(newvar, tsvn[iv], tsvln[iv], tsvu[iv] )

objofile.sync()
objofile.close()

print 'Successfull generation of LIDAR netCDF file "' + ofile + '" !!!!!'
