#!/bin/bash
### Script to get sounding and surface points for validation purposes

#   soundings: different lon,lat locations of soundings stations
#   surface: different lon,lat locations of surface stations
#   simulations: multiple outputs from different models and runs
#   outputs: multiple different type of file outputs from model runs
#

# Name of the file with the configuration
if test $1 = '-h'; then
  echo "******************************************"
  echo "***     Script to get WRF data at     ***"
  echo "*** sounding and surface observations ***"
  echo "***     from multiple simulations     ***"
  echo "*****************************************"
  echo "get_data_snd-sfc_validation [ConfFile](configuration file)"
else
  rootsh=`pwd`

  configfname=$1

####### ###### ##### #### ### ## #

function uploadvars() {
# Function to upload variables to the system from an ASCII file as:
#   [varname] = [value]
  fileval=$1
  errormsg='ERROR -- error -- ERROR -- error'

  if test ! -f ${fileval}; then
    echo ${errormsg}
    echo "  "${fname}": file '"${fileval}"' does not exist!!"
    exit
  fi

  Nlin=`wc -l ${fileval} | awk '{print $1}'`

  ilin=1
  while test ${ilin} -le ${Nlin}; do
    line=`head -n ${ilin} ${fileval} | tail -n 1`
    varname=`echo ${line} | tr '=' ' ' | awk '{print $1}'`
    value=`echo ${line} | tr '=' ' ' | awk '{print $2}'`
    Lvarname=`expr length ${varname}'0'`

    if test ${Lvarname} -gt 1 && test ! ${varname:0:1} = '#'; then
      export ${varname}=${value}
    fi
    ilin=`expr ${ilin} + 1`
  done  
}

#######    #######
## MAIN
    #######
uploadvars ${configfname}
echo "END upload -- end UPLOAD -- END upload -- end UPLOAD"

errmsg='ERROR -- error -- ERROR -- error'

# from scratch
if test ${scratch} = 'true'; then scratch=true
else scratch=false; fi

# Modules
if test ! ${LOADmods} = 'None'; then
  lmods=`echo ${LOADmods} | tr ':' ' '`
  for lmod in ${lmods}; do
    module load ${lmod}
  done
fi

insoutf='allins_functions.inf'

exps=`echo ${experiments} | tr ':' ' '`
sndsts=`echo ${sndstations} | tr ':' ' '`
sfcsts=`echo ${sfcstations} | tr ':' ' '`

for expn in ${exps}; do
  ifold=${infolder}/${expn}/wrfout
  ofold=${ofolder}/${expn}

  mkdir -p ${ofold}

  if test ! ${sndstations} = 'None'; then
  for sndvn in ${sndsts}; do
    sndid=`echo ${sndvn} | tr ',' ' ' | awk '{print $1}'`
    sndlon=`echo ${sndvn} | tr ',' ' ' | awk '{print $2}'`
    sndlat=`echo ${sndvn} | tr ',' ' ' | awk '{print $3}'`

    kout='snd'
    filek='_vars_'${kout}'pt _'${kout}'diags'
    # Sounding values
    if test ! ${snddiags} = 'None'; then
      fHEADn='simout'
      files=`ls -1 ${infolder}/${expn}/wrfout/wrfout_d${domn}*`
      ofile=${ofold}/${fHEADn}_${kout}diags_${sndid}_${expn}.nc
      if test ${scratch} = 'true'; then rm ${ofile} >& /dev/null; fi
      if test ! -f ${ofile}; then
        for filen in ${files}; do
          $pyHOME/get_WRFsounding-surface_data.bash ${scratch} ${ofold} ${expn}      \
            ${sndvn} None ${filen} ${snddiags},None,None,None,None
        # end of files
        done

        # Concatenating files
        for fk in ${filek}; do
          whichk=`expr ${fk} : ."diags"`
          if ! grep -q diags <<< ${fk}; then values=${ofold}',Time,WRFtime'
          else values=${ofold}',Time,time'; fi

          ofile=${ofold}/${fHEADn}${fk}_${sndid}_${expn}.nc
          HMT=${fHEADn}${fk}'_,'${sndid}'_'${expn},'nc'
          Nfiles=`ls -1 ${ofold}/${fHEADn}${fk}_*${sndid}_${expn}*.nc | wc -l`
          if test ${Nfiles} -gt 1; then
            python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT -S ${values} \
             -f ${HMT} -v all
            if test $? -ne 0; then
              echo ${errmsg}
              echo "  python failed!!"
              echo python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT           \
              -S ${values} -f ${HMT} -v all
              exit
            fi
            echo " * Concatenating sounding data '"${fk}"' at point: "${sndid} >> ${insoutf}
            echo python  ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT            \
             -S "'"${values}"'" -f ${HMT} -v all >> ${insoutf}
            echo " " >> ${insoutf}
            mv netcdf_fold_concatenated_HMT.nc ${ofile}
            rm ${ofold}/${fHEADn}${fk}_${sndid}_${expn}_????-??-??_??:??:??.nc >& /dev/null
          else
            file1=`ls -1 ${ofold}/${fHEADn}${fk}_*${sndid}_${expn}*.nc`
            mv ${file1} ${ofile}
          fi
        done
      fi
     fi

    # cordex values
    if test ! ${cdxdiags} = 'None' || test ! ${cdxnondiags} = 'None'; then
      fHEADn='simcdx'
      files=`ls -1 ${infolder}/${expn}/wrfout/wrfcdx_d${domn}*`
      ofile=${ofold}/${fHEADn}_${kout}diags_${sndid}_${expn}.nc
      if test ${scratch} = 'true'; then rm ${ofile} >& /dev/null; fi
      if test ! -f ${ofile}; then
        for filen in ${files}; do
          $pyHOME/get_WRFsounding-surface_data.bash ${scratch} ${ofold} ${expn}      \
            ${sndvn} None ${filen} None,None,None,${cdxdiags},${cdxnondiags}
        # end of files
        done

        # Concatenating files
        for fk in ${filek}; do
          whichk=`expr ${fk} : ."diags"`
          if ! grep -q diags <<< ${fk}; then values=${ofold}',Time,WRFtime'
          else values=${ofold}',Time,time'; fi

          ofile=${ofold}/${fHEADn}${fk}_${sndid}_${expn}.nc
          HMT=${fHEADn}${fk}'_,'${sndid}'_'${expn},'nc'
          Nfiles=`ls -1 ${ofold}/${fHEADn}${fk}_*${sndid}_${expn}*.nc | wc -l`
          if test ${Nfiles} -gt 1; then
            python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT -S ${values}   \
             -f ${HMT} -v all
            if test $? -ne 0; then
              echo ${errmsg}
              echo "  python failed!!"
              echo python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT         \
                -S ${values} -f ${HMT} -v all
              exit
            fi
            echo " * Concatenating cdx sounding data at point: "${sndlon}", "${sndlat} >>\
              ${insoutf}
            echo python  ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT          \
             -S "'"${values}"'" -f ${HMT} -v all >> ${insoutf}
            echo " " >> ${insoutf}
            mv netcdf_fold_concatenated_HMT.nc ${ofile}
            rm ${ofold}/${fHEADn}${fk}_${sndid}_${expn}_????-??-??_??:??:??.nc >& /dev/null
          else
            file1=`ls -1 ${ofold}/${fHEADn}${fk}_*${sndid}_${expn}*.nc`
            mv ${file1} ${ofile}
          fi
        done
      fi
     fi
  # end of sounding stations
  done
  fi

  # Surface stations
  if test ! ${sfcstations} = 'None'; then
  for sfcvn in ${sfcsts}; do
    sfcid=`echo ${sfcvn} | tr ',' ' ' | awk '{print $1}'`
    sfclon=`echo ${sfcvn} | tr ',' ' ' | awk '{print $2}'`
    sfclat=`echo ${sfcvn} | tr ',' ' ' | awk '{print $3}'`

    kout='sfc'
    filek='_vars_'${kout}'pt _'${kout}'diags'
    # out sfc pt
    if test ! ${sfcdiags} = 'None' || test ! ${sfcnondiags} = 'None'; then
      fHEADn='simout'
      files=`ls -1 ${infolder}/${expn}/wrfout/wrfout_d${domn}*`
      ofile=${ofold}/${fHEADn}_${kout}diags_${sfcid}_${expn}.nc
      if test ${scratch} = 'true'; then rm ${ofile} >& /dev/null; fi
      if test ! -f ${ofile}; then
        for filen in ${files}; do
          $pyHOME/get_WRFsounding-surface_data.bash ${scratch} ${ofold} ${expn} None \
            ${sfcvn} ${filen} None,${sfcdiags},${sfcnondiags},None,None
        # end of files
        done

        # Concatenating files
        for fk in ${filek}; do
          whichk=`expr ${fk} : ."diags"`
          if ! grep -q diags <<< ${fk}; then values=${ofold}',Time,WRFtime'
          else values=${ofold}',Time,time'; fi

          ofile=${ofold}/${fHEADn}${fk}_${sfcid}_${expn}.nc
          HMT=${fHEADn}${fk}'_,'${sfcid}'_'${expn},'nc'
          Nfiles=`ls -1 ${ofold}/${fHEADn}${fk}_*${sfcid}_${expn}*.nc | wc -l`
          if test ${Nfiles} -gt 0; then
            python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT -S ${values}   \
             -f ${HMT} -v all
            if test $? -ne 0; then
              echo ${errmsg}
              echo "  python failed!!"
              echo python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT         \
                -S ${values} -f ${HMT} -v all
              exit
            fi
            echo " * Concatenating surface data '"${fk}"' at point: "${sfcid} >> ${insoutf}
            echo python  ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT          \
             -S "'"${values}"'" -f ${HMT} -v all >> ${insoutf}
            echo " " >> ${insoutf}
            mv netcdf_fold_concatenated_HMT.nc ${ofile}
            rm ${ofold}/${fHEADn}${fk}_${sfcid}_${expn}_????-??-??_??:??:??.nc >& /dev/null
          else
            file1=`ls -1 ${ofold}/${fHEADn}${fk}_*${sfcid}_${expn}*.nc`
            mv ${file1} ${ofile}
          fi
        done
      fi
    fi

    # cdx sfc pt
    if test ! ${cdxdiags} = 'None' || test ! ${cdxnondiags} = 'None'; then
      fHEADn='simcdx'
      files=`ls -1 ${infolder}/${expn}/wrfout/wrfcdx_d${domn}*`
      ofile=${ofold}/${fHEADn}_${kout}diags_${sfcid}_${expn}.nc
      if test ${scratch} = 'true'; then rm ${ofile} >& /dev/null; fi
      if test ! -f ${ofile}; then
        for filen in ${files}; do
          $pyHOME/get_WRFsounding-surface_data.bash ${scratch} ${ofold} ${expn} None \
            ${sfcvn} ${filen} None,None,None,${cdxdiags},${cdxnondiags}
        # end of files
        done

        # Concatenating files
        for fk in ${filek}; do
          whichk=`expr ${fk} : ."diags"`
          if ! grep -q diags <<< ${fk}; then values=${ofold}',Time,WRFtime'
          else values=${ofold}',Time,time'; fi

          ofile=${ofold}/${fHEADn}${fk}_${sfcid}_${expn}.nc
          HMT=${fHEADn}${fk}'_,'${sfcid}'_'${expn},'nc'
          Nfiles=`ls -1 ${ofold}/${fHEADn}${fk}_*${sfcid}_${expn}*.nc | wc -l`
          if test ${Nfiles} -gt 0; then
            python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT -S ${values}   \
             -f ${HMT} -v all
            if test $? -ne 0; then
              echo ${errmsg}
              echo "  python failed!!"
              echo python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT         \
                -S ${values} -f ${HMT} -v all
              exit
            fi
            echo " * Concatenating cdx surface data at point: "${sfcid} >> ${insoutf}
            echo python  ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT          \
             -S "'"${values}"'" -f ${HMT} -v all >> ${insoutf}
            echo " " >> ${insoutf}
            mv netcdf_fold_concatenated_HMT.nc ${ofile}
            rm ${ofold}/${fHEADn}${fk}_${sfcid}_${expn}_????-??-??_??:??:??.nc >& /dev/null
          else
            file1=`ls -1 ${ofold}/${fHEADn}${fk}_*${sfcid}_${expn}*.nc`
            mv ${file1} ${ofile}
          fi
        done
      fi
      #exit
    fi

  # end of surfaces
  done
  fi

  # 2D maps
  kout='sfcmap'
  filek='_vars_'${kout}' _'${kout}'diags'
  okind='out cdx' 
  for ik in ${okind}; do
    fHEADn='sim'${ik}
    for fk in ${filek}; do
      whichk=`expr ${fk} : ."diags"`
      if ! grep -q diags <<< ${fk}; then values=${ofold}',Time,WRFtime'
      else values=${ofold}',Time,time'; fi

      ofile=${ofold}/${fHEADn}${fk}_${expn}.nc
      if test ${scratch} = 'true'; then rm ${ofile} >& /dev/null; fi
      if test ! -f ${ofile}; then
        # Concatenating files
        values=${ofold}',Time,time'
        HMT=${fHEADn}${fk}'_,'${expn},'nc'
        Nfiles=`ls -1 ${ofold}/${fHEADn}${fk}_*${expn}*.nc | wc -l`
        if test ${Nfiles} -gt 0; then
          python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT -S ${values}     \
           -f ${HMT} -v all
          if test $? -ne 0; then
            echo ${errmsg}
            echo "  python failed!!"
            echo python ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT           \
              -S ${values} -f ${HMT} -v all
            exit
          fi
          echo " * Concatenating '${ik}' surface map data: " >> ${insoutf}
          echo python  ${pyHOME}/nc_var.py -o netcdf_fold_concatenation_HMT            \
           -S "'"${values}"'" -f ${HMT} -v all >> ${insoutf}
          echo " " >> ${insoutf}
          mv netcdf_fold_concatenated_HMT.nc ${ofile}
          rm ${ofold}/${fHEADn}${fk}_${expn}_????-??-??_??:??:??.nc >& /dev/null
        else
          file1=`ls -1 ${ofold}/${fHEADn}${fk}_*${expn}*.nc`
          mv ${file1} ${ofile}
        fi
      fi
    done
  done

# End of experiments
done

fi
