#!/usr/bin/python
# Python to manage netCDF files.
# From L. Fita work in different places: CCRC (Australia), LMD (France)
# More information at: http://www.xn--llusfb-5va.cat/python/PyNCplot
#
# pyNCplot and its component nc_var.py comes with ABSOLUTELY NO WARRANTY. 
# This work is licendes under a Creative Commons 
#   Attribution-ShareAlike 4.0 International License (http://creativecommons.org/licenses/by-sa/4.0)
#

## e.g. # nc_var.py -o lonlat_polygon -f wrfout_d01_1995-01-01_00:00:00 -S star.dat -v XLONG,XLAT
## e.g. # nc_var.py -o maskvar -f SouthAm_Climzones_masked.nc -S 'geo_em.d01.nc:LANDMASK:Time|0:0' -v region:lon,lat
## e.g. # nc_var.py -o addDim -S 128 -f SouthAm_Climzones.nc -v Lstring
## e.g. # nc_var.py -o addVar -S 'reg,Lstring|region_name@name!of!the!regions@-|c' -f SouthAm_Climzones.nc -v regionn
## e.g. # nc_var.py -o varaddattr -f SouthAm_Climzones.nc -S 'grid_mapping_name|Mercator' -v Mercator
## e.g. # nc_var.py -o varaddattrk -f SouthAm_Climzones.nc -S 'longitude_of_central_meridian|-60.0|R' -v Mercator
## e.g. # nc_var.py -o setvar_asciivalues -S 'nombres_zonas.dat' -f SouthAm_Climzones.nc -v regionn
## e.g. # nc_var.py -o WRF_to_newCF -f wrfout_d01_1995-01-01_00\:00\:00 -S 'XLONG:XLAT:Times:19491201000000:minutes' -v QVAPOR,T2,Q2
## e.g. # nc_var.py -o reconstruct_matrix_from_vector -f cruncep_halfdeg_1958.nc -S 'nav_lon:nav_lat:-90.:-7.:-67.:15.:latlon:0.5:0.5:0.05' -v all 
## e.g. # nc_var.py -o nc_var.py -o CFmorzization -S 'X|west_east|XLONG,Y|south_north|XLAT,T|Time|WRFtime,Z|bottom_top|ZNU:GlobalAttr1995.inf:proj1995.inf' -f ~/PY/wrfout_d01_1995-01-01_00\:00\:00 -v QFX@instantaneous@None
## e.g.# nc_var.py -o CFmorzization -S 'X|west_east|XLONG,Y|south_north|XLAT,T|Time|WRFtime,Z|bottom_top|ZNU:GlobalAttr1995.inf:proj1995.inf' -f ~/PY/wrfout_d01_1995-01-01_00\:00\:00 -v 'RAINC@time:!accumulation@WRFtime_bnds|h|3'
## e.g. # nc_var.py -o dimrm -S removevar -f wrfout_d01_1995-01-01_00:00:00 -v west_east
## e.g. # nc_var.py -o ifile -f ../PY/wrfout_d01_1995-01-01_00:00:00
## e.g. # nc_var.py -o splitfile_dim -S bottom_top:ZNU:QVAPOR_ZNU:.4f -v QVAPOR,XLONG,XLAT,Times -f ~/PY/wrfout_d01_1995-01-01_00:00:00
## e.g. # nc_var.py -o itime -S WRFtime -f ../PY/wrfout_d01_1995-01-01_00:00:00 -v Times
## e.g. # nc_var.py -o get_point -S 'XLONG:XLAT:Time|0' -f /home/lluis/PY/wrfout_d01_1995-01-01_00:00:00 -v -45.,-30.
## e.g. # nc_var.py -o get_time -S '1422759600;seconds!since!1949-12-01!00:00:00' -f /home/lluis/PY/wrfout_d01_1995-01-01_00:00:00 -v WRFtime

## e.g. ccrc468-17 # ./nc_var.py -v time -f 123/CCRC_NARCliM_Sydney_All_1990-1999_pr10max.nc -o out -S 1:-1
## e.g. ccrc468-17 # ./nc_var.py -v prac -f xyz/CCRC_NARCliM_Sydney_DAM_1990-1999_prac.nc -o mname -S pluja
## e.g. ccrc468-17 # ./nc_var.py -v lluis -f CCRC_NARCliM_Sydney_MOM_1990-1999_prac.nc -o addref -S 'prac:standard_name@lluis_variable:long_name@test variable lluis:units@m s-1:0.'
## e.g. ccrc468-17 # ./nc_var.py -v lluis66 -f ~/UNSW-CCRC-WRF/tools/python/CCRC_NARCliM_Sydney_MOM_1990-1999_prac.nc -o addattr -S 'comment|Lluis Fita-123456'
## e.g. ccrc468-17 # ./nc_var.py -v lluis66 -f ~/UNSW-CCRC-WRF/tools/python/CCRC_NARCliM_Sydney_MOM_1990-1999_prac.nc -o rmvattr -S 'comment'
## e.g. acuna # ./nc_var.py -f /d4/lflmd/etudes/WRF_LMDZ/WaquaL/WRF/control/wrfout/wrfout_d01_1979-12-01_00:00:00 -o checkallvars -S 'DateStrLen,Time,soil_layers_stag,bottom_top_stag,bottom_top,west_east_stag,west_east,south_north,south_north_stag:-3,1,2,2,2,-2,-2,-2,-2'
## e.g. foudre # nc_var.py -f ~/etudes/WRF_LMDZ/tests/wrf_input/AR40.0/wrfout_d01_1979-01-01_00\:00\:00 -o checkallvars -S 'bottom_top_plus1,num_orchidee_soil_levels,lmdz_ksoil_types,DIM0009,DateStrLen,Time,soil_layers_stag,bottom_top_stag,bottom_top,west_east_stag,west_east,south_north,south_north_stag:2,0,0,1,-3,1,2,2,2,-2,-2,-2,-2'
## e.g. # nc_var.py -o field_stats -f ~/etudes/domains/Polynesie/geo_em.d03.nc -S full -v HGT_M
## e.g. # nc_var.py -o filter_2dim -S '80,y,x,lon,lat' -f 'tahiti_5m_ll.grd' -v 'z'
## e.g. # nc_var.py -o selvar -f /home/lluis/PY/met_em.d01.1979-01-01_00:00:00.nc -S 'west_east@XLONG_M,south_north@XLAT_M,num_metgrid_levels@int,Time@Times' -v TT,UU,VV,SKINTEMP
## e.g. # nc_var.py -o 'Partialmap_Entiremap' -f carteveg5km.nc -S 'longitude,latitude,std,5000.,Goode,Goode_5km.nc' -v vegetation_map
## e.g. # nc_var.py -o subbasin -f routing.nc -S Caceres,-57.75,-16.25,left
## e.g. # nc_var.py -o computevar_model -f ~/PY/wrfout_d01_2001-11-11_00:00:00 -S hurs
## e.g. # nc_var.py -o model_characteristics -f ~/PY/wrfout_d01_2001-11-11_00:00:00 -S WRF
## e.g. # nc_var.py -o WRF_toCF -f ~/PY/wrfout_d01_2001-11-11_00:00:00 -S XLONG:XLAT:19491201000000:minutes
## e.g. # nc_var.py -o cleaning_varsfile -f ~/PY/wrfout_d01_2001-11-11_00:00:00 -S T2,XLONG,XLAT,Times
## e.g. # nc_var.py -o LMDZ_toCF -f LMDZ/AR40/vas_histins_1-1.nc -S 'minutes!since!1949-12-01!00:00:00'
## e.g. # nc_var.py -o CDO_toCF -f LMDZ/AR40/hfss_reproj-histins.nc 
## e.g. # nc_var.py -o pinterp -f wrfout_d01_2001-11-11_00\:00\:00 -S 100000.:97500.:95000.:92500.:90000.:85000.:80000.:75000.:70000.:65000.:60000.:55000.:50000.:45000.:40000.:35000.:30000.:25000.:20000.:15000.:10000.:5000.:2500.:1000.:500.:250.,1,0 -v WRFt,WRFrh
## e.g. # nc_var.py -o pinterp -f /media/ExtDiskC_ext4/DATA/etudes/WRF_LMDZ/WaquaL_highres/short_copies/LMDZ/AR40/histins_19790101000000-19790304000000_short.nc -S 100000.:97500.:95000.:92500.:90000.:85000.:80000.:75000.:70000.:65000.:60000.:55000.:50000.:45000.:40000.:35000.:30000.:25000.:20000.:15000.:10000.:5000.:2500.:1000.:500.:250.,1,0 -v temp,ovap
## e.g. # nc_var.py -o reproject -f analysis/LMDZ/AR40/hurs_histins.nc -S 'lon,lat,analysis/WRF/current/hurs_wrfout.nc,lon,lat,npp,time@time' -v hurs
## e.g. # nc_var.py -o field_stats_dim -f /home/lluis/PY/wrfout_d01_2001-11-11_00:00:00 -S 'full,None,None,west_east,XLONG,False' -v 'T2'
## e.g. # nc_var.py -o compute_opersvarsfiles -S 'west_east|XLONG|-1;south_north|XLAT|-1;Time|Times|3@add|wrfout_d01_2001-11-11_00:00:00|T2%west_east|XLONG|-1;south_north|XLAT|-1;Time|Times|3@subc,273.15|wrfout_d01_2001-11-11_00:00:00|None' -v 'tempC,air!temperature,C'
## e.g. # nc_var.py -o compute_opersvarsfiles -S 'lon|lon|-1;lat|lat|-1;time_counter|time_counter|-1@forwrdderiv,1,1,2|/ccc/store/cont003/gen7593/fitaborl/etudes/DynamicoESM/aquaplanet/AR40/19800101000000-19810101000000/histday.nc|t2m' -v 'tasderiv,x-derivative|of|air|temperature,K
## e.g. # nc_var.py -o getvars_tofile -S soils_param_Zobler_textXIOS.nc -f soils_param_colorXIOS.nc -v 'soiltext,soiltexttypes'
## e.g. # nc_var.py -o addVar -S 'lon,lat|mask@mask@1|f' -f new_ORCHIDEE_13PFTmap_2010_cmpi6_LUH2v2h.nc -v mask
## e.g. # nc_var.py -o setvar_nc -S 'new_ORCHIDEE_13PFTmap_2010_cmpi6_LUH2v2h.nc,maxvegetfrac,veget;0' -f new_ORCHIDEE_13PFTmap_2010_cmpi6_LUH2v2h.nc -v mask
## e.g. $ nc_var.py -o VarVal_FillValue -S '0.,eq,std' -f new_lai2D.nc -v LAI
## e.g. # nc_var.py -o rm_FillValue -f new_ORCHIDEE_13PFTmap_2010_cmpi6_LUH2v2h.nc -S 0 -v mask
## e.g. # nc_var.py -o curve_section -f /home/lluis/PY/test.nc -S 'gridline,x,y,8.,8.,16.,16.,32' -v all
## e.g. # nc_var.py -o merge_files -S 'plev|plev,time|time:merged.nc' -f 'ncobs/AliceSprings/snd_94326_198201-198201.nc,ncobs/AliceSprings/snd_94326_198202-198202.nc' -v 'plev,time'

from optparse import OptionParser
import numpy as np
from netCDF4 import Dataset as NetCDFFile
import os
import re
import nc_var_tools as ncvar
# Using 'generic_tools.py'
import generic_tools as gen

# addDim: Operation to add a new dimension in a file
# addVar: Operation to add a new variable in a file using exisintg dimensions
# addvals: Function to add values to a given variable at a given dimension
# CDO_toCF: Function to pass a CDO output file to CF-conventions
# CFmorzization: Function to provide a CF-compilation version of a variable within a file
# chdimname: Changing the name of the dimension
# changevartype: Function to change the type of a variable (when possible)
# checkallvars: Function to check all variables of a file
# checkAllValues: Function to check for variables with along all their dimensions with the same value in a file
# checkNaNs: Function to check for NaN values over all variables in a file
# chgtimestep: Function to change the values of a given time-step of a variable inside a netCDF for values from a nother file
# chvarname: Changing the name of the variable
# cleaning_varsfile: Function to keep a list of varibales from a file
# compute_deaccum: Function to compute deaccum: deaccumulation of a variable (VAR[t+1]-VAR[t])
# compute_opersvarsfiles: Function to compute opersvarfiles: operation of variables from different files
# compute_opervaralltime: Function to compute opervaralltime: operation of variable successible allover the time-steps
# compute_opervartimes: Function to compute opervartimes: operation of variable for a given sub-set of time-steps
# compute_tevolboxtraj: Function to compute tevolboxtraj: temporal evolution at a given point along a box following a trajectory
# computevar_model: Function to provide the way to compute a CF-variable providing its name
# curve_section: Function to provide a section of a file following a given curve
# DatesFiles: Function to find different time values on a series of WRF files in a folder
# DataSetSection: Function to get a section (values along a dimension) of a given data-set
# DataSetSection_multidims: Function to get a section (values along multiple dimensions) of a given data-set
# DataSetSection_multivars: Function to get a section (values along multiple variables) of a given data-set
# DYNAMICO_toCF: Function to pass a DYNAMICO original file to CF-conventions
# dimrm: Removing a dimension from a file
# dimToUnlimited: Operation to create an unlimited dimension from an existing one
# dimVar_creation: Function to add a 1D variable with the size of a given dimension in a file
# fattradd: Adding attributes from a reference file
# fdimadd: Adding dimension from another reference file 
# fgaddattr: Adding global attributes from a reference file
# field_stats: Function to retrieve statistics from a field
# field_stats_dim: Function to retrieve statistics from a field along dimensions
# file_creation: Operation to create a file with one variable with a given set of dimensions
# file_oper_alongdims: Function to operate a file along different dimensions of a variable
# filter_2dim: Function to filter along 2 dimensions (moving grid-box means of a given size) values of the netCDF file
# flipdim: flips the value following one dimension
# fvaradd: Adding variable (and all its attributes and dimensions) from a reference file to a file
# gaddattrk: Add a global attribute to a netCDF caring about the type. Removes previous attribute if it exist
# gaddattr: Add a global attribute to a netCDF. Removes previous attribute if it exist
# get_attribute: Function to get an attribute from a netCDF file
# get_point: Function to provide the closest grid point to a given lat,lon
# get_time: Function to provide the closest time-step to a given time
# get_namelist_vars: Function to get namelist-like  values ([varname] = [value]) 
# get_Variables: Function to get a list of variables from an existing file
# getvalues_lonlat: Function to retrieve the values from the closest grid point to a set of longitude, latitude values
# getvars_tofile: Function to get variables from a file and pass them to another one
# grattr: Function to read a global atribute
# grmattr: Removing a global attribute
# idims: Give all the dimensions names of a file
# ifile: Function to provide some information from a given file
# igattrs: Give all the global attributes of a file
# increaseDimvar: Function to increase with 1 dimension an existing variable within a netcdf file. Values of 
#   the variable will be repeated along the new dimension
# isgattrs: Give a single global attribute of a file and its type
# isvattrs: Give a single attribute of a variable
# itime: Function to provide information of the time from a netCDF file
# ivars: Give all the variable names of a file
# ivattrs: Give all the attributes of a variable and its type
# LMDZ_toCF: Function to pass a LMDZ original file to CF-conventions
# lonlat_polygon: Function to define a lon/lat region giving the coordinates of the vertexs of a given polygon 
# maskvar: Function to mask a variable using another variable to mask it. Only need to share at least 1 dimension with the same size (no need same name)
# merge_files: Function to merge variables from two files
# model_characteristics: Function to provide major characterisitcs of a given model output
# mthDYNAMICO_toCF: Function to pass a mthDYNAMICO original file to CF-conventions
# ncreplace: Function to replace something from a netCDF file
# ncstepdiff: Function to compute differencies between time-steps (deacumulate) a netCDF file
# netcdf_concatenation: Function to concatenate netCDF files for a given set of variables
# netcdf_fold_concatenation: Function to concatenate netCDF files in a given folder for a given set of variables
# netcdf_fold_concatenation_HMT: Function to concatenate netCDF files in a given folder for a given set of variables 
#   giving Header, Middle, Tail for the name files
# reconstruct_matrix_from_vector: Function to reconstruct a 2D matrix from a pair of syncronized vectors with the positions on x and y coordinates
# reproject: Function to reproject values to another one
# rm_FillValue: Operation to remove the _FillValue from a variable inside a netCDF file
# Partialmap_Entiremap: Function to transform from a partial global map (e.g.: only land points) to an entire one 
#   Coincidence of points is done throughout a first guess from fractions of the total domain of search
# Partialmap_EntiremapFor: Function to transform from a partial global map (e.g.: only land points) to an entire one 
#   using Fortran code Coincidence of points is done throughout a first guess from fractions of the total domain of search
# Partialmap_EntiremapForExact: Function to transform from a partial global map (e.g.: only land points) to an entire 
#   one using Fortran code with exact location Coincidence of points is done throughout a first guess from fractions of 
#   the total domain of search
# pinterp: Function to vertically interpolate using subroutines from the p_interp.F90 NCAR program
# remapnn: Function to remap to the nearest neightbor a variable using projection from another file
# seasmean: Function to compute the seasonal mean of a variable
# sellonlatbox: Function to select a lotlan box from a data-set
# sellonlatlevbox: Function to select a lotlan box and a given level from a data-set
# selvar: Function to select a series of variables from a netcdf file. Variables with 
# setvar_asciivalues: Function to set de values of a variable with an ASCII file (common Fortran-like format)
# setvar_nc: Operation to set values of a variable from values of an other one
# sorttimesmat: Function to sort the time values of a given file
# spacemean: Function to retrieve a space mean series from a multidimensional variable of a file
# SpatialWeightedMean: Function to compute the spatial mean using weights from a netCDF file
# splitfile_dim: Function to split a file along a given dimension with a new file for each different value along the dimension (assuming resultant vardim of rank-1)
# statcompare_files: Python script to statistically compare two different files
# subbasin: Function to retrieve the subbasin (all the sub-flows untila a given lon,lat)
# submns: Function to retrieve a series of months from a file
# subyrs: Function to retrieve a series of years from a file
# TimeInf: Function to print all the information from the variable time
# time_reset: Function to re-set the time axis of a file
# TimeSplitmat: Function to transform a file with CFtimes to a matrix [Nyear,Nmonth,Nday,Nhour,Nminute,Nsecond] 
# timemean: Function to retrieve a time mean series from a multidimensional variable of a file
# valmod: Function to modify the value of a variable
# valmod_dim: Function to modify the value of a variable at a given dimension and value
# varaddattrk: Add an attribute to a variable caring about the type
# varaddattr: Add an attribute to a variable. Removes previous attribute if it exists
# varaddref: Function to add a variable in an existing file copying characteristics from an existing one
# var_creation: Operation to create a new variable in a file with a given set of dimensions
# varout: Function when we want to output variable values
# varrmattr: Removing an attribute from a variable
# varrm: Removing a variable from a file
# VarVal_FillValue: Function to transform a given value from a given variable to _FillValue in a netCDF file
# vrattr: Function to remove an atribute from a variable
# WRF_d0Nref: Function for the generation of an extra WRF domain from a given one 
# WRF_CFlonlat_creation: Function to add a CF-convention longitude/latitude variables in a WRF file
# WRF_CFtime_creation: Function to add a CF-convention time unit in a WRF file
# WRF_CFxtime_creation: Function to add a CF-convention time unit in a WRF file using variable 'XTIME'
# WRF_toCF: Function to pass a WRF original file to CF-conventions
# WRF_to_newCF: Function to pass a WRF original file to new CF-conventions file

operations=['addDim', 'addVar', 'addvals', 'CDO_toCF', 'CFmorzization',              \
  'chdimname', 'changevartype',                                                      \
  'checkallvars', 'checkAllValues', 'checkNaNs',                                     \
  'chgtimestep', 'chvarname', 'cleaning_varsfile', 'compute_deaccum',                \
  'compute_opersvarsfiles',                                                          \
  'compute_opervaralltime', 'compute_opervartimes', 'compute_tevolboxtraj',          \
  'computevar_model', 'curve_section', 'DatesFiles',                                 \
  'DataSetSection', 'DataSetSection_multidims', 'DataSetSection_multivars',          \
  'DYNAMICO_toCF', 'dimrm', 'dimToUnlimited', 'dimVar_creation',                     \
  'fattradd',                                                                        \
  'fdimadd', 'fgaddattr', 'field_stats', 'field_stats_dim', 'file_creation',         \
  'file_oper_alongdims', 'filter_2dim',                                              \
  'flipdim', 'fvaradd', 'gaddattrk', 'gaddattr', 'get_attribute',                    \
  'get_point', 'get_time', 'get_namelist_vars', 'get_Variables',                     \
  'getvalues_lonlat', 'getvars_tofile', 'grattr',                                    \
  'grmattr', 'idims', 'ifile', 'igattrs', 'increaseDimvar', 'isgattrs',              \
  'isvattrs', 'itime', 'ivars', 'ivattrs', 'LMDZ_toCF', 'lonlat_polygon', 'maskvar', \
  'merge_files', 'model_characteristics',                                            \
  'mthDYNAMICO_toCF', 'ncreplace', 'ncstepdiff', 'netcdf_concatenation',             \
  'netcdf_fold_concatenation',                                                       \
  'netcdf_fold_concatenation_HMT', 'reproject', 'Partialmap_Entiremap',              \
  'Partialmap_EntiremapFor', 'Partialmap_EntiremapForExact',                         \
  'pinterp', 'reconstruct_matrix_from_vector', 'remapnn', 'rm_FillValue',            \
  'seasmean', 'sellonlatbox', 'sellonlatlevbox', 'selvar', 'setvar_asciivalues',     \
  'setvar_nc', 'sorttimesmat', 'spacemean', 'SpatialWeightedMean',                   \
  'splitfile_dim', 'statcompare_files',                                              \
  'subbasin', 'submns', 'subyrs', 'TimeInf', 'time_reset',                           \
  'TimeSplitmat', 'timemean', 'valmod', 'valmod_dim','varaddattrk', 'varaddattr',    \
  'varaddref',                                                                       \
  'var_creation', 'varout', 'varoutold', 'varrmattr', 'varrm', 'VarVal_FillValue',   \
  'vrattr', 'WRF_d0Nref',                                                            \
  'WRF_CFlonlat_creation', 'WRF_CFtime_creation', 'WRF_CFxtime_creation',            \
  'list_operations', 'WRF_toCF', 'WRF_to_newCF']

### Options
##string_operation="operation to make: " + '\n' + " out, output values -S inidim1,[inidim2,...]:enddim1,[enddim2,...]"
string_operation="""operation to make: 
  addgattr, add a new global attribute: addatr -S [attrname]|[attrvalue]
  addvattr, add a new attribute to any given variable: addatr -S [attrname]|[attrvalue]
  addref, add a new variable with dimension and attributes from an already existing 'variable ref' in the file and -S [variable ref]:[attr name]@[value]:[[attr2]@[value2], ...]:[value/file with values]  mname, modify name -S newname
  checkallvalrs: Function to check all variables of a file: -S [dimn1],[[dimn2],...,[dimnN]]:[dim1],[[dim2],...,[dimN]]
  mname, modify name -S newname
  out, output values -S inidim1,[inidim2,...]:enddim1,[enddim2,...]
  valmod, modifiy values of variable -S [modification]:
     sumc,[constant]: add [constant] to variables values
     subc,[constant]: substract [constant] to variables values
     mulc,[constant]: multipy by [constant] to variables values
     divc,[constant]: divide by [constant] to variables values
  rmgattr, remove a global attribute: rmgattr -S [attrname]
  rmvattr, remove an attribute to any given variable: rmvattr -S [attrname]
"""

#print string_operation

operationnames = "'" + gen.numVector_String(operations, "', '") + "'"

parser = OptionParser()
parser.add_option("-f", "--netCDF_file", dest="ncfile", help="file to use", 
  metavar="FILE")
parser.add_option("-o", "--operation", type='choice', dest="operation", 
  choices=operations, help="operation to make: " + operationnames, metavar="OPER")
parser.add_option("-S", "--valueS", dest="values", 
  help="values to use according to the operation (when applicable); '-h' specific help of the operation", metavar="VALUES")
parser.add_option("-v", "--variable", dest="varname",
  help="variable to use (when applicable)", metavar="VAR")

(opts, args) = parser.parse_args()

#if opts.help:
#  parser.print_help()
#  print string_operation
#  sys.exit()

#######    #######
## MAIN
    #######

# Operations which file name is not a real file
NotCheckingFile = ['DatesFiles', 'compute_opersvarsfiles', 'file_creation',          \
  'list_operations', 'merge_files',                                                  \
  'model_characteristics', 'netcdf_concatenation', 'netcdf_fold_concatenation',      \
  'netcdf_fold_concatenation_HMT']

####### ###### ##### #### ### ## #
errormsg='ERROR -- error -- ERROR -- error'

varn=opts.varname
oper=opts.operation

if opts.operation is None:
    print errormsg
    print '  No operation provided !!'
    print "  an operation must be provided as '-o [operationname]' "
    quit(-1)

if opts.ncfile is not None and not os.path.isfile(opts.ncfile) and                   \
  not gen.searchInlist(NotCheckingFile,oper):
    print errormsg
    print '  File ' + opts.ncfile + ' does not exist !!'
    quit(-1)
elif opts.ncfile is None and not gen.searchInlist(NotCheckingFile,oper) and          \
  opts.values != 'h':
    print errormsg
    print '  No file provided !!'
    print "  a file must be provided as '-f [filename]' "
    quit(-1)

if oper == 'addDim':
    ncvar.addDim(opts.values, opts.ncfile, opts.varname)
elif oper == 'addVar':
    ncvar.addVar(opts.values, opts.ncfile, opts.varname)
elif oper == 'addvals':
    ncvar.addvals(opts.values, opts.ncfile, opts.varname)
elif oper == 'CDO_toCF':
    ncvar.CDO_toCF(opts.ncfile)
elif oper == 'CFmorzization':
    ncvar.CFmorzization(opts.values, opts.ncfile, opts.varname)
elif oper == 'chdimname':
    ncvar.chdimname(opts.values, opts.ncfile)
elif oper == 'changevartype':
    ncvar.changevartype(opts.values, opts.ncfile, opts.varname)
elif oper == 'checkallvars':
    ncvar.checkallvars(opts.values, opts.ncfile)
elif oper == 'checkAllValues':
    ncvar.checkAllValues(opts.values, opts.ncfile)
elif oper == 'checkNaNs':
    ncvar.checkNaNs(opts.values, opts.ncfile)
elif oper == 'chgtimestep':
    ncvar.chgtimestep(opts.values, opts.ncfile, opts.varname)
elif oper == 'chvarname':
    ncvar.chvarname(opts.values, opts.ncfile, opts.varname)
elif oper == 'cleaning_varsfile':
    ncvar.cleaning_varsfile(opts.values, opts.ncfile)
elif oper == 'compute_deaccum':
    ncvar.compute_deaccum(opts.values, opts.ncfile, opts.varname)
elif oper == 'compute_opersvarsfiles':
    ncvar.compute_opersvarsfiles(opts.values, opts.varname)
elif oper == 'compute_opervaralltime':
    ncvar.compute_opervaralltime(opts.values, opts.ncfile, opts.varname)
elif oper == 'compute_opervartimes':
    ncvar.compute_opervartimes(opts.values, opts.ncfile, opts.varname)
elif oper == 'compute_tevolboxtraj':
    ncvar.compute_tevolboxtraj(opts.values, opts.ncfile, opts.varname)
elif oper == 'computevar_model':
    ncvar.computevar_model(opts.values, opts.ncfile)
elif oper == 'curve_section':
    ncvar.curve_section(opts.values, opts.ncfile, opts.varname)
elif oper == 'DataSetSection':
    ncvar.DataSetSection(opts.values, opts.ncfile)
elif oper == 'DataSetSection_multidims':
    ncvar.DataSetSection_multidims(opts.values, opts.ncfile, opts.varname)
elif oper == 'DataSetSection_multivars':
    ncvar.DataSetSection_multivars(opts.values, opts.ncfile, opts.varname)
elif oper == 'DatesFiles':
    ncvar.DatesFiles(opts.values, opts.ncfile, opts.varname)
elif oper == 'DYNAMICO_toCF':
    ncvar.DYNAMICO_toCF(opts.values, opts.ncfile)
elif oper == 'dimrm':
    ncvar.dimrm(opts.ncfile, opts.values, opts.varname)
elif oper == 'dimToUnlimited':
    ncvar.dimToUnlimited(opts.values, opts.ncfile)
elif oper == 'dimVar_creation':
    ncvar.dimVar_creation(opts.values, opts.ncfile)
elif oper == 'fattradd':
    ncvar.fattradd(var, opts.values, opts.ncfile)
elif oper == 'fdimadd':
    ncvar.fdimadd(opts.values, opts.ncfile)
elif oper == 'fgaddattr':
    ncvar.fgaddattr(opts.values, opts.ncfile)
elif oper == 'file_creation':
    ncvar.file_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'file_oper_alongdims':
    ncvar.file_oper_alongdims(opts.values, opts.ncfile, opts.varname)
elif oper == 'field_stats':
    ncvar.field_stats(opts.values, opts.ncfile, opts.varname)
elif oper == 'field_stats_dim':
    ncvar.field_stats_dim(opts.values, opts.ncfile, opts.varname)
elif oper == 'filter_2dim':
    ncvar.filter_2dim(opts.values, opts.ncfile, opts.varname)
elif oper == 'flipdim':
    ncvar.flipdim(opts.values, opts.ncfile, opts.varname)
elif oper == 'fvaradd':
    ncvar.fvaradd(opts.values, opts.ncfile)
elif oper == 'gaddattrk':
    ncvar.gaddattrk(opts.values, opts.ncfile)
elif oper == 'gaddattr':
    ncvar.gaddattr(opts.values, opts.ncfile)
elif oper == 'get_attribute':
    ncvar.get_attribute(opts.values, opts.ncfile, opts.varname)
elif oper == 'get_namelist_vars':
    ncvar.get_namelist_vars(opts.values, opts.ncfile)
elif oper == 'get_point':
    ncvar.get_point(opts.values, opts.ncfile, opts.varname)
elif oper == 'get_time':
    ncvar.get_time(opts.values, opts.ncfile, opts.varname)
elif oper == 'get_Variables':
    ncvar.get_Variables(opts.values, opts.ncfile, opts.varname)
elif oper == 'getvalues_lonlat':
    ncvar.getvalues_lonlat(opts.values, opts.ncfile)
elif oper == 'getvars_tofile':
    ncvar.getvars_tofile(opts.values, opts.ncfile, opts.varname)
elif oper == 'grattr':
    ncvar.grattr(opts.values, opts.ncfile)
elif oper == 'grmattr':
    ncvar.grmattr(opts.values, opts.ncfile)
elif oper == 'idims':
    ncvar.idims(opts.ncfile)
elif oper == 'ifile':
    ncvar.ifile(opts.ncfile)
elif oper == 'igattrs':
    ncvar.igattrs(opts.ncfile)
elif oper == 'increaseDimvar':
    ncvar.increaseDimvar(opts.values, opts.ncfile, opts.varname)
elif oper == 'isgattrs':
    ncvar.isgattrs(opts.values, opts.ncfile)
elif oper == 'isvattrs':
    ncvar.isvattrs(opts.values, opts.ncfile, opts.varname)
elif oper == 'itime':
    ncvar.itime(opts.values, opts.ncfile, opts.varname)
elif oper == 'ivars':
    ncvar.ivars(opts.ncfile)
elif oper == 'ivattrs':
    ncvar.ivattrs(opts.ncfile, opts.varname)
elif oper == 'list_operations':
# From: http://www.diveintopython.net/power_of_introspection/all_together.html
    object = ncvar
    for opern in operations:
        if  opern != 'list_operations': 
            print opern + '_______ ______ _____ ____ ___ __ _'
            print getattr(object, opern).__doc__
elif oper == 'LMDZ_toCF':
    ncvar.LMDZ_toCF(opts.values, opts.ncfile)
elif oper == 'lonlat_polygon':
    ncvar.lonlat_polygon(opts.values, opts.ncfile, opts.varname)
elif oper == 'maskvar':
    ncvar.maskvar(opts.values, opts.ncfile, opts.varname)
elif oper == 'merge_files':
    ncvar.merge_files(opts.values, opts.ncfile, opts.varname)
elif oper == 'model_characteristics':
    ncvar.model_characteristics(opts.values, opts.ncfile)
elif oper == 'mthDYNAMICO_toCF':
    ncvar.mthDYNAMICO_toCF(opts.values, opts.ncfile)
elif oper == 'ncreplace':
    ncvar.ncreplace(opts.values, opts.ncfile, opts.varname)
elif oper == 'ncstepdiff':
    ncvar.ncstepdiff(opts.values, opts.ncfile, opts.varname)
elif oper == 'netcdf_concatenation':
    ncvar.netcdf_concatenation(opts.ncfile)
elif oper == 'netcdf_fold_concatenation':
    ncvar.netcdf_fold_concatenation(opts.values, opts.ncfile, opts.varname)
elif oper == 'netcdf_fold_concatenation_HMT':
    ncvar.netcdf_fold_concatenation_HMT(opts.values, opts.ncfile, opts.varname)
elif oper == 'opersvarsfiles':
    ncvar.compute_opersvarsfiles(opts.values, opts.varname)
elif oper == 'pinterp':
    ncvar.pinterp(opts.values, opts.ncfile, opts.varname)
elif oper == 'remapnn':
    ncvar.remapnn(opts.values, opts.ncfile, opts.varname)
elif oper == 'Partialmap_Entiremap':
    ncvar.Partialmap_Entiremap(opts.values, opts.ncfile, opts.varname)
elif oper == 'Partialmap_EntiremapFor':
    ncvar.Partialmap_EntiremapFor(opts.values, opts.ncfile, opts.varname)
elif oper == 'Partialmap_EntiremapForExact':
    ncvar.Partialmap_EntiremapForExact(opts.values, opts.ncfile, opts.varname)
elif oper == 'reconstruct_matrix_from_vector':
    ncvar.reconstruct_matrix_from_vector(opts.values, opts.ncfile, opts.varname)
elif oper == 'reproject':
    ncvar.reproject(opts.values, opts.ncfile, opts.varname)
elif oper == 'rm_FillValue':
    ncvar.rm_FillValue(opts.values, opts.ncfile, opts.varname)
elif oper == 'seasmean':
    ncvar.seasmean(timename, opts.ncfile, opts.varname)
elif oper == 'sellonlatbox':
    ncvar.sellonlatbox(opts.values, opts.ncfile, opts.varname)
elif oper == 'sellonlatlevbox':
    ncvar.sellonlatlevbox(opts.values, opts.ncfile, opts.varname)
elif oper == 'selvar':
    ncvar.selvar(opts.values, opts.ncfile, opts.varname)
elif oper == 'setvar_asciivalues':
    ncvar.setvar_asciivalues(opts.values, opts.ncfile, opts.varname)
elif oper == 'setvar_nc':
    ncvar.setvar_nc(opts.values, opts.ncfile, opts.varname)
elif oper == 'sorttimesmat':
    ncvar.sorttimesmat(opts.ncfile, opts.varname)
elif oper == 'spacemean':
    ncvar.spacemean(opts.ncfile, opts.varname)
elif oper == 'SpatialWeightedMean':
    ncvar.SpatialWeightedMean(opts.values, opts.ncfile, opts.varname)
elif oper == 'splitfile_dim':
    ncvar.splitfile_dim(opts.values, opts.ncfile, opts.varname)
elif oper == 'statcompare_files':
    ncvar.statcompare_files(opts.values)
elif oper == 'subbasin':
    ncvar.subbasin(opts.values, opts.ncfile)
elif oper == 'submns':
    ncvar.submns(opts.values, opts.ncfile, opts.varname)
elif oper == 'subyrs':
    ncvar.subyrs(opts.values, opts.ncfile, opts.varname)
elif oper == 'TimeInf':
    ncvar.TimeInf(opts.ncfile, opts.varname)
elif oper == 'time_reset':
    ncvar.time_reset(opts.values, opts.ncfile, opts.varname)
elif oper == 'TimeSplitmat':
    ncvar.TimeSplitmat(opts.values, opts.ncfile, opts.varname)
elif oper == 'timemean':
    ncvar.timemean(opts.values, opts.ncfile, opts.varname)
elif oper == 'valmod':
    ncvar.valmod(opts.values, opts.ncfile, opts.varname)
elif oper == 'valmod_dim':
    ncvar.valmod_dim(opts.values, opts.ncfile, opts.varname)
elif oper == 'varaddattrk':
    ncvar.varaddattrk(opts.values, opts.ncfile, opts.varname)
elif oper == 'varaddattr':
    ncvar.varaddattr(opts.values, opts.ncfile, opts.varname)
elif oper == 'varaddref':
    ncvar.varaddref(opts.values, opts.ncfile, opts.varname)
elif oper == 'var_creation':
    ncvar.var_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'varout':
    ncvar.varout(opts.values, opts.ncfile, opts.varname)
elif oper == 'varoutold':
    ncvar.varoutold(opts.values, opts.ncfile, opts.varname)
elif oper == 'varrmattr':
    ncvar.varrmattr(opts.values, opts.ncfile, opts.varname)
elif oper == 'varrm':
    ncvar.varrm(opts.ncfile, opts.varname)
elif oper == 'VarVal_FillValue':
    ncvar.VarVal_FillValue(opts.values, opts.ncfile, opts.varname)
elif oper == 'vrattr':
    ncvar.vrattr(opts.values, opts.ncfile, opts.varname)
elif oper == 'WRF_d0Nref':
    ncvar.WRF_d0Nref(opts.values, opts.ncfile)
elif oper == 'WRF_CFlonlat_creation':
    ncvar.WRF_CFlonlat_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'WRF_CFtime_creation':
    ncvar.WRF_CFtime_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'WRF_CFxtime_creation':
    ncvar.WRF_CFxtime_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'WRF_toCF':
    ncvar.WRF_toCF(opts.values, opts.ncfile)
elif oper == 'WRF_to_newCF':
    ncvar.WRF_to_newCF(opts.values, opts.ncfile, opts.varname)
else:
    print errormsg
    print '   The operation ' + oper + ' is not ready !!'
    print errormsg
    quit()
