MODULE physiq_limit_variables_mod
! L. Fita, November 2013. Making them accessible. Since wrfinput/wrfbdy/wrfrst/wrflow files are been used

  IMPLICIT NONE

    REAL, ALLOCATABLE, DIMENSION(:), SAVE                :: restart_runoff
!$OMP THREADPRIVATE(restart_runoff) 
    REAL, ALLOCATABLE, DIMENSION(:), SAVE                :: qsol_rst
!$OMP THREADPRIVATE(qsol_rst) 
    REAL, ALLOCATABLE, DIMENSION(:), SAVE                :: fder_rst
!$OMP THREADPRIVATE(fder_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: snow_rst
!$OMP THREADPRIVATE(snow_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: qsurf_rst
!$OMP THREADPRIVATE(qsurf_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: evap_rst
!$OMP THREADPRIVATE(evap_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: rugos_rst
!$OMP THREADPRIVATE(rugos_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: agesno_rst
!$OMP THREADPRIVATE(agesno_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE            :: ftsoil_rst
!$OMP THREADPRIVATE(ftsoil_rst) 

  CONTAINS

  SUBROUTINE vars_limit()
! Do not do nothing. 

    IMPLICIT NONE

    REAL, ALLOCATABLE, DIMENSION(:), SAVE                :: restart_runoff
!$OMP THREADPRIVATE(restart_runoff) 
    REAL, ALLOCATABLE, DIMENSION(:), SAVE                :: qsol_rst
!$OMP THREADPRIVATE(qsol_rst) 
    REAL, ALLOCATABLE, DIMENSION(:), SAVE                :: fder_rst
!$OMP THREADPRIVATE(fder_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: snow_rst
!$OMP THREADPRIVATE(snow_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: qsurf_rst
!$OMP THREADPRIVATE(qsurf_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: evap_rst
!$OMP THREADPRIVATE(evap_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: rugos_rst
!$OMP THREADPRIVATE(rugos_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:), SAVE              :: agesno_rst
!$OMP THREADPRIVATE(agesno_rst) 
    REAL, ALLOCATABLE, DIMENSION(:,:,:), SAVE            :: ftsoil_rst
!$OMP THREADPRIVATE(ftsoil_rst) 

  END SUBROUTINE

  SUBROUTINE vars_limit_init(klon)
! Subroutine to initialize limit variables

    USE mod_grid_phy_lmdz, ONLY: klon_glo
    USE indice_sol_mod

    IMPLICIT NONE

    INCLUDE "dimensions.h"
    INCLUDE "dimsoil.h"

    INTEGER, INTENT(IN)                                  :: klon

!!    IF (ALLOCATED(restart_runoff)) DEALLOCATE(restart_runoff)
    ALLOCATE(restart_runoff(klon))

!!    IF (ALLOCATED(qsol_rst)) DEALLOCATE(qsol_rst)
    ALLOCATE(qsol_rst(klon))
!!    IF (ALLOCATED(fder_rst)) DEALLOCATE(fder_rst)
    ALLOCATE(fder_rst(klon))
!!    IF (ALLOCATED(snow_rst)) DEALLOCATE(snow_rst)
    ALLOCATE(snow_rst(klon, nbsrf))
!!    IF (ALLOCATED(qsurf_rst)) DEALLOCATE(qsurf_rst)
    ALLOCATE(qsurf_rst(klon, nbsrf))
!!    IF (ALLOCATED(evap_rst)) DEALLOCATE(evap_rst)
    ALLOCATE(evap_rst(klon, nbsrf))
!!    IF (ALLOCATED(rugos_rst)) DEALLOCATE(rugos_rst)
    ALLOCATE(rugos_rst(klon, nbsrf))
!!    IF (ALLOCATED(agesno_rst)) DEALLOCATE(agesno_rst)
    ALLOCATE(agesno_rst(klon, nbsrf))
!!    IF (ALLOCATED(ftsoil_rst)) DEALLOCATE(ftsoil_rst)
    ALLOCATE(ftsoil_rst(klon, nsoilmx, nbsrf))

    RETURN

  END SUBROUTINE vars_limit_init

END MODULE physiq_limit_variables_mod
