MODULE module_definitions

!  INTEGER, PARAMETER                                     :: r_k = KIND(1.d0)
  INTEGER, PARAMETER                                     :: r_k = KIND(1.)
  REAL(r_k), PARAMETER                                   :: zeroRK = 0.
  REAL(r_k), PARAMETER                                   :: oneRK = 1.
  REAL(r_k), PARAMETER                                   :: twoRK = 2.
  !REAL(r_k), PARAMETER                                   :: DegRad = 180.d0/DACOS(-1.)
  REAL(r_k), PARAMETER                                   :: DegRad = 180./ACOS(-1.)
  CHARACTER(len=100)                                     :: infomsg = 'INFORMATION -- information' // &
    ' -- INFORMATION -- information'
  CHARACTER(len=50)                                      :: warnmsg = 'WARNING -- warning -- ' //     &
    'WARNING -- warning'
  CHARACTER(len=50)                                      :: emsg = 'ERROR -- error -- ERROR -- error'
  ! Fill value at 64 bits
  !REAL(r_k)                                              :: fillval64 = 1.d20
  REAL(r_k)                                              :: fillval64 = 1.e20
  INTEGER                                                :: fillvalI = -99999
  CHARACTER(len=50)                                      :: fname
  CHARACTER(len=256)                                     :: msg
  ! Some all-purpose variables
  CHARACTER(len=1)                                       :: Str1
  CHARACTER(len=4)                                       :: numSa, numSb
  CHARACTER(len=10)                                      :: Str10

! Scientific constants
  REAL(r_k), PARAMETER                                   :: grav = 9.81 ! gravity [ms-1]
  REAL(r_k), PARAMETER                                   :: Cpmol = 29.07 ! Molar gas heat capacity at constant pressure [Jmol-1K-1]
  REAL(r_k), PARAMETER                                   :: Cp_g = 1.0035 ! Gas heat capacity [Jg-1K-1]
  REAL(r_k), PARAMETER                                   :: Rstar = 8.3144621 ! Universal molar air constant [JKgm2s-2K-1mol-1/JK-1mol-1]
  REAL(r_k), PARAMETER                                   :: RCp = 0.286 ! R*Cp [-]
  REAL(r_k), PARAMETER                                   :: p0ref = 100000 ! pressure reference [Pa]
! WRF gravity
  REAL(r_k), PARAMETER                                   :: g = 9.81
! Ratio between molecular weights of water and dry air
  REAL(r_k), PARAMETER                                   :: mol_watdry = 0.622
! Standard atmospheric lapse-rate [Km-1]
  REAL, PARAMETER                                        :: gammav = 6.5e-3
! WRF Gas constant for dry air [JK-1kg-1]
  REAL(r_k), PARAMETER                                   :: r_d = 287.
! WRF Gas constant for wet air [JK-1kg-1]
  REAL(r_k), PARAMETER                                   :: r_v = 461.6
! WRF Dry air heat capacity [JK-1kg-1]
  REAL(r_k), PARAMETER                                   :: cp = 7.*r_d/2.
! WRF p 1000 mb constant [Pa]
  REAL(r_k), PARAMETER                                   :: p1000mb = 100000.
! WRF Latent Heat for water vapour [Jkg-1]
  REAL(r_k), PARAMETER                                   :: XLV = 2.5E6
! epislon r_d/r_v for Virtual temperature
  REAL(r_k), PARAMETER                                   :: epsilonv = 0.622

END MODULE module_definitions
