!
! $Id: abort_gcm.F 1425 2010-09-02 13:45:23Z lguez $
!
!c
!c
      SUBROUTINE abort_gcm(modname, message, ierr)
     
#ifdef CPP_IOIPSL
      USE IOIPSL
#else
! if not using IOIPSL, we still need to use (a local version of) getin_dump
      USE ioipsl_getincom
#endif
#include "iniprint.h"
 
!C
!C Stops the simulation cleanly, closing files and printing various
!C comments
!C
!C  Input: modname = name of calling program
!C         message = stuff to print
!C         ierr    = severity of situation ( = 0 normal )

      character(len=*) modname
      integer ierr
      character(len=*) message

      write(lunout,*) 'in abort_gcm'
#ifdef CPP_IOIPSL
      call histclo
      call restclo
#endif
      call getin_dump
!c     call histclo(2)
!c     call histclo(3)
!c     call histclo(4)
!c     call histclo(5)
      write(lunout,*) 'Stopping in ', modname
      write(lunout,*) 'Reason = ',message
      if (ierr .eq. 0) then
        write(lunout,*) 'Everything is cool'
        stop
      else
        write(lunout,*) 'Houston, we have a problem ', ierr
        stop 1
      endif
      END SUBROUTINE abort_gcm

! L. Fita, LMD. August 2014
      SUBROUTINE abort_gcm_point(modname, message, ierr, point, val, if1c, thres)
     
#ifdef CPP_IOIPSL
      USE IOIPSL
#else
! if not using IOIPSL, we still need to use (a local version of) getin_dump
      USE ioipsl_getincom
#endif
#include "iniprint.h"
#include "dimensions.h"
 
!C
!C Stops the simulation cleanly, closing files and printing various
!C comments
!C
!C  Input: modname = name of calling program
!C         message = stuff to print
!C         ierr    = severity of situation ( = 0 normal )
!C         point   = 1D point where the error ocurred
!C         val     = wrong value
!C         if1c    = condition as 1 character 
!C         thres   = threshold value

      character(len=*) modname
      integer ierr
      character(len=*) message
      INTEGER, INTENT(IN)                                :: point
      REAL, INTENT(IN)                                   :: val, thres
      CHARACTER(LEN=1), INTENT(IN)                       :: if1c

! Local
      INTEGER                                            :: xpt, ypt

      write(lunout,*) 'in abort_gcm'
#ifdef CPP_IOIPSL
      call histclo
      call restclo
#endif
      call getin_dump
!c     call histclo(2)
!c     call histclo(3)
!c     call histclo(4)
!c     call histclo(5)
      ypt = INT(pk/wiim) + 1
      xpt = pk - (ypt-1)*wiim

      write(lunout,*) 'Stopping in ', modname
      write(lunout,*) 'Stopping at point ', point,'( ',xpt,', ',ypt,' ) wrong: ',    &
        val, if1c, thres
      write(lunout,*) 'Reason = ',message
      if (ierr .eq. 0) then
        write(lunout,*) 'Everything is cool'
        stop
      else
        write(lunout,*) 'Houston, we have a problem ', ierr
        stop 1
      endif
      END SUBROUTINE abort_gcm_point

! L. Fita, LMD. August 2014
      SUBROUTINE abort_gcm_2Dpoint(modname, message, ierr, pk, pl, val, if1c, thres)
     
#ifdef CPP_IOIPSL
      USE IOIPSL
#else
! if not using IOIPSL, we still need to use (a local version of) getin_dump
      USE ioipsl_getincom
#endif
#include "iniprint.h"
#include "dimensions.h"
 
!C
!C Stops the simulation cleanly, closing files and printing various
!C comments
!C
!C  Input: modname = name of calling program
!C         message = stuff to print
!C         ierr    = severity of situation ( = 0 normal )
!C         pk, pl  = 2D point where the error ocurred (klev, klon)
!C         val     = wrong value
!C         if1c    = condition as 1 character 
!C         thres   = threshold value

      character(len=*) modname
      integer ierr
      character(len=*) message
      INTEGER, INTENT(IN)                                :: pk, pl
      REAL, INTENT(IN)                                   :: val, thres
      CHARACTER(LEN=1), INTENT(IN)                       :: if1c

! Local
      INTEGER                                            :: xpt, ypt

      write(lunout,*) 'in abort_gcm'
#ifdef CPP_IOIPSL
      call histclo
      call restclo
#endif
      call getin_dump
!c     call histclo(2)
!c     call histclo(3)
!c     call histclo(4)
!c     call histclo(5)
      ypt = INT(pk/wiim) + 1
      xpt = pk - (ypt-1)*wiim

      write(lunout,*) 'Stopping in ', modname
      write(lunout,*) 'Stopping at point (klon, klev):', pk, '( ',xpt,', ',ypt,' ) ',&
        pl,' wrong: ',val, if1c, thres
      write(lunout,*) 'Reason = ',message
      if (ierr .eq. 0) then
        write(lunout,*) 'Everything is cool'
        stop
      else
        write(lunout,*) 'Houston, we have a problem ', ierr
        stop 1
      endif
      END SUBROUTINE abort_gcm_2Dpoint
