# Configuration for 'get_stations.py'
# Too much options to be ingested and parsed ?!

#sfcstatfile='ubicacion_datos_sup.csv'
sfcstatfile='None'

# Surface stations columns for data
sfclatcol=0
sfcloncol=1
sfclabcol=3
sfchgtcol=2

sndstatfile='sounding_stattions.csv'

# Sounding stations columns for data
sndlatcol=1
sndloncol=2
sndlabcol=0
sndhgtcol=3

# comment char
comchar = '#'

# separation char
sepchar = ','

# missing value
missvalS = ['0', 'NaN']

# simulation file
simfilen = '/datos/lluis.fita/studies/NNRP/nnrp_1976.nc'

# dimension CFequivalences
CFdims = {'lon': 'lon', 'lat': 'lat', 'plev': 'level', 'time': 'time'}

# axes dimensions
axesdims = {'X': ['lon'], 'Y': ['lat'], 'Z': ['level', 'level_2'], 'T': ['time']}

# axes variables
axesvars = {'X': ['lon'], 'Y': ['lat'], 'Z': ['level', 'levels_2'], 'T': ['time']}

# dim Variables ('H' to determine station height from file, 'None' for no variable available)
dimvariables = {'lon': 'lon', 'lat': 'lat', 'level': 'level', 'time':'time',         \
        'level_2': 'level_2', 'H': 'None'}

# SFC Variables
sfcvariables = {'tas':'T2', 'uas':'WRFuas', 'vas':'WRFvas', 'huss':'Q2', 'ps':'PSFC',\
  'zhgt':'HGT'}
# Surface reference variable (it must be one variable from file which has 
#   the right right shape (e.g. un-staggered) and rang as 3D dimensions [T,Y,X])
sfcrefvar = 'T2'

# Vertical Variables
sndvariables= {'ta':'air', 'ua':'uwnd', 'va':'vwnd', 'hus':'shum',             \
  'zg':'hgt', 'plev':'level', 'tda': 'C_td', 'wd': 'C_wd', 'ws': 'C_ws'}
# Sounding reference variable (it must be one variable from file which has 
#   the right right shape (e.g. un-staggered) and rang as 4D dimensions [T,Z,Y,X])
sndrefvar = 'air'

# Variable pressure
UnitsPress = 'Pa'
Pressdimref = 'level'

# Does pressure variable change with time?
presstime = False

# Map range
#nlon = -80.
#xlon = -50.
#nlat = -60.
#xlat = -20.

# Map range RELAMPAGO
nlon = 70.
xlon = 180.
nlat = -67.
xlat = -5.

# CF Temporal values
ReferenceDate = '19491201000000'
UnitsTime = 'minutes'

