#!/usr/bin/python
## e.g. ccrc468-17 # ./nc_var.py -v time -f 123/CCRC_NARCliM_Sydney_All_1990-1999_pr10max.nc -o out -S 1:-1
## e.g. ccrc468-17 # ./nc_var.py -v prac -f xyz/CCRC_NARCliM_Sydney_DAM_1990-1999_prac.nc -o mname -S pluja
## e.g. ccrc468-17 # ./nc_var.py -v lluis -f CCRC_NARCliM_Sydney_MOM_1990-1999_prac.nc -o addref -S 'prac:standard_name@lluis_variable:long_name@test variable lluis:units@m s-1:0.'
## e.g. ccrc468-17 # ./nc_var.py -v lluis66 -f ~/UNSW-CCRC-WRF/tools/python/CCRC_NARCliM_Sydney_MOM_1990-1999_prac.nc -o addattr -S 'comment|Lluis Fita-123456'
## e.g. ccrc468-17 # ./nc_var.py -v lluis66 -f ~/UNSW-CCRC-WRF/tools/python/CCRC_NARCliM_Sydney_MOM_1990-1999_prac.nc -o rmvattr -S 'comment'
## e.g. acuna # ./nc_var.py -f /d4/lflmd/etudes/WRF_LMDZ/WaquaL/WRF/control/wrfout/wrfout_d01_1979-12-01_00:00:00 -o checkallvars -S 'DateStrLen,Time,soil_layers_stag,bottom_top_stag,bottom_top,west_east_stag,west_east,south_north,south_north_stag:-3,1,2,2,2,-2,-2,-2,-2'
## e.g. foudre # nc_var.py -f ~/etudes/WRF_LMDZ/tests/wrf_input/AR40.0/wrfout_d01_1979-01-01_00\:00\:00 -o checkallvars -S 'bottom_top_plus1,num_orchidee_soil_levels,lmdz_ksoil_types,DIM0009,DateStrLen,Time,soil_layers_stag,bottom_top_stag,bottom_top,west_east_stag,west_east,south_north,south_north_stag:2,0,0,1,-3,1,2,2,2,-2,-2,-2,-2'
## e.g. # nc_var.py -o field_stats -f ~/etudes/domains/Polynesie/geo_em.d03.nc -S full -v HGT_M
## e.g. # nc_var.py -o filter_2dim -S '80,y,x,lon,lat' -f 'tahiti_5m_ll.grd' -v 'z'
## e.g. # nc_var.py -o selvar -f /home/lluis/PY/met_em.d01.1979-01-01_00:00:00.nc -S 'west_east@XLONG_M,south_north@XLAT_M,num_metgrid_levels@int,Time@Times' -v TT,UU,VV,SKINTEMP
## e.g. # nc_var.py -o 'Partialmap_Entiremap' -f carteveg5km.nc -S 'longitude,latitude,std,5000.,Goode,Goode_5km.nc' -v vegetation_map
## e.g. # nc_var.py -o subbasin -f routing.nc -S Caceres,-57.75,-16.25,left
## e.g. # nc_var.py -o computevar_model -f ~/PY/wrfout_d01_2001-11-11_00:00:00 -S hurs
## e.g. # nc_var.py -o model_characteristics -f ~/PY/wrfout_d01_2001-11-11_00:00:00 -S WRF
## e.g. # nc_var.py -o WRF_toCF -f ~/PY/wrfout_d01_2001-11-11_00:00:00 -S XLONG:XLAT:19491201000000:minutes
## e.g. # nc_var.py -o cleaning_varsfile -f ~/PY/wrfout_d01_2001-11-11_00:00:00 -S T2,XLONG,XLAT,Times
## e.g. # nc_var.py -o LMDZ_toCF -f LMDZ/AR40/vas_histins_1-1.nc -S 'minutes!since!1949-12-01!00:00:00'
## e.g. # nc_var.py -o CDO_toCF -f LMDZ/AR40/hfss_reproj-histins.nc 
## e.g. # nc_var.py -o pinterp -f wrfout_d01_2001-11-11_00\:00\:00 -S 100000.:97500.:95000.:92500.:90000.:85000.:80000.:75000.:70000.:65000.:60000.:55000.:50000.:45000.:40000.:35000.:30000.:25000.:20000.:15000.:10000.:5000.:2500.:1000.:500.:250.,1,0 -v WRFt,WRFrh
## e.g. # nc_var.py -o pinterp -f /media/ExtDiskC_ext4/DATA/etudes/WRF_LMDZ/WaquaL_highres/short_copies/LMDZ/AR40/histins_19790101000000-19790304000000_short.nc -S 100000.:97500.:95000.:92500.:90000.:85000.:80000.:75000.:70000.:65000.:60000.:55000.:50000.:45000.:40000.:35000.:30000.:25000.:20000.:15000.:10000.:5000.:2500.:1000.:500.:250.,1,0 -v temp,ovap

from optparse import OptionParser
import numpy as np
from netCDF4 import Dataset as NetCDFFile
import os
import re
import nc_var_tools as ncvar
# Using 'generic_tools.py'
import generic_tools as gen

operations=['addvals', 'CDO_toCF', 'chdimname', 'changevartype', 'checkallvars',     \
  'checkAllValues', 'checkNaNs',                                                     \
  'chgtimestep', 'chvarname', 'cleaning_varsfile', 'compute_deaccum',                \
  'compute_opersvarsfiles',                                                          \
  'compute_opervaralltime', 'compute_opervartimes', 'compute_tevolboxtraj',          \
  'computevar_model', 'DatesFiles',                                                  \
  'DataSetSection', 'DataSetSection_multidims', 'DataSetSection_multivars',          \
  'dimToUnlimited', 'dimVar_creation',                                               \
  'fattradd',                                                                        \
  'fdimadd', 'fgaddattr', 'field_stats', 'file_creation', 'file_oper_alongdims',     \
  'filter_2dim',                                                                     \
  'flipdim', 'fvaradd', 'gaddattrk', 'gaddattr', 'get_attribute',                    \
  'get_namelist_vars', 'get_Variables',                                              \
  'getvalues_lonlat', 'grattr',                                                      \
  'grmattr', 'idims', 'igattrs', 'increaseDimvar', 'isgattrs',                       \
  'isvattrs', 'ivars', 'ivattrs', 'LMDZ_toCF', 'maskvar', 'model_characteristics',   \
  'ncreplace', 'ncstepdiff', 'netcdf_concatenation', 'netcdf_fold_concatenation',    \
  'netcdf_fold_concatenation_HMT', 'reproject', 'Partialmap_Entiremap',              \
  'Partialmap_EntiremapFor', 'Partialmap_EntiremapForExact',                         \
  'pinterp', 'remapnn',                                                              \
  'seasmean', 'sellonlatbox', 'sellonlatlevbox', 'selvar', 'setvar_asciivalues',     \
  'sorttimesmat', 'spacemean', 'SpatialWeightedMean', 'statcompare_files',           \
  'subbasin', 'submns', 'subyrs', 'TimeInf', 'time_reset',                           \
  'TimeSplitmat', 'timemean', 'valmod', 'valmod_dim','varaddattrk', 'varaddattr',    \
  'varaddref',                                                                       \
  'var_creation', 'varout', 'varoutold', 'varrmattr', 'varrm', 'VarVal_FillValue',   \
  'vrattr', 'WRF_d0Nref',                                                            \
  'WRF_CFlonlat_creation', 'WRF_CFtime_creation', 'WRF_CFxtime_creation',            \
  'list_operations', 'WRF_toCF']

### Options
##string_operation="operation to make: " + '\n' + " out, output values -S inidim1,[inidim2,...]:enddim1,[enddim2,...]"
string_operation="""operation to make: 
  addgattr, add a new global attribute: addatr -S [attrname]|[attrvalue]
  addvattr, add a new attribute to any given variable: addatr -S [attrname]|[attrvalue]
  addref, add a new variable with dimension and attributes from an already existing 'variable ref' in the file and -S [variable ref]:[attr name]@[value]:[[attr2]@[value2], ...]:[value/file with values]  mname, modify name -S newname
  checkallvalrs: Function to check all variables of a file: -S [dimn1],[[dimn2],...,[dimnN]]:[dim1],[[dim2],...,[dimN]]
  mname, modify name -S newname
  out, output values -S inidim1,[inidim2,...]:enddim1,[enddim2,...]
  valmod, modifiy values of variable -S [modification]:
     sumc,[constant]: add [constant] to variables values
     subc,[constant]: substract [constant] to variables values
     mulc,[constant]: multipy by [constant] to variables values
     divc,[constant]: divide by [constant] to variables values
  rmgattr, remove a global attribute: rmgattr -S [attrname]
  rmvattr, remove an attribute to any given variable: rmvattr -S [attrname]
"""

#print string_operation

operationnames = "'" + gen.numVector_String(operations, "', '") + "'"

parser = OptionParser()
parser.add_option("-f", "--netCDF_file", dest="ncfile", help="file to use", 
  metavar="FILE")
parser.add_option("-o", "--operation", type='choice', dest="operation", 
  choices=operations, help="operation to make: " + operationnames, metavar="OPER")
parser.add_option("-S", "--valueS", dest="values", 
  help="values to use according to the operation (when applicable); '-h' specific help of the operation", metavar="VALUES")
parser.add_option("-v", "--variable", dest="varname",
  help="variable to use (when applicable)", metavar="VAR")

(opts, args) = parser.parse_args()

#if opts.help:
#  parser.print_help()
#  print string_operation
#  sys.exit()

#######    #######
## MAIN
    #######

# Operations which file name is not a real file
NotCheckingFile = ['DatesFiles', 'file_creation', 'list_operations',                 \
  'model_characteristics', 'netcdf_concatenation', 'netcdf_fold_concatenation',      \
  'netcdf_fold_concatenation_HMT']

####### ###### ##### #### ### ## #
errormsg='ERROR -- error -- ERROR -- error'

varn=opts.varname
oper=opts.operation

if opts.ncfile is not None and not os.path.isfile(opts.ncfile) and                   \
  not gen.searchInlist(NotCheckingFile,oper):
    print errormsg
    print '  File ' + opts.ncfile + ' does not exist !!'
    quit(-1)

if oper == 'addvals':
    ncvar.addvals(opts.values, opts.ncfile, opts.varname)
elif oper == 'CDO_toCF':
    ncvar.CDO_toCF(opts.ncfile)
elif oper == 'chdimname':
    ncvar.chdimname(opts.values, opts.ncfile)
elif oper == 'changevartype':
    ncvar.changevartype(opts.values, opts.ncfile, opts.varname)
elif oper == 'checkallvars':
    ncvar.checkallvars(opts.values, opts.ncfile)
elif oper == 'checkAllValues':
    ncvar.checkAllValues(opts.values, opts.ncfile)
elif oper == 'checkNaNs':
    ncvar.checkNaNs(opts.values, opts.ncfile)
elif oper == 'chgtimestep':
    ncvar.chgtimestep(opts.values, opts.ncfile, opts.varname)
elif oper == 'chvarname':
    ncvar.chvarname(opts.values, opts.ncfile, opts.varname)
elif oper == 'cleaning_varsfile':
    ncvar.cleaning_varsfile(opts.values, opts.ncfile)
elif oper == 'compute_deaccum':
    ncvar.compute_deaccum(opts.values, opts.ncfile, opts.varname)
elif oper == 'compute_opersvarsfiles':
    ncvar.compute_opersvarsfiles(opts.values, opts.varname)
elif oper == 'compute_opervaralltime':
    ncvar.compute_opervaralltime(opts.values, opts.ncfile, opts.varname)
elif oper == 'compute_opervartimes':
    ncvar.compute_opervartimes(opts.values, opts.ncfile, opts.varname)
elif oper == 'compute_tevolboxtraj':
    ncvar.compute_tevolboxtraj(opts.values, opts.ncfile, opts.varname)
elif oper == 'computevar_model':
    ncvar.computevar_model(opts.values, opts.ncfile)
elif oper == 'DataSetSection':
    ncvar.DataSetSection(opts.values, opts.ncfile)
elif oper == 'DataSetSection_multidims':
    ncvar.DataSetSection_multidims(opts.values, opts.ncfile, opts.varname)
elif oper == 'DataSetSection_multivars':
    ncvar.DataSetSection_multivars(opts.values, opts.ncfile, opts.varname)
elif oper == 'DatesFiles':
    ncvar.DatesFiles(opts.values, opts.ncfile, opts.varname)
elif oper == 'dimToUnlimited':
    ncvar.dimToUnlimited(opts.values, opts.ncfile)
elif oper == 'dimVar_creation':
    ncvar.dimVar_creation(opts.values, opts.ncfile)
elif oper == 'fattradd':
    ncvar.fattradd(var, opts.values, opts.ncfile)
elif oper == 'fdimadd':
    ncvar.fdimadd(opts.values, opts.ncfile)
elif oper == 'fgaddattr':
    ncvar.fgaddattr(opts.values, opts.ncfile)
elif oper == 'file_creation':
    ncvar.file_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'file_oper_alongdims':
    ncvar.file_oper_alongdims(opts.values, opts.ncfile, opts.varname)
elif oper == 'field_stats':
    ncvar.field_stats(opts.values, opts.ncfile, opts.varname)
elif oper == 'filter_2dim':
    ncvar.filter_2dim(opts.values, opts.ncfile, opts.varname)
elif oper == 'flipdim':
    ncvar.flipdim(opts.values, opts.ncfile, opts.varname)
elif oper == 'fvaradd':
    ncvar.fvaradd(opts.values, opts.ncfile)
elif oper == 'gaddattrk':
    ncvar.gaddattrk(opts.values, opts.ncfile)
elif oper == 'gaddattr':
    ncvar.gaddattr(opts.values, opts.ncfile)
elif oper == 'get_attribute':
    ncvar.get_attribute(opts.values, opts.ncfile, opts.varname)
elif oper == 'get_namelist_vars':
    ncvar.get_namelist_vars(opts.values, opts.ncfile)
elif oper == 'get_Variables':
    ncvar.get_Variables(opts.values, opts.ncfile, opts.varname)
elif oper == 'getvalues_lonlat':
    ncvar.getvalues_lonlat(opts.values, opts.ncfile)
elif oper == 'grattr':
    ncvar.grattr(opts.values, opts.ncfile)
elif oper == 'grmattr':
    ncvar.grmattr(opts.values, opts.ncfile)
elif oper == 'idims':
    ncvar.idims(opts.ncfile)
elif oper == 'igattrs':
    ncvar.igattrs(opts.ncfile)
elif oper == 'increaseDimvar':
    ncvar.increaseDimvar(opts.values, opts.ncfile, opts.varname)
elif oper == 'isgattrs':
    ncvar.isgattrs(opts.values, opts.ncfile)
elif oper == 'isvattrs':
    ncvar.isvattrs(opts.values, opts.ncfile, opts.varname)
elif oper == 'ivars':
    ncvar.ivars(opts.ncfile)
elif oper == 'ivattrs':
    ncvar.ivattrs(opts.ncfile, opts.varname)
elif oper == 'list_operations':
# From: http://www.diveintopython.net/power_of_introspection/all_together.html
    object = ncvar
    for opern in operations:
        if  opern != 'list_operations': 
            print opern + '_______ ______ _____ ____ ___ __ _'
            print getattr(object, opern).__doc__
elif oper == 'LMDZ_toCF':
    ncvar.LMDZ_toCF(opts.values, opts.ncfile)
elif oper == 'maskvar':
    ncvar.maskvar(opts.values, opts.ncfile, opts.varname)
elif oper == 'model_characteristics':
    ncvar.model_characteristics(opts.values, opts.ncfile)
elif oper == 'ncreplace':
    ncvar.ncreplace(opts.values, opts.ncfile, opts.varname)
elif oper == 'ncstepdiff':
    ncvar.ncstepdiff(opts.values, opts.ncfile, opts.varname)
elif oper == 'netcdf_concatenation':
    ncvar.netcdf_concatenation(opts.ncfile)
elif oper == 'netcdf_fold_concatenation':
    ncvar.netcdf_fold_concatenation(opts.values, opts.ncfile, opts.varname)
elif oper == 'netcdf_fold_concatenation_HMT':
    ncvar.netcdf_fold_concatenation_HMT(opts.values, opts.ncfile, opts.varname)
elif oper == 'opersvarsfiles':
    ncvar.compute_opersvarsfiles(opts.values, opts.varname)
elif oper == 'pinterp':
    ncvar.pinterp(opts.values, opts.ncfile, opts.varname)
elif oper == 'remapnn':
    ncvar.remapnn(opts.values, opts.ncfile, opts.varname)
elif oper == 'Partialmap_Entiremap':
    ncvar.Partialmap_Entiremap(opts.values, opts.ncfile, opts.varname)
elif oper == 'Partialmap_EntiremapFor':
    ncvar.Partialmap_EntiremapFor(opts.values, opts.ncfile, opts.varname)
elif oper == 'Partialmap_EntiremapForExact':
    ncvar.Partialmap_EntiremapForExact(opts.values, opts.ncfile, opts.varname)
elif oper == 'reproject':
    ncvar.reproject(opts.values, opts.ncfile, opts.varname)
elif oper == 'seasmean':
    ncvar.seasmean(timename, opts.ncfile, opts.varname)
elif oper == 'sellonlatbox':
    ncvar.sellonlatbox(opts.values, opts.ncfile, opts.varname)
elif oper == 'sellonlatlevbox':
    ncvar.sellonlatlevbox(opts.values, opts.ncfile, opts.varname)
elif oper == 'selvar':
    ncvar.selvar(opts.values, opts.ncfile, opts.varname)
elif oper == 'setvar_asciivalues':
    ncvar.setvar_asciivalues(opts.values, opts.ncfile, opts.varname)
elif oper == 'sorttimesmat':
    ncvar.sorttimesmat(opts.ncfile, opts.varname)
elif oper == 'spacemean':
    ncvar.spacemean(opts.ncfile, opts.varname)
elif oper == 'SpatialWeightedMean':
    ncvar.SpatialWeightedMean(opts.values, opts.ncfile, opts.varname)
elif oper == 'statcompare_files':
    ncvar.statcompare_files(opts.values)
elif oper == 'subbasin':
    ncvar.subbasin(opts.values, opts.ncfile)
elif oper == 'submns':
    ncvar.submns(opts.values, opts.ncfile, opts.varname)
elif oper == 'subyrs':
    ncvar.subyrs(opts.values, opts.ncfile, opts.varname)
elif oper == 'TimeInf':
    ncvar.TimeInf(opts.ncfile, opts.varname)
elif oper == 'time_reset':
    ncvar.time_reset(opts.values, opts.ncfile, opts.varname)
elif oper == 'TimeSplitmat':
    ncvar.TimeSplitmat(opts.values, opts.ncfile, opts.varname)
elif oper == 'timemean':
    ncvar.timemean(opts.values, opts.ncfile, opts.varname)
elif oper == 'valmod':
    ncvar.valmod(opts.values, opts.ncfile, opts.varname)
elif oper == 'valmod_dim':
    ncvar.valmod_dim(opts.values, opts.ncfile, opts.varname)
elif oper == 'varaddattrk':
    ncvar.varaddattrk(opts.values, opts.ncfile, opts.varname)
elif oper == 'varaddattr':
    ncvar.varaddattr(opts.values, opts.ncfile, opts.varname)
elif oper == 'varaddref':
    ncvar.varaddref(opts.values, opts.ncfile, opts.varname)
elif oper == 'var_creation':
    ncvar.var_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'varout':
    ncvar.varout(opts.values, opts.ncfile, opts.varname)
elif oper == 'varoutold':
    ncvar.varoutold(opts.values, opts.ncfile, opts.varname)
elif oper == 'varrmattr':
    ncvar.varrmattr(opts.values, opts.ncfile, opts.varname)
elif oper == 'varrm':
    ncvar.varrm(opts.ncfile, opts.varname)
elif oper == 'VarVal_FillValue':
    ncvar.VarVal_FillValue(opts.values, opts.ncfile, opts.varname)
elif oper == 'vrattr':
    ncvar.vrattr(opts.values, opts.ncfile, opts.varname)
elif oper == 'WRF_d0Nref':
    ncvar.WRF_d0Nref(opts.values, opts.ncfile)
elif oper == 'WRF_CFlonlat_creation':
    ncvar.WRF_CFlonlat_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'WRF_CFtime_creation':
    ncvar.WRF_CFtime_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'WRF_CFxtime_creation':
    ncvar.WRF_CFxtime_creation(opts.values, opts.ncfile, opts.varname)
elif oper == 'WRF_toCF':
    ncvar.WRF_toCF(opts.values, opts.ncfile)
else:
    print errormsg
    print '   The operation ' + oper + ' is not ready !!'
    print errormsg
    quit()
