      SUBROUTINE top_bound( vcov,ucov,teta, du,dv,dh )
      IMPLICIT NONE
c
#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
CC#include "comgeom2.h"


c ..  DISSIPATION LINEAIRE A HAUT NIVEAU, RUN MESO,
C     F. LOTT DEC. 2006
c                                 (  10/12/06  )

c=======================================================================
c
c   Auteur:  F. LOTT  
c   -------
c
c   Objet:
c   ------
c
c   Dissipation linaire (ex top_bound de la physique)
c
c=======================================================================
c-----------------------------------------------------------------------
c   Declarations:
c   -------------

#include "comgeom.h"
#include "comdissipn.h"

c   Arguments:
c   ----------

      REAL ucov(iip1,jjp1,llm),vcov(iip1,jjm,llm),teta(iip1,jjp1,llm)
      REAL dv(iip1,jjm,llm),du(iip1,jjp1,llm),dh(iip1,jjp1,llm)

c   Local:
c   ------

      REAL uzon(jjp1,llm),vzon(jjm,llm),tzon(jjp1,llm)
      
      INTEGER NDAMP
      PARAMETER (NDAMP=4)
      integer i	
      REAL :: rdamp(llm) = 
     &   (/(0., i =1,llm-NDAMP),0.125E-5,.25E-5,.5E-5,1.E-5/) 

      INTEGER j,l


C  CALCUL DES CHAMPS EN MOYENNE ZONALE:
      
      do l=1,llm
        do j=1,jjm
          vzon(j,l)=0.
          do i=1,iim
            vzon(j,l)=vzon(j,l)+vcov(i,j,l)/float(iim)
          enddo
        enddo
      enddo

      do l=1,llm
        do i=1,iip1
          do j=1,jjm
            dv(i,j,l)=dv(i,j,l)-rdamp(l)*(vcov(i,j,l)-vzon(j,l))
          enddo
        enddo
      enddo

      do l=1,llm
        do j=2,jjm
          uzon(j,l)=0.
          tzon(j,l)=0.
          do i=1,iim
            uzon(j,l)=uzon(j,l)+ucov(i,j,l)/float(iim)
            tzon(j,l)=tzon(j,l)+teta(i,j,l)/float(iim)
          enddo
        enddo
      enddo

C   AMORTISSEMENTS LINEAIRES:

      do l=1,llm
        do i=1,iip1
          do j=2,jjm
            du(i,j,l)=du(i,j,l)-rdamp(l)*(ucov(i,j,l)-uzon(j,l))
            dh(i,j,l)=dh(i,j,l)-rdamp(l)*(teta(i,j,l)-tzon(j,l))
          enddo
        enddo
      enddo
      

      RETURN
      END
