! Abderrahmane 12 2007
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!! Ecreture des Sorties du modele dans les fichiers Netcdf :
! histmth.nc : moyennes mensuelles
! histday.nc : moyennes journalieres
! histhf.nc  : moyennes toutes les 3 heures
! histins.nc : valeurs instantanees
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

MODULE phys_output_mod

  IMPLICIT NONE

   integer, parameter                           :: nfiles = 4
   logical, dimension(nfiles), save             :: clef_files
   integer, dimension(nfiles), save             :: lev_files
   integer, dimension(nfiles), save             :: nid_files

   integer, dimension(nfiles), save             :: nhorim, nvertm
   real, dimension(nfiles), save                :: zstophym, zoutm
   CHARACTER(len=20), dimension(nfiles), save   :: type_ecri

!   integer, save                     :: nid_hf3d 

!!!!!!!!!! stockage dans une region limitee pour chaque fichier !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                 entre [lonmin_reg,lonmax_reg] et [latmin_reg,latmax_reg]

  logical, dimension(nfiles), save  :: ok_reglim         = (/ .false., .false., .false., .false. /) 
  real, dimension(nfiles), save     :: lonmin_reg        = (/ 0., -45., 0., 0. /)
  real, dimension(nfiles), save     :: lonmax_reg        = (/ 90., 45., 90., 90. /)
  real, dimension(nfiles), save     :: latmin_reg        = (/ 0., -45., 0., 0. /)
  real, dimension(nfiles), save     :: latmax_reg        = (/ 90., 90., 90., 90. /)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! Definition pour chaque variable du niveau d ecriture dans chaque fichier
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!/ histmth, histday, histhf, histins /)!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!!! 1D
  integer, dimension(nfiles) , save :: flag_phis         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_aire         = (/ 1, 1, 10,  1 /)
  integer, dimension(nfiles) , save :: flag_contfracATM  = (/ 10, 1,  1, 10 /)
  integer, dimension(nfiles) , save :: flag_contfracOR   = (/ 10, 1,  1, 10 /)
  integer, dimension(nfiles) , save :: flag_aireTER      = (/ 10, 10, 1, 10 /)
  
!!! 2D
  integer, dimension(nfiles) , save :: flag_flat         = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_slp          = (/ 1, 1, 1, 10 /)
  integer, dimension(nfiles) , save :: flag_tsol         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_t2m          = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_t2m_min      = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_t2m_max      = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_t2m_sol      = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_wind10m      = (/ 1, 1, 1, 10 /)
  integer, dimension(nfiles) , save :: flag_wind10max    = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_sicf         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_q2m          = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_u10m         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_v10m         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_psol         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_qsurf        = (/ 1, 10, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_u10m_sol     = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_v10m_sol     = (/ 10, 4, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_qsol         = (/ 1, 10, 10, 1 /)

  integer, dimension(nfiles),save   :: flag_ndayrain     = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles),save   :: flag_precip       = (/ 1, 1, 1, 1 /)
  integer,  dimension(nfiles), save :: flag_plul         = (/ 1, 1, 1, 1 /)

  integer, dimension(nfiles) , save :: flag_pluc         = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_snow         = (/ 1, 1, 10, 1 /) 
  integer, dimension(nfiles) , save :: flag_evap         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_tops         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tops0        = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_topl         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_topl0        = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWupTOA      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWupTOAclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdnTOA      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdnTOAclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWup200      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWup200clr   = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdn200      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdn200clr   = (/ 10, 1, 10, 10 /)

! arajouter
!  integer, dimension(nfiles) , save :: flag_LWupTOA     = (/ 1, 4, 10, 10 /)
!  integer, dimension(nfiles) , save :: flag_LWupTOAclr  = (/ 1, 4, 10, 10 /)
!  integer, dimension(nfiles) , save :: flag_LWdnTOA     = (/ 1, 4, 10, 10 /)
!  integer, dimension(nfiles) , save :: flag_LWdnTOAclr  = (/ 1, 4, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_LWup200      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWup200clr   = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdn200      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdn200clr   = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_sols         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_sols0        = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_soll         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_soll0        = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_radsol       = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWupSFC      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWupSFCclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdnSFC      = (/ 1, 1, 10, 10 /) 
  integer, dimension(nfiles) , save :: flag_SWdnSFCclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWupSFC      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWupSFCclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdnSFC      = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdnSFCclr   = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_bils         = (/ 1, 2, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_sens         = (/ 1, 1, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_fder         = (/ 1, 2, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_ffonte       = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fqcalving    = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fqfonte      = (/ 1, 10, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_taux_sol     = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_tauy_sol     = (/ 1, 4, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_pourc_sol    = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_fract_sol    = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_tsol_sol     = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_sens_sol     = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_lat_sol      = (/ 1, 4, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_flw_sol      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fsw_sol      = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_wbils_sol    = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_wbilo_sol    = (/ 1, 10, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_cdrm         = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_cdrh         = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_cldl         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cldm         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cldh         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cldt         = (/ 1, 1, 2, 10 /)
  integer, dimension(nfiles) , save :: flag_cldq         = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_lwp          = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_iwp          = (/ 1, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ue           = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ve           = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_uq           = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_vq           = (/ 1, 10, 10, 10 /)
 
  integer, dimension(nfiles) , save :: flag_cape         = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_pbase        = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ptop         = (/ 1, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fbase        = (/ 1, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_prw          = (/ 1, 1, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_s_pblh       = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_pblt       = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_lcl       = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_capCL      = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_oliqCL    = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_cteiCL     = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_therm      = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_trmb1      = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_trmb2      = (/ 1, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_s_trmb3      = (/ 1, 10, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_slab_bils    = (/ 1, 1, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_ale_bl    = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_alp_bl    = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_ale_wk    = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_alp_wk    = (/ 1, 1, 1, 1 /)

  integer, dimension(nfiles) , save :: flag_ale       = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_alp       = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_cin       = (/ 1, 1, 1, 1 /)
  integer, dimension(nfiles) , save :: flag_wape       = (/ 1, 1, 1, 1 /)


! Champs interpolles sur des niveaux de pression ??? a faire correctement
! if=1 on ecrit u v w phi sur 850 700 500 200 au niv 1
! if=2 on ecrit w et ph 500 seulement au niv 1
!        et u v sur 850 700 500 200
! if=3 on ecrit ph a 500 seulement au niv 1
!      on ecrit u v t q a 850 700 500 200 au niv 3
!      on ecrit ph  a 500   au niv 3

  integer, dimension(nfiles) , save :: flag_ulevsSTD     = (/ 1, 1, 3, 10 /)
  integer, dimension(nfiles) , save :: flag_vlevsSTD     = (/ 1, 1, 3, 10 /)
  integer, dimension(nfiles) , save :: flag_wlevsSTD     = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tlevsSTD     = (/ 10, 10, 3, 10 /)
  integer, dimension(nfiles) , save :: flag_qlevsSTD     = (/ 10, 10, 3, 10 /)
  integer, dimension(nfiles) , save :: flag_philevsSTD   = (/ 1, 1, 1, 10 /)

  integer, dimension(nfiles) , save :: flag_fluxo        = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_fluxg        = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_t_oce_sic    = (/ 1, 10, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_lmt_bils     = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tslab        = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_seaice       = (/ 1, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_siceh        = (/ 1, 1, 10, 10 /)

  integer, dimension(nfiles) , save :: flag_weakinv      = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dthmin       = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_u10_sol      = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_v10_sol      = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_meantaucld   = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cldtau       = (/ 10, 5, 10, 10 /)                     
  integer, dimension(nfiles) , save :: flag_cldemi       = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_rh2m         = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_qsat2m       = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tpot         = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tpote        = (/ 10, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tke          = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tke_max      = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tke_sol      = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_tke_max_sol  = (/ 10, 4, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_kz           = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_kz_max       = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_SWnetOR      = (/ 10, 10, 2, 10 /)
  integer, dimension(nfiles) , save :: flag_SWdownOR     = (/ 10, 10, 2, 10 /)
  integer, dimension(nfiles) , save :: flag_LWdownOR     = (/ 10, 10, 2, 10 /)

  integer, dimension(nfiles) , save :: flag_snowl         = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_cape_max      = (/ 10, 1, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_solldown      = (/ 10, 1, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_dtsvdfo       = (/ 10, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dtsvdft       = (/ 10, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dtsvdfg       = (/ 10, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dtsvdfi       = (/ 10, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_rugs          = (/ 10, 10, 10, 1 /)

!!!!!!!!!!!!!!!!!!!!!! 3D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
  integer, dimension(nfiles) , save :: flag_lwcon        = (/ 2, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_iwcon        = (/ 2, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_temp         = (/ 2, 3, 4, 1 /)
  integer, dimension(nfiles) , save :: flag_theta         = (/ 2, 3, 4, 1 /)
  integer, dimension(nfiles) , save :: flag_ovap         = (/ 2, 3, 4, 1 /)
  integer, dimension(nfiles) , save :: flag_wvapp        = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_geop         = (/ 2, 3, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_vitu         = (/ 2, 3, 4, 1 /)
  integer, dimension(nfiles) , save :: flag_vitv         = (/ 2, 3, 4, 1 /)
  integer, dimension(nfiles) , save :: flag_vitw         = (/ 2, 3, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_pres         = (/ 2, 3, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_rneb         = (/ 2, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_rnebcon      = (/ 2, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_rhum         = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ozone        = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_upwd         = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtphy        = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqphy        = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_pr_con_l     = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_pr_con_i     = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_pr_lsc_l     = (/ 2, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_pr_lsc_i     = (/ 2, 10, 10, 10 /)
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  integer, dimension(nfiles) , save :: flag_albe_sol     = (/ 3, 4, 10, 1 /) 
  integer, dimension(nfiles) , save :: flag_ages_sol     = (/ 3, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_rugs_sol     = (/ 3, 4, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_albs         = (/ 3, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_albslw       = (/ 3, 10, 10, 1 /)

  integer, dimension(nfiles) , save :: flag_clwcon       = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_Ma           = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dnwd         = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dnwd0        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtdyn        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqdyn        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtcon        = (/ 4, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ducon        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqcon        = (/ 4, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtwak        = (/ 4, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqwak        = (/ 4, 5, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtlsc        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtlschr      = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqlsc        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtvdf        = (/ 4, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dqvdf        = (/ 4, 10, 10, 1 /)
  integer, dimension(nfiles) , save :: flag_dteva        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqeva        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ptconv       = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_ratqs        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtthe        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_f_th        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_e_th        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_d_th        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_f0_th        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_zmax_th        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqthe        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtajs        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dqajs        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtswr        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtsw0        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtlwr        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtlw0        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dtec         = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_duvdf        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dvvdf        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_duoro        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dvoro        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dulif        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_dvlif        = (/ 4, 10, 10, 10 /)
  integer, dimension(nfiles) , save :: flag_trac         = (/ 4, 10, 10, 10 /)

    CONTAINS

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!! Ouverture des fichier et definition des variable de sortie !!!!!!!!
!! histbeg, histvert et histdef
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! 
  
  SUBROUTINE phys_output_open(jjmp1,nqmax,nlevSTD,clevSTD,nbteta, &
                              ctetaSTD,dtime, presnivs, ok_veget, &
                              ocean, iflag_pbl,ok_mensuel,ok_journe, & 
                              ok_hf,ok_instan, nid_fil)

  USE iophy 
  USE dimphy
  USE ioipsl
  USE mod_phys_lmdz_para

  IMPLICIT NONE
  include "dimensions.h"
  include "temps.h"
  include "indicesol.h"
  include "advtrac.h"
  include "clesphys.h"
  include "thermcell.h"

  integer                               :: jjmp1, nqmax
  integer                               :: nbteta, nlevSTD, radpas
  logical                               :: ok_mensuel, ok_journe, ok_hf, ok_instan
  real                                  :: dtime
  integer                               :: idayref
  real                                  :: zjulian
  real, dimension(klev)                 :: presnivs
  character(len=4), dimension(nlevSTD)  :: clevSTD
  integer                               :: nsrf, k, iq, iiq, iff, i, j
  logical                               :: ok_veget
  integer                               :: iflag_pbl
  CHARACTER(len=3)                      :: bb2
  CHARACTER(len=2)                      :: bb3
  character(len=6)                      :: ocean
  CHARACTER(len=3)                      :: ctetaSTD(nbteta)
  integer, dimension(nfiles)            :: nid_fil
  real, dimension(nfiles)               :: ecrit_files
  CHARACTER(len=20), dimension(nfiles)  :: name_files
  INTEGER, dimension(iim*jjmp1)         ::  ndex2d
  INTEGER, dimension(iim*jjmp1*klev)    :: ndex3d
  integer                               :: imin_ins, imax_ins
  integer                               :: jmin_ins, jmax_ins

   name_files(1) = 'histmth'
   name_files(2) = 'histday'
   name_files(3) = 'histhf'
   name_files(4) = 'histins'

   type_ecri(1) = 'ave(X)'
   type_ecri(2) = 'ave(X)'
   type_ecri(3) = 'ave(X)'
   type_ecri(4) = 'inst(X)'

   clef_files(1) = ok_mensuel
   clef_files(2) = ok_journe
   clef_files(3) = ok_hf
   clef_files(4) = ok_instan

   lev_files(1) = lev_histmth
   lev_files(2) = lev_histday
   lev_files(3) = lev_histhf
   lev_files(4) = 1

   ecrit_files(1) = ecrit_mth
   ecrit_files(2) = ecrit_day
   ecrit_files(3) = ecrit_hf
   ecrit_files(4) = ecrit_ins
 
!!!!!!!!!!!!!!!!!!!!!!! Boucle sur les fichiers !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! Appel de histbeg et histvert pour creer le fichier et les niveaux verticaux !!
! Appel des histbeg pour definir les variables (nom, moy ou inst, freq de sortie ..
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

 DO iff=1,nfiles

    IF (clef_files(iff)) THEN
      
      zstophym(iff) = dtime         ! Frequence ou l on moyenne
      zoutm(iff) = ecrit_files(iff) ! Frequence ou l on ecrit

      idayref = day_ref
      CALL ymds2ju(annee_ref, 1, idayref, 0.0, zjulian)

!!!!!!!!!!!!!!!!! Traitement dans le cas ou l'on veut stocker sur un domaine limite !!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     if (ok_reglim(iff)) then

        imin_ins=1
        imax_ins=iim
        jmin_ins=1
        jmax_ins=jjmp1

        do i=1,iim-1
           print*,'io_lon(i)=',io_lon(i)
           if (io_lon(i).le.lonmin_reg(iff)) imin_ins=i
           if (io_lon(i).le.lonmax_reg(iff)) imax_ins=i
        enddo

        do j=1,jjmp1-1
            print*,'io_lat(j)=',io_lat(j)
            if (io_lat(j).ge.latmin_reg(iff)) jmax_ins=j+1
            if (io_lat(j).ge.latmax_reg(iff)) jmin_ins=j
        enddo

         print*,'On stoke le fichier hist sur, ', &
         imin_ins,imax_ins,jmin_ins,jmax_ins
         print*,'On stoke le fichier instantanne sur, ', &
         io_lon(imin_ins),io_lon(imax_ins), &
         io_lat(jmin_ins),io_lat(jmax_ins)

 CALL histbeg(name_files(iff),iim,io_lon,jjmp1,io_lat, &
              imin_ins,imax_ins-imin_ins+1, &
              jmin_ins,jmax_ins-jmin_ins+1, &
              itau_phy,zjulian,dtime,nhorim(iff),nid_fil(iff))
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
       else
 CALL histbeg_phy(name_files(iff),itau_phy,zjulian,dtime,nhorim(iff),nid_fil(iff))
       endif
 
      nid_files(iff)=nid_fil(iff)

 CALL histvert(nid_files(iff),"presnivs","Vertical levels","mb",klev, presnivs/100., nvertm(iff))

!!!!!!!!!!!!! Traitement des champs 3D pour histhf !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!! A Revoir plus tard !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!          IF (iff.eq.3.and.lev_files(iff).ge.4) THEN
!          CALL histbeg_phy("histhf3d",itau_phy, &
!     &                     zjulian, dtime, &
!     &                     nhorim, nid_hf3d)

!         CALL histvert(nid_hf3d,"presnivs", &
!     &                 "Vertical levels","mb", &
!     &                 klev, presnivs/100., nvertm)
!          ENDIF

!!! Champs 1D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 CALL histdef2d(iff,flag_phis,"phis","Surface geop.height","m2/s2") 
 CALL histdef2d(iff,flag_aire,"aire","Grid area","-")
 CALL histdef2d(iff,flag_contfracATM,"contfracATM","% sfce ter+lic","-")
 CALL histdef2d(iff,flag_contfracOR,"contfracOR","% sfce terre OR","-" )
 CALL histdef2d(iff,flag_aireTER,"aireTER","Grid area CONT","-" )

!!! Champs 2D !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 CALL histdef2d(iff,flag_flat,"flat","Latent heat flux","W/m2")
 CALL histdef2d(iff,flag_slp,"slp","Sea Level Pressure", "Pa" )
 CALL histdef2d(iff,flag_tsol,"tsol","Surface Temperature", "K")
 CALL histdef2d( iff,flag_t2m,"t2m","Temperature 2m", "K" )
 CALL histdef2d(iff,flag_t2m_min,"t2m_min","Temp 2m min", "K" )
 CALL histdef2d(iff,flag_t2m_max,"t2m_max", "Temp 2m max", "K" )
 CALL histdef2d(iff,flag_wind10m,"wind10m","10-m wind speed","m/s")
 CALL histdef2d(iff,flag_wind10max,"wind10max","10m wind speed max","m/s")
 CALL histdef2d(iff,flag_sicf,"sicf","Sea-ice fraction", "-" )
 CALL histdef2d(iff,flag_q2m,"q2m","Specific humidity 2m", "kg/kg")
 CALL histdef2d(iff,flag_u10m,"u10m","Vent zonal 10m", "m/s" )
 CALL histdef2d(iff,flag_v10m,"v10m","Vent meridien 10m", "m/s")
 CALL histdef2d(iff,flag_psol,"psol","Surface Pressure","Pa" ) 
 CALL histdef2d(iff,flag_qsurf,"qsurf","Surface Air humidity", "kg/kg")

  if (.not. ok_veget) then
 CALL histdef2d(iff,flag_qsol,"qsol","Soil watter content", "mm" )
  endif

 CALL histdef2d(iff,flag_ndayrain,"ndayrain","Number of dayrain(liq+sol)","-")
 CALL histdef2d(iff,flag_precip,"precip","Precip Totale liq+sol","kg/(s*m2)" )
 CALL histdef2d(iff,flag_plul,"plul","Large-scale Precip.","kg/(s*m2)") 
 CALL histdef2d(iff,flag_pluc,"pluc","Convective Precip.","kg/(s*m2)")
 CALL histdef2d(iff,flag_snow,"snow","Snow fall","kg/(s*m2)" )
 CALL histdef2d(iff,flag_evap,"evap","Evaporat", "kg/(s*m2)" ) 
 CALL histdef2d(iff,flag_tops,"tops","Solar rad. at TOA","W/m2") 
 CALL histdef2d(iff,flag_tops0,"tops0","CS Solar rad. at TOA", "W/m2")
 CALL histdef2d(iff,flag_topl,"topl","IR rad. at TOA", "W/m2" )
 CALL histdef2d(iff,flag_topl0,"topl0", "IR rad. at TOA","W/m2")
 CALL histdef2d(iff,flag_SWupTOA,"SWupTOA","SWup at TOA","W/m2") 
 CALL histdef2d(iff,flag_SWupTOAclr,"SWupTOAclr","SWup clear sky at TOA","W/m2")
 CALL histdef2d(iff,flag_SWdnTOA, "SWdnTOA","SWdn at TOA","W/m2" )
 CALL histdef2d(iff,flag_SWdnTOAclr,"SWdnTOAclr","SWdn clear sky at TOA","W/m2") 
 CALL histdef2d(iff,flag_SWup200,"SWup200","SWup at 200mb","W/m2" ) 
 CALL histdef2d(iff,flag_SWup200clr,"SWup200clr","SWup clear sky at 200mb","W/m2")
 CALL histdef2d(iff,flag_SWdn200,"SWdn200","SWdn at 200mb","W/m2" )
 CALL histdef2d(iff,flag_SWdn200clr,"SWdn200clr","SWdn clear sky at 200mb","W/m2")
 CALL histdef2d(iff,flag_LWup200,"LWup200","LWup at 200mb","W/m2") 
 CALL histdef2d(iff,flag_LWup200clr, "LWup200clr","LWup clear sky at 200mb","W/m2")
 CALL histdef2d(iff,flag_LWdn200,"LWdn200","LWdn at 200mb","W/m2") 
 CALL histdef2d(iff,flag_LWdn200clr, "LWdn200clr","LWdn clear sky at 200mb","W/m2")
 CALL histdef2d(iff,flag_sols,"sols","Solar rad. at surf.","W/m2")
 CALL histdef2d(iff,flag_sols0,"sols0","Solar rad. at surf.","W/m2")
 CALL histdef2d(iff,flag_soll,"soll","IR rad. at surface","W/m2")  
 CALL histdef2d(iff,flag_radsol,"radsol","Rayonnement au sol","W/m2")
 CALL histdef2d(iff,flag_soll0,"soll0","IR rad. at surface","W/m2") 
 CALL histdef2d(iff,flag_SWupSFC,"SWupSFC","SWup at surface","W/m2")
 CALL histdef2d(iff,flag_SWupSFCclr,"SWupSFCclr","SWup clear sky at surface","W/m2")
 CALL histdef2d(iff,flag_SWdnSFC,"SWdnSFC","SWdn at surface","W/m2")
 CALL histdef2d(iff,flag_SWdnSFCclr,"SWdnSFCclr","SWdn clear sky at surface","W/m2")
 CALL histdef2d(iff,flag_LWupSFC,"LWupSFC","Upwd. IR rad. at surface","W/m2")
 CALL histdef2d(iff,flag_LWdnSFC,"LWdnSFC","Down. IR rad. at surface","W/m2")
 CALL histdef2d(iff,flag_LWupSFCclr,"LWupSFCclr","CS Upwd. IR rad. at surface","W/m2")
 CALL histdef2d(iff,flag_LWdnSFCclr,"LWdnSFCclr","Down. CS IR rad. at surface","W/m2")
 CALL histdef2d(iff,flag_bils,"bils","Surf. total heat flux","W/m2")
 CALL histdef2d(iff,flag_sens,"sens","Sensible heat flux","W/m2")
 CALL histdef2d(iff,flag_fder,"fder","Heat flux derivation","W/m2")
 CALL histdef2d(iff,flag_ffonte,"ffonte","Thermal flux for snow melting","W/m2")
 CALL histdef2d(iff,flag_fqcalving,"fqcalving","Ice Calving","kg/m2/s") 
 CALL histdef2d(iff,flag_fqfonte,"fqfonte","Land ice melt","kg/m2/s") 

     DO nsrf = 1, nbsrf
 CALL histdef2d(iff,flag_pourc_sol,"pourc_"//clnsurf(nsrf),"% "//clnsurf(nsrf),"%")
 CALL histdef2d(iff,flag_fract_sol,"fract_"//clnsurf(nsrf),"Fraction "//clnsurf(nsrf),"1")
 CALL histdef2d(iff,flag_taux_sol,"taux_"//clnsurf(nsrf),"Zonal wind stress"//clnsurf(nsrf),"Pa")
 CALL histdef2d(iff,flag_tauy_sol,"tauy_"//clnsurf(nsrf),"Meridional wind stress "//clnsurf(nsrf),"Pa")
 CALL histdef2d(iff,flag_tsol_sol,"tsol_"//clnsurf(nsrf),"Temperature "//clnsurf(nsrf),"K")
 CALL histdef2d(iff,flag_u10m_sol,"u10m_"//clnsurf(nsrf),"Vent Zonal 10m "//clnsurf(nsrf),"m/s")
 CALL histdef2d(iff,flag_v10m_sol,"v10m_"//clnsurf(nsrf),"Vent meredien 10m "//clnsurf(nsrf),"m/s")
 CALL histdef2d(iff,flag_t2m_sol,"t2m_"//clnsurf(nsrf),"Temp 2m "//clnsurf(nsrf),"K")
 CALL histdef2d(iff,flag_sens_sol,"sens_"//clnsurf(nsrf),"Sensible heat flux "//clnsurf(nsrf),"W/m2")
 CALL histdef2d(iff,flag_lat_sol,"lat_"//clnsurf(nsrf),"Latent heat flux "//clnsurf(nsrf),"W/m2")
 CALL histdef2d(iff,flag_flw_sol,"flw_"//clnsurf(nsrf),"LW "//clnsurf(nsrf),"W/m2")
 CALL histdef2d(iff,flag_fsw_sol,"fsw_"//clnsurf(nsrf),"SW "//clnsurf(nsrf),"W/m2")
 CALL histdef2d(iff,flag_wbils_sol,"wbils_"//clnsurf(nsrf),"Bilan sol "//clnsurf(nsrf),"W/m2" )
 CALL histdef2d(iff,flag_wbilo_sol,"wbilo_"//clnsurf(nsrf),"Bilan eau "//clnsurf(nsrf),"kg/(m2*s)")
  if (iflag_pbl>1 .and. lev_files(iff).gt.10 ) then
 CALL histdef2d(iff,flag_tke_sol,"tke_"//clnsurf(nsrf),"Max Turb. Kinetic Energy "//clnsurf(nsrf),"-")
 CALL histdef2d(iff,flag_tke_max_sol,"tke_max_"//clnsurf(nsrf),"Max Turb. Kinetic Energy "//clnsurf(nsrf),"-")
  endif
 CALL histdef2d(iff,flag_albe_sol, "albe_"//clnsurf(nsrf),"Albedo surf. "//clnsurf(nsrf),"-")
 CALL histdef2d(iff,flag_rugs_sol,"rugs_"//clnsurf(nsrf),"Latent heat flux "//clnsurf(nsrf),"W/m2")
 CALL histdef2d(iff,flag_ages_sol,"ages_"//clnsurf(nsrf),"Snow age","day")
     END DO

 CALL histdef2d(iff,flag_albs,"albs","Surface albedo","-")
 CALL histdef2d(iff,flag_albslw,"albslw","Surface albedo LW","-")
 CALL histdef2d(iff,flag_cdrm,"cdrm","Momentum drag coef.", "-")
 CALL histdef2d(iff,flag_cdrh,"cdrh","Heat drag coef.", "-" )
 CALL histdef2d(iff,flag_cldl,"cldl","Low-level cloudiness", "-")
 CALL histdef2d(iff,flag_cldm,"cldm","Mid-level cloudiness", "-")
 CALL histdef2d(iff,flag_cldh,"cldh","High-level cloudiness", "-")
 CALL histdef2d(iff,flag_cldt,"cldt","Total cloudiness","%")
 CALL histdef2d(iff,flag_cldq,"cldq","Cloud liquid water path","kg/m2")
 CALL histdef2d(iff,flag_lwp,"lwp","Cloud water path","kg/m2")
 CALL histdef2d(iff,flag_iwp,"iwp","Cloud ice water path","kg/m2" )
 CALL histdef2d(iff,flag_ue,"ue","Zonal energy transport","-")
 CALL histdef2d(iff,flag_ve,"ve","Merid energy transport", "-")
 CALL histdef2d(iff,flag_uq,"uq","Zonal humidity transport", "-")
 CALL histdef2d(iff,flag_vq,"vq","Merid humidity transport", "-")

     IF(iflag_con.GE.3) THEN ! sb
 CALL histdef2d(iff,flag_cape,"cape","Conv avlbl pot ener","J/kg")
 CALL histdef2d(iff,flag_pbase,"pbase","Cld base pressure", "mb")
 CALL histdef2d(iff,flag_ptop,"ptop","Cld top pressure", "mb")
 CALL histdef2d(iff,flag_fbase,"fbase","Cld base mass flux","kg/m2/s")
 CALL histdef2d(iff,flag_prw,"prw","Precipitable water","kg/m2")
     ENDIF !iflag_con .GE. 3

 CALL histdef2d(iff,flag_s_pblh,"s_pblh","Boundary Layer Height","m")
 CALL histdef2d(iff,flag_s_pblt,"s_pblt","t at Boundary Layer Height","K")
 CALL histdef2d(iff,flag_s_lcl,"s_lcl","Condensation level","m")
 CALL histdef2d(iff,flag_s_capCL,"s_capCL","Conv avlbl pot enerfor ABL", "J/m2" )
 CALL histdef2d(iff,flag_s_oliqCL,"s_oliqCL","Liq Water in BL","kg/m2")
 CALL histdef2d(iff,flag_s_cteiCL,"s_cteiCL","Instability criteria(ABL)","K")
 CALL histdef2d(iff,flag_s_therm,"s_therm","Exces du thermique", "K")
 CALL histdef2d(iff,flag_s_trmb1,"s_trmb1","deep_cape(HBTM2)","J/m2")
 CALL histdef2d(iff,flag_s_trmb2,"s_trmb2","inhibition (HBTM2)","J/m2")
 CALL histdef2d(iff,flag_s_trmb3,"s_trmb3","Point Omega (HBTM2)","m")

! Champs interpolles sur des niveaux de pression
! iif=1 on ecrit u v w phi sur 850 700 500 200 au niv 1
! iif=2 on ecrit w et ph 500 seulement au niv 1
!        et u v sur 850 700 500 200
! iif=3 on ecrit ph a 500 seulement au niv 1
!      on ecrit u v t q a 850 700 500 200 au niv 3

        DO k=1, nlevSTD
     IF(k.GE.2.AND.k.LE.12) bb2=clevSTD(k)
     IF(k.GE.13.AND.k.LE.17) bb3=clevSTD(k)
     IF(bb2.EQ."850".OR.bb2.EQ."700".OR.bb2.EQ."500".OR.bb2.EQ."200")THEN
 CALL histdef2d(iff,flag_ulevsSTD,"u"//bb2,"Zonal wind "//bb2//"mb","m/s")
 CALL histdef2d(iff,flag_vlevsSTD,"v"//bb2,"Meridional wind "//bb2//"mb","m/s")
 CALL histdef2d(iff,flag_wlevsSTD,"w"//bb2,"Vertical wind "//bb2//"mb","m/s")
 CALL histdef2d(iff,flag_philevsSTD,"phi"//bb2,"Geopotential "//bb2//"mb","m")
 CALL histdef2d(iff,flag_qlevsSTD,"q"//bb2,"Specific humidity "//bb2//"mb","kg/kg" )
 CALL histdef2d(iff,flag_tlevsSTD,"t"//bb2,"Temperature "//bb2//"mb","K")
     ENDIF !(bb2.EQ."850".OR.bb2.EQ."700".OR.
       ENDDO

!IM diagnostiques flux ocean-atm ou ocean-glace de mer
!IM pour utilisation dans un modele de "slab" ocean
 CALL histdef2d(iff,flag_fluxo,"fluxo","Flux turbulents ocean-atmosphere","W/m2")
 CALL histdef2d(iff,flag_fluxg,"fluxg","Flux turbulents ocean-glace de mer","W/m2")
 CALL histdef2d(iff,flag_t_oce_sic,"t_oce_sic","Temp mixte oce-sic","K")

     IF (OCEAN.EQ.'force ') THEN
 CALL histdef2d(iff,flag_lmt_bils,"lmt_bils","Bilan au sol atmosphere forcee","W/m2")
     ELSE IF (OCEAN.EQ.'slab  ') THEN
 CALL histdef2d(iff,flag_slab_bils,"slab_bils","Bilan au sol Slab","W/m2") 
 CALL histdef2d(iff,flag_tslab,"tslab", "Slab SST ", "K")
 CALL histdef2d(iff,flag_seaice,"seaice","Slab seaice","kg/m2") 
 CALL histdef2d(iff,flag_siceh,"siceh","Slab seaice height","m")
     ENDIF

 CALL histdef2d(iff,flag_ale_bl,"ale_bl","ALE BL","m2/s2") 
 CALL histdef2d(iff,flag_alp_bl,"alp_bl","ALP BL","m2/s2") 
 CALL histdef2d(iff,flag_ale_wk,"ale_wk","ALE WK","m2/s2") 
 CALL histdef2d(iff,flag_alp_wk,"alp_wk","ALP WK","m2/s2") 

 CALL histdef2d(iff,flag_ale,"ale","ALE","m2/s2")
 CALL histdef2d(iff,flag_alp,"alp","ALP","W/m2")
 CALL histdef2d(iff,flag_cin,"cin","Convective INhibition","m2/s2")
 CALL histdef2d(iff,flag_wape,"WAPE","WAPE","m2/s2")

 CALL histdef2d(iff,flag_weakinv, "weakinv","Weak inversion", "-")
 CALL histdef2d(iff,flag_dthmin,"dthmin","dTheta mini", "K/m")
 if (ok_isccp) then
   CALL histdef2d(iff,flag_meantaucld,"meantaucld","ISCCP mean cloud optical thickness","1")
 endif
 CALL histdef2d(iff,flag_rh2m,"rh2m","Relative humidity at 2m", "%" )
 CALL histdef2d(iff,flag_qsat2m,"qsat2m","Saturant humidity at 2m", "%")
 CALL histdef2d(iff,flag_tpot,"tpot","Surface air potential temperature","K")
 CALL histdef2d(iff,flag_tpote,"tpote","Surface air equivalent potential temperature","K")
 CALL histdef2d(iff,flag_SWnetOR,"SWnetOR","Sfce net SW radiation OR", "W/m2")
 CALL histdef2d(iff,flag_SWdownOR,"SWdownOR","Sfce incident SW radiation OR","W/m2")
 CALL histdef2d(iff,flag_LWdownOR,"LWdownOR","Sfce incident LW radiation OR","W/m2")
 CALL histdef2d(iff,flag_snowl,"snowl","Solid Large-scale Precip.","kg/(m2*s)")
 CALL histdef2d(iff,flag_cape_max,"cape_max","CAPE max.", "J/kg")
 CALL histdef2d(iff,flag_solldown,"solldown","Down. IR rad. at surface","W/m2")
 CALL histdef2d(iff,flag_dtsvdfo,"dtsvdfo","Boundary-layer dTs(o)","K/s")
 CALL histdef2d(iff,flag_dtsvdft,"dtsvdft","Boundary-layer dTs(t)","K/s")
 CALL histdef2d(iff,flag_dtsvdfg,"dtsvdfg","Boundary-layer dTs(g)","K/s")
 CALL histdef2d(iff,flag_dtsvdfi,"dtsvdfi","Boundary-layer dTs(g)","K/s")
 CALL histdef2d(iff,flag_rugs,"rugs","rugosity", "-" )

! Champs 3D:
 CALL histdef3d(iff,flag_lwcon,"lwcon","Cloud liquid water content","kg/kg")
 CALL histdef3d(iff,flag_iwcon,"iwcon","Cloud ice water content","kg/kg")
 CALL histdef3d(iff,flag_temp,"temp","Air temperature","K" )
 CALL histdef3d(iff,flag_theta,"theta","Potential air temperature","K" )
 CALL histdef3d(iff,flag_ovap,"ovap","Specific humidity","kg/kg" )
 CALL histdef3d(iff,flag_geop,"geop","Geopotential height","m2/s2")
 CALL histdef3d(iff,flag_vitu,"vitu","Zonal wind", "m/s" )
 CALL histdef3d(iff,flag_vitv,"vitv","Meridional wind","m/s" )
 CALL histdef3d(iff,flag_vitw,"vitw","Vertical wind","m/s" )
 CALL histdef3d(iff,flag_pres,"pres","Air pressure", "Pa" )
 CALL histdef3d(iff,flag_rneb,"rneb","Cloud fraction","-")
 CALL histdef3d(iff,flag_rnebcon,"rnebcon","Convective Cloud Fraction","-")
 CALL histdef3d(iff,flag_rhum,"rhum","Relative humidity","-")
 CALL histdef3d(iff,flag_ozone,"ozone","Ozone concentration", "ppmv")
 CALL histdef3d(iff,flag_upwd,"upwd","saturated updraft", "kg/m2/s")
 CALL histdef3d(iff,flag_dtphy,"dtphy","Physics dT","K/s")
 CALL histdef3d(iff,flag_dqphy,"dqphy","Physics dQ", "(kg/kg)/s")
 CALL histdef3d(iff,flag_cldtau,"cldtau","Cloud optical thickness","1")
 CALL histdef3d(iff,flag_cldemi,"cldemi","Cloud optical emissivity","1")
!IM: bug ?? dimensionnement variables (klon,klev+1) pmflxr, pmflxs, prfl, psfl
! CALL histdef3d(iff,flag_pr_con_l,"pmflxr","Convective precipitation lic"," ")
! CALL histdef3d(iff,flag_pr_con_i,"pmflxs","Convective precipitation ice"," ")
! CALL histdef3d(iff,flag_pr_lsc_l,"prfl","Large scale precipitation lic"," ")
! CALL histdef3d(iff,flag_pr_lsc_i,"psfl","Large scale precipitation ice"," ")

!FH Sorties pour la couche limite
     if (iflag_pbl>1) then
 CALL histdef3d(iff,flag_tke,"tke","TKE","m2/s2")
 CALL histdef3d(iff,flag_tke_max,"tke_max","TKE max","m2/s2")
     endif

 CALL histdef3d(iff,flag_kz,"kz","Kz melange","m2/s")
 CALL histdef3d(iff,flag_kz_max,"kz_max","Kz melange max","m2/s" )
 CALL histdef3d(iff,flag_clwcon,"clwcon","Convective Cloud Liquid water content", "kg/kg") 
 CALL histdef3d(iff,flag_Ma,"Ma","undilute adiab updraft","kg/m2/s")
 CALL histdef3d(iff,flag_dnwd,"dnwd","saturated downdraft","kg/m2/s")
 CALL histdef3d(iff,flag_dnwd0,"dnwd0","unsat. downdraft", "kg/m2/s")
 CALL histdef3d(iff,flag_dtdyn,"dtdyn","Dynamics dT","K/s")
 CALL histdef3d(iff,flag_dqdyn,"dqdyn","Dynamics dQ", "(kg/kg)/s")
 CALL histdef3d(iff,flag_dtcon,"dtcon","Convection dT","K/s")
 CALL histdef3d(iff,flag_ducon,"ducon","Convection du","m/s2")
 CALL histdef3d(iff,flag_dqcon,"dqcon","Convection dQ", "(kg/kg)/s")
 IF (iflag_wake == 1) THEN
   CALL histdef3d(iff,flag_dtwak,"dtwak","Wake dT","K/s")
   CALL histdef3d(iff,flag_dqwak,"dqwak","Wake dQ","(kg/kg)/s")
 endif
 CALL histdef3d(iff,flag_dtlsc,"dtlsc","Condensation dT", "K/s")
 CALL histdef3d(iff,flag_dtlschr,"dtlschr","Large-scale condensational heating rate","K/s")
 CALL histdef3d(iff,flag_dqlsc,"dqlsc","Condensation dQ","(kg/kg)/s")
 CALL histdef3d(iff,flag_dtvdf,"dtvdf","Boundary-layer dT", "K/s")
 CALL histdef3d(iff,flag_dqvdf,"dqvdf","Boundary-layer dQ","(kg/kg)/s") 
 CALL histdef3d(iff,flag_dteva,"dteva","Reevaporation dT", "K/s")
 CALL histdef3d(iff,flag_dqeva,"dqeva","Reevaporation dQ","(kg/kg)/s")
 CALL histdef3d(iff,flag_ptconv,"ptconv","POINTS CONVECTIFS"," ")
 CALL histdef3d(iff,flag_ratqs,"ratqs", "RATQS"," ")
 CALL histdef3d(iff,flag_dtthe,"dtthe","Dry adjust. dT", "K/s")
 CALL histdef3d(iff,flag_f_th,"f_th","Thermal plume mass flux", "K/s")
 CALL histdef3d(iff,flag_e_th,"e_th","Thermal plume entrainment", "K/s")
 CALL histdef3d(iff,flag_d_th,"d_th","Thermal plume detrainment", "K/s")
 CALL histdef2d(iff,flag_d_th,"f0_th","Thermal closure mass flux", "K/s")
 CALL histdef2d(iff,flag_d_th,"zmax_th","Thermal plume height", "K/s")
 CALL histdef3d(iff,flag_dqthe,"dqthe","Dry adjust. dQ","(kg/kg)/s")
 CALL histdef3d(iff,flag_dtajs,"dtajs","Dry adjust. dT", "K/s")
 CALL histdef3d(iff,flag_dqajs,"dqajs","Dry adjust. dQ","(kg/kg)/s")
 CALL histdef3d(iff,flag_dtswr,"dtswr","SW radiation dT","K/s")
 CALL histdef3d(iff,flag_dtsw0,"dtsw0","CS SW radiation dT","K/s")
 CALL histdef3d(iff,flag_dtlwr,"dtlwr","LW radiation dT","K/s")
 CALL histdef3d(iff,flag_dtlw0,"dtlw0", "CS LW radiation dT","K/s")
 CALL histdef3d(iff,flag_dtec,"dtec","Cinetic dissip dT","K/s")
 CALL histdef3d(iff,flag_duvdf,"duvdf","Boundary-layer dU","m/s2")
 CALL histdef3d(iff,flag_dvvdf,"dvvdf","Boundary-layer dV", "m/s2")

     IF (ok_orodr) THEN
 CALL histdef3d(iff,flag_duoro,"duoro","Orography dU","m/s2")
 CALL histdef3d(iff,flag_dvoro,"dvoro","Orography dV", "m/s2")
     ENDIF

     IF (ok_orolf) THEN
 CALL histdef3d(iff,flag_dulif,"dulif","Orography dU","m/s2")
 CALL histdef3d(iff,flag_dvlif,"dvlif","Orography dV", "m/s2")
     ENDIF

      if (nqmax>=3) THEN
    DO iq=3,nqmax
       iiq=niadv(iq)
 CALL histdef3d ( iff, flag_trac, tnom(iq),ttext(iiq), "-" )
    ENDDO
      endif

        CALL histend(nid_files(iff))

         ndex2d = 0
         ndex3d = 0

         ENDIF ! clef_files

         ENDDO ! 
      end subroutine phys_output_open

      SUBROUTINE histdef2d (iff,flag_var,nomvar,titrevar,unitvar)
      
       use ioipsl
       USE dimphy
       USE mod_phys_lmdz_para

       IMPLICIT NONE
       
       include "dimensions.h"
       include "temps.h"
       include "indicesol.h"
       include "advtrac.h"
       include "clesphys.h"

       integer                          :: iff
       integer, dimension(nfiles)       :: flag_var
       character(len=*)                 :: nomvar
       character(len=*)                 :: titrevar
       character(len=*)                 :: unitvar
       
       if ( flag_var(iff)<=lev_files(iff) ) then
 call histdef (nid_files(iff),nomvar,titrevar,unitvar, &
               iim,jj_nb,nhorim(iff), 1,1,1, -99, 32, &
               type_ecri(iff), zstophym(iff),zoutm(iff))                
       endif                      
      end subroutine histdef2d

      SUBROUTINE histdef3d (iff,flag_var,nomvar,titrevar,unitvar)

       use ioipsl
       USE dimphy
       USE mod_phys_lmdz_para

       IMPLICIT NONE

       include "dimensions.h"
       include "temps.h"
       include "indicesol.h"
       include "advtrac.h"
       include "clesphys.h"

       integer                          :: iff
       integer, dimension(nfiles)       :: flag_var
       character(len=*)                 :: nomvar
       character(len=*)                 :: titrevar
       character(len=*)                 :: unitvar

       if ( flag_var(iff)<=lev_files(iff) ) then
 call histdef (nid_files(iff),nomvar,titrevar,unitvar, &
               iim,jj_nb,nhorim(iff), klev,1,klev,nvertm(iff), 32, &
               type_ecri(iff), zstophym(iff),zoutm(iff))
       endif
      end subroutine histdef3d

END MODULE phys_output_mod

