!
! $Header$
!
!
!

  subroutine conf_phys(ocean, ok_veget, ok_journe, ok_mensuel, ok_instan, ok_hf, &
 &                     solarlong0,seuil_inversion, &
 &                     fact_cldcon, facttemps,ok_newmicro,iflag_radia,&
 &                     iflag_cldcon, &
 &                     iflag_ratqs,ratqsbas,ratqshaut, &
 &		       ok_ade, ok_aie, aerosol_couple, &
 &                     bl95_b0, bl95_b1,&
 &                     iflag_thermals,nsplit_thermals,tau_thermals, &
 &                     iflag_coupl,iflag_clos,iflag_wake )

   use IOIPSL
!!!!   USE surface_data,     ONLY : ocean, ok_veget

   implicit none

 include "conema3.h"
 include "fisrtilp.h"
 include "nuage.h"
 include "YOMCST.h"
 include "YOMCST2.h"
!IM : on inclut/initialise les taux de CH4, N2O, CFC11 et CFC12
include "clesphys.h"
include "compbl.h"
include "control.h"
include "comsoil.h"
!
! Configuration de la "physique" de LMDZ a l'aide de la fonction
! GETIN de IOIPSL
!
! LF 05/2001
!

!
! ocean:      type d'ocean (force, slab, couple)
! ok_veget:   type de modele de vegetation
! ok_journe:  sorties journalieres
! ok_hf:  sorties haute frequence
! ok_mensuel: sorties mensuelles
! ok_instan:  sorties instantanees
! ok_ade, ok_aie: apply or not aerosol direct and indirect effects
! bl95_b*: parameters in the formula to link CDNC to aerosol mass conc 
!


! Sortie:
  character (len = 6)  :: ocean
  logical              :: ok_veget, ok_newmicro
  integer              :: iflag_radia
  logical              :: ok_journe, ok_mensuel, ok_instan, ok_hf
  LOGICAL              :: ok_ade, ok_aie, aerosol_couple
  REAL                 :: bl95_b0, bl95_b1
  real                 :: fact_cldcon, facttemps,ratqsbas,ratqshaut
  integer              :: iflag_cldcon
  integer              :: iflag_ratqs

  character (len = 6),SAVE  :: ocean_omp
  logical,SAVE              :: ok_veget_omp, ok_newmicro_omp
  logical,SAVE        :: ok_journe_omp, ok_mensuel_omp, ok_instan_omp, ok_hf_omp        
  LOGICAL,SAVE        :: ok_ade_omp, ok_aie_omp, aerosol_couple_omp
  REAL,SAVE           :: bl95_b0_omp, bl95_b1_omp
  REAL,SAVE           :: freq_ISCCP_omp, ecrit_ISCCP_omp
  real,SAVE           :: fact_cldcon_omp, facttemps_omp,ratqsbas_omp
  real,SAVE           :: ratqshaut_omp
  integer,SAVE        :: iflag_radia_omp
  integer,SAVE        :: iflag_cldcon_omp, ip_ebil_phy_omp
  integer,SAVE        :: iflag_ratqs_omp

! Local
  integer              :: numout = 6
  real                 :: zzz

  real :: seuil_inversion
  real,save :: seuil_inversion_omp

  integer :: iflag_thermals,nsplit_thermals
  integer,SAVE :: iflag_thermals_omp,nsplit_thermals_omp
  real :: tau_thermals
  real,save :: tau_thermals_omp
  integer :: iflag_coupl
  integer :: iflag_clos
  integer :: iflag_wake
  integer,SAVE :: iflag_coupl_omp,iflag_clos_omp,iflag_wake_omp
  integer,SAVE :: iflag_cvl_sigd_omp
  REAL, SAVE :: supcrit1_omp, supcrit2_omp
  INTEGER, SAVE :: iflag_mix_omp
  real, save :: scut_omp, qqa1_omp, qqa2_omp, gammas_omp, Fmax_omp, alphas_omp

  REAL,SAVE :: R_ecc_omp,R_peri_omp,R_incl_omp,solaire_omp,co2_ppm_omp
  REAL,SAVE :: RCO2_omp,CH4_ppb_omp,RCH4_omp,N2O_ppb_omp,RN2O_omp,CFC11_ppt_omp
  REAL,SAVE :: RCFC11_omp,CFC12_ppt_omp,RCFC12_omp,epmax_omp
  LOGICAL,SAVE :: ok_adj_ema_omp
  INTEGER,SAVE :: iflag_clw_omp
  REAL,SAVE :: cld_lc_lsc_omp,cld_lc_con_omp,cld_tau_lsc_omp,cld_tau_con_omp
  REAL,SAVE :: ffallv_lsc_omp, ffallv_con_omp,coef_eva_omp
  LOGICAL,SAVE :: reevap_ice_omp
  INTEGER,SAVE :: iflag_pdf_omp
  REAL,SAVE :: rad_froid_omp, rad_chau1_omp, rad_chau2_omp
  REAL,SAVE :: inertie_sol_omp,inertie_sno_omp,inertie_ice_omp
  REAL,SAVE :: qsol0_omp
  REAL      :: solarlong0
  REAL,SAVE :: solarlong0_omp
  INTEGER,SAVE :: top_height_omp,overlap_omp
  REAL,SAVE :: cdmmax_omp,cdhmax_omp,ksta_omp,ksta_ter_omp
  LOGICAL,SAVE :: ok_kzmin_omp
  REAL, SAVE ::  fmagic_omp, pmagic_omp
  INTEGER,SAVE :: iflag_pbl_omp,lev_histhf_omp,lev_histday_omp,lev_histmth_omp
  CHARACTER*4, SAVE :: type_run_omp
  LOGICAL,SAVE :: ok_isccp_omp
  REAL,SAVE :: lonmin_ins_omp, lonmax_ins_omp, latmin_ins_omp, latmax_ins_omp
  REAL,SAVE :: ecrit_hf_omp, ecrit_day_omp, ecrit_mth_omp, ecrit_reg_omp
  REAL,SAVE :: ecrit_tra_omp
  LOGICAL, SAVE :: ok_slab_sicOBS_omp
  REAL,SAVE :: cvl_corr_omp
  LOGICAL,SAVE :: ok_lic_melt_omp
!
!
    LOGICAL,SAVE :: cycle_diurne_omp,soil_model_omp,new_oliq_omp
    LOGICAL,SAVE :: ok_orodr_omp, ok_orolf_omp, ok_limitvrai_omp
    INTEGER, SAVE :: nbapp_rad_omp, iflag_con_omp
!

!$OMP MASTER
!Config Key  = OCEAN 
!Config Desc = Type d'ocean
!Config Def  = force
!Config Help = Type d'ocean utilise: force, slab,couple
!
  ocean_omp = 'force '
  call getin('OCEAN', ocean_omp)
!
!Config Key  = VEGET 
!Config Desc = Type de modele de vegetation
!Config Def  = .false.
!Config Help = Type de modele de vegetation utilise
!
  ok_veget_omp = .false.
  call getin('VEGET', ok_veget_omp)
!
!Config Key  = OK_journe
!Config Desc = Pour des sorties journalieres 
!Config Def  = .false.
!Config Help = Pour creer le fichier histday contenant les sorties
!              journalieres 
!
  ok_journe_omp = .false.
  call getin('OK_journe', ok_journe_omp)
!
!Config Key  = ok_hf
!Config Desc = Pour des sorties haute frequence
!Config Def  = .false.
!Config Help = Pour creer le fichier histhf contenant les sorties
!              haute frequence ( 3h ou 6h)
!
  ok_hf_omp = .false.
  call getin('ok_hf', ok_hf_omp)
!
!Config Key  = OK_mensuel
!Config Desc = Pour des sorties mensuelles 
!Config Def  = .true.
!Config Help = Pour creer le fichier histmth contenant les sorties
!              mensuelles 
!
  ok_mensuel_omp = .true.
  call getin('OK_mensuel', ok_mensuel_omp)
!
!Config Key  = OK_instan
!Config Desc = Pour des sorties instantanees 
!Config Def  = .false.
!Config Help = Pour creer le fichier histins contenant les sorties
!              instantanees 
!
  ok_instan_omp = .false.
  call getin('OK_instan', ok_instan_omp)
!
!Config Key  = ok_ade
!Config Desc = Aerosol direct effect or not?
!Config Def  = .false.
!Config Help = Used in radlwsw.F
!
  ok_ade_omp = .false.
  call getin('ok_ade', ok_ade_omp)

!
!Config Key  = ok_aie
!Config Desc = Aerosol indirect effect or not?
!Config Def  = .false.
!Config Help = Used in nuage.F and radlwsw.F
!
  ok_aie_omp = .false.
  call getin('ok_aie', ok_aie_omp)

!
!Config Key  = aerosol_couple
!Config Desc = read aerosol in file or calcul by inca
!Config Def  = .false.
!Config Help = Used in physiq.F
!
  aerosol_couple_omp = .false.
  CALL getin('aerosol_couple',aerosol_couple_omp)

!
!Config Key  = bl95_b0
!Config Desc = Parameter in CDNC-maer link (Boucher&Lohmann 1995)
!Config Def  = .false.
!Config Help = Used in nuage.F
!
  bl95_b0_omp = 2.
  call getin('bl95_b0', bl95_b0_omp)

!Config Key  = bl95_b1
!Config Desc = Parameter in CDNC-maer link (Boucher&Lohmann 1995)
!Config Def  = .false.
!Config Help = Used in nuage.F
!
  bl95_b1_omp = 0.2
  call getin('bl95_b1', bl95_b1_omp)

!Config Key  = freq_ISCCP
!Config Desc = Frequence d'appel du simulateur ISCCP en secondes;
!              par defaut 10800, i.e. 3 heures 
!Config Def  = 10800.
!Config Help = Used in ini_histISCCP.h
!
  freq_ISCCP_omp = 10800.
  call getin('freq_ISCCP', freq_ISCCP_omp)
!
!Config Key  = ecrit_ISCCP
!Config Desc = Frequence d'ecriture des resultats du simulateur ISCCP en nombre de jours;
!              par defaut 1., i.e. 1 jour
!Config Def  = 1.
!Config Help = Used in ini_histISCCP.h
!
!
  ecrit_ISCCP_omp = 1.
  call getin('ecrit_ISCCP', ecrit_ISCCP_omp)
!
!Config Key  = ip_ebil_phy
!Config Desc = Niveau de sortie pour les diags bilan d'energie 
!Config Def  = 0
!Config Help = 
!               
  ip_ebil_phy_omp = 0
  call getin('ip_ebil_phy', ip_ebil_phy_omp)
!
!Config Key  = seuil_inversion
!Config Desc = Seuil ur dTh pour le choix entre les schemas de CL
!Config Def  = -0.1
!Config Help = 
!               
  seuil_inversion_omp = -0.1
  call getin('seuil_inversion', seuil_inversion_omp)

!!
!! Constante solaire & Parametres orbitaux & taux gaz effet de serre BEG
!!
!Config Key  = R_ecc
!Config Desc = Excentricite
!Config Def  = 0.016715
!Config Help = 
!               
!valeur AMIP II
  R_ecc_omp = 0.016715
  call getin('R_ecc', R_ecc_omp)
!!
!Config Key  = R_peri
!Config Desc = Equinoxe
!Config Def  = 
!Config Help = 
!               
!
!valeur AMIP II
  R_peri_omp = 102.7
  call getin('R_peri', R_peri_omp)
!!
!Config Key  = R_incl
!Config Desc = Inclinaison
!Config Def  = 
!Config Help = 
!               
!
!valeur AMIP II
  R_incl_omp = 23.441
  call getin('R_incl', R_incl_omp)
!!
!Config Key  = solaire
!Config Desc = Constante solaire en W/m2
!Config Def  = 1365.
!Config Help = 
!               
!
!valeur AMIP II
  solaire_omp = 1365.
  call getin('solaire', solaire_omp)
!!
!Config Key  = co2_ppm
!Config Desc = concentration du gaz carbonique en ppmv
!Config Def  = 348.
!Config Help = 
!               
!
!valeur AMIP II
  co2_ppm_omp = 348.
  call getin('co2_ppm', co2_ppm_omp)
!!
!Config Key  = RCO2
!Config Desc = Concentration du CO2
!Config Def  = co2_ppm * 1.0e-06  * 44.011/28.97
!Config Def  = 348. * 1.0e-06  * 44.011/28.97
!Config Help = 
!               
! RCO2 = 5.286789092164308E-04
!ancienne valeur
  RCO2_omp = co2_ppm_omp * 1.0e-06  * 44.011/28.97 ! pour co2_ppm=348.

!!  call getin('RCO2', RCO2)
!!
!Config Key  = RCH4
!Config Desc = Concentration du CH4
!Config Def  = 1.65E-06* 16.043/28.97
!Config Help = 
!               
!
!valeur AMIP II
!OK  RCH4 = 1.65E-06* 16.043/28.97
! RCH4 = 9.137366240938903E-07
!
!ancienne valeur
! RCH4 = 1.72E-06* 16.043/28.97
!OK call getin('RCH4', RCH4)
  zzz = 1650.
  call getin('CH4_ppb', zzz)
  CH4_ppb_omp = zzz
  RCH4_omp = CH4_ppb_omp * 1.0E-09 * 16.043/28.97
!!
!Config Key  = RN2O
!Config Desc = Concentration du N2O
!Config Def  = 306.E-09* 44.013/28.97
!Config Help = 
!               
!
!valeur AMIP II
!OK  RN2O = 306.E-09* 44.013/28.97
! RN2O = 4.648939592682085E-07
!
!ancienne valeur
! RN2O = 310.E-09* 44.013/28.97
!OK  call getin('RN2O', RN2O)
  zzz=306.
  call getin('N2O_ppb', zzz)
  N2O_ppb_omp = zzz
  RN2O_omp = N2O_ppb_omp * 1.0E-09 * 44.013/28.97
!!
!Config Key  = RCFC11
!Config Desc = Concentration du CFC11
!Config Def  = 280.E-12* 137.3686/28.97
!Config Help = 
!               
!
!OK RCFC11 = 280.E-12* 137.3686/28.97
  zzz = 280.
  call getin('CFC11_ppt',zzz)
  CFC11_ppt_omp = zzz
  RCFC11_omp=CFC11_ppt_omp* 1.0E-12 * 137.3686/28.97
! RCFC11 = 1.327690990680013E-09
!OK call getin('RCFC11', RCFC11)
!!
!Config Key  = RCFC12
!Config Desc = Concentration du CFC12
!Config Def  = 484.E-12* 120.9140/28.97
!Config Help = 
!               
!
!OK RCFC12 = 484.E-12* 120.9140/28.97
  zzz = 484.
  call getin('CFC12_ppt',zzz)
  CFC12_ppt_omp = zzz
  RCFC12_omp = CFC12_ppt_omp * 1.0E-12 * 120.9140/28.97
! RCFC12 = 2.020102726958923E-09
!OK call getin('RCFC12', RCFC12)



!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! FH 2008/05/09 On elimine toutes les clefs physiques dans la dynamique
! Constantes precedemment dans dyn3d/conf_gcm

!Config  Key  = cycle_diurne
!Config  Desc = Cycle ddiurne
!Config  Def  = y
!Config  Help = Cette option permet d'eteidre le cycle diurne.
!Config         Peut etre util pour accelerer le code !
       cycle_diurne_omp = .TRUE.
       CALL getin('cycle_diurne',cycle_diurne_omp)

!Config  Key  = soil_model
!Config  Desc = Modele de sol
!Config  Def  = y
!Config  Help = Choix du modele de sol (Thermique ?)
!Config         Option qui pourait un string afin de pouvoir
!Config         plus de choix ! Ou meme une liste d'options !
       soil_model_omp = .TRUE.
       CALL getin('soil_model',soil_model_omp)

!Config  Key  = new_oliq
!Config  Desc = Nouvelle eau liquide
!Config  Def  = y
!Config  Help = Permet de mettre en route la
!Config         nouvelle parametrisation de l'eau liquide !
       new_oliq_omp = .TRUE.
       CALL getin('new_oliq',new_oliq_omp)

!Config  Key  = ok_orodr
!Config  Desc = Orodr ???
!Config  Def  = y
!Config  Help = Y en a pas comprendre !
!Config         
       ok_orodr_omp = .TRUE.
       CALL getin('ok_orodr',ok_orodr_omp)

!Config  Key  =  ok_orolf
!Config  Desc = Orolf ??
!Config  Def  = y
!Config  Help = Connais pas !
       ok_orolf_omp = .TRUE.
       CALL getin('ok_orolf_omp', ok_orolf_omp)

!Config  Key  = ok_limitvrai
!Config  Desc = Force la lecture de la bonne annee
!Config  Def  = n
!Config  Help = On peut forcer le modele a lire le
!Config         fichier SST de la bonne annee. C'est une tres bonne
!Config         idee, pourquoi ne pas mettre toujours a y ???
       ok_limitvrai_omp = .FALSE.
       CALL getin('ok_limitvrai',ok_limitvrai_omp)

!Config  Key  = nbapp_rad
!Config  Desc = Frequence d'appel au rayonnement
!Config  Def  = 12
!Config  Help = Nombre  d'appels des routines de rayonnements
!Config         par jour.
       nbapp_rad_omp = 12
       CALL getin('nbapp_rad',nbapp_rad_omp)

!Config  Key  = iflag_con
!Config  Desc = Flag de convection
!Config  Def  = 2
!Config  Help = Flag  pour la convection les options suivantes existent :
!Config         1 pour LMD,
!Config         2 pour Tiedtke,
!Config         3 pour CCM(NCAR)  
       iflag_con_omp = 2
       CALL getin('iflag_con',iflag_con_omp)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!
!! Constante solaire & Parametres orbitaux & taux gaz effet de serre END
!!
!! KE
!

!Config key  = cvl_corr
!Config Desc = Facteur multiplication des precip convectives dans KE
!Config Def  = 1.00
!Config Help = 1.02 pour un moderne ou un pre-ind. A ajuster pour un glaciaire
  cvl_corr_omp = 1.00
  CALL getin('cvl_corr', cvl_corr_omp)


!Config Key  = epmax
!Config Desc = Efficacite precip
!Config Def  = 0.993
!Config Help = 
!
  epmax_omp = .993
  call getin('epmax', epmax_omp)
!
!Config Key  = ok_adj_ema
!Config Desc =  
!Config Def  = false
!Config Help = 
!
  ok_adj_ema_omp = .false.
  call getin('ok_adj_ema',ok_adj_ema_omp)
!
!Config Key  = iflag_clw
!Config Desc =  
!Config Def  = 0
!Config Help = 
!
  iflag_clw_omp = 0
  call getin('iflag_clw',iflag_clw_omp)
!
!Config Key  = cld_lc_lsc 
!Config Desc =  
!Config Def  = 2.6e-4
!Config Help = 
!
  cld_lc_lsc_omp = 2.6e-4
  call getin('cld_lc_lsc',cld_lc_lsc_omp)
!
!Config Key  = cld_lc_con
!Config Desc =  
!Config Def  = 2.6e-4
!Config Help = 
!
  cld_lc_con_omp = 2.6e-4
  call getin('cld_lc_con',cld_lc_con_omp)
!
!Config Key  = cld_tau_lsc
!Config Desc =  
!Config Def  = 3600.
!Config Help = 
!
  cld_tau_lsc_omp = 3600.
  call getin('cld_tau_lsc',cld_tau_lsc_omp)
!
!Config Key  = cld_tau_con
!Config Desc =  
!Config Def  = 3600.
!Config Help = 
!
  cld_tau_con_omp = 3600.
  call getin('cld_tau_con',cld_tau_con_omp)
!
!Config Key  = ffallv_lsc
!Config Desc =  
!Config Def  = 1.
!Config Help = 
!
  ffallv_lsc_omp = 1.
  call getin('ffallv_lsc',ffallv_lsc_omp)
!
!Config Key  = ffallv_con
!Config Desc =  
!Config Def  = 1.
!Config Help = 
!
  ffallv_con_omp = 1.
  call getin('ffallv_con',ffallv_con_omp)
!
!Config Key  = coef_eva
!Config Desc =  
!Config Def  = 2.e-5
!Config Help = 
!
  coef_eva_omp = 2.e-5
  call getin('coef_eva',coef_eva_omp)
!
!Config Key  = reevap_ice
!Config Desc =  
!Config Def  = .false.
!Config Help = 
!
  reevap_ice_omp = .false.
  call getin('reevap_ice',reevap_ice_omp)

!Config Key  = iflag_ratqs
!Config Desc =
!Config Def  = 1
!Config Help =
!
  iflag_ratqs_omp = 1
  call getin('iflag_ratqs',iflag_ratqs_omp)

!
!Config Key  = iflag_radia 
!Config Desc =  
!Config Def  = 1
!Config Help = 
!
  iflag_radia_omp = 1
  call getin('iflag_radia',iflag_radia_omp)

!Config Key  = iflag_cldcon 
!Config Desc =  
!Config Def  = 1
!Config Help = 
!
  iflag_cldcon_omp = 1
  call getin('iflag_cldcon',iflag_cldcon_omp)

!
!Config Key  = iflag_pdf 
!Config Desc =  
!Config Def  = 0
!Config Help = 
!
  iflag_pdf_omp = 0
  call getin('iflag_pdf',iflag_pdf_omp)
!
!Config Key  = fact_cldcon
!Config Desc =  
!Config Def  = 0.375
!Config Help = 
!
  fact_cldcon_omp = 0.375
  call getin('fact_cldcon',fact_cldcon_omp)

!
!Config Key  = facttemps
!Config Desc =  
!Config Def  = 1.e-4
!Config Help = 
!
  facttemps_omp = 1.e-4
  call getin('facttemps',facttemps_omp)

!
!Config Key  = ok_newmicro
!Config Desc =  
!Config Def  = .true.
!Config Help = 
!
  ok_newmicro_omp = .true.
  call getin('ok_newmicro',ok_newmicro_omp)
!
!Config Key  = ratqsbas
!Config Desc =  
!Config Def  = 0.01
!Config Help = 
!
  ratqsbas_omp = 0.01
  call getin('ratqsbas',ratqsbas_omp)
!
!Config Key  = ratqshaut
!Config Desc =  
!Config Def  = 0.3
!Config Help = 
!
  ratqshaut_omp = 0.3
  call getin('ratqshaut',ratqshaut_omp)

!
!-----------------------------------------------------------------------
! Longitude solaire pour le calcul de l'ensoleillement en degre
! si on veut imposer la saison. Sinon, solarlong0=-999.999
!Config Key  = solarlong0
!Config Desc =  
!Config Def  = -999.999 
!Config Help = 
!
  solarlong0_omp = -999.999
  call getin('solarlong0',solarlong0_omp)
!
!-----------------------------------------------------------------------
!  Valeur imposee de l'humidite du sol pour le modele bucket.
!Config Key  = qsol0
!Config Desc =  
!Config Def  = -1.
!Config Help = 
!
  qsol0_omp = -1.
  call getin('qsol0',qsol0_omp)
!
!-----------------------------------------------------------------------
!
!Config Key  = inertie_ice
!Config Desc =  
!Config Def  = 2000.
!Config Help = 
!
  inertie_ice_omp = 2000.
  call getin('inertie_ice',inertie_ice_omp)
!
!Config Key  = inertie_sno
!Config Desc =  
!Config Def  = 2000.
!Config Help = 
!
  inertie_sno_omp = 2000.
  call getin('inertie_sno',inertie_sno_omp)
!
!Config Key  = inertie_sol
!Config Desc =  
!Config Def  = 2000.
!Config Help = 
!
  inertie_sol_omp = 2000.
  call getin('inertie_sol',inertie_sol_omp)

!
!Config Key  = rad_froid
!Config Desc =  
!Config Def  = 35.0
!Config Help = 
!
  rad_froid_omp = 35.0
  call getin('rad_froid',rad_froid_omp)

!
!Config Key  = rad_chau1
!Config Desc =  
!Config Def  = 13.0
!Config Help = 
!
  rad_chau1_omp = 13.0
  call getin('rad_chau1',rad_chau1_omp)

!
!Config Key  = rad_chau2
!Config Desc =  
!Config Def  = 9.0
!Config Help = 
!
  rad_chau2_omp = 9.0
  call getin('rad_chau2',rad_chau2_omp)

!
!Config Key  = top_height
!Config Desc =
!Config Def  = 3
!Config Help =
!
  top_height_omp = 3
  call getin('top_height',top_height_omp)

!
!Config Key  = overlap
!Config Desc =
!Config Def  = 3
!Config Help =
!
  overlap_omp = 3
  call getin('overlap',overlap_omp)


!
!
!Config Key  = cdmmax
!Config Desc =
!Config Def  = 1.3E-3
!Config Help =
!
  cdmmax_omp = 1.3E-3
  call getin('cdmmax',cdmmax_omp)

!
!Config Key  = cdhmax
!Config Desc =
!Config Def  = 1.1E-3
!Config Help =
!
  cdhmax_omp = 1.1E-3
  call getin('cdhmax',cdhmax_omp)

!261103
!
!Config Key  = ksta
!Config Desc =
!Config Def  = 1.0e-10
!Config Help =
!
  ksta_omp = 1.0e-10
  call getin('ksta',ksta_omp)

!
!Config Key  = ksta_ter
!Config Desc =
!Config Def  = 1.0e-10
!Config Help =
!
  ksta_ter_omp = 1.0e-10
  call getin('ksta_ter',ksta_ter_omp)

!
!Config Key  = ok_kzmin
!Config Desc =
!Config Def  = .true.
!Config Help =
!
  ok_kzmin_omp = .true.
  call getin('ok_kzmin',ok_kzmin_omp)

!
!Config Key  = fmagic
!Config Desc = additionnal multiplicator factor used for albedo
!Config Def  = 1.
!Config Help = additionnal multiplicator factor used in albedo.F
!
  fmagic_omp = 1.
  call getin('fmagic',fmagic_omp)

!
!Config Key  = pmagic
!Config Desc = additional factor used for albedo
!Config Def  = 0.
!Config Help = additional factor used in albedo.F
!
  pmagic_omp = 0.
  call getin('pmagic',pmagic_omp)


!Config Key = ok_lic_melt
!Config Desc = Prise en compte de la fonte de la calotte dans le bilan d'eau
!Config Def  = .false.
!Config Help = mettre a .false. pour assurer la conservation en eau
  ok_lic_melt_omp = .false.
  call getin('ok_lic_melt', ok_lic_melt_omp)

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! PARAMETER FOR THE PLANETARY BOUNDARY LAYER
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!Config Key  = iflag_pbl
!Config Desc =
!Config Def  = 1
!Config Help =
!
  iflag_pbl_omp = 1
  call getin('iflag_pbl',iflag_pbl_omp)
!
!Config Key  = iflag_thermals
!Config Desc =
!Config Def  = 0
!Config Help =
!
  iflag_thermals_omp = 0
  call getin('iflag_thermals',iflag_thermals_omp)
!
!
!Config Key  = nsplit_thermals
!Config Desc =
!Config Def  = 1
!Config Help =
!
  nsplit_thermals_omp = 1
  call getin('nsplit_thermals',nsplit_thermals_omp)

!Config Key  = tau_thermals
!Config Desc =
!Config Def  = 0.
!Config Help =
!
  tau_thermals_omp = 0.
  call getin('tau_thermals',tau_thermals_omp)

!
!Config Key  = iflag_coupl
!Config Desc =
!Config Def  = 0
!Config Help =
!
  iflag_coupl = 0
  call getin('iflag_coupl',iflag_coupl_omp)

!
!Config Key  = iflag_clos
!Config Desc =  
!Config Def  = 0
!Config Help = 
!
  iflag_clos = 1
  call getin('iflag_clos',iflag_clos_omp)
!
!Config Key  = iflag_cvl_sigd
!Config Desc =  
!Config Def  = 0
!Config Help = 
!
  iflag_cvl_sigd = 0
  call getin('iflag_cvl_sigd',iflag_cvl_sigd_omp)

!Config Key  = iflag_wake
!Config Desc =  
!Config Def  = 0
!Config Help = 
!
  iflag_wake = 0
  call getin('iflag_wake',iflag_wake_omp)

!
!Config Key  = lev_histhf
!Config Desc =
!Config Def  = 1
!Config Help =
!
  lev_histhf_omp = 1
  call getin('lev_histhf',lev_histhf_omp)

!
!Config Key  = lev_histday
!Config Desc =
!Config Def  = 1
!Config Help =
!
  lev_histday_omp = 1
  call getin('lev_histday',lev_histday_omp)

!
!Config Key  = lev_histmth
!Config Desc =
!Config Def  = 2
!Config Help =
!
  lev_histmth_omp = 2
  call getin('lev_histmth',lev_histmth_omp)

  !
!Config Key  = type_run
!Config Desc =
!Config Def  = 'AMIP'/'CFMIP'  ou 'CLIM'/'ENSP'
!Config Help =
!
  type_run_omp = 'AMIP'
  call getin('type_run',type_run_omp)

!
!Config Key  = ok_isccp
!Config Desc =
!Config Def  = .true.
!Config Help =
!
! ok_isccp = .true.
  ok_isccp_omp = .false.
  call getin('ok_isccp',ok_isccp_omp)

!
! coordonnees (lonmin_ins, lonmax_ins, latmin_ins, latmax_ins) pour la zone 
! avec sorties instantannees tous les pas de temps de la physique => "histbilKP_ins.nc"
!
!Config Key  = lonmin_ins
!Config Desc = 100.  
!Config Def  = longitude minimale sorties "bilKP_ins"
!Config Help = 
!
   lonmin_ins_omp = 100.
   call getin('lonmin_ins',lonmin_ins_omp)
!
!Config Key  = lonmax_ins
!Config Desc = 130. 
!Config Def  = longitude maximale sorties "bilKP_ins"
!Config Help =
!
   lonmax_ins_omp = 130.
   call getin('lonmax_ins',lonmax_ins_omp)
!
!Config Key  = latmin_ins
!Config Desc = -20.  
!Config Def  = latitude minimale sorties "bilKP_ins"
!Config Help = 
!
   latmin_ins_omp = -20.
   call getin('latmin_ins',latmin_ins_omp)
!
!Config Key  = latmax_ins
!Config Desc = 20. 
!Config Def  = latitude maximale sorties "bilKP_ins"
!Config Help =
!
   latmax_ins_omp = 20.
   call getin('latmax_ins',latmax_ins_omp)
!
!Config Key  = ecrit_hf
!Config Desc =
!Config Def  = 1./8. !toutes les 3h
!Config Help =
!
  ecrit_hf_omp = 1./8.
  call getin('ecrit_hf',ecrit_hf_omp)
!
!Config Key  = ecrit_day
!Config Desc =
!Config Def  = 1.0 !tous les jours
!Config Help = nombre de jours pour ecriture fichier histday.nc
!
  ecrit_day_omp = 1.0
  call getin('ecrit_day',ecrit_day_omp)
!
!Config Key  = ecrit_mth
!Config Desc =
!Config Def  = 30. !tous les 30jours (1 fois par mois)
!Config Help =
!
  ecrit_mth_omp = 30.
  call getin('ecrit_mth',ecrit_mth_omp)
!
!Config Key  = ecrit_tra
!Config Desc =
!Config Def  = 30. !tous les 30jours (1 fois par mois)
!Config Help =
!
  ecrit_tra_omp = 30.
  call getin('ecrit_tra',ecrit_tra_omp)
!
!Config Key  = ecrit_reg
!Config Desc =
!Config Def  = 0.25  !4 fois par jour
!Config Help =
!
  ecrit_reg_omp = 0.25   !4 fois par jour
  call getin('ecrit_reg',ecrit_reg_omp)
!
!
!
!Config Key  = ok_slab_sicOBS
!Config Desc =
!Config Def  = .true.
!Config Help = Pour faire tourner le slab avec fraction 
!              de glace de mer Observee
!
  ok_slab_sicOBS_omp = .true.
  call getin('ok_slab_sicOBS', ok_slab_sicOBS_omp)
!
!
! PARAMETERS FOR CONVECTIVE INHIBITION BY TROPOS. DRYNESS
!
!Config Key  = supcrit1
!Config Desc =
!Config Def  = .540
!Config Help =
!
  supcrit1_omp = .540
  call getin('supcrit1',supcrit1_omp)

!
!Config Key  = supcrit2
!Config Desc =
!Config Def  = .600
!Config Help =
!
  supcrit2_omp = .600
  call getin('supcrit2',supcrit2_omp)

!
! PARAMETERS FOR THE MIXING DISTRIBUTION
!
!
!Config Key  = iflag_mix
!Config Desc =
!Config Def  = 1
!Config Help =
!
  iflag_mix_omp = 1
  call getin('iflag_mix',iflag_mix_omp)

!
!Config Key  = scut
!Config Desc =
!Config Def  = 0.95
!Config Help =
!
  scut_omp = 0.95
  call getin('scut',scut_omp)

!
!Config Key  = qqa1
!Config Desc =
!Config Def  = 1.0
!Config Help =
!
  qqa1_omp = 1.0
  call getin('qqa1',qqa1_omp)

!
!Config Key  = qqa2
!Config Desc =
!Config Def  = 0.0
!Config Help =
!
  qqa2_omp = 0.0
  call getin('qqa2',qqa2_omp)

!
!Config Key  = gammas
!Config Desc =
!Config Def  = 0.05
!Config Help =
!
  gammas_omp = 0.05
  call getin('gammas',gammas_omp)

!
!Config Key  = Fmax
!Config Desc =
!Config Def  = 0.65
!Config Help =
!
  Fmax_omp = 0.65
  call getin('Fmax',Fmax_omp)

!
!Config Key  = alphas  
!Config Desc =
!Config Def  = -5.
!Config Help =
!
  alphas_omp = -5.
  call getin('alphas',alphas_omp)



!$OMP END MASTER
!$OMP BARRIER

    R_ecc = R_ecc_omp
    R_peri = R_peri_omp
    R_incl = R_incl_omp
    solaire = solaire_omp
    co2_ppm = co2_ppm_omp
    RCO2 = RCO2_omp
    CH4_ppb = CH4_ppb_omp
    RCH4 = RCH4_omp
    N2O_ppb = N2O_ppb_omp
    RN2O = RN2O_omp
    CFC11_ppt = CFC11_ppt_omp
    RCFC11 = RCFC11_omp
    CFC12_ppt = CFC12_ppt_omp
    RCFC12 = RCFC12_omp

    cycle_diurne = cycle_diurne_omp
    soil_model = soil_model_omp
    new_oliq = new_oliq_omp
    ok_orodr = ok_orodr_omp
    ok_orolf = ok_orolf_omp
    ok_limitvrai = ok_limitvrai_omp
    nbapp_rad = nbapp_rad_omp
    iflag_con = iflag_con_omp

    epmax = epmax_omp
    ok_adj_ema = ok_adj_ema_omp
    iflag_clw = iflag_clw_omp
    cld_lc_lsc = cld_lc_lsc_omp
    cld_lc_con = cld_lc_con_omp
    cld_tau_lsc = cld_tau_lsc_omp
    cld_tau_con = cld_tau_con_omp
    ffallv_lsc = ffallv_lsc_omp
    ffallv_con = ffallv_con_omp
    coef_eva = coef_eva_omp
    reevap_ice = reevap_ice_omp
    iflag_pdf = iflag_pdf_omp
    solarlong0 = solarlong0_omp
    qsol0 = qsol0_omp
    inertie_sol = inertie_sol_omp
    inertie_ice = inertie_ice_omp
    inertie_sno = inertie_sno_omp
    rad_froid = rad_froid_omp
    rad_chau1 = rad_chau1_omp
    rad_chau2 = rad_chau2_omp
    top_height = top_height_omp
    overlap = overlap_omp
    cdmmax = cdmmax_omp
    cdhmax = cdhmax_omp
    ksta = ksta_omp
    ksta_ter = ksta_ter_omp
    ok_kzmin = ok_kzmin_omp
    fmagic = fmagic_omp
    pmagic = pmagic_omp
    iflag_pbl = iflag_pbl_omp
    lev_histhf = lev_histhf_omp
    lev_histday = lev_histday_omp
    lev_histmth = lev_histmth_omp

    ocean = ocean_omp
    ok_veget = ok_veget_omp
    ok_newmicro = ok_newmicro_omp
    ok_journe = ok_journe_omp
    ok_hf = ok_hf_omp
    ok_mensuel = ok_mensuel_omp
    ok_instan = ok_instan_omp
    freq_ISCCP = freq_ISCCP_omp
    ecrit_ISCCP = ecrit_ISCCP_omp
    ok_ade = ok_ade_omp
    ok_aie = ok_aie_omp
    aerosol_couple = aerosol_couple_omp
    bl95_b0 = bl95_b0_omp
    bl95_b1 = bl95_b1_omp
    fact_cldcon = fact_cldcon_omp
    facttemps = facttemps_omp
    ratqsbas = ratqsbas_omp
    ratqshaut = ratqshaut_omp
    iflag_radia = iflag_radia_omp
    iflag_cldcon = iflag_cldcon_omp
    iflag_ratqs = iflag_ratqs_omp
    ip_ebil_phy = ip_ebil_phy_omp
    iflag_thermals = iflag_thermals_omp
    nsplit_thermals = nsplit_thermals_omp
    tau_thermals = tau_thermals_omp
    iflag_coupl = iflag_coupl_omp
    iflag_clos = iflag_clos_omp
    iflag_wake = iflag_wake_omp
    iflag_cvl_sigd = iflag_cvl_sigd_omp
    type_run = type_run_omp
    ok_isccp = ok_isccp_omp
    seuil_inversion=seuil_inversion_omp
    lonmin_ins = lonmin_ins_omp
    lonmax_ins = lonmax_ins_omp
    latmin_ins = latmin_ins_omp
    latmax_ins = latmax_ins_omp
    ecrit_hf   = ecrit_hf_omp
    ecrit_day = ecrit_day_omp
    ecrit_mth = ecrit_mth_omp
    ecrit_tra = ecrit_tra_omp
    ecrit_reg = ecrit_reg_omp
    ok_slab_sicOBS = ok_slab_sicOBS_omp
    cvl_corr = cvl_corr_omp
    ok_lic_melt = ok_lic_melt_omp
    supcrit1 = supcrit1_omp
    supcrit2 = supcrit2_omp
    iflag_mix = iflag_mix_omp
    scut = scut_omp
    qqa1 = qqa1_omp
    qqa2 = qqa2_omp
    gammas = gammas_omp
    Fmax = Fmax_omp
    alphas = alphas_omp

!$OMP MASTER

  write(numout,*)' ##############################################'
  write(numout,*)' Configuration des parametres de la physique: '
  write(numout,*)' Config ocean = ', ocean
  write(numout,*)' Config veget = ', ok_veget
  write(numout,*)' Sortie journaliere = ', ok_journe
  write(numout,*)' Sortie haute frequence = ', ok_hf
  write(numout,*)' Sortie mensuelle = ', ok_mensuel
  write(numout,*)' Sortie instantanee = ', ok_instan
  write(numout,*)' Frequence appel simulateur ISCCP, freq_ISCCP =', freq_ISCCP
  write(numout,*)' Frequence appel simulateur ISCCP, ecrit_ISCCP =', ecrit_ISCCP
  write(numout,*)' Sortie bilan d''energie, ip_ebil_phy =', ip_ebil_phy
  write(numout,*)' Excentricite = ',R_ecc
  write(numout,*)' Equinoxe = ',R_peri
  write(numout,*)' Inclinaison =',R_incl
  write(numout,*)' Constante solaire =',solaire
  write(numout,*)' co2_ppm =',co2_ppm
  write(numout,*)' RCO2 = ',RCO2
  write(numout,*)' CH4_ppb =',CH4_ppb,' RCH4 = ',RCH4
  write(numout,*)' N2O_ppb =',N2O_ppb,' RN2O =  ',RN2O
  write(numout,*)' CFC11_ppt=',CFC11_ppt,' RCFC11 =  ',RCFC11
  write(numout,*)' CFC12_ppt=',CFC12_ppt,' RCFC12 =  ',RCFC12
  write(numout,*)' cvl_corr=', cvl_corr
  write(numout,*)'ok_lic_melt=', ok_lic_melt
  write(numout,*)'cycle_diurne=',cycle_diurne
  write(numout,*)'soil_model=',soil_model
  write(numout,*)'new_oliq=',new_oliq
  write(numout,*)'ok_orodr=',ok_orodr
  write(numout,*)'ok_orolf=',ok_orolf
  write(numout,*)'ok_limitvrai=',ok_limitvrai
  write(numout,*)'nbapp_rad=',nbapp_rad
  write(numout,*)'iflag_con=',iflag_con
  write(numout,*)' epmax = ', epmax
  write(numout,*)' ok_adj_ema = ', ok_adj_ema
  write(numout,*)' iflag_clw = ', iflag_clw
  write(numout,*)' cld_lc_lsc = ', cld_lc_lsc
  write(numout,*)' cld_lc_con = ', cld_lc_con
  write(numout,*)' cld_tau_lsc = ', cld_tau_lsc
  write(numout,*)' cld_tau_con = ', cld_tau_con
  write(numout,*)' ffallv_lsc = ', ffallv_lsc
  write(numout,*)' ffallv_con = ', ffallv_con
  write(numout,*)' coef_eva = ', coef_eva
  write(numout,*)' reevap_ice = ', reevap_ice
  write(numout,*)' iflag_pdf = ', iflag_pdf
  write(numout,*)' iflag_cldcon = ', iflag_cldcon
  write(numout,*)' iflag_radia = ', iflag_radia
  write(numout,*)' iflag_ratqs = ', iflag_ratqs
  write(numout,*)' seuil_inversion = ', seuil_inversion
  write(numout,*)' fact_cldcon = ', fact_cldcon
  write(numout,*)' facttemps = ', facttemps
  write(numout,*)' ok_newmicro = ',ok_newmicro 
  write(numout,*)' ratqsbas = ',ratqsbas 
  write(numout,*)' ratqshaut = ',ratqshaut 
  write(numout,*)' top_height = ',top_height 
  write(numout,*)' overlap = ',overlap 
  write(numout,*)' cdmmax = ',cdmmax 
  write(numout,*)' cdhmax = ',cdhmax 
  write(numout,*)' ksta = ',ksta 
  write(numout,*)' ksta_ter = ',ksta_ter 
  write(numout,*)' ok_kzmin = ',ok_kzmin 
  write(numout,*)' fmagic = ',fmagic
  write(numout,*)' pmagic = ',pmagic
  write(numout,*)' ok_ade = ',ok_ade
  write(numout,*)' ok_aie = ',ok_aie
  write(numout,*)' aerosol_couple = ', aerosol_couple
  write(numout,*)' bl95_b0 = ',bl95_b0
  write(numout,*)' bl95_b1 = ',bl95_b1
  write(numout,*)' lev_histhf = ',lev_histhf 
  write(numout,*)' lev_histday = ',lev_histday 
  write(numout,*)' lev_histmth = ',lev_histmth 
  write(numout,*)' iflag_pbl = ', iflag_pbl
  write(numout,*)' iflag_thermals = ', iflag_thermals
  write(numout,*)' type_run = ',type_run 
  write(numout,*)' ok_isccp = ',ok_isccp 
  WRITE(numout,*)' solarlong0 = ', solarlong0
  write(numout,*)' qsol0 = ', qsol0
  write(numout,*)' inertie_sol = ', inertie_sol
  write(numout,*)' inertie_ice = ', inertie_ice
  write(numout,*)' inertie_sno = ', inertie_sno
  write(numout,*)' supcrit1 = ', supcrit1
  write(numout,*)' supcrit2 = ', supcrit2
  write(numout,*)' iflag_mix = ', iflag_mix
  write(numout,*)' scut = ', scut
  write(numout,*)' qqa1 = ', qqa1
  write(numout,*)' qqa2 = ', qqa2
  write(numout,*)' gammas = ', gammas
  write(numout,*)' Fmax = ', Fmax
  write(numout,*)' alphas = ', alphas

  write(numout,*)' lonmin lonmax latmin latmax bilKP_ins =',&
 & lonmin_ins, lonmax_ins, latmin_ins, latmax_ins
  write(numout,*)' ecrit_ hf, day, mth, reg, tra, ISCCP',&
 & ecrit_hf, ecrit_day, ecrit_mth, ecrit_reg, ecrit_tra, ecrit_ISCCP

!$OMP END MASTER

  return
  
  end subroutine conf_phys

!
!#################################################################
!

   subroutine conf_interface(tau_calv)

   use IOIPSL
   implicit none

! Configuration de l'interace atm/surf
!
! tau_calv:    temps de relaxation pour la fonte des glaciers

  REAL          :: tau_calv
  REAL,SAVE     :: tau_calv_omp

! Local
  integer              :: numout = 6
!
!Config Key  = tau_calv
!Config Desc = temps de relaxation pour fonte des glaciers en jours
!Config Def  = 1 an 
!Config Help = 
!
  tau_calv_omp = 360.*10.
!$OMP MASTER
  call getin('tau_calv',tau_calv_omp)
!$OMP END MASTER
!$OMP BARRIER

  tau_calv=tau_calv_omp
  
!$OMP MASTER
  write(numout,*)' ##############################################'
  WRITE(numout,*)' Configuration de l''interface atm/surfaces  : '
  WRITE(numout,*)' tau_calv = ',tau_calv
!$OMP END MASTER

  return

  end subroutine conf_interface
