      MODULE phys_state_var_mod
! Variables sauvegardees pour le startphy.nc
!======================================================================
!
!
!======================================================================
! Declaration des variables
      USE dimphy
      REAL, SAVE :: dtime, co2_ppm_etat0, solaire_etat0
      REAL, ALLOCATABLE, SAVE :: rlat(:), rlon(:), pctsrf(:,:)
      REAL, ALLOCATABLE, SAVE :: ftsol(:,:)
      character(len=6), SAVE :: ocean
      logical, SAVE :: ok_veget 
      REAL, ALLOCATABLE, SAVE :: falb1(:,:), falb2(:,:)
      REAL, ALLOCATABLE, SAVE :: rain_fall(:), snow_fall(:)
      REAL, ALLOCATABLE, SAVE :: solsw(:), sollw(:)
      REAL, ALLOCATABLE, SAVE :: radsol(:)
!clesphy0 param physiq
!
! Parametres de l'Orographie a l'Echelle Sous-Maille (OESM):
!
      REAL, ALLOCATABLE, SAVE :: zmea(:), zstd(:), zsig(:), zgam(:)
      REAL, ALLOCATABLE, SAVE :: zthe(:), zpic(:), zval(:)
!     REAL tabcntr0(100)
      REAL, ALLOCATABLE, SAVE :: rugoro(:)
      REAL, ALLOCATABLE, SAVE :: t_ancien(:,:), q_ancien(:,:)
      LOGICAL, SAVE :: ancien_ok
      REAL, ALLOCATABLE, SAVE :: clwcon(:,:),rnebcon(:,:)
      REAL, ALLOCATABLE, SAVE :: ratqs(:,:)
      REAL, ALLOCATABLE, SAVE :: pbl_tke(:,:,:) ! turb kinetic energy
      REAL, ALLOCATABLE, SAVE :: zmax0(:), f0(:) ! 

CONTAINS

!======================================================================
SUBROUTINE phys_state_var_init
use dimphy
IMPLICIT NONE
#include "indicesol.h"

      ALLOCATE( rlat(klon))
      ALLOCATE( rlon(klon)) 
      ALLOCATE( pctsrf(klon,nbsrf))
      ALLOCATE( ftsol(klon,nbsrf))
      ALLOCATE( falb1(klon,nbsrf))
      ALLOCATE( falb2(klon,nbsrf))
      ALLOCATE( rain_fall(klon) )
      ALLOCATE( snow_fall(klon) )
      ALLOCATE(solsw(klon), sollw(klon))
      ALLOCATE( radsol(klon))
      ALLOCATE( zmea(klon), zstd(klon), zsig(klon), zgam(klon) )
      ALLOCATE( zthe(klon), zpic(klon), zval(klon) )

      ALLOCATE( rugoro(klon))
      ALLOCATE( t_ancien(klon,klev), q_ancien(klon,klev))
      ALLOCATE( clwcon(klon,klev),rnebcon(klon,klev))
      ALLOCATE( ratqs(klon,klev))
      ALLOCATE(pbl_tke(klon,klev+1,nbsrf))
      ALLOCATE(zmax0(klon), f0(klon))

END SUBROUTINE phys_state_var_init

!======================================================================
SUBROUTINE phys_state_var_end
use dimphy
IMPLICIT NONE
#include "indicesol.h"
!     deallocate(t_seri,q_seri,ql_seri,qs_seri)

      deallocate( rlat, rlon, pctsrf, ftsol, falb1, falb2 )
      deallocate( rain_fall, snow_fall, solsw, sollw, radsol )
      deallocate( zmea, zstd, zsig, zgam )
      deallocate( zthe, zpic, zval )
      deallocate( rugoro, t_ancien, q_ancien, clwcon, rnebcon )
      deallocate( ratqs, pbl_tke )
      deallocate( zmax0, f0 )

END SUBROUTINE phys_state_var_end

      END MODULE phys_state_var_mod
