!
! $Header$
!
MODULE surf_landice_mod
  
  USE dimphy
  USE surface_data,     ONLY : ocean, calice, calsno
  USE fonte_neige_mod,  ONLY : fonte_neige, run_off_lic
  USE cpl_mod,          ONLY : cpl_send_landice_fields
  USE calcul_fluxs_mod, ONLY : calcul_fluxs

  IMPLICIT NONE

CONTAINS
!
!****************************************************************************************
!
  SUBROUTINE surf_landice(itime, dtime, knon, knindex, &
       tsurf, p1lay, tq_cdrag, precip_rain, precip_snow, temp_air, spechum, &
       petAcoef, peqAcoef, petBcoef, peqBcoef, &
       ps, u1_lay, v1_lay, rugoro, pctsrf, &
       radsol, snow, qsurf, qsol, agesno, &
       tsoil, z0_new, alblw, evap, fluxsens, fluxlat, &
       tsurf_new, alb_new, dflux_s, dflux_l, pctsrf_lic)

    INCLUDE "indicesol.h"
    INCLUDE "dimsoil.h"
    INCLUDE "YOMCST.h"
    INCLUDE "clesphys.h"

! Input variables 
!****************************************************************************************
    INTEGER, INTENT(IN)                           :: itime, knon
    INTEGER, DIMENSION(klon), INTENT(in)          :: knindex
    REAL, INTENT(in)                              :: dtime
    REAL, DIMENSION(klon), INTENT(IN)             :: tsurf
    REAL, DIMENSION(klon), INTENT(IN)             :: p1lay
    REAL, DIMENSION(klon), INTENT(IN)             :: tq_cdrag
    REAL, DIMENSION(klon), INTENT(IN)             :: precip_rain, precip_snow
    REAL, DIMENSION(klon), INTENT(IN)             :: temp_air, spechum
    REAL, DIMENSION(klon), INTENT(IN)             :: petAcoef, peqAcoef
    REAL, DIMENSION(klon), INTENT(IN)             :: petBcoef, peqBcoef
    REAL, DIMENSION(klon), INTENT(IN)             :: ps
    REAL, DIMENSION(klon), INTENT(IN)             :: u1_lay, v1_lay
    REAL, DIMENSION(klon), INTENT(IN)             :: rugoro
    REAL, DIMENSION(klon,nbsrf), INTENT(IN)       :: pctsrf

! In/Output variables
!****************************************************************************************
    REAL, DIMENSION(klon), INTENT(INOUT)          :: radsol
    REAL, DIMENSION(klon), INTENT(INOUT)          :: snow, qsol
    REAL, DIMENSION(klon), INTENT(INOUT)          :: agesno
    REAL, DIMENSION(klon, nsoilmx), INTENT(INOUT) :: tsoil

! Output variables
!****************************************************************************************
    REAL, DIMENSION(klon), INTENT(OUT)            :: qsurf
    REAL, DIMENSION(klon), INTENT(OUT)            :: z0_new
    REAL, DIMENSION(klon), INTENT(OUT)            :: alblw
    REAL, DIMENSION(klon), INTENT(OUT)            :: evap, fluxsens, fluxlat
    REAL, DIMENSION(klon), INTENT(OUT)            :: tsurf_new, alb_new
    REAL, DIMENSION(klon), INTENT(OUT)            :: dflux_s, dflux_l      
    REAL, DIMENSION(klon), INTENT(OUT)            :: pctsrf_lic

! Local variables
!****************************************************************************************
    REAL, DIMENSION(klon)    :: soilcap, soilflux
    REAL, DIMENSION(klon)    :: cal, beta, dif_grnd
    REAL, DIMENSION(klon)    :: zfra, alb_neig

! End definition
!****************************************************************************************
!
! Initialize output variables
    alblw(:) =  999999.
    alb_new(:) = 999999.


!****************************************************************************************
! Soil calculations
! 
!****************************************************************************************
    IF (soil_model) THEN 
       CALL soil(dtime, is_lic, knon, snow, tsurf, tsoil, soilcap, soilflux)
       cal(1:knon) = RCPD / soilcap(1:knon)
       radsol(1:knon)  = radsol(1:knon) + soilflux(1:knon)
    ELSE 
       cal = RCPD * calice
       WHERE (snow > 0.0) cal = RCPD * calsno
    ENDIF


!****************************************************************************************
! Calulate fluxes
!
!****************************************************************************************
    beta(:) = 1.0
    dif_grnd(:) = 0.0

    CALL calcul_fluxs(knon, is_lic, dtime, &
         tsurf, p1lay, cal, beta, tq_cdrag, ps, &
         precip_rain, precip_snow, snow, qsurf,  &
         radsol, dif_grnd, temp_air, spechum, u1_lay, v1_lay, &
         petAcoef, peqAcoef, petBcoef, peqBcoef, &
         tsurf_new, evap, fluxlat, fluxsens, dflux_s, dflux_l)


!****************************************************************************************
! Calculate snow height, age, run-off,..
!    
!****************************************************************************************
    CALL fonte_neige( knon, is_lic, knindex, dtime, &
         tsurf, precip_rain, precip_snow, &
         snow, qsol, tsurf_new, evap)


!****************************************************************************************
! Calculate albedo
!
!****************************************************************************************
    CALL albsno(klon,knon,dtime,agesno(:),alb_neig(:), precip_snow(:))  
    WHERE (snow(1 : knon) .LT. 0.0001) agesno(1 : knon) = 0.
    zfra(1:knon) = MAX(0.0,MIN(1.0,snow(1:knon)/(snow(1:knon)+10.0)))
    alb_new(1:knon)  = alb_neig(1:knon)*zfra(1:knon) + &
         0.6 * (1.0-zfra(1:knon))
!
!IM: plusieurs choix/tests sur l'albedo des "glaciers continentaux"
!       alb_new(1 : knon)  = 0.6 !IM cf FH/GK 
!       alb_new(1 : knon)  = 0.82
!       alb_new(1 : knon)  = 0.77 !211003 Ksta0.77
!       alb_new(1 : knon)  = 0.8 !KstaTER0.8 & LMD_ARMIP5
!IM: KstaTER0.77 & LMD_ARMIP6    

! Attantion: alb_new and alblw are the same!
    alb_new(1:knon)  = 0.77
    alblw(1:knon)    = alb_new(1:knon)


!****************************************************************************************
! Rugosity
!
!****************************************************************************************
    z0_new(:) = rugoro(:)


!****************************************************************************************
! Return the pourcentage for this sub-surface
!
!****************************************************************************************
    pctsrf_lic(:) = pctsrf(:,is_lic)
    

!****************************************************************************************
! Send run-off on land-ice to coupler if coupled ocean.
! run_off_lic has been calculated in fonte_neige
!
!****************************************************************************************
    IF (ocean=='couple') THEN
       CALL cpl_send_landice_fields(itime, knon, knindex, run_off_lic)
    ENDIF


  END SUBROUTINE surf_landice
!
!****************************************************************************************
!
END MODULE surf_landice_mod



