c
c $Header$
c
      IF (ok_mensuel) THEN
c$OMP MASTER
c
       zstophy = dtime
       zstomth = ecrit_mth                       !valeurs mensuelles "instantannees"
       zstorad = dtime * FLOAT(radpas)    !variables stockees toutes les 2h
       zstohf = ecrit_hf                         !variables stockees toutes les 6h
       zout = ecrit_mth                          !frequence des sorties : 1 val. par mois
c
         idayref = day_ref
         CALL ymds2ju(annee_ref, 1, idayref, 0.0, zjulian)
c
cym         CALL gr_fi_ecrit(1,klon,iim,jjmp1,rlon,zx_lon)
cym         DO i = 1, iim
cym            zx_lon(i,1) = rlon(i+1)
cym            zx_lon(i,jjmp1) = rlon(i+1)
cym         ENDDO
         DO ll=1,klev
            znivsig(ll)=float(ll)
         ENDDO
cym         CALL gr_fi_ecrit(1,klon,iim,jjmp1,rlat,zx_lat)
cym         CALL histbeg("histmth.nc", iim,zx_lon(:,1), jjmp1,zx_lat(1,:),
cym     .                 1,iim,1,jjmp1, itau_phy, zjulian, dtime, 
cym     .                 nhori, nid_mth)

           CALL histbeg_phy("histmth",itau_phy, zjulian, dtime, 
     .                 nhori, nid_mth)
     
       write(*,*)'Mensuel ', itau_phy, zjulian
         CALL histvert(nid_mth, "presnivs", "Vertical levels", "mb",
     .                 klev, presnivs/100., nvert)
c
!        CALL histdef(nid_mth, "dtthe", "Dry adjust. dT", "K/s",
!    .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
!    .                "ave(X)", zstophy,zout)
!
!        CALL histdef(nid_mth, "dtcon", "Convection dT", "K/s",
!    .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
!    .                "ave(X)", zstophy,zout)
c
      IF(type_run.EQ."CLIM".OR.type_run.EQ."ENSP") THEN
c
      IF(lev_histmth.GE.1) THEN
c
         CALL histdef(nid_mth, "phis", 
     .                "Surface geop. height", "m2/s2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "once",  zstophy,zout)
c
         CALL histdef(nid_mth, "aire", "Grid area", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "once",  zstophy,zout)
c
         CALL histdef(nid_mth, "pourc_"//clnsurf(is_ter), 
     .         "% "//clnsurf(is_ter), "%",  
     .         iim,jj_nb,nhori, 1,1,1, -99, 32,
     .         "once", zstophy,zout)
c
         CALL histdef(nid_mth, "fract_"//clnsurf(is_ter), 
     .         "Fraction "//clnsurf(is_ter), "1",  
     .         iim,jj_nb,nhori, 1,1,1, -99, 32,
     .         "once", zstophy,zout)
c
c Champs 2D:
c
         CALL histdef(nid_mth, "slp", "Sea Level Pressure", "Pa",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "tsol", "Surface Temperature", "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "t2m", "Temperature 2m", "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
c ENSEMBLES BEG
c        CALL histdef(nid_mth, "t2m_min", "Temp. 2m min.",
c    .                "K",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32,
c    .                t2mincels, zstophy,zout)
c
c        CALL histdef(nid_mth, "t2m_max", "Temp. 2m max.",
c    .                "K",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32,
c    .                t2maxcels, zstophy,zout)
c
c        CALL histdef(nid_mth, "tsoil", "Sfce soil Temperature",
c    .                "K",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32,
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "wind10m","10-m wind speed","m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "sicf", "Sea-ice fraction", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
c ENSEMBLES END
         CALL histdef(nid_mth, "q2m", "Specific humidity 2m", "kg/kg",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "u10m", "Vent zonal 10m", "m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "v10m", "Vent meridien 10m", "m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "psol", "Surface Pressure", "Pa",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "qsurf", "Surface Air humidity", "kg/kg",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
      if (.not. ok_veget) then
         CALL histdef(nid_mth, "qsol", "Soil watter content", "mm",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
      endif
c
c        CALL histdef(nid_mth, "ndayrain", 
c    .                "Number of day with rain (liq+sol)", "-",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
c    .                "inst(X)", zstomth,zout)
c
         CALL histdef(nid_mth, "precip", "Precipitation Totale liq+sol", 
     .                "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "plul", "Large-scale Precip.", 
     .   "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "pluc", "Convective Precip.", 
     .   "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "snow", "Snow fall", "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
c        CALL histdef(nid_mth, "snow_mass", "Snow Mass", "kg/m2",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "evap", "Evaporation", "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "tops", "Solar rad. at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "tops0", "CS Solar rad. at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "topl", "IR rad. at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "topl0", "IR rad. at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWupTOA", "SWup at TOA","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWupTOAclr", 
     .                "SWup clear sky at TOA","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdnTOA", "SWdn at TOA","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdnTOAclr", 
     .                "SWdn clear sky at TOA","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWup200", "SWup at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWup200clr", 
     .                "SWup clear sky at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdn200", "SWdn at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdn200clr", 
     .                "SWdn clear sky at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "LWup200", "LWup at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "LWup200clr", 
     .                "LWup clear sky at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "LWdn200", "LWdn at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "LWdn200clr", 
     .                "LWdn clear sky at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "sols", "Solar rad. at surf.", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "sols0", "Solar rad. at surf.", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "soll", "IR rad. at surface", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "radsol", "Rayonnement au sol", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "soll0", "IR rad. at surface", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWupSFC", "SWup at surface","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWupSFCclr", 
     .                "SWup clear sky at surface","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdnSFC", "SWdn at surface","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdnSFCclr", 
     .                "SWdn clear sky at surface","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"LWupSFC","Upwd. IR rad. at surface", 
     .                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"LWdnSFC","Down. IR rad. at surface", 
     .                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"LWupSFCclr",
     .                "CS Upwd. IR rad. at surface", 
     .                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"LWdnSFCclr",
     .                "Down. CS IR rad. at surface", 
     .                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "bils", "Surf. total heat flux", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "sens", "Sensible heat flux", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "fder", "Heat flux derivation", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
c Effets des aerosols
c
      IF (ok_ade.OR.ok_aie) THEN
         CALL histdef(nid_mth, "topsad", "ADE at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "solsad", "ADE at sfc", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "topsai", "AIE at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "solsai", "AIE at sfc", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
      endif
c
c          CALL histdef(nid_mth, "frtu", "Zonal wind stress", "Pa",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
c    .                "ave(X)", zstophy,zout)
c
c        CALL histdef(nid_mth, "frtv", "Meridional wind stress", "Pa",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ffonte","Thermal flux for snow melting",
     .                "W/m2",iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "fqcalving","Ice Calving",
     .                "kg/m2/s",iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "fqfonte","Land ice melt",
     .                "kg/m2/s",iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)

         DO nsrf = 1, nbsrf
           call histdef(nid_mth, "taux_"//clnsurf(nsrf), 
     $         "Zonal wind stress"//clnsurf(nsrf), "Pa",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)

           call histdef(nid_mth, "tauy_"//clnsurf(nsrf), 
     $         "Meridional wind stress "//clnsurf(nsrf), "Pa",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
         ENDDO
c
         DO nsrf = 1, nbsrf
C
          IF(nsrf.GE.2) THEN
           call histdef(nid_mth, "pourc_"//clnsurf(nsrf), 
     $         "% "//clnsurf(nsrf), "%",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
           call histdef(nid_mth, "fract_"//clnsurf(nsrf), 
     $         "Fraction "//clnsurf(nsrf), "1",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
          ENDIF !nsrf.GT.2
C
           call histdef(nid_mth, "tsol_"//clnsurf(nsrf), 
     $         "Temperature "//clnsurf(nsrf), "K",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "sens_"//clnsurf(nsrf), 
     $         "Sensible heat flux "//clnsurf(nsrf), "W/m2",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
           call histdef(nid_mth, "lat_"//clnsurf(nsrf), 
     $         "Latent heat flux "//clnsurf(nsrf), "W/m2",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "flw_"//clnsurf(nsrf),
     $         "LW "//clnsurf(nsrf), "W/m2",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
           call histdef(nid_mth, "fsw_"//clnsurf(nsrf),
     $         "SW "//clnsurf(nsrf), "W/m2",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "wbils_"//clnsurf(nsrf),
     $         "Bilan sol "//clnsurf(nsrf), "W/m2",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "wbilo_"//clnsurf(nsrf),
     $         "Bilan eau "//clnsurf(nsrf), "kg/(m2*s)",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
cIM 250105 BEG
          IF(1.EQ.0) THEN
C
           call histdef(nid_mth, "evapour_"//clnsurf(nsrf),
     $         "Evap*pourc "//clnsurf(nsrf), "kg/(s*m2)",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "prepour_"//clnsurf(nsrf),
     $         "Precip*pourc "//clnsurf(nsrf), "kg/(s*m2)",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
          ENDIF !(1.EQ.0) THEN
cIM 250105 END
C
         END DO
c
         CALL histdef(nid_mth, "cdrm", "Momentum drag coef.", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cdrh", "Heat drag coef.", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cldl", "Low-level cloudiness", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cldm", "Mid-level cloudiness", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cldh", "High-level cloudiness", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cldt", "Total cloudiness", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"cldq","Cloud liquid water path","kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"lwp","Cloud water path","kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"iwp","Cloud ice water path","kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ue", "Zonal energy transport", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ve", "Merid energy transport", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "uq", "Zonal humidity transport", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "vq", "Merid humidity transport", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
cKE43
      IF(iflag_con.GE.3) THEN ! sb
c
         CALL histdef(nid_mth, "cape", "Conv avlbl pot ener", "J/kg",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "pbase", "Cld base pressure", "mb",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ptop", "Cld top pressure", "mb",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "fbase", "Cld base mass flux", "kg/m2/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "prw", "Precipitable water", "kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
      ENDIF !iflag_con .GE. 3
c34EK
cIM cf. AM 081204 BEG
c34EK
c HBTM2
         CALL histdef(nid_mth, "s_pblh", "Boundary Layer Height", "m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_pblt", "t at Boundary Layer Height",
     .                "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_lcl", "Condensation level", "m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_capCL", "Conv avlbl pot ener 
     .                for ABL", "J/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_oliqCL", "Liq Water in BL", "kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_cteiCL", "Instability criteria 
     .                (ABL)", "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_therm", "Exces du thermique", "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_trmb1", "deep_cape(HBTM2)", "J/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_trmb2", "inhibition (HBTM2)", "J/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_trmb3", "Point Omega (HBTM2)", "m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
cIM cf. AM 081204 END
c
c Champs interpolles sur des niveaux de pression
         DO k=1, nlevSTD
c
c        bb=clevSTD(k)
c
c        IF(k.GE.2) THEN
         IF(k.GE.2.AND.k.LE.12) bb2=clevSTD(k)
         IF(k.GE.13.AND.k.LE.17) bb3=clevSTD(k)
c         aa=clevSTD(k)
c         bb=aa(1:lnblnk1(aa))
c        ENDIF
c
      IF(bb2.EQ."850".OR.bb2.EQ."700".OR.
     $   bb2.EQ."500".OR.bb2.EQ."200") THEN
c
          CALL histdef(nid_mth, "u"//bb2,
     .                 "Zonal wind "//bb2//"mb","m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "inst(X)", zout,zout)
c
          CALL histdef(nid_mth, "v"//bb2,
     .                 "Meridional wind "//bb2//"mb","m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "inst(X)", zout,zout)
c
          CALL histdef(nid_mth, "w"//bb2,
     .                 "Vertical wind "//bb2//"mb","m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "inst(X)", zout,zout)
c
          CALL histdef(nid_mth, "phi"//bb2,
     .                 "Geopotential "//bb2//"mb","m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "inst(X)", zout,zout)
c
        ENDIF !(bb2.EQ."850".OR.bb2.EQ."700".OR.
       ENDDO
c
cIM diagnostiques flux ocean-atm ou ocean-glace de mer
cIM pour utilisation dans un modele de "slab" ocean
c
       CALL histdef(nid_mth, "fluxo",
     .              "Flux turbulents ocean-atmosphere", "W/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       CALL histdef(nid_mth, "fluxg",
     .              "Flux turbulents ocean-glace de mer","W/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       CALL histdef(nid_mth, "t_oce_sic",
     .              "Temp. mixte oce-sic","K",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       IF (OCEAN.EQ.'force ') THEN
c
        CALL histdef(nid_mth, "lmt_bils",
     .       "Bilan au sol atmosphere forcee", "W/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       ELSE IF (OCEAN.EQ.'slab  ') THEN
c
        CALL histdef(nid_mth, "slab_bils",
     .       "Bilan au sol Slab", "W/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
        CALL histdef(nid_mth, "tslab", "Slab SST ", "K",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
        CALL histdef(nid_mth, "seaice", "Slab seaice", "kg/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
        CALL histdef(nid_mth, "siceh", "Slab seaice height", "m",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       ENDIF
c
      ENDIF !lev_histmth.GE.1
c
      IF(lev_histmth.GE.2) THEN
c
c Champs 3D:
c
c
         CALL histdef(nid_mth,"lwcon","Cloud liquid water content",
     .                "kg/kg",
     .                iim,jj_nb,nhori, klev,1,klev, nvert, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"iwcon","Cloud ice water content","kg/kg",
     .                iim,jj_nb,nhori, klev,1,klev, nvert, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "temp", "Air temperature", "K",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ovap", "Specific humidity", "kg/kg",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
c        CALL histdef(nid_mth,"wvap","Water vapor mixing ratio","kg/kg",
c    .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "geop", "Geopotential height", "m2/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "vitu", "Zonal wind", "m/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "vitv", "Meridional wind", "m/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "vitw", "Vertical wind", "Pa/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "pres", "Air pressure", "Pa",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
        CALL histdef(nid_mth, "rneb", "Cloud fraction", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "rnebcon", "Convective Cloud Fraction"
     .                , "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "rhum", "Relative humidity", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ozone", "Ozone concentration", "ppmv",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "upwd", "saturated updraft", "kg/m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtphy", "Physics dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqphy", "Physics dQ", "(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
      ENDIF !lev_histmth.GE.2
c
      IF(lev_histmth.GE.3) THEN
c
        DO nsrf=1, nbsrf
c
           call histdef(nid_mth, "albe_"//clnsurf(nsrf), 
     $         "Albedo surf. "//clnsurf(nsrf), "-",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
           call histdef(nid_mth, "rugs_"//clnsurf(nsrf), 
     $         "Latent heat flux "//clnsurf(nsrf), "W/m2",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ages_"//clnsurf(nsrf), "Snow age","day",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
	 ENDDO !nsrf=1, nbsrf
c
         CALL histdef(nid_mth, "albs", "Surface albedo", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "albslw", "Surface albedo LW", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
      ENDIF !lev_histmth.GE.3
c
      IF(lev_histmth.GE.4) THEN
c
!FH Sorties pour la couche limite
      if (iflag_pbl>1) then
         CALL histdef(nid_mth, "tke","TKE","m2/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "tke_max","TKE max","m2/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "t_max(X)", zstophy,zout)
      endif
c
         CALL histdef(nid_mth, "kz","Kz melange","m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "kz_max","Kz melange max","m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "t_max(X)", zstophy,zout)


         CALL histdef(nid_mth, "clwcon", 
     .                "Convective Cloud Liquid water content"
     .                , "kg/kg",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"Ma","undilute adiab updraft","kg/m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dnwd", "saturated downdraft","kg/m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dnwd0", "unsat. downdraft", "kg/m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtdyn", "Dynamics dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqdyn", "Dynamics dQ", "(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtcon", "Convection dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c


c
c        CALL histdef(nid_mth, "ducon", "Convection du", "m/s2",
c    .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqcon", "Convection dQ", "(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtlsc", "Condensation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtlschr",
     $     "Large-scale condensational heating rate", "K/s",iim,jj_nb
     $     ,nhori, klev,1,klev,nvert, 32,"ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqlsc", "Condensation dQ", "(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtvdf", "Boundary-layer dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqvdf","Boundary-layer dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dteva", "Reevaporation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqeva","Reevaporation dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)

         CALL histdef(nid_mth, "ptconv", "POINTS CONVECTIFS"," ",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)

         CALL histdef(nid_mth, "ratqs", "RATQS"," ",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)

c
         CALL histdef(nid_mth, "dtthe", "Dry adjust. dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)

         CALL histdef(nid_mth,"dqthe","Dry adjust. dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtajs", "Dry adjust. dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)

         CALL histdef(nid_mth,"dqajs","Dry adjust. dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtswr", "SW radiation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtsw0", "CS SW radiation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtlwr", "LW radiation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"dtlw0","CS LW radiation dT","K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtec", "Cinetic dissip dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "duvdf", "Boundary-layer dU", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dvvdf", "Boundary-layer dV", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         IF (ok_orodr) THEN
         CALL histdef(nid_mth, "duoro", "Orography dU", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dvoro", "Orography dV", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         ENDIF
C
         IF (ok_orolf) THEN
         CALL histdef(nid_mth, "dulif", "Orography dU", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dvlif", "Orography dV", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         ENDIF
C
#if defined(INCA_AER) && defined(CPP_COUPLE)
         CALL histdef(nid_mth, "tau", "cloud opt thickness", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "CCM1", "CCM1", "",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "CCM2", "CCM2", "",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "taupi", "cloud opt thickn. (pi)", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "cldemi", "emissivite IR", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_ZERO", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_AER", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_NAT", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_AD", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_AI", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOACS_ZERO", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOACS_AER", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOACS_AD", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOACS_NAT", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
#endif
#ifndef INCA
         if (nqmax.GE.3) THEN
           DO iq=3,nqmax
             iiq=niadv(iq)
             CALL histdef(nid_mth, tnom(iq), ttext(iiq), "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
             ENDDO
           ENDIF
#endif
c
      ENDIF !lev_histmth.GE.4
c
      ELSE IF(type_run.EQ."AMIP".OR.type_run.EQ."CFMI") THEN
c
      IF(lev_histmth.GE.1) THEN
c
         CALL histdef(nid_mth, "phis", "Surface geop. height", "m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "once",  zstophy,zout)
c
         CALL histdef(nid_mth, "aire", "Grid area", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "once",  zstophy,zout)
c
         CALL histdef(nid_mth, "pourc_"//clnsurf(is_ter), 
     .         "% "//clnsurf(is_ter), "%",  
     .         iim,jj_nb,nhori, 1,1,1, -99, 32,
     .         "once", zstophy,zout)
c
         CALL histdef(nid_mth, "fract_"//clnsurf(is_ter), 
     .         "Fraction "//clnsurf(is_ter), "1",  
     .         iim,jj_nb,nhori, 1,1,1, -99, 32,
     .         "once", zstophy,zout)
c
         CALL histdef(nid_mth, "pourc_"//clnsurf(is_lic), 
     .         "% "//clnsurf(is_lic), "%",  
     .         iim,jj_nb,nhori, 1,1,1, -99, 32,
     .         "once", zstophy,zout)
c
         CALL histdef(nid_mth, "fract_"//clnsurf(is_lic), 
     .         "Fraction "//clnsurf(is_lic), "1",  
     .         iim,jj_nb,nhori, 1,1,1, -99, 32,
     .         "once", zstophy,zout)
c
         CALL histdef(nid_mth, "pourc_"//clnsurf(is_sic),
     .         "% "//clnsurf(is_sic), "%",
     .         iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "fract_"//clnsurf(is_sic),
     .         "Fraction "//clnsurf(is_sic), "1",
     .         iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "flat", "Latent heat flux", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "bilTOA",
     .                "Net radiation at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
c
c        CALL histdef(nid_mth, "tops01",
c    .                "TOA reflected clear-sky shortwave 
c    .                radiation (method 1)", "W/m2",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32,
c    .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dtdia","dtdia","K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dtsw","dtsw","K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dtlw","dtlw","K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"dqthe","Dry adjust. dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dtajs","dtajs","K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dtlsc","dtlsc","K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dqdia","dqdia","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "duoli",
     .         "duoli","m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dvoli",
     .         "dvoli","m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "ducon",
     .         "ducon","m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dvcon",
     .         "dvcon","m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dutot",
     .         "dutot","m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "dvtot",
     .         "dvtot","m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
c         CALL histdef(nid_mth, "cldtrue",
c    .         "TRUE Cloud fraction ","%",
c    .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
c    .         "inst(X)", zout,zout)
c
c         CALL histdef(nid_mth, "cldTOA",
c    .         "Cloud amount (satellite view)","%",
c    .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
c    .         "ave(X)", zstophy,zout)
c
c         CALL histdef(nid_mth, "cldSFC",
c    .         "Cloud amount (surface view)","%",
c    .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
c    .         "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "GWDtaux",
     .         "GWD induced Ewd wind stress","Pa",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .         "ave(X)", zstophy,zout)
c
          CALL histdef(nid_mth, "GWDtauy",
     .         "GWD induced Nwd wind stress","Pa",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .         "ave(X)", zstophy,zout)
c
c Champs 2D:
c
         CALL histdef(nid_mth, "slp", "Sea Level Pressure", "Pa",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstorad,zout)
c
         CALL histdef(nid_mth, "tsol", "Surface Temperature", "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "t2m", "Temperature 2m", "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstorad,zout)
c
c        CALL histdef(nid_mth, "t2m_min", "Temp. 2m min.",
c    .                "K",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32,
c    .                t2mincels, zstophy,zout)
c
c        CALL histdef(nid_mth, "t2m_max", "Temp. 2m max.",
c    .                "K",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32,
c    .                t2maxcels, zstophy,zout)
c
c        CALL histdef(nid_mth, "tsoil", "Sfce soil Temperature",
c    .                "K",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32,
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "wind10m","10-m wind speed","m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstorad,zout)
c
         CALL histdef(nid_mth, "sicf", "Sea-ice fraction", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)

c
         CALL histdef(nid_mth, "q2m","Specific humidity 2m","kg/kg",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstorad,zout)
c
         CALL histdef(nid_mth, "u10m", "Vent zonal 10m", "m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstorad,zout)
c
         CALL histdef(nid_mth, "v10m", "Vent meridien 10m", "m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstorad,zout)
c
         CALL histdef(nid_mth, "psol", "Surface Pressure", "Pa",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstorad,zout)
c
         CALL histdef(nid_mth, "qsurf","Surface Air humidity","kg/kg",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
      if (.not. ok_veget) then
         CALL histdef(nid_mth, "qsol", "Soil watter content", "mm",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
      endif
c
         CALL histdef(nid_mth, "ndayrain", 
     .                "Number of day with rain (liq+sol)", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "inst(X)", zstomth,zout)
c
         CALL histdef(nid_mth, "precip", "Precipitation Totale liq+sol", 
     .                "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "plul", "Large-scale Precip.", 
     .   "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "pluc", "Convective Precip.", 
     .   "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "snowf", "Snow fall", "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
c        CALL histdef(nid_mth, "snow_mass", "Snow Mass", "kg/m2",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "evap", 
     .                "Evaporation plus sublimation rate", "kg/(s*m2)",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "tops", "Solar rad. at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "tops0", "CS Solar rad. at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "topl", "IR rad. at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "topl0", "IR rad. at TOA", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWupTOA", "SWup at TOA","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWupTOAclr", 
     .                "SWup clear sky at TOA","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdnTOA", "SWdn at TOA","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdnTOAclr", 
     .                "SWdn clear sky at TOA","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWup200", "SWup at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWup200clr", 
     .                "SWup clear sky at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdn200", "SWdn at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdn200clr", 
     .                "SWdn clear sky at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "LWup200", "LWup at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "LWup200clr", 
     .                "LWup clear sky at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "LWdn200", "LWdn at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "LWdn200clr", 
     .                "LWdn clear sky at 200mb","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "sols", "Solar rad. at surf.", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "sols0", "Solar rad. at surf.", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "soll", "IR rad. at surface", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "radsol", "Rayonnement au sol", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "soll0", "IR rad. at surface", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWupSFC", "SWup at surface","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWupSFCclr", 
     .                "SWup clear sky at surface","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdnSFC", "SWdn at surface","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "SWdnSFCclr", 
     .                "SWdn clear sky at surface","W/m2",
     .                iim,jj_nb,nhori, 1,1,1,-99,
     .                32, "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"LWupSFC","Upwd. IR rad. at surface", 
     .                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"LWdnSFC","Down. IR rad. at surface", 
     .                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"LWupSFCclr",
     .                "CS Upwd. IR rad. at surface", 
     .                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"LWdnSFCclr",
     .                "Down. CS IR rad. at surface", 
     .                "W/m2", iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "bils", "Surf. total heat flux", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "sens", "Sensible heat flux", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "fder", "Heat flux derivation", "W/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
c Effets des aerosols
c
         IF (ok_ade.OR.ok_aie) THEN
             CALL histdef(nid_mth, "topsad", "ADE at TOA", "W/m2",
     .                    iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                    "ave(X)", zstophy,zout)
c
             CALL histdef(nid_mth, "solsad", "ADE at sfc", "W/m2",
     .                    iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                    "ave(X)", zstophy,zout)
c
             CALL histdef(nid_mth, "topsai", "AIE at TOA", "W/m2",
     .                    iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                    "ave(X)", zstophy,zout)
c
             CALL histdef(nid_mth, "solsai", "AIE at sfc", "W/m2",
     .                    iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                    "ave(X)", zstophy,zout)
         ENDIF
c
c          CALL histdef(nid_mth, "frtu", "Zonal wind stress", "Pa",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
c    .                "ave(X)", zstophy,zout)
c
c        CALL histdef(nid_mth, "frtv", "Meridional wind stress", "Pa",
c    .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ffonte","Thermal flux for snow melting",
     .                "W/m2",iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "fqcalving","Ice Calving",
     .                "kg/m2/s",iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         DO nsrf = 1, nbsrf
           call histdef(nid_mth, "taux_"//clnsurf(nsrf), 
     $         "Zonal wind stress"//clnsurf(nsrf), "Pa",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)

           call histdef(nid_mth, "tauy_"//clnsurf(nsrf), 
     $         "Meridional wind stress "//clnsurf(nsrf), "Pa",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
         ENDDO
c
           call histdef(nid_mth, "pourc_"//clnsurf(is_oce), 
     $         "% "//clnsurf(is_oce), "%",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
           call histdef(nid_mth, "fract_"//clnsurf(is_oce), 
     $         "Fraction "//clnsurf(is_oce), "1",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
         DO nsrf = 1, nbsrf
C
           call histdef(nid_mth, "tsol_"//clnsurf(nsrf), 
     $         "Temperature "//clnsurf(nsrf), "K",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "sens_"//clnsurf(nsrf), 
     $         "Sensible heat flux "//clnsurf(nsrf), "W/m2",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
           call histdef(nid_mth, "lat_"//clnsurf(nsrf), 
     $         "Latent heat flux "//clnsurf(nsrf), "W/m2",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "flw_"//clnsurf(nsrf),
     $         "LW "//clnsurf(nsrf), "W/m2",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
           call histdef(nid_mth, "fsw_"//clnsurf(nsrf),
     $         "SW "//clnsurf(nsrf), "W/m2",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "wbils_"//clnsurf(nsrf),
     $         "Bilan sol "//clnsurf(nsrf), "W/m2",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "wbilo_"//clnsurf(nsrf),
     $         "Bilan eau "//clnsurf(nsrf), "kg/(m2*s)",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
cIM 250105 BEG
          IF(1.EQ.0) THEN
C
           call histdef(nid_mth, "evapour_"//clnsurf(nsrf),
     $         "Evap*pourc "//clnsurf(nsrf), "kg/(s*m2)",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
           call histdef(nid_mth, "prepour_"//clnsurf(nsrf),
     $         "Precip*pourc "//clnsurf(nsrf), "kg/(s*m2)",
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
C
          ENDIF !(1.EQ.0) THEN
cIM 250105 END
C
         END DO
c
         CALL histdef(nid_mth, "cdrm", "Momentum drag coef.", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cdrh", "Heat drag coef.", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cldl", "Low-level cloudiness", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cldm", "Mid-level cloudiness", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cldh", "High-level cloudiness", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "cldt", "Total cloudiness", "%",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"cldq","Cloud liquid water path","kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"lwp","Cloud water path","kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"iwp","Cloud ice water path","kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ue", "Zonal energy transport", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ve", "Merid energy transport", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "uq", "Zonal humidity transport", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "vq", "Merid humidity transport", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
cKE43
      IF(iflag_con.GE.3) THEN ! sb
c
         CALL histdef(nid_mth, "cape", "Conv avlbl pot ener", "J/kg",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "pbase", "Cld base pressure", "mb",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ptop", "Cld top pressure", "mb",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "fbase", "Cld base mass flux", "kg/m2/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "prw", "Precipitable water", "kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "upwd", "saturated updraft", "kg/m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
      ENDIF !iflag_con .GE. 3
c34EK
cIM cf. AM 081204 BEG
c34EK
c HBTM2
         CALL histdef(nid_mth, "s_pblh", "Boundary Layer Height", "m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_pblt", "T at Boundary Layer Height",
     .                "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_lcl", "Condensation level", "m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth,"s_capCL","Conv avlbl pot ener for ABL",
     .                "J/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_oliqCL", "Liq Water in BL", "kg/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth,"s_cteiCL","Instability criteria (ABL)",
     .                "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_therm", "Exces du thermique", "K",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_trmb1", "deep_cape(HBTM2)", "J/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_trmb2", "inhibition (HBTM2)", "J/m2",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "s_trmb3", "Point Omega (HBTM2)", "m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
c
cIM cf. AM 081204 END
c
c Champs interpolles sur des niveaux de pression
         DO k=1, nlevSTD
c
c        bb=clevSTD(k)
c
c        IF(k.GE.2) THEN
         IF(k.GE.2.AND.k.LE.12) bb2=clevSTD(k)
         IF(k.GE.13.AND.k.LE.17) bb3=clevSTD(k)
c         aa=clevSTD(k)
c         bb=aa(1:lnblnk1(aa))
c        ENDIF
c
       IF(bb2.EQ."850".OR.bb2.EQ."700"
     $   .OR.bb2.EQ."500".OR.bb2.EQ."200") THEN
c
          CALL histdef(nid_mth, "u"//bb2,
     .                 "Zonal wind "//bb2//"mb","m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "inst(X)", zout,zout)
c
          CALL histdef(nid_mth, "v"//bb2,
     .                 "Meridional wind "//bb2//"mb","m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "inst(X)", zout,zout)
c
          CALL histdef(nid_mth, "w"//bb2,
     .                 "Vertical wind "//bb2//"mb","m/s",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "inst(X)", zout,zout)
c
          CALL histdef(nid_mth, "phi"//bb2,
     .                 "Geopotential "//bb2//"mb","m",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "inst(X)", zout,zout)
c
         ENDIF !(bb2.EQ."850".OR.bb2.EQ."700"
c
       ENDDO !nlevSTD
c
cIM diagnostiques flux ocean-atm ou ocean-glace de mer
cIM pour utilisation dans un modele de "slab" ocean
c
       CALL histdef(nid_mth, "fluxo",
     .              "Flux turbulents ocean-atmosphere", "W/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       CALL histdef(nid_mth, "fluxg",
     .              "Flux turbulents ocean-glace de mer","W/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       CALL histdef(nid_mth, "t_oce_sic",
     .              "Temp. mixte oce-sic","K",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       IF (OCEAN.EQ.'force ') THEN
c
        CALL histdef(nid_mth, "lmt_bils",
     .       "Bilan au sol atmosphere forcee", "W/m2",
     .       iim,jj_nb,nhori, 1,1,1, -99, 32,
     .       "ave(X)", zstophy,zout)
c
       ELSE IF (OCEAN.EQ.'slab  ') THEN
c
        CALL histdef(nid_mth, "slab_bils",
     .              "Bilan au sol Slab", "W/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
        CALL histdef(nid_mth, "tslab", "Slab SST ", "K",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
        CALL histdef(nid_mth, "seaice", "Slab seaice", "kg/m2",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
        CALL histdef(nid_mth, "siceh", "Slab seaice height", "m",
     .              iim,jj_nb,nhori, 1,1,1, -99, 32,
     .              "ave(X)", zstophy,zout)
c
       ENDIF !OCEAN.EQ.slab/force
c
      ENDIF !lev_histmth.GE.1
c
      IF(lev_histmth.GE.2) THEN
c
c Champs 3D:
c
c
         CALL histdef(nid_mth,"lwcon","Cloud liquid water content",
     .                "kg/kg",
     .                iim,jj_nb,nhori, klev,1,klev, nvert, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"iwcon","Cloud ice water content","kg/kg",
     .                iim,jj_nb,nhori, klev,1,klev, nvert, 32, 
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "temp", "Air temperature", "K",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ovap", "Specific humidity", "kg/kg",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
c        CALL histdef(nid_mth,"wvap","Water vapor mixing ratio","kg/kg",
c    .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
c    .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "geop", "Geopotential height", "m2/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "vitu", "Zonal wind", "m/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "vitv", "Meridional wind", "m/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "vitw", "Vertical wind", "Pa/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "pres", "Air pressure", "Pa",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
        CALL histdef(nid_mth, "rneb", "Cloud fraction", "%",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "rnebcon", "Convective Cloud Fraction"
     .                , "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "rhum", "Relative humidity", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ozone", "Ozone concentration", "ppmv",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtphy", "Physics dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqphy","Physics dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
      ENDIF !lev_histmth.GE.2
c
      IF(lev_histmth.GE.3) THEN
c
        DO nsrf=1, nbsrf
c
           call histdef(nid_mth, "albe_"//clnsurf(nsrf), 
     $         "Albedo surf. "//clnsurf(nsrf), "-",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
           call histdef(nid_mth, "rugs_"//clnsurf(nsrf), 
     $         "Rugosite "//clnsurf(nsrf), "m",  
     $         iim,jj_nb,nhori, 1,1,1, -99, 32,
     $         "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "ages_"//clnsurf(nsrf), "Snow age","day",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
	 ENDDO !nsrf=1, nbsrf
c
         CALL histdef(nid_mth, "albs", "Surface albedo", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "albslw", "Surface albedo LW", "-",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32, 
     .                "ave(X)", zstophy,zout)
c
      ENDIF !lev_histmth.GE.3
c
      IF(lev_histmth.GE.4) THEN
c
!FH Sorties pour la couche limite
      if (iflag_pbl>1) then
         CALL histdef(nid_mth, "tke","TKE","m2/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "tke_max","TKE max","m2/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "t_max(X)", zstophy,zout)
      endif
c
         CALL histdef(nid_mth, "kz","Kz melange","m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "kz_max","Kz melange max","m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "t_max(X)", zstophy,zout)




         CALL histdef(nid_mth, "clwcon", 
     .                "Convective Cloud Liquid water content"
     .                , "kg/kg",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"Ma","undilute adiab updraft","kg/m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dnwd", "saturated downdraft","kg/m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dnwd0", "unsat. downdraft", "kg/m2/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtdyn", "Dynamics dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqdyn","Dynamics dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqcon","Convection dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtlschr",
     $       "Large-scale condensational heating rate", "K/s",
     $       iim,jj_nb
     $       ,nhori, klev,1,klev,nvert, 32,"ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqlsc","Condensation dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtvdf", "Boundary-layer dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dqvdf","Boundary-layer dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dteva", "Reevaporation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"dqeva","Reevaporation dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)

         CALL histdef(nid_mth, "ptconv", "POINTS CONVECTIFS"," ",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)

         CALL histdef(nid_mth, "ratqs", "RATQS"," ",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)

c
         CALL histdef(nid_mth, "dqajs","Dry adjust. dQ","(kg/kg)/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtswr", "SW radiation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtsw0", "CS SW radiation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtlwr", "LW radiation dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth,"dtlw0","CS LW radiation dT","K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dtec", "Cinetic dissip dT", "K/s",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "duvdf", "Boundary-layer dU", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dvvdf", "Boundary-layer dV", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         IF (ok_orodr) THEN
         CALL histdef(nid_mth, "duoro", "Orography dU", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dvoro", "Orography dV", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         ENDIF
C
         IF (ok_orolf) THEN
         CALL histdef(nid_mth, "dulif", "Orography dU", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
c
         CALL histdef(nid_mth, "dvlif", "Orography dV", "m/s2",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         ENDIF
C
#if defined(INCA_AER) && defined(CPP_COUPLE)
         CALL histdef(nid_mth, "tau", "cloud opt thickness", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "CCM1", "CCM1", "",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "CCM2", "CCM2", "",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "taupi", "cloud opt thickn. (pi)", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         CALL histdef(nid_mth, "cldemi", "emissivite IR", "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_ZERO", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_AER", "?", "?",
     .                iim,jj_nb,nhori, 1,1,1, -99, 32,
     .                "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_NAT", "?", "?",
     .        iim,jj_nb,nhori, 1,1,1, -99, 32,
     .        "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_AD", "?", "?",
     .        iim,jj_nb,nhori, 1,1,1, -99, 32,
     .        "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOAAS_AI", "?", "?",
     .        iim,jj_nb,nhori, 1,1,1, -99, 32,
     .        "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOACS_ZERO", "?", "?",
     .        iim,jj_nb,nhori, 1,1,1, -99, 32,
     .        "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOACS_AER", "?", "?",
     .        iim,jj_nb,nhori, 1,1,1, -99, 32,
     .        "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOACS_AD", "?", "?",
     .        iim,jj_nb,nhori, 1,1,1, -99, 32,
     .        "ave(X)", zstophy,zout)
	 CALL histdef(nid_mth, "SWTOACS_NAT", "?", "?",
     .        iim,jj_nb,nhori, 1,1,1, -99, 32,
     .        "ave(X)", zstophy,zout)
#endif
#ifndef INCA
         if (nqmax.GE.3) THEN
         DO iq=3,nqmax
         iiq=niadv(iq)
         CALL histdef(nid_mth, tnom(iq), ttext(iiq), "-",
     .                iim,jj_nb,nhori, klev,1,klev,nvert, 32,
     .                "ave(X)", zstophy,zout)
         ENDDO
         ENDIF
#endif

      ENDIF !lev_histmth.GE.4
c
      ENDIF !type_run.EQ."CLIM".OR.type_run.EQ."ENSP")
c
         CALL histend(nid_mth)
c
         ndex2d = 0
         ndex3d = 0
c
c$OMP END MASTER
      ENDIF ! fin de test sur ok_mensuel
