!
! $Header$
!
MODULE surf_land_mod
  
  USE surface_data, ONLY    : ok_veget
  USE dimphy
 
#ifdef CPP_VEGET
  USE surf_land_orchidee_mod
#endif
  USE surf_land_bucket_mod

  IMPLICIT NONE

CONTAINS
!
!****************************************************************************************
!  
  SUBROUTINE surf_land(itime, dtime, date0, jour, knon, knindex, &
       rlon, rlat, &
       debut, lafin, zlev, epot_air, ccanopy, sollwdown, swnet, swdown, &
       tsurf, p1lay, tq_cdrag, precip_rain, precip_snow, temp_air, spechum, &
       petAcoef, peqAcoef, petBcoef, peqBcoef, &
       ps, u1_lay, v1_lay, rugoro, pctsrf, &
       radsol, snow, qsurf, qsol, agesno, &
       tsoil, z0_new, alblw, evap, fluxsens, fluxlat, &
       tsurf_new, alb_new, dflux_s, dflux_l, pctsrf_ter)

    INCLUDE "indicesol.h"
    INCLUDE "dimsoil.h"

! Input variables  
!****************************************************************************************
    INTEGER, INTENT(IN)                     :: itime, jour, knon
    INTEGER, DIMENSION(klon), INTENT(IN)    :: knindex
    REAL, INTENT(IN)                        :: date0
    REAL, DIMENSION(klon), INTENT(IN)       :: rlon, rlat
    LOGICAL, INTENT(IN)                     :: debut, lafin
    REAL, INTENT(IN)                        :: dtime
    REAL, DIMENSION(klon), INTENT(IN)       :: zlev, epot_air, ccanopy
    REAL, DIMENSION(klon), INTENT(IN)       :: sollwdown, swnet, swdown    
    REAL, DIMENSION(klon), INTENT(IN)       :: tsurf
    REAL, DIMENSION(klon), INTENT(IN)       :: p1lay
    REAL, DIMENSION(klon), INTENT(IN)       :: tq_cdrag
    REAL, DIMENSION(klon), INTENT(IN)       :: precip_rain, precip_snow
    REAL, DIMENSION(klon), INTENT(IN)       :: temp_air, spechum
    REAL, DIMENSION(klon), INTENT(IN)       :: petAcoef, peqAcoef
    REAL, DIMENSION(klon), INTENT(IN)       :: petBcoef, peqBcoef
    REAL, DIMENSION(klon), INTENT(IN)       :: ps
    REAL, DIMENSION(klon), INTENT(IN)       :: u1_lay, v1_lay
    REAL, DIMENSION(klon), INTENT(IN)       :: rugoro
    REAL, DIMENSION(klon,nbsrf), INTENT(IN) :: pctsrf

! In/Output variables
!****************************************************************************************
    REAL, DIMENSION(klon), INTENT(INOUT)          :: radsol
    REAL, DIMENSION(klon), INTENT(INOUT)          :: snow, qsol
    REAL, DIMENSION(klon), INTENT(INOUT)          :: agesno
    REAL, DIMENSION(klon, nsoilmx), INTENT(INOUT) :: tsoil

! Output variables
!****************************************************************************************
    REAL, DIMENSION(klon), INTENT(OUT)       :: qsurf
    REAL, DIMENSION(klon), INTENT(OUT)       :: z0_new
    REAL, DIMENSION(klon), INTENT(OUT)       :: alblw
    REAL, DIMENSION(klon), INTENT(OUT)       :: evap, fluxsens, fluxlat
    REAL, DIMENSION(klon), INTENT(OUT)       :: tsurf_new, alb_new
    REAL, DIMENSION(klon), INTENT(OUT)       :: dflux_s, dflux_l      
    REAL, DIMENSION(klon), INTENT(OUT)       :: pctsrf_ter

! Local variables
!****************************************************************************************
    REAL, DIMENSION(klon) :: ps_tmp, p1lay_tmp
    REAL, DIMENSION(klon) :: tsol_rad, emis_new ! output from interfsol not used
    INTEGER               :: i


!**************************************************************************************** 
! Choice between call to vegetation model (ok_veget=true) or simple calculation below
!
!****************************************************************************************
   IF (ok_veget) THEN
!****************************************************************************************
!  Call model sechiba
!
!****************************************************************************************
       p1lay_tmp(:)      = 0.0
       ps_tmp(:)         = 0.0
       p1lay_tmp(1:knon) = p1lay(1:knon)/100.
       ps_tmp(1:knon)    = ps(1:knon)/100.

#ifdef CPP_VEGET
       CALL surf_land_orchidee(itime, dtime, date0, knon, &
            knindex, rlon, rlat, pctsrf, &
            debut, lafin, &
            zlev,  u1_lay, v1_lay, temp_air, spechum, epot_air, ccanopy, & 
            tq_cdrag, petAcoef, peqAcoef, petBcoef, peqBcoef, &
            precip_rain, precip_snow, sollwdown, swnet, swdown, &
            ps_tmp, &
            evap, fluxsens, fluxlat, &              
            tsol_rad, tsurf_new, alb_new, alblw, &
            emis_new, z0_new, qsurf)       
#endif

!  
!* Ajout de la contribution du relief
!  
       DO i=1,knon
          z0_new(i) = SQRT(z0_new(i)**2 + rugoro(i)**2)
       ENDDO

    ELSE  ! not ok_veget
!****************************************************************************************
! No extern vegetation model choosen, call simple bucket calculations instead.
!
!****************************************************************************************
       CALL surf_land_bucket(itime, jour, knon, knindex, debut, dtime,&
            tsurf, p1lay, tq_cdrag, precip_rain, precip_snow, temp_air, &
            spechum, petAcoef, peqAcoef, petBcoef, peqBcoef, ps, &
            u1_lay, v1_lay, rugoro, &
            radsol, snow, qsol, agesno, tsoil, &
            qsurf, z0_new, alblw, evap, fluxsens, fluxlat, &
            tsurf_new, alb_new, dflux_s, dflux_l)

    ENDIF ! ok_veget

!****************************************************************************************
! Return the pourcentage of land in each grid cell, even if not changed in here!
!
!****************************************************************************************
    pctsrf_ter(:) = pctsrf(:,is_ter)


  END SUBROUTINE surf_land
!
!****************************************************************************************
!  
END MODULE surf_land_mod
!
!****************************************************************************************
!  
