MODULE write_field_phy

  CONTAINS 
 
    SUBROUTINE WriteField_phy(name,Field,ll)
    USE dimphy
    USE Write_Field
    IMPLICIT NONE
    include 'dimensions90.h'
    include 'paramet90.h'

    character(len=*)   :: name
    INTEGER :: ll
    real, dimension(klon_omp,ll) :: Field
    real,save,allocatable :: Field_tmp(:,:)
    real, dimension(klon2,ll):: New_Field
    real, dimension(iim,jjp1,ll):: Field_2d
	
    if (omp_rank==0) then
      allocate(Field_tmp(klon_mpi,ll))
    endif
    
!$OMP BARRIER
    CALL GatherField_omp(Field,Field_tmp,ll)
!$OMP BARRIER

  if (omp_rank==0) then
    CALL GatherField(Field_tmp,New_Field,ll)
    IF (phy_rank==0) THEN
      CALL gr_fi_ecrit(ll, klon2,iim,jjp1, New_Field, Field_2d)
      CALL WriteField(name,Field_2d)
    ENDIF
    deallocate(Field_tmp)
  endif
!$OMP BARRIER 
  
   END SUBROUTINE WriteField_phy
 
 END MODULE write_field_phy
