!
! $Header$
!
c
      SUBROUTINE phyredem (fichnom,dtime,radpas,
     .           rlat_p,rlon_p, pctsrf_p,tsol_p,tsoil_p,
cIM "slab" ocean
     .           tslab,seaice,
     .           qsurf_p,qsol_p,snow_p,albedo_p, alblw_p, evap_p,
     .           rain_fall_p, snow_fall_p,solsw_p, sollw_p,fder_p,
     .           radsol_p,frugs_p,agesno_p,zmea_p,zstd_p,zsig_p,
     .           zgam_p,zthe_p,zpic_p,zval_p,rugsrel_p,
     .           t_ancien_p, q_ancien_p, rnebcon_p, ratqs_p, clwcon_p,
     .           run_off_lic_0_p)
      USE dimphy
      IMPLICIT none
c======================================================================
c Auteur(s) Z.X. Li (LMD/CNRS) date: 19930818
c Objet: Ecriture de l'etat de redemarrage pour la physique
c======================================================================
cym#include "dimensions.h"
cym#include "dimphy.h"
#include "netcdf.inc"
#include "indicesol.h"
#include "dimsoil.h"
#include "clesphys.h"
#include "control.h"
#include "temps.h"
c======================================================================
      CHARACTER*(*) fichnom
      REAL dtime
      INTEGER radpas
      REAL rlat_p(klon), rlon_p(klon)
      REAL tsol_p(klon,nbsrf)
      REAL tsoil_p(klon,nsoilmx,nbsrf)
cIM "slab" ocean
      REAL tslab_p(klon), seaice_p(klon)
      REAL qsurf_p(klon,nbsrf)
      REAL qsol_p(klon)
      REAL snow_p(klon,nbsrf)
      REAL albedo_p(klon,nbsrf)
cIM BEG
      REAL alblw_p(klon,nbsrf)
cIM END
      REAL evap_p(klon,nbsrf)
      REAL rain_fall_p(klon)
      REAL snow_fall_p(klon)
      real solsw_p(klon)
      real sollw_p(klon)
      real fder_p(klon)
      REAL radsol_p(klon)
      REAL frugs_p(klon,nbsrf)
      REAL agesno_p(klon,nbsrf)
      REAL zmea_p(klon)
      REAL zstd_p(klon)
      REAL zsig_p(klon)
      REAL zgam_p(klon)
      REAL zthe_p(klon)
      REAL zpic_p(klon)
      REAL zval_p(klon)
      REAL rugsrel_p(klon)
      REAL pctsrf_p(klon, nbsrf)
      REAL t_ancien_p(klon,klev), q_ancien_p(klon,klev)
      real clwcon_p(klon,klev),rnebcon_p(klon,klev),ratqs_p(klon,klev)
      REAL run_off_lic_0_p(klon)
      
      REAL rlat(klon2), rlon(klon2)
      REAL tsol(klon2,nbsrf)
      REAL tsoil(klon2,nsoilmx,nbsrf)
      REAL tslab(klon2), seaice(klon2)
      REAL qsurf(klon2,nbsrf)
      REAL qsol(klon2)
      REAL snow(klon2,nbsrf)
      REAL albedo(klon2,nbsrf)
      REAL alblw(klon2,nbsrf)
      REAL evap(klon2,nbsrf)
      REAL rain_fall(klon2)
      REAL snow_fall(klon2)
      real solsw(klon2)
      real sollw(klon2)
      real fder(klon2)
      REAL radsol(klon2)
      REAL frugs(klon2,nbsrf)
      REAL agesno(klon2,nbsrf)
      REAL zmea(klon2)
      REAL zstd(klon2)
      REAL zsig(klon2)
      REAL zgam(klon2)
      REAL zthe(klon2)
      REAL zpic(klon2)
      REAL zval(klon2)
      REAL rugsrel(klon2)
      REAL pctsrf(klon2, nbsrf)
      REAL t_ancien(klon2,klev), q_ancien(klon2,klev)
      real clwcon(klon2,klev),rnebcon(klon2,klev),ratqs(klon2,klev)
      REAL run_off_lic_0(klon2)
      REAL masq(klon2)
c
      INTEGER nid, nvarid, idim1, idim2, idim3
      INTEGER ierr
      INTEGER length
      PARAMETER (length=100)
      REAL tab_cntrl(length)
c
      INTEGER isoil, nsrf
      CHARACTER*7 str7
      CHARACTER*2 str2
c
      REAL,SAVE,ALLOCATABLE :: rlat_mpi(:), rlon_mpi(:)
      REAL,SAVE,ALLOCATABLE :: tsol_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: tsoil_mpi(:,:,:)
      REAL,SAVE,ALLOCATABLE :: tslab_mpi(:)
      REAL,SAVE,ALLOCATABLE :: seaice_mpi(:)
      REAL,SAVE,ALLOCATABLE :: qsurf_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: qsol_mpi(:)
      REAL,SAVE,ALLOCATABLE :: snow_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: albedo_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: alblw_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: evap_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: rain_fall_mpi(:)
      REAL,SAVE,ALLOCATABLE :: snow_fall_mpi(:)
      REAL,SAVE,ALLOCATABLE :: solsw_mpi(:)
      REAL,SAVE,ALLOCATABLE :: sollw_mpi(:)
      REAL,SAVE,ALLOCATABLE :: fder_mpi(:)
      REAL,SAVE,ALLOCATABLE :: radsol_mpi(:)
      REAL,SAVE,ALLOCATABLE :: frugs_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: agesno_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: zmea_mpi(:)
      REAL,SAVE,ALLOCATABLE :: zstd_mpi(:)
      REAL,SAVE,ALLOCATABLE :: zsig_mpi(:)
      REAL,SAVE,ALLOCATABLE :: zgam_mpi(:)
      REAL,SAVE,ALLOCATABLE :: zthe_mpi(:)
      REAL,SAVE,ALLOCATABLE :: zpic_mpi(:)
      REAL,SAVE,ALLOCATABLE :: zval_mpi(:)
      REAL,SAVE,ALLOCATABLE :: rugsrel_mpi(:)
      REAL,SAVE,ALLOCATABLE :: pctsrf_mpi(:, :)
      REAL,SAVE,ALLOCATABLE :: t_ancien_mpi(:,:), q_ancien_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: clwcon_mpi(:,:),rnebcon_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: ratqs_mpi(:,:)
      REAL,SAVE,ALLOCATABLE :: run_off_lic_0_mpi(:)
      REAL,SAVE,ALLOCATABLE :: masq_mpi(:)
      
c$OMP MASTER
      ALLOCATE( rlat_mpi(klon_mpi), rlon_mpi(klon_mpi))
      ALLOCATE( tsol_mpi(klon_mpi,nbsrf))
      ALLOCATE( tsoil_mpi(klon_mpi,nsoilmx,nbsrf))
      ALLOCATE( tslab_mpi(klon_mpi))
      ALLOCATE( seaice_mpi(klon_mpi))
      ALLOCATE( qsurf_mpi(klon_mpi,nbsrf))
      ALLOCATE( qsol_mpi(klon_mpi))
      ALLOCATE( snow_mpi(klon_mpi,nbsrf))
      ALLOCATE( albedo_mpi(klon_mpi,nbsrf))
      ALLOCATE( alblw_mpi(klon_mpi,nbsrf))
      ALLOCATE( evap_mpi(klon_mpi,nbsrf))
      ALLOCATE( rain_fall_mpi(klon_mpi))
      ALLOCATE( snow_fall_mpi(klon_mpi))
      ALLOCATE( solsw_mpi(klon_mpi))
      ALLOCATE( sollw_mpi(klon_mpi))
      ALLOCATE( fder_mpi(klon_mpi))
      ALLOCATE( radsol_mpi(klon_mpi))
      ALLOCATE( frugs_mpi(klon_mpi,nbsrf))
      ALLOCATE( agesno_mpi(klon_mpi,nbsrf))
      ALLOCATE( zmea_mpi(klon_mpi))
      ALLOCATE( zstd_mpi(klon_mpi))
      ALLOCATE( zsig_mpi(klon_mpi))
      ALLOCATE( zgam_mpi(klon_mpi))
      ALLOCATE( zthe_mpi(klon_mpi))
      ALLOCATE( zpic_mpi(klon_mpi))
      ALLOCATE( zval_mpi(klon_mpi))
      ALLOCATE( rugsrel_mpi(klon_mpi))
      ALLOCATE( pctsrf_mpi(klon_mpi, nbsrf))
      ALLOCATE( t_ancien_mpi(klon_mpi,klev))
      ALLOCATE( q_ancien_mpi(klon_mpi,klev))
      ALLOCATE( clwcon_mpi(klon_mpi,klev),rnebcon_mpi(klon_mpi,klev))
      ALLOCATE( ratqs_mpi(klon_mpi,klev))
      ALLOCATE( run_off_lic_0_mpi(klon_mpi))
      ALLOCATE( masq_mpi(klon_mpi))
c$OMP END MASTER
c$OMP BARRIER      

      call GatherField_omp( rlat_p,rlat_mpi,1)
      call GatherField_omp( rlon_p,rlon_mpi,1)
      call GatherField_omp( tsol_p,tsol_mpi,nbsrf)
      call GatherField_omp( tsoil_p,tsoil_mpi,nsoilmx*nbsrf)
      call GatherField_omp( tslab_p,tslab_mpi,1)
      call GatherField_omp( seaice_p,seaice_mpi,1)
      call GatherField_omp( qsurf_p,qsurf_mpi,nbsrf)
      call GatherField_omp( qsol_p,qsol_mpi,1)
      call GatherField_omp( snow_p,snow_mpi,nbsrf)
      call GatherField_omp( albedo_p,albedo_mpi,nbsrf)
      call GatherField_omp( alblw_p,alblw_mpi,nbsrf)
      call GatherField_omp( evap_p,evap_mpi,nbsrf)
      call GatherField_omp( radsol_p,radsol_mpi,1)
      call GatherField_omp( rain_fall_p,rain_fall_mpi,1)
      call GatherField_omp( snow_fall_p,snow_fall_mpi,1)
      call GatherField_omp( sollw_p,sollw_mpi,1)
      call GatherField_omp( solsw_p,solsw_mpi,1)
      call GatherField_omp( fder_p,fder_mpi,1)
      call GatherField_omp( frugs_p,frugs_mpi,nbsrf)
      call GatherField_omp( agesno_p,agesno_mpi,nbsrf)
      call GatherField_omp( zmea_p,zmea_mpi,1)
      call GatherField_omp( zstd_p,zstd_mpi,1)
      call GatherField_omp( zsig_p,zsig_mpi,1)
      call GatherField_omp( zgam_p,zgam_mpi,1)
      call GatherField_omp( zthe_p,zthe_mpi,1)
      call GatherField_omp( zpic_p,zpic_mpi,1)
      call GatherField_omp( zval_p,zval_mpi,1)
      call GatherField_omp( rugsrel_p,rugsrel_mpi,1)
      call GatherField_omp( pctsrf_p,pctsrf_mpi, nbsrf)
      call GatherField_omp( run_off_lic_0_p,run_off_lic_0_mpi,1)
      call GatherField_omp( t_ancien_p,t_ancien_mpi,klev)
      call GatherField_omp( q_ancien_p,q_ancien_mpi,klev)
      call GatherField_omp( rnebcon_p,rnebcon_mpi,klev)
      call GatherField_omp( clwcon_p,clwcon_mpi,klev)
      call GatherField_omp( ratqs_p,ratqs_mpi,klev)
      call GatherField_omp( zmasq,masq_mpi,1)

c$OMP MASTER      
      call GatherField( rlat_mpi,rlat,1)
      call GatherField( rlon_mpi,rlon,1)
      call GatherField( tsol_mpi,tsol,nbsrf)
      call GatherField( tsoil_mpi,tsoil,nsoilmx*nbsrf)
      call GatherField( tslab_mpi,tslab,1)
      call GatherField( seaice_mpi,seaice,1)
      call GatherField( qsurf_mpi,qsurf,nbsrf)
      call GatherField( qsol_mpi,qsol,1)
      call GatherField( snow_mpi,snow,nbsrf)
      call GatherField( albedo_mpi,albedo,nbsrf)
      call GatherField( alblw_mpi,alblw,nbsrf)
      call GatherField( evap_mpi,evap,nbsrf)
      call GatherField( radsol_mpi,radsol,1)
      call GatherField( rain_fall_mpi,rain_fall,1)
      call GatherField( snow_fall_mpi,snow_fall,1)
      call GatherField( sollw_mpi,sollw,1)
      call GatherField( solsw_mpi,solsw,1)
      call GatherField( fder_mpi,fder,1)
      call GatherField( frugs_mpi,frugs,nbsrf)
      call GatherField( agesno_mpi,agesno,nbsrf)
      call GatherField( zmea_mpi,zmea,1)
      call GatherField( zstd_mpi,zstd,1)
      call GatherField( zsig_mpi,zsig,1)
      call GatherField( zgam_mpi,zgam,1)
      call GatherField( zthe_mpi,zthe,1)
      call GatherField( zpic_mpi,zpic,1)
      call GatherField( zval_mpi,zval,1)
      call GatherField( rugsrel_mpi,rugsrel,1)
      call GatherField( pctsrf_mpi,pctsrf, nbsrf)
      call GatherField( run_off_lic_0_mpi,run_off_lic_0,1)
      call GatherField( t_ancien_mpi,t_ancien,klev)
      call GatherField( q_ancien_mpi,q_ancien,klev)
      call GatherField( rnebcon_mpi,rnebcon,klev)
      call GatherField( clwcon_mpi,clwcon,klev)
      call GatherField( ratqs_mpi,ratqs,klev)
      call GatherField( masq_mpi,masq,1)
      
      DEALLOCATE( rlat_mpi, rlon_mpi)
      DEALLOCATE( tsol_mpi)
      DEALLOCATE( tsoil_mpi)
      DEALLOCATE( tslab_mpi)
      DEALLOCATE( seaice_mpi)
      DEALLOCATE( qsurf_mpi)
      DEALLOCATE( qsol_mpi)
      DEALLOCATE( snow_mpi)
      DEALLOCATE( albedo_mpi)
      DEALLOCATE( alblw_mpi)
      DEALLOCATE( evap_mpi)
      DEALLOCATE( rain_fall_mpi)
      DEALLOCATE( snow_fall_mpi)
      DEALLOCATE( solsw_mpi)
      DEALLOCATE( sollw_mpi)
      DEALLOCATE( fder_mpi)
      DEALLOCATE( radsol_mpi)
      DEALLOCATE( frugs_mpi)
      DEALLOCATE( agesno_mpi)
      DEALLOCATE( zmea_mpi)
      DEALLOCATE( zstd_mpi)
      DEALLOCATE( zsig_mpi)
      DEALLOCATE( zgam_mpi)
      DEALLOCATE( zthe_mpi)
      DEALLOCATE( zpic_mpi)
      DEALLOCATE( zval_mpi)
      DEALLOCATE( rugsrel_mpi)
      DEALLOCATE( pctsrf_mpi)
      DEALLOCATE( t_ancien_mpi)
      DEALLOCATE( q_ancien_mpi)
      DEALLOCATE( clwcon_mpi,rnebcon_mpi)
      DEALLOCATE( ratqs_mpi)
      DEALLOCATE( run_off_lic_0_mpi)
      DEALLOCATE( masq_mpi)

      if (phy_rank==0) then
      
      ierr = NF_CREATE(fichnom, NF_CLOBBER, nid)
      IF (ierr.NE.NF_NOERR) THEN
        write(6,*)' Pb d''ouverture du fichier '//fichnom
        write(6,*)' ierr = ', ierr
        CALL ABORT
      ENDIF
c
      ierr = NF_PUT_ATT_TEXT (nid, NF_GLOBAL, "title", 28,
     .                       "Fichier redemmarage physique")
c
      ierr = NF_DEF_DIM (nid, "index", length, idim1)
      ierr = NF_DEF_DIM (nid, "points_physiques", klon2, idim2)
      ierr = NF_DEF_DIM (nid, "horizon_vertical", klon2*klev, idim3)
c
      ierr = NF_ENDDEF(nid)
c
      DO ierr = 1, length
         tab_cntrl(ierr) = 0.0
      ENDDO
      tab_cntrl(1) = dtime
      tab_cntrl(2) = radpas
      tab_cntrl(3) = co2_ppm
      tab_cntrl(4) = solaire
      tab_cntrl(5) = iflag_con
      tab_cntrl(6) = nbapp_rad

      IF( cycle_diurne ) tab_cntrl( 7 ) = 1.
      IF(   soil_model ) tab_cntrl( 8 ) = 1.
      IF(     new_oliq ) tab_cntrl( 9 ) = 1.
      IF(     ok_orodr ) tab_cntrl(10 ) = 1.
      IF(     ok_orolf ) tab_cntrl(11 ) = 1.

      tab_cntrl(13) = day_end
      tab_cntrl(14) = annee_ref
      tab_cntrl(15) = itau_phy
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "controle", NF_DOUBLE, 1, idim1,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "controle", NF_FLOAT, 1, idim1,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 22,
     .                        "Parametres de controle")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tab_cntrl)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,tab_cntrl)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "longitude", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "longitude", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 32,
     .                        "Longitudes de la grille physique")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rlon)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rlon)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "latitude", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "latitude", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 31,
     .                        "Latitudes de la grille physique")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rlat)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rlat)
#endif
c
C PB ajout du masque terre/mer
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "masque", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "masque", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 16,
     .                        "masque terre mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,masq)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,masq)
#endif      
c BP ajout des fraction de chaque sous-surface
C
C 1. fraction de terre 
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FTER", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FTER", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 21,
     .                        "fraction de continent")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf(1 : klon2, is_ter))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf(1 : klon2, is_ter))
#endif
C 
C 2. Fraction de glace de terre
C 
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FLIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FLIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 24,
     .                        "fraction glace de terre")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf(1 : klon2,is_lic))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf(1 : klon2, is_lic))
#endif
C
C 3. fraction ocean
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FOCE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FOCE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 14,
     .                        "fraction ocean")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf(1 : klon2, is_oce))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf(1 : klon2, is_oce))
#endif
C
C 4. Fraction glace de mer
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "FSIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "FSIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 18,
     .                        "fraction glace mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,pctsrf(1 : klon2, is_sic))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,pctsrf(1 : klon2, is_sic))
#endif
C
C
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid, "TS"//str2, NF_DOUBLE, 1, idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid, "TS"//str2, NF_FLOAT, 1, idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Temperature de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tsol(1,nsrf))
#else
        ierr = NF_PUT_VAR_REAL (nid,nvarid,tsol(1,nsrf))
#endif
      ENDDO
c
      DO nsrf = 1, nbsrf
      DO isoil=1, nsoilmx
        IF (isoil.LE.99 .AND. nsrf.LE.99) THEN
        WRITE(str7,'(i2.2,"srf",i2.2)') isoil,nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid, "Tsoil"//str7,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid, "Tsoil"//str7,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 29,
     .                        "Temperature du sol No."//str7)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de couches"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tsoil(1,isoil,nsrf))
#else
        ierr = NF_PUT_VAR_REAL (nid,nvarid,tsoil(1,isoil,nsrf))
#endif
      ENDDO
      ENDDO
c
cIM "slab" ocean
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "TSLAB", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "TSLAB", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 33,
     .                        "Ecart de la SST (pour slab-ocean)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,tslab)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,tslab)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "SEAICE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "SEAICE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 33,
     .                        "Glace de mer kg/m2 (pour slab-ocean)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,seaice)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,seaice)
#endif
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"QS"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"QS"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 25,
     .                        "Humidite de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,qsurf(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,qsurf(1,nsrf))
#endif
      END DO
C
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid,"QSOL",NF_DOUBLE,1,idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid,"QSOL",NF_FLOAT,1,idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 20,
     .    "Eau dans le sol (mm)")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,qsol)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,qsol)
#endif
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"ALBE"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"ALBE"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "albedo de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,albedo(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,albedo(1,nsrf))
#endif
      ENDDO

cIM BEG albedo LW
        DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"ALBLW"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"ALBLW"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "albedo LW de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,alblw(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,alblw(1,nsrf))
#endif
      ENDDO
cIM END albedo LW
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"EVAP"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"EVAP"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Evaporation de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,evap(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,evap(1,nsrf))
#endif
      ENDDO

c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"SNOW"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"SNOW"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 22,
     .                        "Neige de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,snow(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,snow(1,nsrf))
#endif
      ENDDO

c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RADS", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RADS", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Rayonnement net a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,radsol)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,radsol)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "solsw", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "solsw", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 32,
     .                        "Rayonnement solaire a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,solsw)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,solsw)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "sollw", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "sollw", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 27,
     .                        "Rayonnement IF a la surface")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,sollw)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,sollw)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "fder", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "fder", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 14,
     .                        "Derive de flux")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,fder)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,fder)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "rain_f", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "rain_f", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 21,
     .                        "precipitation liquide")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rain_fall)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rain_fall)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "snow_f", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "snow_f", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 20,
     .                        "precipitation solide")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,snow_fall)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,snow_fall)
#endif
c
       endif
c$OMP END MASTER
cc ----> necessaire pour eviter bug openMP sur SX6
c$OMP MASTER
      if (phy_rank==0) then
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
        WRITE(str2,'(i2.2)') nsrf
        ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
        ierr = NF_DEF_VAR (nid,"RUG"//str2,NF_DOUBLE,1,idim2,nvarid)
#else
        ierr = NF_DEF_VAR (nid,"RUG"//str2,NF_FLOAT,1,idim2,nvarid)
#endif
        ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 23,
     .                        "rugosite de surface No."//str2)
        ierr = NF_ENDDEF(nid)
        ELSE
        PRINT*, "Trop de sous-mailles"
        CALL abort
        ENDIF
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,frugs(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,frugs(1,nsrf))
#endif
      ENDDO
c
      DO nsrf = 1, nbsrf
        IF (nsrf.LE.99) THEN
            WRITE(str2,'(i2.2)') nsrf
            ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
            ierr = NF_DEF_VAR (nid,"AGESNO"//str2,NF_DOUBLE,1,idim2
     $          ,nvarid)
#else
            ierr = NF_DEF_VAR (nid,"AGESNO"//str2,NF_FLOAT,1,idim2
     $          ,nvarid)
#endif
            ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 15,
     .                        "Age de la neige surface No."//str2)
            ierr = NF_ENDDEF(nid)
        ELSE
            PRINT*, "Trop de sous-mailles"
            CALL abort
        ENDIF
#ifdef NC_DOUBLE
        ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,agesno(1,nsrf))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,agesno(1,nsrf))
#endif
      ENDDO
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZMEA", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZMEA", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zmea)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zmea)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZSTD", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZSTD", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zstd)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zstd)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZSIG", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZSIG", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zsig)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zsig)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZGAM", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZGAM", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zgam)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zgam)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZTHE", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZTHE", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zthe)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zthe)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZPIC", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZPIC", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zpic)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zpic)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "ZVAL", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "ZVAL", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,zval)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,zval)
#endif
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RUGSREL", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RUGSREL", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rugsrel)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rugsrel)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "TANCIEN", NF_DOUBLE, 1, idim3,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "TANCIEN", NF_FLOAT, 1, idim3,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,t_ancien)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,t_ancien)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "QANCIEN", NF_DOUBLE, 1, idim3,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "QANCIEN", NF_FLOAT, 1, idim3,nvarid)
#endif
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,q_ancien)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,q_ancien)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RUGMER", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RUGMER", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Longueur de rugosite sur mer")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,frugs(1,is_oce))
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,frugs(1,is_oce))
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "CLWCON", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "CLWCON", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Eau liquide convective")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,clwcon)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,clwcon)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RNEBCON", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RNEBCON", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Nebulosite convective")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,rnebcon)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,rnebcon)
#endif
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr = NF_DEF_VAR (nid, "RATQS", NF_DOUBLE, 1, idim2,nvarid)
#else
      ierr = NF_DEF_VAR (nid, "RATQS", NF_FLOAT, 1, idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Ratqs")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,ratqs)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,ratqs)
#endif
c
c run_off_lic_0
c
      ierr = NF_REDEF (nid)
#ifdef NC_DOUBLE
      ierr=NF_DEF_VAR(nid,"RUNOFFLIC0",NF_DOUBLE,1,idim2,nvarid)
#else
      ierr=NF_DEF_VAR(nid,"RUNOFFLIC0",NF_FLOAT, 1,idim2,nvarid)
#endif
      ierr = NF_PUT_ATT_TEXT (nid,nvarid,"title", 28,
     .                        "Runofflic0")
      ierr = NF_ENDDEF(nid)
#ifdef NC_DOUBLE
      ierr = NF_PUT_VAR_DOUBLE (nid,nvarid,run_off_lic_0)
#else
      ierr = NF_PUT_VAR_REAL (nid,nvarid,run_off_lic_0)
#endif
c
c
      ierr = NF_CLOSE(nid)
c
      endif   ! phy_rank==0
c$OMP END MASTER
      RETURN
      END
