!
! $Header$
!
c
c
      PROGRAM gcm

#ifdef CPP_IOIPSL
      USE IOIPSL
#endif
      USE parallel
      USE dimphy
      USE comgeomphy
      USE mod_hallo
      USE Bands
      IMPLICIT NONE

c      ......   Version  du 10/01/98    ..........

c             avec  coordonnees  verticales hybrides 
c   avec nouveaux operat. dissipation * ( gradiv2,divgrad2,nxgraro2 )

c=======================================================================
c
c   Auteur:  P. Le Van /L. Fairhead/F.Hourdin
c   -------
c
c   Objet:
c   ------
c
c   GCM LMD nouvelle grille
c
c=======================================================================
c
c  ... Dans inigeom , nouveaux calculs pour les elongations  cu , cv
c      et possibilite d'appeler une fonction f(y)  a derivee tangente
c      hyperbolique a la  place de la fonction a derivee sinusoidale.
c  ... Possibilite de choisir le schema pour l'advection de
c        q  , en modifiant iadv dans traceur.def  (MAF,10/02) .
c
c      Pour Van-Leer + Vapeur d'eau saturee, iadv(1)=4. (F.Codron,10/99)
c      Pour Van-Leer iadv=10
c
c-----------------------------------------------------------------------
c   Declarations:
c   -------------
      include 'mpif.h'
#include "dimensions.h"
#include "paramet.h"
#include "comconst.h"
#include "comdissnew.h"
#include "comvert.h"
#include "comgeom.h"
#include "logic.h"
#include "temps.h"
#include "control.h"
#include "ener.h"
#include "description.h"
#include "serre.h"
#include "com_io_dyn.h"
#include "iniprint.h"
#include "tracstoke.h"
#include "advtrac.h"

      INTEGER         longcles
      PARAMETER     ( longcles = 20 )
      REAL  clesphy0( longcles )
      SAVE  clesphy0



      REAL zdtvr
      INTEGER nbetatmoy, nbetatdem,nbetat

c   variables dynamiques
      REAL vcov(ip1jm,llm),ucov(ip1jmp1,llm) ! vents covariants
      REAL teta(ip1jmp1,llm)                 ! temperature potentielle 
      REAL q(ip1jmp1,llm,nqmx)               ! champs advectes
      REAL ps(ip1jmp1)                       ! pression  au sol
      REAL p (ip1jmp1,llmp1  )               ! pression aux interfac.des couches
      REAL pks(ip1jmp1)                      ! exner au  sol
      REAL pk(ip1jmp1,llm)                   ! exner au milieu des couches
      REAL pkf(ip1jmp1,llm)                  ! exner filt.au milieu des couches
      REAL masse(ip1jmp1,llm)                ! masse d'air
      REAL phis(ip1jmp1)                     ! geopotentiel au sol
      REAL phi(ip1jmp1,llm)                  ! geopotentiel
      REAL w(ip1jmp1,llm)                    ! vitesse verticale

c variables dynamiques intermediaire pour le transport

c   variables pour le fichier histoire
      REAL dtav      ! intervalle de temps elementaire

      REAL time_0

      LOGICAL lafin
      INTEGER ij,iq,l,i,j


      real time_step, t_wrt, t_ops

      REAL rdayvrai,rdaym_ini,rday_ecri
      LOGICAL first

      LOGICAL call_iniphys
      data call_iniphys/.true./

      REAL alpha(ip1jmp1,llm),beta(ip1jmp1,llm)
c+jld variables test conservation energie
      REAL ecin(ip1jmp1,llm),ecin0(ip1jmp1,llm)
C     Tendance de la temp. potentiel d (theta)/ d t due a la 
C     tansformation d'energie cinetique en energie thermique
C     cree par la dissipation
      REAL dhecdt(ip1jmp1,llm)
      REAL vcont(ip1jm,llm),ucont(ip1jmp1,llm)
      REAL      d_h_vcol, d_qt, d_qw, d_ql, d_ec
      CHARACTER*15 ztit
c-jld 


      character*80 dynhist_file, dynhistave_file
      character*20 modname
      character*80 abort_message

C Calendrier
      LOGICAL true_calendar
      PARAMETER (true_calendar = .false.)

c-----------------------------------------------------------------------
c    variables pour l'initialisation de la physique :
c    ------------------------------------------------
      INTEGER ngridmx,nq
      PARAMETER( ngridmx = 2+(jjm-1)*iim - 1/jjm   )
      REAL zcufi(ngridmx),zcvfi(ngridmx)
      REAL latfi(ngridmx),lonfi(ngridmx)
      REAL airefi(ngridmx)
      SAVE latfi, lonfi, airefi
      
c varaiable pour l'allocation du Buffer MPI (sur NEC)      
      pointer (Pbuffer,MPI_Buffer(MaxBufferSize))
      REAL :: MPI_Buffer
      INTEGER(KIND=MPI_ADDRESS_KIND) :: BS 
      INTEGER :: ierr


c-----------------------------------------------------------------------
c   Initialisations:
c   ----------------

      abort_message = 'last timestep reached'
      modname = 'gcm'
      descript = 'Run GCM LMDZ'
      lafin    = .FALSE.
      dynhist_file = 'dyn_hist'
      dynhistave_file = 'dyn_hist_ave'


c initialisation Anne
      hadv_flg(:) = 0.
      vadv_flg(:) = 0.
      conv_flg(:) = 0.
      pbl_flg(:)  = 0. 
      tracnam(:)  = '        ' 
      nprath = 1
      nbtrac = 0
      mmt_adj(:,:,:,:) = 1


c--------------------------------------------------------------------------
c   Iflag_phys controle l'appel a la physique :
c   -------------------------------------------
c      0 : pas de physique
c      1 : Normale (appel a phylmd, phymars ...)
c      2 : rappel Newtonien pour la temperature + friction au sol
      iflag_phys=1

c--------------------------------------------------------------------------
c   Lecture de l'etat initial :
c   ---------------------------
c     T : on lit start.nc
c     F : le modele s'autoinitialise avec un cas academique (iniacademic)
#ifdef CPP_IOIPSL
      read_start=.true.
#else
      read_start=.false.
#endif

c-----------------------------------------------------------------------
c   Choix du calendrier
c   -------------------

#ifdef CPP_IOIPSL
      if (true_calendar) then
        call ioconf_calendar('gregorian')
      else
        call ioconf_calendar('360d')
      endif
#endif
c----------------------------------------------------------------------
c  lecture des fichiers gcm.def ou run.def
c  ---------------------------------------
c
#ifdef CPP_IOIPSL
      CALL conf_gcm( 99, .TRUE. , clesphy0 )
#else
      CALL defrun( 99, .TRUE. , clesphy0 )
#endif
c
c
c------------------------------------
c   Initialisation partie parallele
c------------------------------------
      call init_parallel
      call InitDimphy
      call InitBands
      call MPI_BARRIER(COMM_LMDZ,ierr)
      if (mpi_rank==0) call WriteBands
      call SetDistrib(jj_Nb_Caldyn)
c  Allocation du buffer MPI
      Bs=8*MaxBufferSize
      call MPI_ALLOC_MEM(BS,MPI_INFO_NULL,Pbuffer,ierr)
      print *,'ierr',ierr
      do i=1,MaxBufferSize
	MPI_Buffer(i)=i
      enddo
      call Init_Mod_hallo(MPI_Buffer)
c$OMP PARALLEL
      call init_phys_openmp
      call InitComgeomphy
c$OMP END PARALLEL 
#ifdef INCA
      call init_const_lmdz(nbtrac,anneeref,dayref,iphysiq,day_step,nday)
      call init_inca_para(iim,jjm+1,klon2,phy_size,klon_para_nb)
#endif

c-----------------------------------------------------------------------
c   Initialisation des traceurs
c   ---------------------------
c  Choix du schema pour l'advection
c  dans fichier trac.def ou via INCA

       call iniadvtrac(nq)
c
c-----------------------------------------------------------------------
c   Lecture de l'etat initial :
c   ---------------------------

c  lecture du fichier start.nc
      if (read_start) then
#ifdef CPP_IOIPSL
         CALL dynetat0("start.nc",nqmx,vcov,ucov,
     .              teta,q,masse,ps,phis, time_0)
c       write(73,*) 'ucov',ucov
c       write(74,*) 'vcov',vcov
c       write(75,*) 'teta',teta
c       write(76,*) 'ps',ps
c       write(77,*) 'q',q

#endif
      endif

#ifdef INCA
      call init_inca_dim(klon,llm,iim,jjm,
     $     rlonu,rlatu,rlonv,rlatv)
#endif


c le cas echeant, creation d un etat initial
      IF (prt_level > 9) WRITE(lunout,*)
     .                 'AVANT iniacademic AVANT AVANT AVANT AVANT'
      if (.not.read_start) then
         CALL iniacademic(nqmx,vcov,ucov,teta,q,masse,ps,phis,time_0)
      endif


c-----------------------------------------------------------------------
c   Lecture des parametres de controle pour la simulation :
c   -------------------------------------------------------
c  on recalcule eventuellement le pas de temps

      IF(MOD(day_step,iperiod).NE.0) THEN
        abort_message = 
     .  'Il faut choisir un nb de pas par jour multiple de iperiod'
        call abort_gcm(modname,abort_message,1)
      ENDIF

      IF(MOD(day_step,iphysiq).NE.0) THEN
        abort_message = 
     * 'Il faut choisir un nb de pas par jour multiple de iphysiq'
        call abort_gcm(modname,abort_message,1)
      ENDIF

      zdtvr    = daysec/FLOAT(day_step)
        IF(dtvr.NE.zdtvr) THEN
         WRITE(lunout,*)
     .    'WARNING!!! changement de pas de temps',dtvr,'>',zdtvr
        ENDIF

C
C on remet le calendrier  zero si demande
c
      if (annee_ref .ne. anneeref .or. day_ref .ne. dayref) then
        write(lunout,*)
     .  ' Attention les dates initiales lues dans le fichier'
        write(lunout,*)
     .  ' restart ne correspondent pas a celles lues dans '
        write(lunout,*)' gcm.def'
        if (raz_date .ne. 1) then
          write(lunout,*)
     .    ' On garde les dates du fichier restart'
        else
          annee_ref = anneeref
          day_ref = dayref
          day_ini = dayref
          itau_dyn = 0
          itau_phy = 0
          time_0 = 0.
          write(lunout,*)
     .   ' On reinitialise a la date lue dans gcm.def'
        endif
      ELSE
        raz_date = 0
      endif


c  nombre d'etats dans les fichiers demarrage et histoire
      nbetatdem = nday / iecri
      nbetatmoy = nday / periodav + 1

c-----------------------------------------------------------------------
c   Initialisation des constantes dynamiques :
c   ------------------------------------------
      dtvr = zdtvr
      CALL iniconst

c-----------------------------------------------------------------------
c   Initialisation de la geometrie :
c   --------------------------------
      CALL inigeom

c-----------------------------------------------------------------------
c   Initialisation du filtre :
c   --------------------------
      CALL inifilr
c
c-----------------------------------------------------------------------
c   Initialisation de la dissipation :
c   ----------------------------------

      CALL inidissip( lstardis, nitergdiv, nitergrot, niterh   ,
     *                tetagdiv, tetagrot , tetatemp              )

c-----------------------------------------------------------------------
c   Initialisation de la physique :
c   -------------------------------
#ifdef CPP_PHYS
      IF (call_iniphys.and.iflag_phys.eq.1) THEN
         latfi(1)=rlatu(1)
         lonfi(1)=0.
         zcufi(1) = cu(1)
         zcvfi(1) = cv(1)
         DO j=2,jjm
            DO i=1,iim
               latfi((j-2)*iim+1+i)= rlatu(j)
               lonfi((j-2)*iim+1+i)= rlonv(i)
               zcufi((j-2)*iim+1+i) = cu((j-1)*iip1+i)
               zcvfi((j-2)*iim+1+i) = cv((j-1)*iip1+i)
            ENDDO
         ENDDO
         latfi(ngridmx)= rlatu(jjp1)
         lonfi(ngridmx)= 0.
         zcufi(ngridmx) = cu(ip1jm+1)
         zcvfi(ngridmx) = cv(ip1jm-iim)
         CALL gr_dyn_fi(1,iip1,jjp1,ngridmx,aire,airefi)
         WRITE(lunout,*)
     .           'WARNING!!! vitesse verticale nulle dans la physique'

         CALL iniphysiq(ngridmx,llm,daysec,day_ini,dtphys ,
     ,                latfi,lonfi,airefi,zcufi,zcvfi,rad,g,r,cpp     )

         call_iniphys=.false.
      ENDIF
#endif

c  numero de stockage pour les fichiers de redemarrage:

c-----------------------------------------------------------------------
c   Initialisation des I/O :
c   ------------------------


      day_end = day_ini + nday
      WRITE(lunout,300)day_ini,day_end

#ifdef CPP_IOIPSL
      CALL dynredem0_p("restart.nc", day_end, phis, nqmx)

      ecripar = .TRUE.

      if ( 1.eq.1) then
      time_step = zdtvr
      t_ops = iecri * daysec
      t_wrt = iecri * daysec
      CALL inithist_p(dynhist_file,day_ref,annee_ref,time_step,
     .              t_ops, t_wrt, nqmx, histid, histvid)

      t_ops = iperiod * time_step
      t_wrt = periodav * daysec
      CALL initdynav_p(dynhistave_file,day_ref,annee_ref,time_step,
     .              t_ops, t_wrt, nqmx, histaveid)

      dtav = iperiod*dtvr/daysec
      endif


#endif

c  Choix des frequences de stokage pour le offline
c      istdyn=day_step/4     ! stockage toutes les 6h=1jour/4
c      istdyn=day_step/12     ! stockage toutes les 2h=1jour/12
      istdyn=day_step/4     ! stockage toutes les 6h=1jour/12
      istphy=istdyn/iphysiq     


c
c-----------------------------------------------------------------------
c   Integration temporelle du modele :
c   ----------------------------------

c       write(78,*) 'ucov',ucov
c       write(78,*) 'vcov',vcov
c       write(78,*) 'teta',teta
c       write(78,*) 'ps',ps
c       write(78,*) 'q',q


      CALL leapfrog_p(ucov,vcov,teta,ps,masse,phis,nq,q,clesphy0,
     .              time_0)



 300  FORMAT('1'/,15x,'run du pas',i7,2x,'au pas',i7,2x,
     . 'c''est a dire du jour',i7,3x,'au jour',i7//)
      END

