module Vampir

  INTEGER,parameter :: VTcaldyn=1
  INTEGER,parameter :: VTintegre=2
  INTEGER,parameter :: VTadvection=3
  INTEGER,parameter :: VTdissipation=4
  INTEGER,parameter :: VThallo=5
  INTEGER,parameter :: VTphysiq=6
  INTEGER,parameter :: VTinca=7
  
contains

  subroutine InitVampir
    implicit none
#ifdef USE_VT
    include 'VT.inc'
    integer :: ierr
    
    call VTSYMDEF(VTcaldyn,"caldyn","caldyn",ierr)
    call VTSYMDEF(VTintegre,"integre","integre",ierr)
    call VTSYMDEF(VTadvection,"advection","advection",ierr)
    call VTSYMDEF(VTdissipation,"dissipation","dissipation",ierr)
    call VTSYMDEF(VThallo,"hallo","hallo",ierr)
    call VTSYMDEF(VTphysiq,"physiq","physiq",ierr)
    call VTSYMDEF(VTinca,"inca","inca",ierr)
#endif  
  end subroutine InitVampir
  
  subroutine VTb(number)
    implicit none
    INTEGER :: number
#ifdef USE_VT    
    include 'VT.inc'
    integer :: ierr
    
    call VTBEGIN(number,ierr)
#endif
  end subroutine VTb
  
  subroutine VTe(number)
    implicit none
    INTEGER :: Number
#ifdef USE_VT    
    include 'VT.inc'
    integer :: ierr
   
    call VTEND(number,ierr)
#endif    

  end subroutine VTe
  
end module Vampir
  
