#!/bin/bash

version=20260122.trunk
rel=6050 ; rel_opt="-r $rel"

local=$( pwd )



# Noms et installation eventuelle du modele
LMDZdir0=$local/LMDZ${version}${rel}ORnone
LMDZdir=$LMDZdir0/modipsl/modeles/LMDZ
if [ ! -d $LMDZdir0 ] ; then
   if [ ! -f install_lmdz.sh ] ; then
      wget http://lmdz.lmd.jussieu.fr/pub/install_lmdz.sh
   fi
   if [ -f ~/LMDZ/pub/netcdf4_hdf5_seq ] ; then netcdf=~/LMDZ/pub ; else netcdf=0 ; fi
   bash install_lmdz.sh -v $version -unstable $rel_opt -rad oldrad -netcdf $netcdf -bench 0 -save_pub
fi


# Noms et installation eventuelle du cas 1D
SCMcase=ARMCU/REF
SCMdir=$LMDZdir0/1D/EXEC/6AL79/$SCMcase
if [ ! -d $SCMdir ] ; then
   # Installation et test 1D
   cd $LMDZdir0
   wget http://lmdz.lmd.jussieu.fr/pub/1D/1D.tar.gz
   tar xvf 1D.tar.gz
   cd 1D
   # On ne compile pas avec fcm
   sed -i'' -e 's/^fcm=.*$/fcm=0/' bin/compile
   ./run.sh
fi

# Récupération des scripts replay
svn checkout https://svn.lmd.jussieu.fr/LMDZ/BOL/Replay .

# Replaysation du code source. Ici thermcell_plume
cd $LMDZdir/libf/phylmd
replay_equip.sh thermcell_plume_6A

# En 1D, sur le cas ARMCU créé par défaut par run.sh
cd $SCMdir/..
if [ -d Replay ] ; then mv Replay Replay$$ ; fi
cp -r $( basename $SCMdir ) Replay
cd Replay
replaydir=$PWD

echo  =========== Simulation replay mise en place sur $( pwd ) ============

# On recompile pour prendre en compte la replaysation et on relance
./compile.sh
./lmdz1d.e

# On sauvegarde les fichiers créés dans cette première simulation
mkdir -p SAVE
mv -f dump_param_out.bin  hourly.nc  lmdz_thermcell_ini.bin  phys.nc  SAVE/

# On récupère les fichiers nécessaires en 1D.
cp SAVE/lmdz_thermcell_ini.bin .
cp SAVE/dump_param_out.bin dump_param_in.bin

# Si on veut changer les variables d'entrées, on modifie le fichiers phys.nc
# créé lors de la première exécution qu'on renomme en replay_in.nc
# Ici on enleve 5% au profile d'entrée de vapeur d'eau po
ncap2 -s 'po=0.95*po' SAVE/phys.nc -O replay_in.nc

# On relance
./compile.sh replay1d
./replay1d.e

echo ===================================================
echo Comparer phys.nc et SAVE/phys.nc
echo sur $replaydir
echo Par exemple avec ferret -script cmp.jnl
echo ===================================================

cat <<eod> cmp.jnl
use SAVE/phys.nc
use phys.nc
set view left
let var=po*1000
reg/l=40/k=50:79/i=1/j=1
plot/vs/d=1/line=1 var,zlev
plot/vs/d=2/o/line=2 var,zlev
set view right
let var=w_est^0.5
plot/vs/d=1/line=1 var,zlev
plot/vs/d=2/o/line=2 var,zlev
eod

