module esat_m

  implicit none

contains

   elemental real function esat(T, P)
   implicit none
    ! Saturation vapor pressure of water in Pa. Buck, 1981,
    ! J. Appl. Meteor. 20, 1527-1532, equation (8).
    real, intent(in):: T ! temperature, in K
    real, intent(in):: P ! air pressure, in Pa
    real            :: esat

    !--------------------------------------------------------------------

    esat = (1.0007 + 3.46e-8 * P) * 6.1121e2 &
         * exp(17.502 * (T - 273.15) / (T - 32.18))

  end function esat

end module esat_m
