MODULE icolmdz_mpipara
  LOGICAL,SAVE :: using_oasis = .FALSE.
  !$OMP THREADPRIVATE(using_oasis)

CONTAINS
  
  SUBROUTINE set_wrapper
  USE mpipara, ONLY : set_plugin_wrapper, set_default_mpi_initialization, get_mpi_comm_generic, finalize_mpi_generic 
  IMPLICIT NONE
    
    PROCEDURE(get_mpi_comm_generic), POINTER :: get_mpi_comm_ 
    PROCEDURE(finalize_mpi_generic), POINTER :: finalize_mpi_ 

    get_mpi_comm_ => get_mpi_comm
    finalize_mpi_ => finalize_mpi

    CALL set_default_mpi_initialization('plugin')
    CALL set_plugin_wrapper(get_mpi_comm_, finalize_mpi_)

  END SUBROUTINE set_wrapper

  SUBROUTINE get_mpi_comm(comm_out)
  USE xios
  USE ioipsl, ONLY: getin
  IMPLICIT NONE
    INTEGER, INTENT(OUT) :: comm_out
    INTEGER :: comm_in
    CHARACTER(LEN=256) :: required_mode_str
    INTEGER :: required_mode, mpi_threading_mode
    INTEGER :: ierr
    INCLUDE 'mpif.h'

    using_oasis = .FALSE.
    CALL getin('using_oasis', using_oasis)

    IF (using_oasis) THEN

      required_mode_str = 'funneled'
      CALL getin('mpi_threading_mode', required_mode_str)

      SELECT CASE (TRIM(required_mode_str))
        CASE ('single')
          required_mode = MPI_THREAD_SINGLE
        CASE ('funneled')
            required_mode = MPI_THREAD_FUNNELED
        CASE ('serialized')
            required_mode = MPI_THREAD_SERIALIZED
        CASE ('multiple')
            required_mode = MPI_THREAD_MULTIPLE
        CASE DEFAULT
            PRINT *, 'Bad selector for variable mpi_threading_mode  : <', TRIM(required_mode_str), &
                  '>  => options are <single>, <funneled>, <serialized>, <multiple>'
        STOP
      END SELECT

      IF (required_mode == MPI_THREAD_SERIALIZED .OR. required_mode == MPI_THREAD_MULTIPLE) THEN
        PRINT *,"mpi_threading_mode /= 'single' .AND. mpi_threading_mode /= 'funneled'"
        STOP 
      END IF

      IF (required_mode == MPI_THREAD_SINGLE) PRINT *, 'MPI_INIT_THREAD : MPI_SINGLE_THREAD required'
      IF (required_mode == MPI_THREAD_FUNNELED) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_FUNNELED required'
      IF (required_mode == MPI_THREAD_SERIALIZED) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_SERIALIZED required'
      IF (required_mode == MPI_THREAD_MULTIPLE) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_MULTIPLE required'

      CALL MPI_INIT_THREAD(required_mode, mpi_threading_mode, ierr)

      IF (mpi_threading_mode == MPI_THREAD_SINGLE) PRINT *, 'MPI_INIT_THREAD : MPI_SINGLE_THREAD provided'
      IF (mpi_threading_mode == MPI_THREAD_FUNNELED) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_FUNNELED provided'
      IF (mpi_threading_mode == MPI_THREAD_SERIALIZED) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_SERIALIZED provided'
      IF (mpi_threading_mode == MPI_THREAD_MULTIPLE) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_MULTIPLE provided'

      IF (mpi_threading_mode > required_mode) mpi_threading_mode = required_mode

      IF (mpi_threading_mode == MPI_THREAD_SINGLE) THEN
        PRINT *, 'MPI_INIT_THREAD : MPI_SINGLE_THREAD used : Warning : openMP is not garanted to work'
      END IF
      IF (mpi_threading_mode == MPI_THREAD_FUNNELED) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_FUNNELED used'
      IF (mpi_threading_mode == MPI_THREAD_SERIALIZED) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_SERIALIZED used'
      IF (mpi_threading_mode == MPI_THREAD_MULTIPLE) PRINT *, 'MPI_INIT_THREAD : MPI_THREAD_MULTIPLE used'
    END IF

#ifdef CPP_USING_XIOS3        
    IF (using_oasis) THEN
      CALL initialize_third_party_coupler( 'icosa', comm_in, ierr )
      CALL xios_initialize("icosagcm", local_comm=comm_in, return_comm=comm_out)
    ELSE
      CALL xios_initialize("icosagcm", return_comm=comm_out)
    ENDIF
#else
    CALL xios_initialize("icosagcm", return_comm=comm_out)
#endif

  END SUBROUTINE get_mpi_comm

  SUBROUTINE finalize_mpi
  USE xios
  IMPLICIT NONE
  INTEGER :: ierr

    CALL xios_finalize
#ifdef CPP_USING_XIOS3
    IF (using_oasis) THEN
       CALL finalize_third_party_coupler( ierr )
       CALL MPI_FINALIZE(ierr)
    ENDIF

#endif

  END SUBROUTINE finalize_mpi

  SUBROUTINE initialize_third_party_coupler( comp_id, comm_icosa, ierr )
  USE icolmdz_oasis
  IMPLICIT NONE
     CHARACTER(len=*), INTENT(IN) :: comp_id
     INTEGER, INTENT(OUT) :: comm_icosa
     INTEGER, INTENT(OUT) :: ierr
    
     INTEGER :: ncomp_id
     CALL oasis_init_comp ( ncomp_id, comp_id, ierr )
     CALL oasis_get_localcomm ( comm_icosa, ierr )
  
  END SUBROUTINE initialize_third_party_coupler
  
  
  SUBROUTINE finalize_third_party_coupler( ierr )
     USE icolmdz_oasis
     IMPLICIT NONE
     INTEGER, INTENT(OUT) :: ierr
    
     PRINT*, "FINALIZING THROUGH WRAPPER"
     CALL oasis_terminate( ierr )
  END SUBROUTINE finalize_third_party_coupler

END MODULE icolmdz_mpipara
