
! $Id: ini_undefSTD.f90 5789 2025-07-28 11:12:04Z fhourdin $


SUBROUTINE ini_undefstd(itap)
USE clesphys_mod_h, ONLY : freq_outnmc
USE dimphy, ONLY : klon
USE phys_state_var_mod, ONLY : tnondef,tsumstd,usumstd,vsumstd,wsumstd,phisumstd,qsumstd,rhsumstd
USE phys_state_var_mod, ONLY : uvsumstd,vqsumstd,vtsumstd,wqsumstd,vphisumstd,wtsumstd,u2sumstd
USE phys_state_var_mod, ONLY : v2sumstd,t2sumstd,o3sumstd,o3daysumstd,nlevSTD,nout,phys_tstep
USE phys_state_var_mod, ONLY : missing_val_nf90
USE phys_cal_mod, ONLY: mth_len
USE phys_output_var_mod, ONLY : clef_files

IMPLICIT NONE

  ! ====================================================================

  ! I. Musat : 09.2004

  ! Initialisation - a des frequences differentes :

  ! 1) des variables moyennees sur la journee "day" ou sur le mois "mth"
  ! calculees a partir des valeurs "instantannees" de la physique

  ! 2) des variables moyennes mensuelles "NMC" calculees a partir des val.
  ! toutes les 6 heures

  ! nout=1 !var. journaliere "day" moyenne sur tous les pas de temps
  ! ! de la physique
  ! nout=2 !var. mensuelle "mth" moyennee sur tous les pas de temps
  ! ! de la physique
  ! nout=3 !var. mensuelle "NMC" moyennee toutes les 6heures

  ! NB: mettre "inst(X)" dans le write_hist*NMC.h !
  ! ====================================================================

  ! ym INCLUDE "dimphy.h"
  ! variables Input/Output
  ! INTEGER nlevSTD, klevSTD, itap
  INTEGER itap
  ! PARAMETER(klevSTD=17)
  ! REAL dtime

  ! variables locales
  ! INTEGER i, k, nout, n
  INTEGER i, k, n
  ! PARAMETER(nout=3) !nout=1 day/nout=2 mth/nout=3 NMC
  ! REAL freq_outNMC(nout)
  REAL un_jour
  PARAMETER (un_jour=86400.)

  ! variables Output
  ! REAL tnondef(klon,klevSTD,nout)
  ! REAL tsumSTD(klon,klevSTD,nout)

  DO n = 1, nout

    ! initialisation variables en debut du mois, de la journee ou des 6h

    !IF ( clef_files(n) .and. mod(itap,nint(freq_outnmc(n)/phys_tstep))==1) THEN
    IF ( mod(itap,nint(freq_outnmc(n)/phys_tstep))==1) THEN
      DO k = 1, nlevstd
        DO i = 1, klon
          tnondef(i, k, n) = 0.
        END DO !i
      END DO !k
      IF ( clef_files(n) ) THEN
        ! print*,'ini_undefSTD n itap',n,itap
        DO k = 1, nlevstd
          DO i = 1, klon
            tnondef(i, k, n) = 0.
            tsumstd(i, k, n) = 0.
            usumstd(i, k, n) = 0.
            vsumstd(i, k, n) = 0.
            wsumstd(i, k, n) = 0.
            phisumstd(i, k, n) = 0.
            qsumstd(i, k, n) = 0.
            rhsumstd(i, k, n) = 0.
            uvsumstd(i, k, n) = 0.
            vqsumstd(i, k, n) = 0.
            vtsumstd(i, k, n) = 0.
            wqsumstd(i, k, n) = 0.
            vphisumstd(i, k, n) = 0.
            wtsumstd(i, k, n) = 0.
            u2sumstd(i, k, n) = 0.
            v2sumstd(i, k, n) = 0.
            t2sumstd(i, k, n) = 0.
            o3sumstd(i, k, n) = 0.
            o3daysumstd(i, k, n) = 0.
          END DO !i
        END DO !k
      END IF !
    END IF !
  END DO !n
  RETURN
END SUBROUTINE ini_undefstd
