#!/bin/bash
#
# Lancement d'un install_lmdz.sh immédiatement apres un commit
# pour tester la compilation et l'execution. Retour d'un code erreur adequat
# au serveur svn pour notifier qui de droit

set -vx

REV="$1"

TMP_OUT=/u/lmdz/WWW/Distrib/OUT
TMP_D=/tmp/lmdz/test_rev_${REV}_$$ ; mkdir -p $TMP_D
ncdfdir=/u/lmdz/Netcdf/lmdz-cq_20230902

resolution=48x36x39
physiq=NPv6.0.14splith
# Changed on 15/03/2023 r4473
physiq=NPv6.3

cd $TMP_D
cp /u/lmdz/WWW/pub/install_lmdz.sh .
#chmod 755 /u/lmdz/WWW/pub/install_lmdz.sh
chmod +x install_lmdz.sh
#./install_lmdz.sh -SCM -unstable -debug -d $resolution -r $REV -physiq $physiq > ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$ 2>&1
#./install_lmdz.sh -SCM -unstable -debug -d $resolution -r $REV -netcdf /u/lmdz/Netcdf/lmdz-cq_9.4.0_ubunutu20.04/ -rad oldrad -parallel mpi_omp  -physiq $physiq \
./install_lmdz.sh -SCM -unstable -debug -d $resolution -r $REV -netcdf $ncdfdir -rad oldrad -parallel mpi_omp  -benchphysiq $physiq \
	          -arch local-gfortran9-parallel -arch_dir /u/lmdz/WWW/Distrib/arch.local \
		   > ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$ 2>&1
#
# menage: si ca a marche on efface le repertoire dans /tmp/lmdz
#
grep 'Everything is cool' ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$
RET=$?
# checking 1D results
cd LMDZ*${REV}*/1D/EXEC/6AL79/
listecas="ARMCU/REF RICO/SHORT SANDU/REF"
((ret1d=0))
for cas in $listecas ; do
    ((ret1d=$ret1d*10))
    gunzip -dc "$cas"/listing.gz |grep -i cool
    retcas=$?
    ((ret1d=$ret1d+$retcas))
done
# checking isotope compilation
if [[ -v LD_LIBRARY_PATH ]]; then
    echo "export LD_LIBRARY_PATH=$ncdfdir/lib:$LD_LIBRARY_PATH" >> icosalmdz.env
else
    echo "export LD_LIBRARY_PATH=$ncdfdir/lib" >> icosalmdz.env
fi
export PATH=$ncdfdir/bin:$PATH

echo 'Verification iso' >> ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$ 2>&1
cd $TMP_D
cd LMDZ*${REV}*/modipsl/modeles/LMDZ/
#./makelmdz_fcm -debug -arch local -j 8 -rad rrtm -d $resolution -v false -p lmdiso -isotopes true -isoverif true gcm  > ./compile_iso.out 2>&1
./makelmdz_fcm -debug -arch local -j 8 -rad rrtm -d $resolution -v false -p lmdiso -isotopes true -isoverif true gcm  >> ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$ 2>&1
ls bin/*iso*
retiso=$?

if [ ${RET} -eq 0 ] && [ ${ret1d} -eq 0 ] && [ ${retiso} -eq 0 ] ; then
  echo "Everything is cool for revision ${REV}" >> ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$
  echo "Cleaning up /tmp/lmdz/test_rev_${REV}_$$" >> ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$
  \rm -rf /tmp/lmdz/test_rev_${REV}_$$
else
  echo "There is a problem. QC is run in this directory /tmp/lmdz/test_rev_${REV}_$$ on lmdz-cq" >> ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$
fi

#  Cleaning up
if [ ${RET} -eq 0 ] && [ ${ret1d} -eq 0 ] ; then
  \rm -rf /tmp/lmdz/test_rev_${REV}_$$
fi
#
# sorties retour nécessaires pour envoyer le message a la liste
#
echo "Sortie dans" ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$
if [ ${RET} -eq 0 ] ; then
    echo "Bench 3D ok"
fi
if [ ${ret1d} -eq 0 ] ; then
    echo "Bench 1D ok"
fi
if [ ${retiso} -eq 0 ] ; then
    echo "Compilation iso ok"
fi

#grep 'Everything is cool' ${TMP_OUT}/post-commit-lmdz-cq-${REV}_$$
exit
