#ifdef ISO
#ifdef ISOTRAC

MODULE isotrac_mod
  USE infotrac_phy, ONLY: niso, ntiso, nzone, delPhase
  USE isotopes_mod, ONLY: ridicule, get_in

  IMPLICIT NONE
  SAVE

!=== CONTENT: ALL THE ISOTOPIC TRACERS RELATED VARIABLES ===
!
! option 1: on trace evap ocean et continent separement  
! option 2: on trace evap ocean, continent et evap precip
! option 3: on trace evap differents bassins oceaniques 
!       + continents + residu
!       attention, choisir dans ce cas les bassins oceaniques
!       dans iso_traceurs_opt3F90.h 
! option 4: tracage par temperature minimale
!       dans ce cas, on definit des bins dans iso_traceurs_opt4.h
! option 5: pour AMMA: on taggue residu/AEJ/flux mousson/Harmattan
! option 6: taggage des ddfts
! option 7: pour Sandrine: taggage de la vapeur a 700hPa pour omega500<-20 TODO
! option 8: pour Sandrine: taggage de la vapeur entre 950 et 800hPa, omega de 0 a 25 hPa et de l'evaoration en omega<-20. TODO
! option 9: taggage du condensat et de la revap precip
! option 10: taggage evap oce, transpiration et evaporation
! fractionante. A utiliser quand on couple avec ORCHIDEE
! option 11: comme 2, mais on trace juste revap precip et reste
! option 12: taggage evap oce, sol nu, canop et reste evap cont. 
! A utiliser quand on couple avec ORCHIDEE
! option 13: taggage temperature minimale + revap precip
! option 14: taggage lat et altitude de derniere saturation (niveaux de pression) + evap surf
! otion 15: taggage irrigation
! option 16: taggage precip selon saisons et fonte neige: seulement pour ORCHIDEE
! option 17: taggage temperature minimum de condensation directement dans la convection et la cond LS, + evap sfc, condensat et precipitation
! option 18: idem 17 mais on tague qsmin au lieu de Tmin
! option 19: on tag vap residuelle, vap residuelle dans ddfts, sfc, cond, rev
! option 20: on taggue vapeur tropicale vs vapeur extratropicale
! option 21: taggage de 2 boites 3D: extratropiques (>35°) et UT tropicale (15-15°, > 500hPa)
! option 22: tagage de la vapeur proccessee dans les zones tres convectives
                
   !--- nzone_opt (value of nzone for the selected option) must be equal to nzone as defined in onfotrac
   REAL, PARAMETER :: ridicule_trac = ridicule * 1e4
   INTEGER, SAVE :: option_traceurs, nzone_opt, nzoneOR
!$OMP THREADPRIVATE(option_traceurs,nzone_opt,nzoneOR)
   INTEGER, SAVE :: initialisation_isotrac
!$OMP THREADPRIVATE(initialisation_isotrac)      
                ! 1 pour idealise
                ! 0 pour lecture dans fichier

   !=== VARIABLES SPECIFIC TO THE SELECTED OPTION, BUT NEEDED FOR THE COMPUTATION OF THE NUMBER OF ZONES ; TO BE INITIALIZED IN traceurs_init

   !--- option 3
   LOGICAL, SAVE :: use_bassin_Austral, use_bassin_Atlantic, use_bassin_MidLats, use_bassin_SouthIndian, use_bassin_MerArabie
!$OMP THREADPRIVATE(use_bassin_Austral, use_bassin_Atlantic, use_bassin_MidLats, use_bassin_SouthIndian, use_bassin_MerArabie)
   INTEGER, SAVE ::     bassin_Austral,     bassin_Atlantic,     bassin_MidLats,     bassin_SouthIndian,     bassin_MerArabie
!$OMP THREADPRIVATE(    bassin_Austral,     bassin_Atlantic,     bassin_MidLats,     bassin_SouthIndian,     bassin_MerArabie)
   LOGICAL, SAVE :: use_bassin_Pacific, use_bassin_Indian,   use_bassin_Tropics, use_bassin_BengalGolf,  use_bassin_HighLats, use_bassin_Medit
!$OMP THREADPRIVATE(use_bassin_Pacific, use_bassin_Indian,   use_bassin_Tropics, use_bassin_BengalGolf,  use_bassin_HighLats, use_bassin_Medit)
   INTEGER, SAVE ::     bassin_Pacific,     bassin_Indian,       bassin_Tropics,     bassin_BengalGolf,      bassin_HighLats,     bassin_Medit
!$OMP THREADPRIVATE(    bassin_Pacific,     bassin_Indian,       bassin_Tropics,     bassin_BengalGolf,      bassin_HighLats,     bassin_Medit)

   !--- option 4
   INTEGER, PARAMETER :: nzone_temp = 1
   REAL,   SAVE ::  zone_temp1, zone_tempf, zone_tempa  
!$OMP THREADPRIVATE(zone_temp1, zone_tempf, zone_tempa)
   REAL,   SAVE ::  zone_temp(nzone_temp-1)
!$OMP THREADPRIVATE(zone_temp)

   !--- option 5
   INTEGER, SAVE :: izone_aej, izone_harmattan, izone_mousson
!$OMP THREADPRIVATE(izone_aej, izone_harmattan, izone_mousson)

   !--- option 6
   INTEGER, SAVE :: izone_ddft
!$OMP THREADPRIVATE(izone_ddft)

   !--- option 10
   INTEGER, SAVE :: izone_contfrac
!$OMP THREADPRIVATE(izone_contfrac)

   !--- option 12	
   INTEGER, SAVE :: izone_contcanop
!$OMP THREADPRIVATE(izone_contcanop)

   !--- option 13
   INTEGER, PARAMETER :: nzone_pres = 3
   REAL, SAVE ::  zone_pres(nzone_pres-1)
!$OMP THREADPRIVATE(zone_pres)

   !--- option 14
   INTEGER, PARAMETER :: nzone_lat = 4
   REAL,    SAVE :: zone_pres1, zone_presf, zone_presa 
!$OMP THREADPRIVATE(zone_pres1, zone_presf, zone_presa) 
   REAL,    SAVE :: dlattag, lattag_min, zone_lat(nzone_lat-1)
!$OMP THREADPRIVATE(dlattag, lattag_min, zone_lat)

   !--- option 15
   INTEGER, SAVE :: izone_irrig
!$OMP THREADPRIVATE(izone_irrig)

   !--- option 17
   REAL,    SAVE :: seuil_tag_tmin, seuil_tag_tmin_ls
!$OMP THREADPRIVATE(seuil_tag_tmin, seuil_tag_tmin_ls)
  INTEGER,  SAVE :: option_seuil_tag_tmin
!$OMP THREADPRIVATE(option_seuil_tag_tmin)

   !--- option 20
   INTEGER, SAVE :: izone_trop, izone_extra
!$OMP THREADPRIVATE(izone_trop, izone_extra)
   REAL,    SAVE :: lim_tag20 
!$OMP THREADPRIVATE(lim_tag20)

   !--- option 21: on garde izone_trop, izone_extra  

   !--- option 22
   INTEGER, SAVE :: izone_conv_BT, izone_conv_UT
!$OMP THREADPRIVATE(izone_conv_BT, izone_conv_UT)
   REAL,    SAVE :: lim_precip_tag22 
!$OMP THREADPRIVATE(lim_precip_tag22)

        
  INTEGER, ALLOCATABLE, SAVE :: index_iso(:), index_zone(:), itZonIso_loc(:,:)
!$OMP THREADPRIVATE(            index_iso,    index_zone,    itZonIso_loc)
  CHARACTER(LEN=3), ALLOCATABLE :: strtrac(:)
!$OMP THREADPRIVATE(               strtrac)
  INTEGER, ALLOCATABLE, SAVE :: bassin_map(:), boite_map(:,:)
!$OMP THREADPRIVATE(            bassin_map,    boite_map)

   !=== RECYCLING AND EVAPORATION TREATMENT
   INTEGER, SAVE :: izone_cont, izone_oce        !--- For land and ocean recycling
!$OMP THREADPRIVATE(izone_cont, izone_oce)
   INTEGER, SAVE :: izone_poubelle               !--- For small numerical residues
!$OMP THREADPRIVATE(izone_poubelle)
   INTEGER, SAVE :: izone_init                   !--- For default initialization
!$OMP THREADPRIVATE(izone_init)
   INTEGER, SAVE :: izone_revap                  !--- For droplets evaporation
!$OMP THREADPRIVATE(izone_revap)
   INTEGER, SAVE :: option_revap, option_tmin, option_cond, izone_cond
!$OMP THREADPRIVATE(option_revap, option_tmin, option_cond, izone_cond)
   REAL, PARAMETER :: evap_franche = 1e-6        !--- In kg/m2/s

CONTAINS

   SUBROUTINE iso_traceurs_init()

   USE infotrac_phy, ONLY: itZonIso, isoName, isoZone
   USE isotopes_mod, ONLY: iso_eau, ntracisoOR, initialisation_iso
   USE dimphy,       ONLY: klon, klev
   USE  strings_mod, ONLY: int2str, strStack, strTail, strHead, strIdx

   IMPLICIT NONE
   ! Define which zones and isotopes correspond to isotopic tagging tracers
   ! Modify traceurs.h variables
   INTEGER :: izone, ixt, k
   INTEGER :: izone_pres, izone_lat
   INTEGER :: nzone_opt

   CALL msg("traceurs_init 18: isotrac ne marche que si on met l'eau comme isotope", 'iso_traceurs_init', iso_eau==0)
   IF(lerr) STOP

   !--- Initialize
   option_traceurs = 0
   initialisation_isotrac = 0

   !--- Allocate
   ALLOCATE(index_iso (ntiso))
   ALLOCATE(index_zone(ntiso))
   ALLOCATE(itZonIso_loc(nzone,niso))
   ALLOCATE(strtrac(nzone))
   ALLOCATE(bassin_map(klon))
   ALLOCATE( boite_map(klon,klev))

   IF(initialisation_iso == 0) CALL get_in('initialisation_isotrac', initialisation_isotrac)

   !--- Read tracing option
   CALL get_in('option_traceurs', option_traceurs)

   !--- Genral case: no traceurs in ORCHIDEE
   ntracisoOR=niso

   ! partie a editer ! pour definir les differentes zones
   SELECT CASE(option_traceurs)
      !========================================================================================================================
      CASE(1)      !=== TRACING LAND/OCEAN
      !========================================================================================================================
         nzone_opt=2
         izone_cont=1
         izone_oce=2
         izone_poubelle=2    ! zone ou on met les flux non physiques, de reajustement
         izone_init=2        ! zone d'initialisation par defaut          
         option_revap=0
         option_tmin=0
         izone_revap=0
         option_cond=0
         strtrac(izone_cont) = 'con'
         strtrac(izone_oce)  = 'oce'
      !========================================================================================================================
      CASE(2)      !=== TRACING LAND/OCEAN/DROPLETS REEVAPORATION
      !========================================================================================================================
         nzone_opt=3
         izone_cont=1
         izone_oce=2
         izone_poubelle=2    ! zone ou on met les flux non physiques, de reajustement
         izone_init=2        ! zone d'initialisation par defaut          
         option_revap=1
         option_tmin=0
         izone_revap=3
         option_cond=0
         strtrac(izone_cont) = 'con'
         strtrac(izone_oce)  = 'oce'
         strtrac(izone_revap)= 'rev'
      !========================================================================================================================
      CASE(3)      !=== TRACING OCEANS BASINS + RESIDUE (LAST DIMENSION). NO DROPLETS EVAPORATION TRACING.
      !========================================================================================================================
         ! lire les use_bassin
         CALL get_in('use_bassin_Atlantic',   use_bassin_Atlantic)
         CALL get_in('use_bassin_Medit',      use_bassin_Medit)
         CALL get_in('use_bassin_Indian',     use_bassin_Indian)
         CALL get_in('use_bassin_Austral',    use_bassin_Austral)
         CALL get_in('use_bassin_Pacific',    use_bassin_Pacific)
         CALL get_in('use_bassin_MerArabie',  use_bassin_MerArabie)
         CALL get_in('use_bassin_BengalGolf', use_bassin_BengalGolf)
         CALL get_in('use_bassin_SouthIndian',use_bassin_SouthIndian)
         CALL get_in('use_bassin_Tropics',    use_bassin_Tropics)
         CALL get_in('use_bassin_Midlats',    use_bassin_Midlats)
         CALL get_in('use_bassin_HighLats',   use_bassin_HighLats)
         nzone_opt  =  2  +  COUNT([use_bassin_Atlantic, use_bassin_Medit,     use_bassin_Indian,     &
            use_bassin_Austral,     use_bassin_Pacific,  use_bassin_MerArabie, use_bassin_BengalGolf, &
            use_bassin_SouthIndian, use_bassin_Tropics,  use_bassin_Midlats,   use_bassin_HighLats])
         izone_cont=nzone
         izone_oce=0             ! pas de sens car separee en bassins          
         izone_poubelle=nzone-1  ! zone ou on met les flux non physiques, de reajustement
         izone_init=nzone-1      ! zone d'initialisation par defaut
         option_revap=0          ! on ne trace pas les gouttes 
         option_tmin=0
         izone_revap=0           ! pas de sens car on taggue pas les gouttes separemment  
         option_cond=0
#ifdef ISOVERIF
         IF(use_bassin_Indian) THEN   !=== NON COMPATIBLE WITH A DETAILED INDIAN CUTTING
            IF(use_bassin_MerArabie .OR. use_bassin_SouthIndian .OR. use_bassin_BengalGolf) THEN
               WRITE(*,*) 'traceurs_init 73'; STOP
            END IF
!           CALL iso_verif_egalite(float(use_bassin_MerArabie),   0.0, 'iso_traceurs_init 73: revoir def des bassins')
!           CALL iso_verif_egalite(float(use_bassin_BengalGolf),  0.0, 'iso_traceurs_init 73: revoir def des bassins')
!           CALL iso_verif_egalite(float(use_bassin_SouthIndian), 0.0, 'iso_traceurs_init 73: revoir def des bassins')
         END IF
#endif    
         bassin_Atlantic   = 1
         bassin_Medit      = bassin_Atlantic    + COUNT([use_bassin_Medit]);       WRITE(*,*) 'bassin_Atlantic    =' ,bassin_Atlantic
         bassin_Indian     = bassin_Medit       + COUNT([use_bassin_Indian]);      WRITE(*,*) 'bassin_Medit       =' ,bassin_Medit
         bassin_Austral    = bassin_Indian      + COUNT([use_bassin_Austral]);     WRITE(*,*) 'bassin_Indian      =' ,bassin_Indian
         bassin_Pacific    = bassin_Austral     + COUNT([use_bassin_Pacific]);     WRITE(*,*) 'bassin_Austral     =' ,bassin_Austral
         bassin_MerArabie  = bassin_Pacific     + COUNT([use_bassin_MerArabie]);   WRITE(*,*) 'bassin_MerArabie   =' ,bassin_MerArabie
         bassin_BengalGolf = bassin_MerArabie   + COUNT([use_bassin_BengalGolf]);  WRITE(*,*) 'bassin_BengalGolf  =' ,bassin_BengalGolf
         bassin_SouthIndian= bassin_BengalGolf  + COUNT([use_bassin_SouthIndian]); WRITE(*,*) 'bassin_SouthIndian =' ,bassin_SouthIndian
         bassin_Tropics    = bassin_SouthIndian + COUNT([use_bassin_Tropics]);     WRITE(*,*) 'bassin_Tropics     =' ,bassin_Tropics
         bassin_MidLats    = bassin_Tropics     + COUNT([use_bassin_MidLats]);     WRITE(*,*) 'bassin_MidLats     =' ,bassin_MidLats
         bassin_HighLats   = bassin_MidLats     + COUNT([use_bassin_HighLats]);    WRITE(*,*) 'bassin_HighLats    =' ,bassin_HighLats
         IF(use_bassin_atlantic   ) strtrac(bassin_atlantic)   = 'atl'
         IF(use_bassin_medit      ) strtrac(bassin_medit)      = 'med'
         IF(use_bassin_indian     ) strtrac(bassin_indian)     = 'ind'
         IF(use_bassin_austral    ) strtrac(bassin_austral)    = 'aus'
         IF(use_bassin_pacific    ) strtrac(bassin_pacific)    = 'pac'
         IF(use_bassin_merarabie  ) strtrac(bassin_merarabie)  = 'ara'
         IF(use_bassin_BengalGolf ) strtrac(bassin_BengalGolf) = 'ben'
         IF(use_bassin_SouthIndian) strtrac(bassin_SouthIndian)= 'ins'
         IF(use_bassin_tropics    ) strtrac(bassin_tropics)    = 'tro'
         IF(use_bassin_midlats    ) strtrac(bassin_midlats)    = 'mid'
         IF(use_bassin_HighLats   ) strtrac(bassin_HighLats)   = 'hau'
         strtrac(nzone-1)='res'
         strtrac(nzone)='con'
      !========================================================================================================================
      CASE(4)      !=== TRACING MINIMAL EXPERIENCED TEMPERATURE AS IN THE ARTICLE ON LfG, EXCEPT NO REVAPORATION
      !========================================================================================================================
         zone_temp1 = 293.0  ! en K
!        zone_tempf = 223.0  ! en K
         zone_tempf = 243.0  ! en K
        ! courbure de la relation entre l'indice et la temperature: 0 pour lineaire, <0 pour plus de detal en bas
        ! zone 1: >= zone_temp1
        ! zone 2 a 4: intermediaire, 
        ! zone 5: <zone_tempf
         nzone_opt=nzone_temp+1
         zone_tempa=-4.0     ! en K
         izone_cont=nzone
         izone_oce=nzone  
         izone_poubelle=nzone
         izone_init=nzone    ! zone d'initialisation par defaut
         option_revap=0 
         option_tmin=0  
         izone_revap=0
         option_cond=0
         DO izone=1,nzone_temp
            strtrac(izone) = 't'//TRIM(int2str(izone))
            WRITE(*,*) 'izone, strtrac=', izone, strtrac(izone)
         END DO
         strtrac(izone_poubelle)='pou'
         ! Initialization of temperatures zones
         DO izone=1,nzone_temp-1
            zone_temp(izone) = zone_temp1+float(izone-1)            &
                            * (zone_tempa*float(izone-nzone_temp+1) &
                            + (zone_tempf-zone_temp1)/float(nzone_temp-2))
         END DO
         WRITE(*,*) 'iso_trac_init 183: zone_temp=', zone_temp
      !========================================================================================================================
      CASE(5)      !=== TRACING AEJ/MOONSOON FLUX/Harmattan
      !========================================================================================================================
!        WRITE*,*) 'iso_traceurs_init 129'
         nzone_opt=4
         izone_cont=1
         izone_oce=1
         izone_poubelle=1    ! zone ou on met les flux non physiques, de reajustement
         izone_init=1        ! zone d'initialisation par defaut          
         option_revap=0
         option_tmin=0
         izone_revap=0
         izone_aej=2
         izone_mousson=3
         izone_harmattan=4 
         option_cond=0
         strtrac(izone_poubelle) = 'res'
         strtrac(izone_aej)      = 'aej'
         strtrac(izone_mousson)  = 'mou'
         strtrac(izone_harmattan)= 'sah'
      !========================================================================================================================
      CASE(6)      !=== TRACING DDFTS
      !========================================================================================================================
         nzone_opt=2
         izone_cont=1
         izone_oce=1
         izone_poubelle=1    ! zone ou on met les flux non physiques, de reajustement
         izone_init=1        ! zone d'initialisation par defaut          
         option_revap=0
         option_tmin=0
         izone_revap=0
         izone_ddft=2
         option_cond=0
         strtrac(izone_poubelle)='res'
         strtrac(izone_ddft)='dft'
      !========================================================================================================================
      CASE(9)      !=== TRACING CONDENSATION
      !========================================================================================================================
         nzone_opt=3
         izone_cont=1
         izone_oce=1
         izone_poubelle=1    ! zone ou on met les flux non physiques, de reajustement
         izone_init=1        ! zone d'initialisation par defaut          
         option_revap=1
         option_tmin=0
         izone_revap=2
         izone_cond=3
         option_cond=1
         ! 1 par defaut pour colorier a la fois condensat LS et condensat convectif.
         ! Mais on peut mettre 2 si on ne veut que colorier que le condensat convectif.
         CALL get_in('option_cond',option_cond)
         strtrac(izone_poubelle)='res'
         strtrac(izone_cond)='con'
         strtrac(izone_revap)='rev'
      !========================================================================================================================
      CASE(10)     !=== TRACING EVAPORATION FROM OCEAN/LAND, NON FRAC/LAND FRAC ; ONLY WHEN COUPLED WITH ORCHIDEE
      !========================================================================================================================
#ifndef CPP_VEGET
         WRITE(*,*) 'iso_traceurs_init 219: option_traceurs=10 inutile si on ne couple pas avec ORCHIDEE'; STOP
#endif          
         nzone_opt=3
         izone_cont=1        ! sous-entendu non fractionnant
         izone_oce=2
         izone_poubelle=2    ! zone ou on met les flux non physiques, de reajustement
         izone_init=2        ! zone d'initialisation par defaut
         option_revap=0
         option_tmin=0
         izone_revap=0
         izone_contfrac=3
         izone_contcanop=3
         izone_irrig=0
         option_cond=0
         strtrac(izone_oce)='oce'
         strtrac(izone_cont)='con'  
         strtrac(izone_contfrac)='enu'  ! evap sol nu
      !========================================================================================================================
      CASE(11)     !=== TRACING DROPLETS REEVAPORATION + REST
      !========================================================================================================================
         nzone_opt=2
         izone_cont=1
         izone_oce=1
         izone_poubelle=1    ! zone ou on met les flux non physiques, de reajustement
         izone_init=1        ! zone d'initialisation par defaut
         option_revap=1
         option_tmin=0
         izone_revap=2
         izone_irrig=0
         option_cond=0
         strtrac(izone_poubelle)='res'
         strtrac(izone_revap)='rev'
      !========================================================================================================================
      CASE(12)     !=== TRACING NAKED GROUND EVAPORATION, CANOPY EVAPORATION, REST OF LAND EVAPORATION AND OCEAN EVAPORATION
      !========================================================================================================================
#ifndef CPP_VEGET
         WRITE(*,*) 'iso_traceurs_init 257: option_traceurs=10 inutile si on ne couple pas avec ORCHIDEE'; STOP
#endif           
         nzone_opt=2
         izone_cont=1
         izone_oce=2
         izone_poubelle=2    ! zone ou on met les flux non physiques, de reajustement
         izone_init=2        ! zone d'initialisation par defaut
         option_revap=0
         option_tmin=0
         izone_revap=0
         izone_contfrac=3
         izone_contcanop=4
         izone_irrig=0   
         option_cond=0
         strtrac(izone_oce)='oce'
         strtrac(izone_cont)='con'
         strtrac(izone_contfrac)='enu' ! evap sol nu
         strtrac(izone_contcanop)='eca'! evap canop
      !========================================================================================================================
      CASE(13)     !=== TRACING MINIMUM EXPERIENCED TEMPERATIRES + REEVAPORATION AS IN THE ARTICLE ON LdG
      !========================================================================================================================
         zone_temp1=293.0    ! en K        
!        zone_tempf=223.0    ! en K
         zone_tempf=243.0    ! en K
         zone_tempa=-4.0     ! courbure de la relation entre l'indice et la temperature: 0 pour lineaire, <0 pour plus de detal en bas
         ! zone 1: >= zone_temp1
         ! zone 2 a 4: intermediaire, 
         ! zone 5: <zone_tempf
         nzone_opt=nzone_temp+1
         izone_cont=1
         izone_oce=1  
         izone_poubelle=1
         izone_init=1        ! zone d'initialisation par defaut
         option_revap=1   
         option_tmin=0
         izone_revap=nzone
         izone_irrig=0
         option_cond=0
         DO izone=1,nzone_temp
            strtrac(izone) = 't'//TRIM(int2str(izone))
            WRITE(*,*) 'izone, strtrac = ', izone, strtrac(izone)
         END DO
         strtrac(izone_revap)='rev'
         ! initialisation des zones de tempearture
         DO izone=1,nzone_temp-1
            zone_temp(izone) = zone_temp1+float(izone-1) &
                             *(zone_tempa*float(izone-nzone_temp+1) &
                             +(zone_tempf-zone_temp1)/float(nzone_temp-2))
         END DO
         WRITE(*,*) 'zone_temp=',zone_temp
      !========================================================================================================================
      CASE(14)     !=== TRACING PRES AND LAT OF LAST SATURATION DEFINED AS rh>90%
      !========================================================================================================================
         zone_pres1=600.0*100.0   ! en Pa       
         zone_presf=300.0*100.0   ! en Pa
         zone_presa=0.0           ! courbure de la relation entre l'indice et la temperature: 0 pour lineaire
         lattag_min=10.0          ! en degres
         dlattag=15.0
         ! zone 1: >= zone_pres1
         ! zone 2 a 4: intermediaire, 
         ! zone 5: <zone_presf
         nzone_opt=nzone_pres*nzone_lat+1          
         izone_cont=nzone
         izone_oce=nzone
         izone_poubelle=nzone
         izone_init=nzone         ! zone d'initialisation par defaut
         option_revap=0  
         option_tmin=0 
         izone_revap=0
         izone_irrig=0
         option_cond=0
         DO izone_pres=1,nzone_pres
            DO izone_lat=1,nzone_lat
               izone=izone_lat+(izone_pres-1)*nzone_lat
               strtrac(izone) = 't'//TRIM(int2str(izone_pres))//TRIM(int2str(izone_lat))
               write(*,*) 'izone_pres, izone_lat, izone, strtrac = ',izone_pres, izone_lat, izone, strtrac(izone)
            END DO
         END DO
         strtrac(nzone)='sfc'
         ! initialisation des zones de temperature
         DO izone=1,nzone_pres-1
            zone_pres(izone) = zone_pres1+float(izone-1) &
                             *(zone_presa*float(izone-nzone_pres+1) &
                             +(zone_presf-zone_pres1)/float(nzone_pres-2))
         END DO
         WRITE(*,*) 'traceurs_init 332: zone_pres=',zone_pres
      !========================================================================================================================
      CASE(15)     !=== TRACING IRRIGATION IN ORCHIDEE
      !========================================================================================================================
#ifndef CPP_VEGET
         WRITE(*,*) 'iso_traceurs_init 257: option_traceurs=15 inutile si on ne couple pas avec ORCHIDEE'; STOP
#endif
         nzone_opt=1
         izone_cont=1
         izone_oce=1
         izone_poubelle=1    ! zone ou on met les flux non physiques, de reajustement
         izone_init=1        ! zone d'initialisation par defaut
         option_revap=0
         option_tmin=0
         izone_revap=0
         izone_contfrac=0
         izone_contcanop=0 
         izone_irrig=2 
         option_cond=0
         strtrac(izone_poubelle)='res'
         strtrac(izone_irrig)='irrig'
         ! dans ce cas particulier, il y a des traceurs dans ORCHIDEE
         ntracisoOR=ntiso
      !========================================================================================================================
      CASE(17,18)  !=== TRACING MINIMAL EXPERIENCES TEMPERATURES AS IN THE ARTICLE ABOUT LdG, BUT NO EVAPORATION
      !========================================================================================================================
         zone_temp1=12.0e-3  ! en kg/kg        
         zone_tempf=0.2e-3   ! en kg/kg
         zone_tempa=1.2e-3   ! courbure de la relation entre l'indice et la temperature: 0 pour lineaire
!	 zone_temp1=14.0e-3  ! en kg/kg        
!   	 zone_tempf=0.2e-3   ! en kg/kg
!	 zone_tempa=0.5e-3       
!        zone_temp1=10.0e-3  ! en kg/kg
!   	 zone_tempf=0.5e-3   ! en kg/kg
!	 zone_tempa=0.5e-3
         ! zone 1: >= zone_temp1
         ! zone 2 a 4: intermediaire, 
         ! zone 5: <zone_tempf
         nzone_opt=nzone_temp+3
         izone_cont=nzone_temp+1
         izone_oce=nzone_temp+1 
         izone_poubelle=nzone_temp+1
         izone_init=nzone_temp+1 ! zone d'initialisation par defaut
         option_revap=1  
         option_tmin=1 
         option_cond=1
         izone_revap=nzone_temp+3
         izone_cond=nzone_temp+2
         DO izone=1,nzone_temp
            strtrac(izone) = 't'//TRIM(int2str(izone))
            WRITE(*,*) 'izone, strtrac = ', izone, strtrac(izone)
         END DO !do izone=1,nzone_temp
         strtrac(izone_poubelle)='sfc'
         strtrac(izone_cond)='con'
         strtrac(izone_revap)='rev'
         ! initialisation des zones de tempearture
         DO izone=1,nzone_temp-1
            zone_temp(izone) = zone_temp1+float(izone-1) &
                             *(zone_tempa*float(izone-nzone_temp+1) &
                             +(zone_tempf-zone_temp1)/float(nzone_temp-2))
         END DO
         WRITE(*,*) 'zone_temp1,zone_tempf,zone_tempa=',zone_temp1,zone_tempf,zone_tempa
         WRITE(*,*) 'zone_temp=',zone_temp
!        STOP          
      !========================================================================================================================
      CASE(19)     !=== TRACING TROPICAL AND EXTRATROPICAL VAPOUR
      !========================================================================================================================
         zone_temp1=12.0e-3  ! en kg/kg        
         zone_tempf=0.2e-3   ! en kg/kg
         zone_tempa=1.2e-3   ! courbure de la relation entre l'indice et la temperature: 0 pour lineaire, <0 pour plus de detail en bas
!        zone_temp1=14.0e-3  ! en kg/kg        
!        zone_tempf=0.2e-3   ! en kg/kg
!        zone_tempa=0.5e-3
!        zone_temp1=10.0e-3  ! en kg/kg        
!        zone_tempf=0.5e-3   ! en kg/kg
!        zone_tempa=0.5e-3
         ! zone 1: >= zone_temp1
         ! zone 2 a 4: intermediaire, 
         ! zone 5: <zone_tempf
         nzone_opt=nzone_temp+4
         izone_cont=nzone_temp+1
         izone_oce=nzone_temp+1 
         izone_poubelle=nzone_temp+1
         IF(option_seuil_tag_tmin == 1) THEN
            izone_init=nzone_temp+1 ! zone d'initialisation par defaut
         ELSE
            izone_init=nzone_temp
         END IF
         option_revap=1   
         izone_revap=nzone_temp+3
         izone_cond=nzone_temp+2
         izone_ddft=nzone_temp+4
         option_tmin=1          
         option_cond=1
         DO izone=1,nzone_temp
            strtrac(izone) = 't'//TRIM(int2str(izone))
            WRITE(*,*) 'izone, strtrac = ', izone, strtrac(izone)
         END DO
         strtrac(izone_poubelle)='sfc'
         strtrac(izone_cond)='con'
         strtrac(izone_revap)='rev'
         strtrac(izone_ddft)='dft'
      !========================================================================================================================
      CASE(20)     !=== TRACING TROPICAL/EXTRATROPICAL/EXTRATROPICAL RECYCLING TO STUDY HUMIDITY AND SUBTROPICAL ISOTOPES CONTROL
      !========================================================================================================================
         CALL get_in('lim_tag20', lim_tag20, 35.0)
         nzone_opt=3
         izone_cont=1
         izone_oce=1
         izone_poubelle=2    ! zone ou on met les flux non physiques, de reajustement
         izone_init=2        ! zone d'initialisation par defaut
         option_revap=0
         option_tmin=0
         izone_revap=0
         izone_trop=2
         izone_extra=3
         strtrac(izone_trop)='tro'     ! tropical vapour
         strtrac(izone_extra)='ext'    ! extratropical vapour evaporated in the tropics
         strtrac(izone_cont)='rec'     ! recycling
      !========================================================================================================================
      CASE(21)     !=== TRACING TWO 3D BOXES: TROPICAL UT AND EXTRATROPICS ; SIMILAR TO 5 FOR AMMA ZONES TAGGING
      !========================================================================================================================
!        WRITE(*,*) 'iso_traceurs_init 129'
         nzone_opt=3
         izone_cont=1
         izone_oce=1
         izone_poubelle=1    ! zone ou on met les flux non physiques, de reajustement
         izone_init=1        ! zone d'initialisation par defaut
         option_revap=0
         option_tmin=0
         izone_revap=0
         izone_trop=2
         izone_extra=3
         option_cond=0
         strtrac(izone_poubelle)='res'
         strtrac(izone_trop)='tro'
         strtrac(izone_extra)='ext'
      !========================================================================================================================
      CASE(22)     !=== TRACING WATER VAPOUR PROCESSED IN THE 3-LEVELS SCONVECTION ZONES BT, MT AND UT
      !========================================================================================================================
         CALL get_in('lim_precip_tag22', lim_precip_tag22, 20.0)
         nzone_opt=3
         izone_cont=1
         izone_oce=1
         izone_poubelle=1    ! zone ou on met les flux non physiques, de reajustement
         izone_init=1        ! zone d'initialisation par defaut
         option_revap=0
         option_tmin=0
         izone_revap=0
         izone_conv_BT=2
         izone_conv_UT=3
         option_cond=0
         strtrac(izone_poubelle)='res'
         strtrac(izone_conv_BT)='cbt'
         strtrac(izone_conv_UT)='cut'
      CASE DEFAULT
         WRITE(*,*) 'traceurs_init 36: option pas encore prevue'
         CALL abort_physic ('isotrac_mod 641','option pas encore prevue',1)
   END SELECT

   IF(nzone_opt /= nzone) THEN
      WRITE(*,*) 'nzone_opt, nzone=', nzone_opt, nzone
      CALL abort_physic ('isotrac_mod','nzone incoherent',1)
   END IF

   !--- Condensation rate threshold
   IF(option_tmin == 1) THEN
      seuil_tag_tmin = 0.01
      CALL get_in('seuil_tag_tmin',        seuil_tag_tmin,        0.01)
      CALL get_in('seuil_tag_tmin_ls',     seuil_tag_tmin_ls,     seuil_tag_tmin)
      CALL get_in('option_seuil_tag_tmin', option_seuil_tag_tmin, 1)
   END IF

   index_zone = [(strIdx(isoZone, strTail(isoName(ixt) ,'_',.TRUE.)), ixt=1, ntiso)]
   index_iso  = [(strIdx(isoName, strHead(isoName(ixt) ,'_',.TRUE.)), ixt=1, ntiso)]
   itZonIso_loc = itZonIso(:,:)
#ifdef ISOVERIF
   WRITE(*,*) 'traceurs_init 65: bilan de l''init:'
   WRITE(*,*) 'index_zone = '//TRIM(strStack(int2str(index_zone(1:ntiso))))
   WRITE(*,*) 'index_iso  = '//TRIM(strStack(int2str(index_iso (1:ntiso))))
   DO izone=1,nzone
      WRITE(*,*)'itZonIso('//TRIM(int2str(izone))//',:) = '//strStack(int2str(itZonIso(izone,:)))
   END DO
   DO izone=1,nzone
      WRITE(*,*)'strtrac('//TRIM(int2str(izone))//',:) = '//TRIM(strtrac(izone))
   END DO
   WRITE(*,*) 'ntracisoOR=',ntracisoOR
#endif  

END SUBROUTINE iso_traceurs_init

END MODULE isotrac_mod
#endif
#endif
